/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import org.adempiere.exceptions.ValueChangeListener;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.RecordInfo;
import org.compiere.apps.search.InfoPAttribute;
import org.compiere.apps.search.InfoProduct;
import org.compiere.grid.ed.VEditor;
import org.compiere.grid.ed.VPAttributeDialog;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MColumn;
import org.compiere.model.MPAttributeLookup;
import org.compiere.model.MProduct;
import org.compiere.swing.CButton;
import org.compiere.swing.CDialog;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VPAttribute
extends JComponent
implements VEditor,
ActionListener {
    private static final long serialVersionUID = -1823370077523962901L;
    private Object value = new Object();
    private String attributeWhere = null;
    private String columnName = "M_AttributeSetInstance_ID";
    private MPAttributeLookup attributeLookup;
    private CTextField text = new CTextField();
    private CButton button = new CButton();
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem menuEditor;
    private boolean isReadWrite;
    private boolean isMandatory;
    private int windowNo;
    private int partnerId;
    private boolean isSearchOnly;
    private GridTab gridTabAttribute;
    private GridField gridFieldAttribute;
    private int columnId = 0;
    private Integer oldValue = 0;
    private String oldText = "";
    private String oldWhere = "";
    private static Integer NO_INSTANCE = 0;
    private static CLogger log = CLogger.getCLogger(VPAttribute.class);

    public VPAttribute() {
        this(null, false, false, true, 0, null, false);
    }

    public VPAttribute(boolean mandatory, boolean isReadOnly, boolean isUpdated, int WindowNo, MPAttributeLookup lookup, boolean searchOnly) {
        this(null, mandatory, isReadOnly, isUpdated, WindowNo, lookup, searchOnly);
    }

    public VPAttribute(GridTab gridTab, boolean mandatory, boolean isReadOnly, boolean isUpdatable, int windowNo, MPAttributeLookup lookup, boolean searchOnly) {
        super.setName(this.columnName);
        this.text.setName("VPAttribute Text - " + this.columnName);
        this.button.setName("VPAttribute Button - " + this.columnName);
        this.value = 0;
        this.gridTabAttribute = gridTab;
        this.windowNo = windowNo;
        this.attributeLookup = lookup;
        this.partnerId = Env.getContextAsInt(Env.getCtx(), windowNo, "C_BPartner_ID");
        this.isSearchOnly = searchOnly;
        LookAndFeel.installBorder(this, "TextField.border");
        this.setLayout(new BorderLayout());
        this.setPreferredSize(this.text.getPreferredSize());
        int height = this.text.getPreferredSize().height;
        this.text.setEditable(false);
        this.text.setFocusable(false);
        this.text.setBorder(null);
        this.text.setHorizontalAlignment(10);
        this.setMandatory(mandatory);
        this.add((Component)this.text, "Center");
        this.button.setIcon(Env.getImageIcon("PAttribute10.gif"));
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.setPreferredSize(new Dimension(height, height));
        this.button.addActionListener(this);
        this.button.setFocusable(true);
        this.add((Component)this.button, "East");
        this.setPreferredSize(this.getPreferredSize());
        if (isReadOnly || !isUpdatable) {
            this.setReadWrite(false);
        } else {
            this.setReadWrite(true);
        }
        this.text.addMouseListener(new VPAttribute_mouseAdapter(this));
        this.menuEditor = new CMenuItem(Msg.getMsg(Env.getCtx(), "PAttribute"), Env.getImageIcon("Zoom16.gif"));
        this.menuEditor.addActionListener(this);
        this.popupMenu.add(this.menuEditor);
        this.set_oldValue();
    }

    @Override
    public void dispose() {
        this.text = null;
        this.button = null;
        this.attributeLookup.dispose();
        this.attributeLookup = null;
        this.gridFieldAttribute = null;
        this.gridTabAttribute = null;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.isMandatory = mandatory;
        this.button.setMandatory(mandatory);
        this.setBackground(false);
    }

    @Override
    public boolean isMandatory() {
        return this.isMandatory;
    }

    @Override
    public void setReadWrite(boolean rw) {
        this.isReadWrite = rw;
        this.button.setReadWrite(rw);
        this.setBackground(false);
    }

    @Override
    public boolean isReadWrite() {
        return this.isReadWrite;
    }

    @Override
    public void setForeground(Color color) {
        this.text.setForeground(color);
    }

    @Override
    public void setBackground(boolean error) {
        if (error) {
            this.setBackground(AdempierePLAF.getFieldBackground_Error());
        } else if (!this.isReadWrite) {
            this.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        } else if (this.isMandatory) {
            this.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        } else {
            this.setBackground(AdempierePLAF.getInfoBackground());
        }
    }

    @Override
    public void setBackground(Color color) {
        this.text.setBackground(color);
    }

    @Override
    public void setValue(Object value) {
        if (value == null || NO_INSTANCE.equals(value)) {
            this.text.setText("");
            this.value = value;
            this.attributeWhere = "";
            return;
        }
        if (value.equals(this.value)) {
            return;
        }
        log.fine("Value=" + value);
        this.value = value;
        this.text.setText(this.attributeLookup.getDisplay(value));
        this.text.setToolTipText(this.text.getText());
        this.attributeWhere = "EXISTS (SELECT * FROM M_Storage s WHERE s.M_AttributeSetInstance_ID=" + value + " AND s.M_Product_ID=p.M_Product_ID)";
    }

    @Override
    public Object getValue() {
        Integer temp = null;
        if (this.value != null || NO_INSTANCE.equals(this.value)) {
            try {
                temp = (Integer)this.value;
            }
            catch (ClassCastException cce) {
                temp = null;
            }
        }
        return temp;
    }

    public String getAttributeWhere() {
        return this.attributeWhere;
    }

    @Override
    public String getDisplay() {
        return this.text.getText();
    }

    @Override
    public void setField(GridField mField) {
        this.columnId = mField.getAD_Column_ID();
        this.gridFieldAttribute = mField;
        if (this.gridFieldAttribute != null) {
            RecordInfo.addMenu(this, this.popupMenu);
        }
    }

    @Override
    public GridField getField() {
        return this.gridFieldAttribute;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.text.addActionListener(listener);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MProduct product;
        int attributeSetId;
        int oldValueInt;
        if (e.getActionCommand().equals("ChangeLog")) {
            RecordInfo.start(this.gridFieldAttribute);
            return;
        }
        if (!this.button.isEnabled()) {
            return;
        }
        this.button.setEnabled(false);
        Integer oldValueEvent = 0;
        try {
            oldValueEvent = (Integer)this.getValue();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        int attributeSetInstanceId = oldValueInt = oldValueEvent == null ? 0 : oldValueEvent;
        int productId = 0;
        int productBOMId = 0;
        if (this.gridTabAttribute != null) {
            productId = Env.getContextAsInt(Env.getCtx(), this.windowNo, this.gridTabAttribute.getTabNo(), "M_Product_ID");
            productBOMId = Env.getContextAsInt(Env.getCtx(), this.windowNo, this.gridTabAttribute.getTabNo(), "M_ProductBOM_ID");
        } else {
            productId = Env.getContextAsInt(Env.getCtx(), this.windowNo, "M_Product_ID");
            productBOMId = Env.getContextAsInt(Env.getCtx(), this.windowNo, "M_ProductBOM_ID");
        }
        int locatorId = -1;
        log.config("M_Product_ID=" + productId + "/" + productBOMId + ",M_AttributeSetInstance_ID=" + attributeSetInstanceId + ", AD_Column_ID=" + this.columnId);
        boolean productWindow = this.columnId == MColumn.getColumn_ID("M_Product", "M_AttributeSetInstance_ID");
        boolean exclude = false;
        if (productId != 0 && (attributeSetId = (product = MProduct.get(Env.getCtx(), productId)).getM_AttributeSet_ID()) != 0) {
            int tableId = MColumn.getTable_ID(Env.getCtx(), this.columnId, null);
            MAttributeSet mas = MAttributeSet.get(Env.getCtx(), attributeSetId);
            exclude = mas.excludeEntry(tableId, Env.isSOTrx(Env.getCtx(), this.windowNo));
        }
        boolean changed = false;
        if (productBOMId != 0) {
            productId = productBOMId;
        }
        if (this.isSearchOnly) {
            Container me;
            for (me = this.getParent(); me != null && !(me instanceof InfoProduct); me = me.getParent()) {
            }
            InfoPAttribute ia = new InfoPAttribute((CDialog)me);
            this.attributeWhere = ia.getWhereClause();
            String oldText = this.text.getText();
            this.text.setText(ia.getDisplay());
            this.text.setToolTipText(this.text.getText());
            ActionEvent ae = new ActionEvent(this.text, 1001, "updated");
            ((InfoProduct)me).actionPerformed(ae);
        } else if (!productWindow && (productId == 0 || exclude)) {
            changed = true;
            this.text.setText(null);
            attributeSetInstanceId = 0;
        } else {
            VPAttributeDialog vad = new VPAttributeDialog(Env.getFrame(this), attributeSetInstanceId, productId, this.partnerId, productWindow, this.columnId, this.windowNo, this.isReadWrite());
            if (vad.isChanged()) {
                this.text.setText(vad.getM_AttributeSetInstanceName());
                this.text.setToolTipText(vad.getM_AttributeSetInstanceName());
                attributeSetInstanceId = vad.getM_AttributeSetInstance_ID();
                if (!productWindow && vad.getM_Locator_ID() > 0) {
                    locatorId = vad.getM_Locator_ID();
                }
                changed = true;
            }
        }
        if (changed) {
            log.finest("Changed M_AttributeSetInstance_ID=" + attributeSetInstanceId);
            this.value = new Object();
            if (attributeSetInstanceId == 0) {
                this.setValue(null);
            } else {
                this.setValue(attributeSetInstanceId);
            }
            if (this.gridTabAttribute != null && locatorId > 0) {
                log.finest("Change M_Locator_ID=" + locatorId);
                this.gridTabAttribute.setValue("M_Locator_ID", (Object)locatorId);
            }
            try {
                String columnName = "M_AttributeSetInstance_ID";
                if (this.gridFieldAttribute != null) {
                    columnName = this.gridFieldAttribute.getColumnName();
                }
                this.fireVetoableChange(columnName, new Object(), this.getValue());
            }
            catch (PropertyVetoException pve) {
                log.log(Level.SEVERE, "", pve);
            }
            if (attributeSetInstanceId == oldValueInt && this.gridTabAttribute != null && this.gridFieldAttribute != null) {
                this.gridTabAttribute.processFieldChange(this.gridFieldAttribute);
            }
        }
        this.button.setEnabled(true);
        this.requestFocus();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    public void set_oldValue() {
        if (this.getValue() != null) {
            try {
                this.oldValue = (Integer)this.getValue();
            }
            catch (ClassCastException e) {
                this.oldValue = null;
            }
        } else {
            this.oldValue = null;
        }
        this.oldText = this.text != null ? this.text.getDisplay() : "";
        this.oldWhere = this.attributeWhere;
    }

    public Object get_oldValue() {
        return this.oldValue;
    }

    public boolean hasChanged() {
        if (this.text != null) {
            if (this.oldText != null) {
                return !this.oldText.equals(this.text.getDisplay());
            }
            return true;
        }
        if (this.oldText != null) {
            return true;
        }
        if (this.attributeWhere != null) {
            if (this.oldWhere != null) {
                return !this.oldWhere.equals(this.attributeWhere);
            }
            return true;
        }
        return this.oldWhere != null;
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
    }

    final class VPAttribute_mouseAdapter
    extends MouseAdapter {
        private VPAttribute attribute;

        VPAttribute_mouseAdapter(VPAttribute attribute) {
            this.attribute = attribute;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                this.attribute.actionPerformed(new ActionEvent(e.getSource(), e.getID(), "Mouse"));
            }
            if (SwingUtilities.isRightMouseButton(e)) {
                this.attribute.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

