/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.border.AbstractBorder;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.util.Language;

public class VLine
extends AbstractBorder {
    private static final long serialVersionUID = -3510090015856709962L;
    private String m_header = "";
    private Font m_font = AdempierePLAF.getFont_Label();
    private Color m_color = AdempierePLAF.getTextColor_Label();
    public static final int GAP = 5;
    public static final int SPACE = 4;

    public VLine() {
        this("");
    }

    public VLine(String header) {
        this.setHeader(header);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        Graphics copy = g.create();
        if (copy != null) {
            try {
                copy.translate(x, y);
                this.paintLine(c, copy, w, h);
            }
            finally {
                copy.dispose();
            }
        }
    }

    private void paintLine(Component c, Graphics g, int w, int h) {
        int y = h - 4;
        g.setColor(Color.darkGray);
        g.drawLine(5, y, w - 5, y);
        g.setColor(Color.white);
        g.drawLine(5, y + 1, w - 5, y + 1);
        if (this.m_header == null || this.m_header.length() == 0) {
            return;
        }
        g.setColor(this.m_color);
        g.setFont(this.m_font);
        int x = 5;
        if (!Language.getLoginLanguage().isLeftToRight()) {
            // empty if block
        }
        g.drawString(this.m_header, 5, h - 4 - 1);
    }

    public void setHeader(String newHeader) {
        this.m_header = newHeader.replace('_', ' ');
    }

    public String getHeader() {
        return this.m_header;
    }
}

