/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.adempiere.exceptions.ValueChangeListener;
import org.compiere.grid.ed.VEditor;
import org.compiere.model.GridField;
import org.compiere.swing.CButton;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VBinary
extends JComponent
implements VEditor,
ActionListener {
    private static final long serialVersionUID = 298576564679201761L;
    private CButton m_OpenButton = new CButton();
    private CButton m_SaveButton = new CButton();
    private String m_columnName;
    private Object m_data = null;
    private static CLogger log = CLogger.getCLogger(VBinary.class);
    private GridField m_mField = null;

    public VBinary(String columnName, int WindowNo) {
        super.setName(columnName);
        this.m_columnName = columnName;
        this.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        buttonPanel.setPreferredSize(new Dimension(500, 25));
        this.add((Component)buttonPanel, "Center");
        this.m_OpenButton.setIcon(Env.getImageIcon("Open16.gif"));
        this.m_OpenButton.addActionListener(this);
        this.m_OpenButton.setToolTipText(Msg.translate(Env.getCtx(), "Upload"));
        buttonPanel.add(this.m_OpenButton);
        this.m_SaveButton.setIcon(Env.getImageIcon("Save16.gif"));
        this.m_SaveButton.addActionListener(this);
        this.m_SaveButton.setToolTipText(Msg.translate(Env.getCtx(), "Download"));
        buttonPanel.add(this.m_SaveButton);
    }

    @Override
    public void dispose() {
        this.m_data = null;
    }

    @Override
    public void setValue(Object value) {
        log.config("=" + value);
        this.m_data = value;
        this.m_SaveButton.setEnabled(value != null);
    }

    @Override
    public Object getValue() {
        return this.m_data;
    }

    @Override
    public String getDisplay() {
        return this.m_data == null ? null : "#" + ((byte[])this.m_data).length;
    }

    @Override
    public void setReadWrite(boolean rw) {
        if (this.isEnabled() != rw) {
            this.setEnabled(rw);
        }
    }

    @Override
    public boolean isReadWrite() {
        return super.isEnabled();
    }

    @Override
    public void setMandatory(boolean mandatory) {
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public void setBackground(Color color) {
    }

    public void setBackground() {
    }

    @Override
    public void setBackground(boolean error) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        log.info(evt.toString());
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser("");
        fc.setMultiSelectionEnabled(false);
        fc.setFileSelectionMode(0);
        boolean save = false;
        int option2 = 0;
        if (e.getSource() == this.m_OpenButton) {
            log.fine("Open Button");
            option2 = fc.showOpenDialog(this);
            save = false;
        }
        if (e.getSource() == this.m_SaveButton) {
            log.fine("Save Button");
            option2 = fc.showSaveDialog(this);
            save = true;
        }
        if (option2 != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        if (file == null) {
            return;
        }
        log.info(file.toString());
        try {
            if (save) {
                FileOutputStream os = new FileOutputStream(file);
                byte[] buffer = (byte[])this.m_data;
                os.write(buffer);
                os.flush();
                os.close();
                log.config("Save to " + file + " #" + buffer.length);
            } else {
                FileInputStream is = new FileInputStream(file);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                byte[] buffer = new byte[8192];
                int length = -1;
                while ((length = is.read(buffer)) != -1) {
                    os.write(buffer, 0, length);
                }
                is.close();
                byte[] data = os.toByteArray();
                this.m_data = data;
                log.config("Load from " + file + " #" + data.length);
                os.close();
            }
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Save=" + save, ex);
        }
        try {
            this.fireVetoableChange(this.m_columnName, null, this.m_data);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setField(GridField mField) {
        this.m_mField = mField;
    }

    @Override
    public GridField getField() {
        return this.m_mField;
    }

    @Override
    public void setVisible(boolean visible) {
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setName(String columnName) {
    }

    @Override
    public void addActionListener(ActionListener listener) {
    }

    @Override
    public void setFont(Font font) {
    }

    @Override
    public void setBorder(Border border) {
    }

    @Override
    public void setForeground(Color color) {
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
    }
}

