/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.crm.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.crm.model.MOpportunity;
import org.compiere.crm.process.ConvertLeadAbstract;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocation;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class ConvertLead
extends ConvertLeadAbstract {
    private int userId = 0;

    @Override
    protected void prepare() {
        super.prepare();
        this.userId = MUser.Table_ID == this.getTable_ID() ? this.getRecord_ID() : this.getAD_User_ID();
        if (this.getSalesStageId() == 0) {
            String sql = "SELECT MIN(s.C_SalesStage_ID) FROM C_SalesStage s WHERE s.AD_Client_ID = ? AND s.IsActive = 'Y' AND NOT EXISTS (SELECT * FROM C_SalesStage ss WHERE ss.AD_Client_ID=s.AD_Client_ID AND ss.IsActive='Y' AND ss.Value < s.Value)";
            this.setSalesStageId(DB.getSQLValue(this.get_TrxName(), sql, this.getAD_Client_ID()));
        }
    }

    @Override
    protected String doIt() throws Exception {
        MLocation address;
        MBPartnerLocation loc;
        MLocation leadAddress;
        if (this.userId <= 0) {
            throw new FillMandatoryException(new String[]{"AD_User_ID"});
        }
        MUser lead = new MUser(this.getCtx(), this.userId, this.get_TrxName());
        if (!lead.isSalesLead() || lead.getC_BPartner_ID() != 0) {
            throw new AdempiereUserError("Lead already converted");
        }
        MBPartner bp = MBPartner.getTemplate(this.getCtx(), this.getAD_Client_ID());
        bp.set_TrxName(this.get_TrxName());
        if (!Util.isEmpty(lead.getBPName())) {
            bp.setName(lead.getBPName());
        } else {
            bp.setName(lead.getName());
        }
        bp.saveEx();
        this.addLog("Business Partner created.");
        lead.setC_BPartner_ID(bp.getC_BPartner_ID());
        if (lead.getC_Location_ID() != 0) {
            leadAddress = (MLocation)lead.getC_Location();
            loc = new MBPartnerLocation(bp);
            address = new MLocation(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(leadAddress, address);
            address.saveEx();
            loc.setC_Location_ID(address.getC_Location_ID());
            loc.setPhone(lead.getPhone());
            loc.setPhone2(lead.getPhone2());
            loc.setFax(lead.getFax());
            loc.saveEx();
            lead.setC_BPartner_Location_ID(loc.getC_BPartner_Location_ID());
            this.addLog("Contact Location added.");
        }
        if (lead.getBP_Location_ID() != 0) {
            leadAddress = (MLocation)lead.getBP_Location();
            loc = new MBPartnerLocation(bp);
            address = new MLocation(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(leadAddress, address);
            address.saveEx();
            loc.setC_Location_ID(address.getC_Location_ID());
            loc.saveEx();
            this.addLog("BP Address added.");
        }
        if (this.isCreateOpportunity()) {
            MOpportunity op = new MOpportunity(this.getCtx(), 0, this.get_TrxName());
            op.setAD_User_ID(lead.getAD_User_ID());
            op.setC_BPartner_ID(bp.getC_BPartner_ID());
            op.setExpectedCloseDate(this.getExpectedCloseDate() != null ? this.getExpectedCloseDate() : new Timestamp(System.currentTimeMillis()));
            op.setOpportunityAmt(this.getOpportunityAmt() != null ? this.getOpportunityAmt() : Env.ZERO);
            if (this.getSalesStageId() > 0) {
                op.setC_SalesStage_ID(this.getSalesStageId());
            }
            String sql = "SELECT Probability FROM C_SalesStage WHERE C_SalesStage_ID = ?";
            BigDecimal probability = DB.getSQLValueBD(this.get_TrxName(), sql, this.getSalesStageId());
            op.setProbability(probability != null ? probability : Env.ZERO);
            op.setDescription(this.getDescription());
            if (this.getCurrencyId() > 0) {
                op.setC_Currency_ID(this.getCurrencyId());
            } else {
                op.setC_Currency_ID(Env.getContextAsInt(this.getCtx(), "$C_Currency_ID"));
            }
            if (this.getSalesRepId() > 0) {
                op.setSalesRep_ID(this.getSalesRepId());
            } else if (lead.getSalesRep_ID() > 0) {
                op.setSalesRep_ID(lead.getSalesRep_ID());
            } else {
                op.setSalesRep_ID(Env.getContextAsInt(this.getCtx(), "#SalesRep_ID"));
            }
            op.setC_Campaign_ID(lead.getC_Campaign_ID());
            op.saveEx();
            this.addLog("Opportunity created.");
        }
        lead.setIsSalesLead(false);
        lead.setLeadStatus("C");
        lead.saveEx();
        this.addLog("Lead converted.");
        return "@OK@";
    }
}

