/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MDepreciationEntry;
import org.compiere.asset.model.MDepreciationExp;
import org.compiere.asset.model.MDepreciationWorkfile;
import org.compiere.model.MPeriod;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

public class DepreciationExpCheck
extends SvrProcess {
    private boolean p_IsTest = true;
    private int p_A_Asset_ID = -1;
    private String p_WhereClause = null;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter processInfoParameter : this.getParameter()) {
            String string = processInfoParameter.getParameterName();
            if (processInfoParameter.getParameter() == null) continue;
            if (string.equals("IsTest")) {
                this.p_IsTest = processInfoParameter.getParameterAsBoolean();
                continue;
            }
            if (string.equals("A_Asset_ID")) {
                this.p_A_Asset_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (!string.equals("WhereClause")) continue;
            this.p_WhereClause = (String)processInfoParameter.getParameter();
        }
    }

    @Override
    protected String doIt() throws Exception {
        for (int n : this.getAsset_IDs()) {
            this.fixDepreciation(n);
            if (!this.p_IsTest) continue;
            this.rollback();
        }
        return "Ok";
    }

    private int[] getAsset_IDs() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = null;
        if (this.p_A_Asset_ID > 0) {
            string = "A_Asset_ID=?";
            arrayList.add(this.p_A_Asset_ID);
        } else {
            string = this.p_WhereClause;
        }
        return new Query(this.getCtx(), "A_Asset", string, this.get_TrxName()).setParameters(arrayList).setOrderBy("A_Asset_ID").getIDs();
    }

    private void fixDepreciation(int n) {
        int n2;
        Object object;
        MAsset mAsset = MAsset.get(this.getCtx(), n, this.get_TrxName());
        List<MDepreciationExp> list = this.getDepreciation(mAsset);
        if (list.get(0).getA_Period() == 0) {
            this.fixDepreciationExp(list.get(0), TimeUtil.getMonthLastDay(mAsset.getAssetServiceDate()));
            object = list.get(0).getDateAcct();
            for (n2 = 1; n2 < list.size(); ++n2) {
                this.fixDepreciationExp(list.get(n2), TimeUtil.getMonthLastDay(TimeUtil.addMonths((Timestamp)object, 1)));
                object = list.get(n2).getDateAcct();
            }
        } else {
            this.fixDepreciationExp(list.get(0), TimeUtil.getMonthLastDay(TimeUtil.addMonths(mAsset.getAssetServiceDate(), 1)));
            object = list.get(0).getDateAcct();
            for (n2 = 1; n2 < list.size(); ++n2) {
                this.fixDepreciationExp(list.get(n2), TimeUtil.getMonthLastDay(TimeUtil.addMonths((Timestamp)object, 1)));
                object = list.get(n2).getDateAcct();
            }
        }
        for (MDepreciationWorkfile mDepreciationWorkfile : MDepreciationWorkfile.forA_Asset_ID(this.getCtx(), n, this.get_TrxName())) {
            mDepreciationWorkfile.setA_Current_Period();
            mDepreciationWorkfile.saveEx();
            this.addLog(mDepreciationWorkfile + ": Period=" + mDepreciationWorkfile.getA_Current_Period() + ", DateAcct=" + mDepreciationWorkfile.getDateAcct());
        }
    }

    private void fixDepreciationExp(MDepreciationExp mDepreciationExp, Timestamp timestamp) {
        if (!mDepreciationExp.getDateAcct().equals(timestamp)) {
            this.addLog("OLD1: " + mDepreciationExp);
            MDepreciationEntry.deleteFacts(mDepreciationExp);
            mDepreciationExp.setDateAcct(timestamp);
            mDepreciationExp.setA_Depreciation_Entry_ID(0);
            mDepreciationExp.saveEx();
            this.addLog("NEW1: " + mDepreciationExp);
        }
        if (mDepreciationExp.getA_Depreciation_Entry_ID() > 0) {
            int n = DB.getSQLValueEx(mDepreciationExp.get_TrxName(), "SELECT C_Period_ID FROM A_Depreciation_Entry WHERE A_Depreciation_Entry_ID=?", mDepreciationExp.getA_Depreciation_Entry_ID());
            MPeriod mPeriod = MPeriod.get(mDepreciationExp.getCtx(), n);
            if (!mPeriod.isInPeriod(mDepreciationExp.getDateAcct())) {
                this.addLog("OLD2: " + mDepreciationExp);
                MDepreciationEntry.deleteFacts(mDepreciationExp);
                mDepreciationExp.setA_Depreciation_Entry_ID(0);
                mDepreciationExp.saveEx();
                this.addLog("NEW2: " + mDepreciationExp);
            }
        }
    }

    private List<MDepreciationExp> getDepreciation(MAsset mAsset) {
        String string = "A_Asset_ID=?";
        return new Query(this.getCtx(), "A_Depreciation_Exp", string, this.get_TrxName()).setParameters(mAsset.get_ID()).setOrderBy("A_Period").list();
    }
}

