/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.process;

import java.io.File;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MAssetDelivery;
import org.compiere.asset.process.AssetDeliveryAbstract;
import org.compiere.model.MClient;
import org.compiere.model.MMailText;
import org.compiere.model.MProductDownload;
import org.compiere.model.MUser;
import org.compiere.model.Query;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.spin.queue.notification.DefaultNotifier;
import org.spin.queue.util.QueueLoader;

public class AssetDelivery
extends AssetDeliveryAbstract {
    private MClient client = null;
    private MMailText mailTemplate = null;
    private AtomicInteger count;
    private AtomicInteger errors;
    private AtomicInteger reminders;
    private AtomicInteger delivered;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getGuaranteeDate() == null) {
            this.setGuaranteeDate(new Timestamp(System.currentTimeMillis()));
        }
        this.client = MClient.get(this.getCtx());
        this.count = new AtomicInteger();
        this.errors = new AtomicInteger();
        this.reminders = new AtomicInteger();
        this.delivered = new AtomicInteger();
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("");
        long l = System.currentTimeMillis();
        if (!this.isSelection()) {
            StringBuffer stringBuffer = new StringBuffer();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (this.getAssetId() != 0) {
                stringBuffer.append("A_Asset_ID = ?");
                arrayList.add(this.getAssetId());
            }
            if (this.getAssetGroupId() != 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append("A_Asset_Group_ID = ?");
                arrayList.add(this.getAssetGroupId());
            }
            if (this.getProductId() != 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append("M_Product_ID = ?");
                arrayList.add(this.getProductId());
            }
            if (arrayList.size() == 0) {
                throw new AdempiereException("@RestrictSelection@");
            }
            if (this.getMailTextId() == 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append("GuaranteeDate >= ?");
                arrayList.add(this.getGuaranteeDate());
            }
            new Query(this.getCtx(), "A_Asset", stringBuffer.toString(), this.get_TrxName()).setParameters(arrayList).setOrderBy("Value").list().forEach(mAsset -> this.deliverAsset((MAsset)mAsset));
        } else {
            this.getInstancesForSelection(this.get_TrxName()).forEach(mAsset -> this.deliverAsset((MAsset)mAsset));
        }
        this.log.info("Count=" + this.count + ", Errors=" + this.errors + ", Reminder=" + this.reminders + " - " + (System.currentTimeMillis() - l) + "ms");
        return "@IsDelivered@=" + this.delivered + " - @Sent@=" + this.count + " - @Errors@=" + this.errors;
    }

    private void deliverAsset(MAsset mAsset) {
        if (this.getBPartnerId() != 0) {
            int n = -1;
            int n2 = -1;
            boolean bl = this.getParameterAsBoolean("IsReturnedToOrganization");
            if (!bl) {
                n = this.getBPartnerId();
                n2 = this.getUserId();
            }
            mAsset.setIsInPosession(bl);
            mAsset.setC_BPartner_ID(n);
            mAsset.setAD_User_ID(n2);
            mAsset.saveEx();
            MAssetDelivery mAssetDelivery = new MAssetDelivery(mAsset, this.getBPartnerId(), 0, this.getParameterAsTimestamp("MovementDate"));
            String string = this.getParameterAsString("Description");
            if (!Util.isEmpty(string)) {
                mAssetDelivery.setDescription(string);
            }
            mAssetDelivery.saveEx();
            this.delivered.getAndIncrement();
        }
        if (this.isSendEMail()) {
            this.notifyAsset(mAsset);
        }
    }

    private void notifyAsset(MAsset mAsset) {
        if (mAsset.getGuaranteeDate() != null && mAsset.getGuaranteeDate().before(this.getGuaranteeDate())) {
            if (this.getMailTextId() != 0) {
                this.sendNoGuaranteeMail(mAsset);
                this.reminders.getAndIncrement();
            }
        } else {
            String string = this.sendDeliveryeMail(mAsset);
            this.addLog(mAsset.getA_Asset_ID(), null, null, string);
            if (string.startsWith("** ")) {
                this.errors.getAndIncrement();
            } else {
                this.count.getAndIncrement();
            }
        }
    }

    private String sendNoGuaranteeMail(MAsset mAsset) {
        if (mAsset.getAD_User_ID() == 0) {
            return Msg.parseTranslation(this.getCtx(), "@A_Asset_ID@ @AD_User_ID@ @NotFound@");
        }
        MUser mUser = new MUser(this.getCtx(), mAsset.getAD_User_ID(), this.get_TrxName());
        if (this.mailTemplate == null || this.mailTemplate.getR_MailText_ID() != this.getMailTextId()) {
            this.mailTemplate = new MMailText(this.getCtx(), this.getMailTextId(), this.get_TrxName());
        }
        if (Util.isEmpty(this.mailTemplate.getMailHeader())) {
            return Msg.parseTranslation(this.getCtx(), "@Subject@ @NotFound@");
        }
        this.mailTemplate.setPO(mUser);
        this.mailTemplate.setPO(mAsset);
        String string = this.mailTemplate.getMailText(true);
        DefaultNotifier defaultNotifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(this.getCtx()).withTransactionName(this.get_TrxName());
        defaultNotifier.clearMessage().withApplicationType("UDP").withUserId(this.getAD_User_ID()).addRecipient(mUser.getAD_User_ID()).withText(string).withDescription(this.mailTemplate.getMailHeader()).withEntity(MAsset.Table_ID, mAsset.getA_Asset_ID());
        defaultNotifier.addToQueue();
        return mUser.getEMail();
    }

    private String sendDeliveryeMail(MAsset mAsset) {
        this.log.fine("A_Asset_ID=" + mAsset.getA_Asset_ID());
        long l = System.currentTimeMillis();
        if (mAsset.getAD_User_ID() == 0) {
            return Msg.parseTranslation(this.getCtx(), "@A_Asset_ID@ @AD_User_ID@ @NotFound@");
        }
        MUser mUser = new MUser(this.getCtx(), mAsset.getAD_User_ID(), this.get_TrxName());
        if (mAsset.getProductR_MailText_ID() == 0) {
            return Msg.parseTranslation(this.getCtx(), "@ProductR_MailText_ID@ @NotFound@");
        }
        if (this.mailTemplate == null || this.mailTemplate.getR_MailText_ID() != mAsset.getProductR_MailText_ID()) {
            this.mailTemplate = new MMailText(this.getCtx(), mAsset.getProductR_MailText_ID(), this.get_TrxName());
        }
        if (this.mailTemplate.getMailHeader() == null || this.mailTemplate.getMailHeader().length() == 0) {
            return Msg.parseTranslation(this.getCtx(), "@Subject@ @NotFound@");
        }
        this.mailTemplate.setUser(mUser);
        this.mailTemplate.setPO(mAsset);
        String string = this.mailTemplate.getMailText(true);
        DefaultNotifier defaultNotifier = (DefaultNotifier)QueueLoader.getInstance().getQueueManager("NTF").withContext(this.getCtx()).withTransactionName(this.get_TrxName());
        defaultNotifier.clearMessage().withApplicationType("UDP").withUserId(this.getAD_User_ID()).addRecipient(mUser.getAD_User_ID()).withText(string).withDescription(this.mailTemplate.getMailHeader()).withEntity(MAsset.Table_ID, mAsset.getA_Asset_ID());
        if (this.isAttachAsset()) {
            MProductDownload[] mProductDownloadArray = mAsset.getProductDownloads();
            if (mProductDownloadArray != null) {
                for (MProductDownload mProductDownload : mProductDownloadArray) {
                    File file = mProductDownload.getDownloadFile(this.client.getDocumentDir());
                    defaultNotifier.addAttachment(file);
                }
            } else {
                this.log.warning("No DowloadURL for Asset=" + mAsset);
            }
        }
        defaultNotifier.addToQueue();
        this.log.fine(System.currentTimeMillis() - l + " ms");
        return mUser.getEMail() + " - " + mAsset.getProductVersionNo();
    }
}

