/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model.validator;

import java.util.List;
import org.adempiere.core.domains.models.I_M_Product;
import org.adempiere.core.domains.models.X_A_Asset;
import org.adempiere.core.domains.models.X_C_Invoice;
import org.adempiere.core.domains.models.X_C_InvoiceLine;
import org.adempiere.core.domains.models.X_M_InOut;
import org.adempiere.core.domains.models.X_M_InOutLine;
import org.adempiere.core.domains.models.X_M_Product_Category;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.acct.Fact;
import org.compiere.asset.exceptions.AssetProductStockedException;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MAssetAddition;
import org.compiere.asset.model.MAssetDisposed;
import org.compiere.asset.model.MAssetGroup;
import org.compiere.asset.model.SetGetModel;
import org.compiere.asset.model.SetGetUtil;
import org.compiere.model.FactsValidator;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class FixedAsset
implements ModelValidator,
FactsValidator {
    private static CLogger log = CLogger.getCLogger(FixedAsset.class);
    private int clientId = -1;

    @Override
    public int getAD_Client_ID() {
        return this.clientId;
    }

    @Override
    public void initialize(ModelValidationEngine modelValidationEngine, MClient mClient) {
        if (mClient != null) {
            this.clientId = mClient.getAD_Client_ID();
        }
        modelValidationEngine.addModelChange("C_InvoiceLine", this);
        modelValidationEngine.addModelChange("M_MatchInv", this);
        modelValidationEngine.addModelChange("A_Asset_Group", this);
        modelValidationEngine.addDocValidate("C_Invoice", this);
        modelValidationEngine.addDocValidate("M_InOut", this);
    }

    @Override
    public String login(int n, int n2, int n3) {
        return null;
    }

    @Override
    public String modelChange(PO pO, int n) throws Exception {
        if (pO instanceof MMatchInv && (4 == n || 5 == n && pO.is_ValueChanged("Processed"))) {
            MInvoiceLine mInvoiceLine;
            MMatchInv mMatchInv = (MMatchInv)pO;
            if (mMatchInv.isProcessed() && (mInvoiceLine = new MInvoiceLine(mMatchInv.getCtx(), mMatchInv.getC_InvoiceLine_ID(), mMatchInv.get_TrxName())).isA_CreateAsset() && !mInvoiceLine.isA_Processed()) {
                int n2 = 1;
                if ("Exp".equals(mInvoiceLine.getA_CapvsExp())) {
                    mInvoiceLine.set_ValueOfColumn("IsCollectiveAsset", (Object)false);
                }
                if ("Cap".equals(mInvoiceLine.getA_CapvsExp()) && mInvoiceLine.getA_Asset_ID() > 0) {
                    mInvoiceLine.set_ValueOfColumn("IsCollectiveAsset", (Object)false);
                }
                if ("Cap".equals(mInvoiceLine.getA_CapvsExp()) && mInvoiceLine.getA_Asset_ID() <= 0 && !mInvoiceLine.get_ValueAsBoolean("IsCollectiveAsset")) {
                    n2 = mMatchInv.getQty().intValue();
                }
                for (int i = 0; i < n2; ++i) {
                    MAssetAddition.createAsset(mMatchInv);
                }
            }
        } else if (pO instanceof MInvoiceLine) {
            MInvoiceLine mInvoiceLine = (MInvoiceLine)pO;
            if (n == 2 || n == 1) {
                this.beforeSave(mInvoiceLine, n == 1);
            }
            FixedAsset.modelChange_InvoiceLine(SetGetUtil.wrap(pO), n);
        } else if (pO.get_TableName().equals("A_Asset_Group")) {
            MAssetGroup mAssetGroup = (MAssetGroup)pO;
            if (n == 1 || n == 2) {
                this.beforeSave(mAssetGroup, n == 1);
            } else if (n == 4 || n == 5) {
                this.afterSave(mAssetGroup, n == 4);
            } else if (n == 3) {
                this.beforeDelete(mAssetGroup);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String docValidate(PO pO, int n) {
        int n2;
        PO[] pOArray;
        Object object;
        PO pO3;
        log.info(pO.get_TableName() + " Timing: " + n);
        String string = null;
        String string2 = pO.get_TableName();
        if (string2.equals("C_Invoice")) {
            if (n == 9 && ((X_C_Invoice)(pO3 = (MInvoice)pO)).isSOTrx()) {
                void mInvoiceLine;
                object = ((MInvoice)pO3).getLines();
                pOArray = object;
                n2 = pOArray.length;
                boolean i = false;
                while (mInvoiceLine < n2) {
                    PO pO2 = pOArray[mInvoiceLine];
                    if (((X_C_InvoiceLine)pO2).isA_CreateAsset() && !((X_C_InvoiceLine)pO2).isA_Processed()) {
                        if (((X_C_InvoiceLine)pO2).getA_Asset_ID() <= 0) {
                            throw new AdempiereException("@A_Asset_ID@ @NotFound@");
                        }
                        MAssetDisposed.createAssetDisposed((MInvoiceLine)pO2);
                    }
                    ++mInvoiceLine;
                }
            }
            if (n == 10 && (object = this.afterVoid((MInvoice)(pO3 = (MInvoice)pO))) != null) {
                return object;
            }
            if (n == 5 && (object = this.beforeReverseCorrect((MInvoice)(pO3 = (MInvoice)pO))) != null) {
                return object;
            }
        }
        if (string2.equals("M_InOut")) {
            PO pO4;
            if (n == 9) {
                pO3 = (MInOut)pO;
                for (MInvoiceLine mInvoiceLine : ((MInOut)pO3).getLines()) {
                    MProduct mProduct = ((MInOutLine)((Object)mInvoiceLine)).getProduct();
                    pO4 = MProductCategory.get(mProduct.getCtx(), mProduct.getM_Product_Category_ID());
                    MAssetGroup mAssetGroup = MAssetGroup.get(mProduct.getCtx(), ((X_M_Product_Category)pO4).getA_Asset_Group_ID());
                    if (mProduct == null || !((X_M_InOut)pO3).isSOTrx() || !mProduct.isCreateAsset() || mAssetGroup.isFixedAsset() || ((X_M_InOutLine)((Object)mInvoiceLine)).getMovementQty().signum() <= 0 || ((MInOut)pO3).isReversal()) continue;
                    log.fine("Asset");
                    int n3 = ((X_M_InOutLine)((Object)mInvoiceLine)).getMovementQty().intValue();
                    if (!mProduct.isOneAssetPerUOM()) {
                        n3 = 1;
                    }
                    for (int i = 0; i < n3; ++i) {
                        int n4 = i + 1;
                        if (!mProduct.isOneAssetPerUOM()) {
                            n4 = 0;
                        }
                        MAsset mAsset = new MAsset((MInOut)pO3, (MInOutLine)((Object)mInvoiceLine), n4);
                        mAsset.saveEx(pO3.get_TrxName());
                    }
                }
            }
            if (n == 13) {
                void var9_14;
                pO3 = (MInOut)pO;
                object = ((X_M_InOut)pO3).getReversal();
                pOArray = ((MInOut)pO3).getLines();
                n2 = pOArray.length;
                boolean bl = false;
                while (var9_14 < n2) {
                    PO pO5 = pOArray[var9_14];
                    pO4 = MAsset.getFromShipment(pO3.getCtx(), ((X_M_InOutLine)pO5).getM_InOutLine_ID(), pO3.get_TrxName());
                    if (pO4 != null) {
                        pO4.setIsActive(false);
                        ((X_A_Asset)pO4).setDescription(((X_A_Asset)pO4).getDescription() + " (" + object.getDocumentNo() + " #" + ((X_M_InOutLine)pO5).getLine() + "<-)");
                        pO4.saveEx();
                    }
                    ++var9_14;
                }
            }
        }
        return string;
    }

    public static void modelChange_InvoiceLine(SetGetModel setGetModel, int n) {
        if (-1 == n || 1 == n || 2 == n) {
            boolean bl;
            PO pO;
            boolean bl2 = false;
            int n2 = 0;
            boolean bl3 = SetGetUtil.get_AttrValueAsBoolean(setGetModel, "A_CreateAsset");
            int n3 = SetGetUtil.get_AttrValueAsInt(setGetModel, "M_Product_ID");
            if (n3 > 0) {
                pO = MProduct.get(setGetModel.getCtx(), n3, setGetModel.get_TrxName());
                if (((MProduct)pO).isCreateAsset()) {
                    bl = pO != null && pO.get_ID() > 0 && ((MProduct)pO).isCreateAsset();
                    n2 = ((MProduct)pO).getA_Asset_Group_ID();
                } else {
                    n2 = SetGetUtil.get_AttrValueAsInt(setGetModel, "A_Asset_Group_ID");
                }
            }
            setGetModel.set_AttrValue("A_CreateAsset", bl);
            if (bl) {
                setGetModel.set_AttrValue("A_Asset_Group_ID", n2);
                setGetModel.set_AttrValue("IsFixedAssetInvoice", bl);
                setGetModel.set_AttrValue("A_CreateAsset", "Y");
            } else {
                setGetModel.set_AttrValue("A_Asset_Group_ID", null);
                setGetModel.set_AttrValue("A_Asset_ID", null);
                setGetModel.set_AttrValue("IsFixedAssetInvoice", false);
            }
            if (bl && setGetModel instanceof MInvoiceLine) {
                pO = (MInvoiceLine)((Object)setGetModel);
                if ("Exp".equals(((X_C_InvoiceLine)pO).getA_CapvsExp()) && ((X_C_InvoiceLine)pO).getA_Asset_ID() <= 0) {
                    throw new FillMandatoryException(new String[]{"A_Asset_ID"});
                }
                if (((X_C_InvoiceLine)pO).getLineNetAmt().signum() == 0) {
                    throw new FillMandatoryException("QtyEntered", "PriceEntered");
                }
                MProduct mProduct = ((MInvoiceLine)pO).getProduct();
                if (mProduct.isStocked() && pO.get_ValueAsBoolean("IsFixedAssetInvoice")) {
                    throw new AssetProductStockedException(mProduct);
                }
            }
        }
        if (4 == n || 5 == n || 6 == n) {
            int n4 = SetGetUtil.get_AttrValueAsInt(setGetModel, "C_Invoice_ID");
            String string = "UPDATE C_Invoice i SET IsFixedAssetInvoice=(SELECT COALESCE(MAX(il.IsFixedAssetInvoice),'N') FROM C_InvoiceLine il WHERE il.C_Invoice_ID=i.C_Invoice_ID AND il.IsDescription='N') WHERE C_Invoice_ID=?";
            DB.executeUpdateEx(string, new Object[]{n4}, setGetModel.get_TrxName());
        }
    }

    private String beforeSave(MAssetGroup mAssetGroup, boolean bl) throws Exception {
        int n;
        if (mAssetGroup.is_ValueChanged("IsDefault") && (n = DB.getSQLValue(mAssetGroup.get_TrxName(), "SELECT count(*) FROM A_Asset_Group WHERE IsActive='Y' AND IsDefault='Y' AND Ad_Client_ID=? AND Ad_Org_ID=?", mAssetGroup.getAD_Client_ID(), mAssetGroup.getAD_Org_ID())) == 1 && !mAssetGroup.isDefault() && !bl) {
            throw new IllegalStateException("One active Default is expected");
        }
        return null;
    }

    private String afterSave(MAssetGroup mAssetGroup, boolean bl) throws Exception {
        if (mAssetGroup.isDefault()) {
            DB.executeUpdateEx("UPDATE A_Asset_Group SET IsDefault='N' WHERE IsActive='Y' AND Ad_Client_ID=? AND Ad_Org_ID=? AND A_Asset_Group_ID !=?", new Object[]{mAssetGroup.getAD_Client_ID(), mAssetGroup.getAD_Org_ID(), mAssetGroup.getA_Asset_Group_ID()}, mAssetGroup.get_TrxName());
        }
        return null;
    }

    private String beforeDelete(MAssetGroup mAssetGroup) throws Exception {
        int n = DB.getSQLValue(mAssetGroup.get_TrxName(), "SELECT count(*) FROM A_Asset_Group WHERE IsActive='Y' AND IsDefault='Y' AND Ad_Client_ID=? AND Ad_Org_ID=? AND A_Asset_Group_ID=? ", mAssetGroup.getAD_Client_ID(), mAssetGroup.getAD_Org_ID(), mAssetGroup.getA_Asset_Group_ID());
        if (n == 1) {
            throw new IllegalStateException("One active Default is expected");
        }
        return null;
    }

    private boolean beforeSave(MInvoiceLine mInvoiceLine, boolean bl) {
        if (mInvoiceLine.isA_CreateAsset()) {
            MAsset mAsset;
            I_M_Product i_M_Product = mInvoiceLine.getM_Product();
            if ("Cap".equals(mInvoiceLine.getA_CapvsExp()) && i_M_Product.getM_Product_Category().getA_Asset_Group_ID() == 0) {
                throw new AdempiereException("@A_Asset_Group_ID@ @NotFound@ @To@ @M_Product_ID@ : " + i_M_Product.getName());
            }
            if ("Cap".equals(mInvoiceLine.getA_CapvsExp()) && mInvoiceLine.getA_Asset_ID() > 0) {
                mAsset = MAsset.get(mInvoiceLine.getCtx(), mInvoiceLine.getA_Asset_ID(), null);
                if (mInvoiceLine.getA_Asset_Group_ID() != mAsset.getA_Asset_Group_ID()) {
                    throw new AdempiereException(Msg.translate(mInvoiceLine.getCtx(), "Asset Group on Invoice Line is different from Asset Group on Asset"));
                }
                if (mInvoiceLine.getM_Product_ID() != mAsset.getM_Product_ID()) {
                    throw new AdempiereException(Msg.translate(mInvoiceLine.getCtx(), "Product on Invoice Line is different from Asset Product"));
                }
            }
            if ("Exp".equals(mInvoiceLine.getA_CapvsExp()) && mInvoiceLine.getA_Asset_ID() > 0) {
                mAsset = MAsset.get(mInvoiceLine.getCtx(), mInvoiceLine.getA_Asset_ID(), null);
                mInvoiceLine.setA_Asset_ID(mAsset.getA_Asset_ID());
                mInvoiceLine.setA_Asset_Group_ID(mAsset.getA_Asset_Group_ID());
                mInvoiceLine.setA_CapvsExp("Exp");
            }
        }
        return true;
    }

    private String beforeReverseCorrect(MInvoice mInvoice) {
        if (mInvoice.get_ValueAsBoolean("IsFixedAssetInvoice")) {
            int n = DB.getSQLValueEx(mInvoice.get_TrxName(), "SELECT A_Asset_Addition_ID FROM A_Asset_Addition WHERE C_Invoice_ID=? ", mInvoice.get_ID());
            MAssetAddition mAssetAddition = new MAssetAddition(mInvoice.getCtx(), n, mInvoice.get_TrxName());
            if (mAssetAddition.getDocStatus().equals("CO") || mAssetAddition.getDocStatus().equals("CL")) {
                return "Can't Void or Reverse Invoice with Completed Asset Addition";
            }
        }
        return null;
    }

    private String afterVoid(MInvoice mInvoice) {
        if (mInvoice.get_ValueAsBoolean("IsFixedAssetInvoice")) {
            int n = DB.getSQLValueEx(mInvoice.get_TrxName(), "SELECT A_Asset_Addition_ID FROM A_Asset_Addition WHERE C_Invoice_ID=? ", mInvoice.get_ID());
            MAssetAddition mAssetAddition = new MAssetAddition(mInvoice.getCtx(), n, mInvoice.get_TrxName());
            if ("DR".equals(mAssetAddition.getDocStatus()) || "IP".equals(mAssetAddition.getDocStatus()) || "IN".equals(mAssetAddition.getDocStatus()) || "AP".equals(mAssetAddition.getDocStatus()) || "NA".equals(mAssetAddition.getDocStatus())) {
                if (!mAssetAddition.processIt("VO")) {
                    log.warning("Asset Addition Process Failed: " + mAssetAddition + " - " + mAssetAddition.getProcessMsg());
                    throw new IllegalStateException("Asset Addition Process Failed: " + mAssetAddition + " - " + mAssetAddition.getProcessMsg());
                }
                mAssetAddition.saveEx();
            }
        }
        return null;
    }

    @Override
    public String factsValidate(MAcctSchema mAcctSchema, List<Fact> list, PO pO) {
        return null;
    }
}

