/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.adempiere.model.GridTabWrapper;
import org.compiere.asset.model.SetGetModel;
import org.compiere.model.GridTab;
import org.compiere.model.MLookupFactory;
import org.compiere.model.PO;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Util;

public class SetGetUtil {
    private static CLogger s_log = CLogger.getCLogger(SetGetUtil.class);

    public static void updateColumns(SetGetModel setGetModel, String[] stringArray, String string, Object[] objectArray, String string2) {
        SetGetUtil.updateColumns(new SetGetModel[]{setGetModel}, stringArray, string, objectArray, string2);
    }

    public static void updateColumns(SetGetModel setGetModel, String[] stringArray, String string, String string2) {
        SetGetUtil.updateColumns(new SetGetModel[]{setGetModel}, stringArray, string, null, string2);
    }

    public static void updateColumns(SetGetModel[] setGetModelArray, String[] stringArray, String string, Object[] objectArray, String string2) {
        CPreparedStatement cPreparedStatement = null;
        ResultSet resultSet = null;
        try {
            cPreparedStatement = DB.prepareStatement(string, string2);
            DB.setParameters((PreparedStatement)cPreparedStatement, objectArray);
            resultSet = cPreparedStatement.executeQuery();
            SetGetUtil.updateColumns(setGetModelArray, stringArray, resultSet);
        }
        catch (SQLException sQLException) {
            try {
                throw new DBException(sQLException, string);
            }
            catch (Throwable throwable) {
                DB.close(resultSet, cPreparedStatement);
                resultSet = null;
                cPreparedStatement = null;
                throw throwable;
            }
        }
        DB.close(resultSet, cPreparedStatement);
        resultSet = null;
        cPreparedStatement = null;
    }

    public static void updateColumns(SetGetModel[] setGetModelArray, String[] stringArray, ResultSet resultSet) throws SQLException {
        for (SetGetModel setGetModel : setGetModelArray) {
            if (CLogMgt.isLevelFinest()) {
                s_log.finest("Model: " + setGetModel);
            }
            if (resultSet.next()) {
                if (stringArray == null) {
                    stringArray = SetGetUtil.getColumnNames(resultSet);
                }
                for (String string : stringArray) {
                    if (Util.isEmpty(string)) continue;
                    Object object = null;
                    boolean bl = false;
                    object = resultSet.getObject(string);
                    if (object instanceof Date) {
                        object = new Timestamp(((Date)object).getTime());
                    } else if (object instanceof BigDecimal && string.endsWith("_ID")) {
                        object = ((BigDecimal)object).intValue();
                    }
                    bl = setGetModel.set_AttrValue(string, object);
                    if (!CLogMgt.isLevelFinest()) continue;
                    s_log.finest("columnName=" + string + ", value=[" + object + "][" + (object != null ? object.getClass().getName() : "null") + "], ok=" + bl);
                }
                continue;
            }
            s_log.finest("@NoResult@");
            break;
        }
    }

    public static void updateColumns(SetGetModel setGetModel, String[] stringArray, ResultSet resultSet) throws SQLException {
        SetGetUtil.updateColumns(new SetGetModel[]{setGetModel}, stringArray, resultSet);
    }

    private static final String[] getColumnNames(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            return new String[0];
        }
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        String[] stringArray = new String[n];
        for (int i = 1; i <= n; ++i) {
            stringArray[i - 1] = resultSetMetaData.getColumnName(i).toUpperCase();
        }
        return stringArray;
    }

    public static boolean copyValues(SetGetModel setGetModel, String string, int n, String[] stringArray) {
        if (setGetModel == null || string == null || n <= 0 || stringArray == null || stringArray.length == 0) {
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : stringArray) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(string2);
        }
        stringBuffer.insert(0, "SELECT ");
        stringBuffer.append(" FROM ").append(string).append(" WHERE ").append(string).append("_ID=").append(n);
        SetGetUtil.updateColumns(setGetModel, stringArray, stringBuffer.toString(), null);
        return true;
    }

    public static int get_AttrValueAsInt(SetGetModel setGetModel, String string) {
        Object object = setGetModel.get_AttrValue(string);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return 0;
    }

    public static Timestamp get_AttrValueAsDate(SetGetModel setGetModel, String string) {
        Object object = setGetModel.get_AttrValue(string);
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        return null;
    }

    public static BigDecimal get_AttrValueAsBigDecimal(SetGetModel setGetModel, String string) {
        Object object = setGetModel.get_AttrValue(string);
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        return BigDecimal.ZERO;
    }

    public static boolean get_AttrValueAsBoolean(SetGetModel setGetModel, String string) {
        Object object = setGetModel.get_AttrValue(string);
        if (object != null) {
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            return "Y".equals(object);
        }
        return false;
    }

    public static String get_AttrValueAsString(SetGetModel setGetModel, String string, String string2) {
        Object object = setGetModel.get_AttrValue(string);
        if (object == null) {
            return string2;
        }
        return object.toString();
    }

    public static void set_AttrValueEx(SetGetModel setGetModel, String string, Object object) {
        if (!setGetModel.set_AttrValue(string, object)) {
            throw new AdempiereException("Value not set " + string + "=" + object);
        }
    }

    public static boolean is_ValueChanged(SetGetModel setGetModel, String ... stringArray) {
        for (String string : stringArray) {
            if (!setGetModel.is_AttrValueChanged(string)) continue;
            return true;
        }
        return false;
    }

    public static String getTrxName(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SetGetModel) {
            return ((SetGetModel)object).get_TrxName();
        }
        if (object instanceof PO) {
            return ((PO)object).get_TrxName();
        }
        return null;
    }

    public static boolean isUserEntry(Object object) {
        if (object == null) {
            return false;
        }
        return !(object instanceof PO);
    }

    public static void setLineNo(SetGetModel setGetModel, String string, String string2) {
        int n;
        if (string2 == null) {
            string2 = "Line";
        }
        if ((n = SetGetUtil.get_AttrValueAsInt(setGetModel, string2)) != 0) {
            return;
        }
        String string3 = setGetModel.get_TableName();
        String string4 = string3 + "_ID";
        ArrayList<Comparable<Boolean>> arrayList = new ArrayList<Comparable<Boolean>>();
        StringBuffer stringBuffer = new StringBuffer("SELECT COALESCE(MAX(" + string2 + "),0)+10");
        stringBuffer.append(" FROM ").append(string3);
        stringBuffer.append(" WHERE IsActive=?");
        arrayList.add(Boolean.valueOf(true));
        stringBuffer.append(" AND AD_Client_ID IN (0,?)");
        arrayList.add(Integer.valueOf(SetGetUtil.get_AttrValueAsInt(setGetModel, "AD_Client_ID")));
        stringBuffer.append(" AND ").append(string4).append("<>?");
        arrayList.add(Integer.valueOf(SetGetUtil.get_AttrValueAsInt(setGetModel, string4)));
        if (string != null) {
            stringBuffer.append(" AND ").append(string).append("=?");
            arrayList.add(Integer.valueOf(SetGetUtil.get_AttrValueAsInt(setGetModel, string)));
        }
        n = DB.getSQLValueEx(setGetModel.get_TrxName(), stringBuffer.toString(), new Object[]{arrayList});
        setGetModel.set_AttrValue(string2, n);
    }

    public static String getTableName(Class<? extends PO> clazz) {
        try {
            return (String)clazz.getField("Table_Name").get(null);
        }
        catch (Exception exception) {
            throw new AdempiereException(exception);
        }
    }

    public static final boolean isPersistent(Object object) {
        return object != null && object instanceof PO;
    }

    public static Properties getCtx(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SetGetModel) {
            return ((SetGetModel)object).getCtx();
        }
        if (object instanceof PO) {
            return ((PO)object).getCtx();
        }
        return Env.getCtx();
    }

    public static SetGetModel wrap(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof SetGetModel && !(object instanceof Proxy)) {
            return (SetGetModel)object;
        }
        if (object instanceof Proxy && Proxy.getInvocationHandler(object) instanceof GridTabWrapper) {
            GridTabWrapper gridTabWrapper = (GridTabWrapper)Proxy.getInvocationHandler(object);
            return new GridTab2SetGetModelWrapper(gridTabWrapper.getGridTab());
        }
        if (object instanceof GridTab) {
            return new GridTab2SetGetModelWrapper((GridTab)object);
        }
        if (object instanceof PO) {
            final PO pO = (PO)object;
            return new SetGetModel(){

                @Override
                public boolean set_AttrValue(String string, Object object) {
                    return pO.set_ValueOfColumnReturningBoolean(string, object);
                }

                @Override
                public boolean is_AttrValueChanged(String string) {
                    return pO.is_ValueChanged(string);
                }

                @Override
                public String get_TrxName() {
                    return pO.get_TrxName();
                }

                @Override
                public int get_Table_ID() {
                    return pO.get_Table_ID();
                }

                @Override
                public String get_TableName() {
                    return pO.get_TableName();
                }

                @Override
                public Object get_AttrValue(String string) {
                    return pO.get_Value(string);
                }

                @Override
                public Properties getCtx() {
                    return pO.getCtx();
                }
            };
        }
        throw new IllegalArgumentException("Can not wrap to SetGetModel - " + object.getClass());
    }

    public static <T> T newInstance(Properties properties, Class<T> clazz, String string) {
        try {
            return clazz.getConstructor(Properties.class, Integer.TYPE, String.class).newInstance(properties, 0, string);
        }
        catch (Exception exception) {
            throw new AdempiereException(exception);
        }
    }

    public static void appendValue(SetGetModel setGetModel, String string, String string2) {
        if (Util.isEmpty(string2, true)) {
            return;
        }
        String string3 = string2.trim();
        String string4 = SetGetUtil.get_AttrValueAsString(setGetModel, string, null);
        Object object = Util.isEmpty(string4, true) ? string2 : string4 + " | " + string3;
        setGetModel.set_AttrValue(string, object);
    }

    public static String getInfoString(Properties properties, String string, int n, String string2) {
        Language language = Env.getLanguage(properties);
        String string3 = MLookupFactory.getLookup_TableDirEmbed(language, string + "_ID", "[?", "?]").replace("[?.?]", "?");
        Object object = DB.getSQLValueStringEx(string2, string3, n);
        if (Util.isEmpty((String)object)) {
            object = "<" + string + ":" + n + ">";
        }
        return object;
    }

    private static class GridTab2SetGetModelWrapper
    implements SetGetModel {
        private final GridTab tab;

        GridTab2SetGetModelWrapper(GridTab gridTab) {
            this.tab = gridTab;
        }

        @Override
        public Properties getCtx() {
            return Env.getCtx();
        }

        @Override
        public Object get_AttrValue(String string) {
            return this.tab.getValue(string);
        }

        @Override
        public String get_TableName() {
            return this.tab.getTableName();
        }

        @Override
        public int get_Table_ID() {
            return this.tab.getAD_Table_ID();
        }

        @Override
        public String get_TrxName() {
            return null;
        }

        @Override
        public boolean is_AttrValueChanged(String string) {
            return false;
        }

        @Override
        public boolean set_AttrValue(String string, Object object) {
            String string2 = this.tab.setValue(string, object);
            return string2 == null || string2.length() <= 0;
        }
    }
}

