/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.core.domains.models.X_A_RegistrationValue;
import org.compiere.asset.model.MRegistration;
import org.compiere.asset.model.MRegistrationAttribute;

public class MRegistrationValue
extends X_A_RegistrationValue
implements Comparable {
    private static final long serialVersionUID = 3380153548447464552L;
    private String m_registrationAttribute = null;
    private String m_registrationAttributeDescription = null;
    private int m_seqNo = -1;

    public MRegistrationValue(Properties properties, int n, String string) {
        super(properties, 0, string);
        if (n != 0) {
            throw new IllegalArgumentException("Multi-Key");
        }
    }

    public MRegistrationValue(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MRegistrationValue(MRegistration mRegistration, int n, String string) {
        super(mRegistration.getCtx(), 0, mRegistration.get_TrxName());
        this.setClientOrg(mRegistration);
        this.setA_Registration_ID(mRegistration.getA_Registration_ID());
        this.setA_RegistrationAttribute_ID(n);
        this.setName(string);
    }

    public String getRegistrationAttribute() {
        if (this.m_registrationAttribute == null) {
            int n = this.getA_RegistrationAttribute_ID();
            MRegistrationAttribute mRegistrationAttribute = MRegistrationAttribute.get(this.getCtx(), n, this.get_TrxName());
            this.m_registrationAttribute = mRegistrationAttribute.getName();
            this.m_registrationAttributeDescription = mRegistrationAttribute.getDescription();
            this.m_seqNo = mRegistrationAttribute.getSeqNo();
        }
        return this.m_registrationAttribute;
    }

    public String getRegistrationAttributeDescription() {
        if (this.m_registrationAttributeDescription == null) {
            this.getRegistrationAttribute();
        }
        return this.m_registrationAttributeDescription;
    }

    public int getSeqNo() {
        if (this.m_seqNo == -1) {
            this.getRegistrationAttribute();
        }
        return this.m_seqNo;
    }

    public int compareTo(Object object) {
        if (object == null) {
            return 0;
        }
        MRegistrationValue mRegistrationValue = (MRegistrationValue)object;
        int n = this.getSeqNo() - mRegistrationValue.getSeqNo();
        return n;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getSeqNo()).append(": ").append(this.getRegistrationAttribute()).append("=").append(this.getName());
        return stringBuffer.toString();
    }
}

