/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.sql.ResultSet;
import java.util.Properties;
import org.adempiere.core.domains.models.X_A_Asset_Type;
import org.compiere.asset.exceptions.ArhRuntimeException;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MAssetGroup;
import org.compiere.asset.model.SetGetModel;
import org.compiere.asset.model.SetGetUtil;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MAssetType
extends X_A_Asset_Type {
    private static final long serialVersionUID = 1L;
    public static final String A_ASSET_TYPE_MFX = "MFX";
    public static final String A_ASSET_TYPE_INV = "INV";
    public static final int A_ASSET_TYPE_ID_MFX = 1;
    public static final int A_ASSET_TYPE_ID_INV = 2;
    public static final int A_ASSET_TYPE_ID_SUP = 3;
    public static final int A_ASSET_TYPE_ID_OIN = 4;
    private static CCache<Integer, MAssetType> s_cache = new CCache("A_Asset_Type", 10, 0);

    public static MAssetType get(Properties properties, int n) {
        if (n <= 0) {
            return null;
        }
        MAssetType mAssetType = s_cache.get(n);
        if (mAssetType != null) {
            return mAssetType;
        }
        mAssetType = new MAssetType(properties, n, null);
        if (mAssetType.get_ID() > 0) {
            s_cache.put(n, mAssetType);
            return mAssetType;
        }
        return null;
    }

    public static MAssetType get(Properties properties, Object object) {
        if (object == null) {
            return null;
        }
        return MAssetType.get(properties, ((Number)object).intValue());
    }

    public MAssetType(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MAssetType(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public boolean isFixedAsset() {
        return A_ASSET_TYPE_MFX.equals(this.getValue());
    }

    public static boolean isFixedAsset(int n) {
        return new Query(Env.getCtx(), "A_Asset", "A_Asset_ID=? AND A_AssetType=?", null).setParameters(n, A_ASSET_TYPE_MFX).match();
    }

    public static boolean isFixedAsset(MAsset mAsset) {
        if (mAsset.getA_Asset_Type_ID() <= 0) {
            return false;
        }
        MAssetType mAssetType = MAssetType.get(mAsset.getCtx(), mAsset.getA_Asset_Type_ID());
        if (mAssetType.getValue() == null) {
            return false;
        }
        return mAsset != null && A_ASSET_TYPE_MFX.equals(mAssetType.getValue());
    }

    public static boolean isFixedAssetGroup(Properties properties, int n) {
        if (n <= 0) {
            return false;
        }
        MAssetGroup mAssetGroup = MAssetGroup.get(properties, n);
        int n2 = mAssetGroup.getA_Asset_Type_ID();
        if (n2 <= 0) {
            return false;
        }
        MAssetType mAssetType = MAssetType.get(properties, n2);
        return mAssetType.isFixedAsset();
    }

    public boolean isInventoryObject() {
        return A_ASSET_TYPE_INV.equals(this.getValue());
    }

    protected static Boolean getBoolean(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = string.substring(0, 1);
        if ("N".equals(string2)) {
            return Boolean.FALSE;
        }
        if ("Y".equals(string2)) {
            return Boolean.TRUE;
        }
        if ("X".equals(string2) && bl) {
            return MAssetType.getBoolean(string.substring(1), false);
        }
        return null;
    }

    public static void validate(Model model) {
        MAssetType mAssetType = MAssetType.get(model.getCtx(), model.getA_Asset_Type_ID());
        if (mAssetType == null) {
            throw new ArhRuntimeException(model.getCtx(), "@NotFound@ @A_Asset_Type_ID@").addInfo("@A_Asset_Type_ID", model.getA_Asset_Type_ID());
        }
        ArhRuntimeException arhRuntimeException = new ArhRuntimeException(model.getCtx(), "");
        Boolean bl = MAssetType.getBoolean(mAssetType.getIsOwned(), false);
        if (bl != null && bl.booleanValue() != model.isOwned()) {
            arhRuntimeException.addInfo("@IsOwned@ <> @" + bl + "@");
        }
        if ((bl = MAssetType.getBoolean(mAssetType.getIsInPosession(), false)) != null && bl.booleanValue() != model.isInPosession()) {
            arhRuntimeException.addInfo("@IsInPosession@ <> @" + bl + "@");
        }
        if ((bl = MAssetType.getBoolean(mAssetType.getIsDepreciable(), false)) != null && bl.booleanValue() != model.isDepreciated()) {
            arhRuntimeException.addInfo("@IsDepreciated@ <> @" + bl + "@");
        }
        if (arhRuntimeException.hasInfo()) {
            throw arhRuntimeException;
        }
    }

    public boolean update(SetGetModel setGetModel, boolean bl) {
        Boolean bl2 = MAssetType.getBoolean(this.getIsOwned(), bl);
        if (bl2 != null) {
            setGetModel.set_AttrValue("IsOwned", bl2);
        }
        if ((bl2 = MAssetType.getBoolean(this.getIsInPosession(), bl)) != null) {
            setGetModel.set_AttrValue("IsInPosession", bl2);
        }
        if ((bl2 = MAssetType.getBoolean(this.getIsDepreciable(), bl)) != null) {
            setGetModel.set_AttrValue("IsDepreciated", bl2);
        }
        if (!this.isFixedAsset()) {
            setGetModel.set_AttrValue("A_Asset_Class_ID", null);
        }
        setGetModel.set_AttrValue("A_Asset_Type", this.getValue());
        return true;
    }

    public static class Callout
    extends CalloutEngine {
        public String assetType(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
            if (this.isCalloutActive()) {
                return "";
            }
            int n2 = 0;
            if (object == null || !(object instanceof Number)) {
                return "";
            }
            n2 = ((Number)object).intValue();
            MAssetType mAssetType = MAssetType.get(properties, n2);
            if (mAssetType != null) {
                mAssetType.update(SetGetUtil.wrap(gridTab), true);
            }
            return "";
        }
    }

    public static interface Model {
        public Properties getCtx();

        public int getA_Asset_Type_ID();

        public boolean isInPosession();

        public boolean isOwned();

        public boolean isDepreciated();
    }
}

