/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.X_A_Asset_Reval;
import org.adempiere.core.domains.models.X_A_Depreciation_Workfile;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MDepreciationWorkfile;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MAssetReval
extends X_A_Asset_Reval
implements DocAction {
    private static final long serialVersionUID = 1L;
    private boolean m_justPrepared = false;
    private String m_processMsg = null;

    public MAssetReval(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setProcessed(false);
        }
    }

    public MAssetReval(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    @Override
    public boolean approveIt() {
        return false;
    }

    @Override
    public boolean closeIt() {
        this.setDocAction("--");
        return true;
    }

    @Override
    public String prepareIt() {
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), "GLJ", this.getAD_Org_ID());
        MDepreciationWorkfile mDepreciationWorkfile = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType());
        if (!mDepreciationWorkfile.isDepreciated(this.getDateAcct())) {
            throw new AdempiereException("Asset is not depreciated at this moment");
        }
        if (mDepreciationWorkfile.getA_Asset_Cost().equals(this.getA_Asset_Cost_Change()) && mDepreciationWorkfile.getA_Accumulated_Depr().equals(this.getA_Change_Acumulated_Depr())) {
            throw new AdempiereException("Nothing has changed");
        }
        if (mDepreciationWorkfile.getA_Asset_Cost().equals(this.getA_Asset_Cost_Change()) && !mDepreciationWorkfile.getA_Accumulated_Depr().equals(this.getA_Change_Acumulated_Depr())) {
            throw new AdempiereException("It has changed the cost of Asset");
        }
        if (!mDepreciationWorkfile.getA_Asset_Cost().equals(this.getA_Asset_Cost_Change()) && mDepreciationWorkfile.getA_Accumulated_Depr().equals(this.getA_Change_Acumulated_Depr())) {
            throw new AdempiereException("It has changed the cumulative depreciation");
        }
        if (!this.isLastDepreciated(this.getDateAcct())) {
            throw new AdempiereException("It can only review the last month processed");
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    public boolean isLastDepreciated(Timestamp timestamp) {
        MDepreciationWorkfile mDepreciationWorkfile = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType());
        Timestamp timestamp2 = mDepreciationWorkfile.getLastActionDate();
        boolean bl = TimeUtil.getMonthLastDay(timestamp).equals(timestamp2);
        return bl;
    }

    @Override
    public String completeIt() {
        Object object;
        if (!this.m_justPrepared && !"IP".equals(object = this.prepareIt())) {
            return object;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        object = MDepreciationWorkfile.get(this.getCtx(), this.getA_Asset_ID(), this.getPostingType(), this.get_TrxName());
        ((X_A_Depreciation_Workfile)object).setA_Asset_Cost(this.getA_Asset_Cost_Change());
        ((X_A_Depreciation_Workfile)object).setA_Accumulated_Depr(this.getA_Change_Acumulated_Depr());
        ((PO)object).saveEx();
        MAsset mAsset = MAsset.get(this.getCtx(), this.getA_Asset_ID(), this.get_TrxName());
        mAsset.setA_Asset_RevalDate(this.getDateDoc());
        mAsset.saveEx();
        String string = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (string != null) {
            this.m_processMsg = string;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public File createPDF() {
        return null;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return Env.ZERO;
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getCreatedBy();
    }

    @Override
    public String getDocumentInfo() {
        return this.getDocumentNo() + "/" + this.getDateAcct();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public String getSummary() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("@DocumentNo@ #").append(this.getDocumentNo());
        return stringBuffer.toString();
    }

    @Override
    public boolean invalidateIt() {
        return false;
    }

    @Override
    public boolean processIt(String string) throws Exception {
        this.m_processMsg = null;
        DocumentEngine documentEngine = new DocumentEngine(this, this.getDocStatus());
        return documentEngine.processIt(string, this.getDocAction());
    }

    @Override
    public boolean reActivateIt() {
        return false;
    }

    @Override
    public boolean rejectIt() {
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        return false;
    }

    @Override
    public boolean reverseCorrectIt() {
        return false;
    }

    @Override
    public boolean unlockIt() {
        return false;
    }

    @Override
    public boolean voidIt() {
        return false;
    }

    @Override
    public String getDocumentNo() {
        return null;
    }
}

