/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.search.InfoProduct;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLine;
import org.compiere.grid.ed.VNumber;
import org.compiere.grid.ed.VString;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MLot;
import org.compiere.model.MRole;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class InfoPAttribute
extends CDialog {
    private static final long serialVersionUID = -4309055112258081495L;
    private int p_M_AttributeSet_ID = 0;
    private String m_query = "";
    private String m_display = "";
    private ArrayList<Component> m_productEditors = new ArrayList();
    private ArrayList<Component> m_productEditorsTo = new ArrayList();
    private ArrayList<Component> m_instanceEditors = new ArrayList();
    private ArrayList<Component> m_instanceEditorsTo = new ArrayList();
    private static CLogger log = CLogger.getCLogger(InfoPAttribute.class);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel centerPanel = new CPanel();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private CLabel serNoLabel = new CLabel(Msg.translate(Env.getCtx(), "SerNo"));
    private VString serNoField = new VString("SerNo", false, false, true, 10, 20, null, null);
    private CLabel lotLabel = new CLabel(Msg.translate(Env.getCtx(), "Lot"));
    private VString lotField = new VString("Lot", false, false, true, 10, 20, null, null);
    private VComboBox guaranteeDateSelection = null;
    private VDate guaranteeDateField = new VDate("GuaranteeDate", false, false, true, 15, Msg.translate(Env.getCtx(), "GuaranteeDate"));
    private CLabel lotLabel2 = new CLabel(Msg.translate(Env.getCtx(), "M_Lot_ID"));
    private VComboBox lotSelection = null;
    private JScrollPane scrollPane = new JScrollPane();

    public InfoPAttribute(JDialog parent) {
        super(parent, Msg.getMsg(Env.getCtx(), "InfoPAttribute"), true);
        if (parent instanceof InfoProduct) {
            this.p_M_AttributeSet_ID = ((InfoProduct)parent).getM_AttributeSet_ID();
        }
        try {
            this.jbInit();
            this.dynInit();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "InfoPAttribute", e);
        }
        AEnv.showCenterWindow(parent, this);
    }

    private void jbInit() throws Exception {
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.mainPanel.setLayout(this.mainLayout);
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.mainPanel.add((Component)this.scrollPane, "Center");
        this.centerPanel.setLayout(new ALayout());
        this.scrollPane.getViewport().add((Component)this.centerPanel, null);
        this.confirmPanel.addActionListener(this);
        this.mainPanel.add((Component)this.confirmPanel, "South");
    }

    private void dynInit() {
        int row = this.addAttributes();
        boolean isGuarantee = true;
        boolean isSerial = true;
        boolean isLot = true;
        if (this.p_M_AttributeSet_ID > 0) {
            MAttributeSet as = new MAttributeSet(Env.getCtx(), this.p_M_AttributeSet_ID, null);
            isGuarantee = as.isGuaranteeDate();
            isSerial = as.isSerNo();
            isLot = as.isLot();
        }
        String s = Msg.translate(Env.getCtx(), "GuaranteeDate");
        this.guaranteeDateSelection = new VComboBox(new Object[]{s + " <", s + " =", s + " >"});
        this.initLotSelection();
        if (isSerial) {
            this.centerPanel.add((Component)this.serNoLabel, new ALayoutConstraint(row++, 0));
            this.centerPanel.add((Component)this.serNoField, null);
        }
        if (isLot) {
            this.centerPanel.add((Component)this.lotLabel, new ALayoutConstraint(row++, 0));
            this.centerPanel.add((Component)this.lotField, null);
            this.centerPanel.add((Component)this.lotLabel2, new ALayoutConstraint(row++, 0));
            this.centerPanel.add((Component)this.lotSelection, null);
        }
        if (isGuarantee) {
            this.centerPanel.add((Component)this.guaranteeDateSelection, new ALayoutConstraint(row++, 0));
            this.centerPanel.add((Component)this.guaranteeDateField, null);
        }
        Dimension d = this.centerPanel.getPreferredSize();
        d.width = 400;
        this.centerPanel.setPreferredSize(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addAttributes() {
        int row = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        Object whereAttributeSet = this.p_M_AttributeSet_ID > 0 ? "AND M_Attribute_ID IN (SELECT M_Attribute_ID FROM M_AttributeUse WHERE M_AttributeSet_ID=" + this.p_M_AttributeSet_ID + ")" : "";
        String sql = MRole.getDefault().addAccessSQL("SELECT M_Attribute_ID, Name, Description, AttributeValueType, IsInstanceAttribute FROM M_Attribute WHERE IsActive='Y' " + (String)whereAttributeSet + " ORDER BY IsInstanceAttribute, Name", "M_Attribute", false, false);
        boolean instanceLine = false;
        boolean productLine = false;
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                CPanel group;
                int attribute_ID = rs.getInt(1);
                String name = rs.getString(2);
                String description = rs.getString(3);
                String attributeValueType = rs.getString(4);
                boolean isInstanceAttribute = "Y".equals(rs.getString(5));
                if (!productLine && !isInstanceAttribute) {
                    group = new CPanel();
                    group.setBorder(new VLine(Msg.translate(Env.getCtx(), "IsProductAttribute")));
                    group.add(Box.createVerticalStrut(4));
                    this.centerPanel.add((Component)group, new ALayoutConstraint(row++, 0));
                    productLine = true;
                }
                if (!instanceLine && isInstanceAttribute) {
                    group = new CPanel();
                    group.add(Box.createVerticalStrut(4));
                    group.setBorder(new VLine(Msg.translate(Env.getCtx(), "IsInstanceAttribute")));
                    group.add(Box.createVerticalStrut(4));
                    this.centerPanel.add((Component)group, new ALayoutConstraint(row++, 0));
                    instanceLine = true;
                }
                CLabel label = new CLabel(name);
                if (description != null && description.length() > 0) {
                    label.setToolTipText(description);
                }
                this.centerPanel.add((Component)label, new ALayoutConstraint(row++, 0));
                JComponent field = null;
                field = "L".equals(attributeValueType) ? new VComboBox(this.getAttributeList(attribute_ID)) : ("N".equals(attributeValueType) ? new VNumber(name, false, false, true, 22, name) : new VString(name, false, false, true, 10, 40, null, null));
                label.setLabelFor(field);
                this.centerPanel.add((Component)field, null);
                field.setName(String.valueOf(attribute_ID));
                if (isInstanceAttribute) {
                    this.m_instanceEditors.add(field);
                } else {
                    this.m_productEditors.add(field);
                }
                VNumber fieldTo = null;
                if ("N".equals(attributeValueType)) {
                    fieldTo = new VNumber(name, false, false, true, 22, name);
                    this.centerPanel.add((Component)new CLabel("-"), null);
                    this.centerPanel.add((Component)fieldTo, null);
                }
                if (isInstanceAttribute) {
                    this.m_instanceEditorsTo.add(fieldTo);
                    continue;
                }
                this.m_productEditorsTo.add(fieldTo);
            }
        }
        catch (Exception e) {
            try {
                log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (!instanceLine) {
            boolean isGuarantee = true;
            boolean isSerial = true;
            boolean isLot = true;
            if (this.p_M_AttributeSet_ID > 0) {
                MAttributeSet as = new MAttributeSet(Env.getCtx(), this.p_M_AttributeSet_ID, null);
                isGuarantee = as.isGuaranteeDate();
                isSerial = as.isSerNo();
                isLot = as.isLot();
            }
            if (isGuarantee || isSerial || isLot) {
                CPanel group = new CPanel();
                group.setBorder(new VLine(Msg.translate(Env.getCtx(), "IsInstanceAttribute")));
                group.add(Box.createVerticalStrut(4));
                this.centerPanel.add((Component)group, new ALayoutConstraint(row++, 0));
                instanceLine = true;
            }
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyNamePair[] getAttributeList(int M_Attribute_ID) {
        ArrayList<KeyNamePair> list = new ArrayList<KeyNamePair>();
        list.add(new KeyNamePair(-1, ""));
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = MRole.getDefault().addAccessSQL("SELECT M_AttributeValue_ID, Value, Name FROM M_AttributeValue WHERE M_Attribute_ID=? ORDER BY 2", "M_AttributeValue", false, false);
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_Attribute_ID);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new KeyNamePair(rs.getInt(1), rs.getString(3)));
            }
        }
        catch (Exception e) {
            try {
                log.log(Level.SEVERE, sql, e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        KeyNamePair[] retValue = new KeyNamePair[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    private void initLotSelection() {
        List keyNamePairLotList = MLot.getByAttributeSetId(Env.getCtx(), this.p_M_AttributeSet_ID, null).stream().map(lot -> new KeyNamePair(lot.getM_Lot_ID(), lot.getName())).collect(Collectors.toList());
        this.lotSelection = new VComboBox(keyNamePairLotList.toArray());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            this.setDisplay();
            this.createQuery();
            this.dispose();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.m_query = null;
            this.m_display = null;
            this.dispose();
        }
    }

    private String createQuery() {
        BigDecimal valueTo;
        VNumber fieldTo;
        Object value;
        JComponent field;
        int M_Attribute_ID;
        Component cTo;
        Component c;
        int i;
        Timestamp ts;
        KeyNamePair pp;
        StringBuffer sb = new StringBuffer();
        String s = this.serNoField.getText();
        if (s != null && s.length() > 0) {
            sb.append(" AND asi.SerNo");
            if (s.indexOf(37) == -1 && s.indexOf(95) == 1) {
                sb.append("=");
            } else {
                sb.append(" LIKE ");
            }
            sb.append(DB.TO_STRING(s));
        }
        if ((s = this.lotField.getText()) != null && s.length() > 0) {
            sb.append(" AND asi.Lot");
            if (s.indexOf(37) == -1 && s.indexOf(95) == 1) {
                sb.append("=");
            } else {
                sb.append(" LIKE ");
            }
            sb.append(DB.TO_STRING(s));
        }
        if ((pp = (KeyNamePair)this.lotSelection.getSelectedItem()) != null && pp.getKey() != -1) {
            int ID2 = pp.getKey();
            sb.append(" AND asi.M_Lot_ID=").append(ID2);
        }
        if ((ts = (Timestamp)this.guaranteeDateField.getValue()) != null) {
            sb.append(" AND TRUNC(asi.GuaranteeDate, 'DD')");
            int index = this.guaranteeDateSelection.getSelectedIndex();
            if (index == 0) {
                sb.append("<");
            } else if (index == 1) {
                sb.append("=");
            } else {
                sb.append(">");
            }
            sb.append(DB.TO_DATE(ts, true));
        }
        for (i = 0; i < this.m_instanceEditors.size(); ++i) {
            StringBuffer iAttr = new StringBuffer();
            c = this.m_instanceEditors.get(i);
            cTo = this.m_instanceEditorsTo.get(i);
            M_Attribute_ID = Integer.parseInt(c.getName());
            if (c instanceof VComboBox) {
                field = (VComboBox)c;
                pp = (KeyNamePair)((JComboBox)field).getSelectedItem();
                if (pp != null && pp.getKey() != -1) {
                    iAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND M_AttributeValue_ID=").append(pp.getKey());
                }
            } else if (c instanceof VNumber) {
                field = (VNumber)c;
                value = (BigDecimal)((VNumber)field).getValue();
                fieldTo = (VNumber)cTo;
                valueTo = (BigDecimal)fieldTo.getValue();
                if (value != null || valueTo != null) {
                    iAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND ValueNumber");
                    if (value != null && valueTo == null) {
                        iAttr.append("=").append(value);
                    } else if (value == null && valueTo != null) {
                        iAttr.append("<=").append(valueTo);
                    } else if (value != null && valueTo != null) {
                        iAttr.append(" BETWEEN ").append(value).append(" AND ").append(valueTo);
                    }
                }
            } else {
                field = (VString)c;
                value = ((VString)field).getText();
                if (value != null && ((String)value).length() > 0) {
                    iAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND Value");
                    if (((String)value).indexOf(37) == -1 && ((String)value).indexOf(95) == -1) {
                        iAttr.append("=");
                    } else {
                        iAttr.append(" LIKE ");
                    }
                    iAttr.append(DB.TO_STRING((String)value));
                }
            }
            if (iAttr.length() <= 0) continue;
            sb.append(" AND asi.M_AttributeSetInstance_ID IN (SELECT M_AttributeSetInstance_ID FROM M_AttributeInstance WHERE ").append(iAttr).append(")");
        }
        if (sb.length() > 0) {
            sb.insert(0, " AND EXISTS (SELECT * FROM M_Storage s INNER JOIN M_AttributeSetInstance asi ON (s.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID) WHERE s.M_Product_ID=p.M_Product_ID");
            sb.append(")");
        }
        for (i = 0; i < this.m_productEditors.size(); ++i) {
            StringBuffer pAttr = new StringBuffer();
            c = this.m_productEditors.get(i);
            cTo = this.m_productEditorsTo.get(i);
            M_Attribute_ID = Integer.parseInt(c.getName());
            if (c instanceof VComboBox) {
                field = (VComboBox)c;
                pp = (KeyNamePair)((JComboBox)field).getSelectedItem();
                if (pp != null && pp.getKey() != -1) {
                    pAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND M_AttributeValue_ID=").append(pp.getKey());
                }
            } else if (c instanceof VNumber) {
                field = (VNumber)c;
                value = (BigDecimal)((VNumber)field).getValue();
                fieldTo = (VNumber)cTo;
                valueTo = (BigDecimal)fieldTo.getValue();
                if (value != null || valueTo != null) {
                    pAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND ValueNumber");
                    if (value != null && valueTo == null) {
                        pAttr.append("=").append(value);
                    } else if (value == null && valueTo != null) {
                        pAttr.append("<=").append(valueTo);
                    } else if (value != null && valueTo != null) {
                        pAttr.append(" BETWEEN ").append(value).append(" AND ").append(valueTo);
                    }
                }
            } else {
                field = (VString)c;
                value = ((VString)field).getText();
                if (value != null && ((String)value).length() > 0) {
                    pAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND Value");
                    if (((String)value).indexOf(37) == -1 && ((String)value).indexOf(95) == -1) {
                        pAttr.append("=");
                    } else {
                        pAttr.append(" LIKE ");
                    }
                    pAttr.append(DB.TO_STRING((String)value));
                }
            }
            if (pAttr.length() <= 0) continue;
            sb.append(" AND p.M_AttributeSetInstance_ID IN (SELECT M_AttributeSetInstance_ID FROM M_AttributeInstance WHERE ").append(pAttr).append(")");
        }
        this.m_query = null;
        if (sb.length() > 0) {
            this.m_query = sb.toString();
        }
        log.config(this.m_query);
        return this.m_query;
    }

    public String getDisplay() {
        return this.m_display;
    }

    private void setDisplay() {
        VNumber fieldTo;
        JComponent field;
        Component cTo;
        Component c;
        int i;
        StringBuffer display = new StringBuffer();
        if (this.serNoField != null && this.serNoField.getValue().toString().length() > 0) {
            display.append(this.serNoField.getValue().toString() + "-");
        }
        if (this.lotField != null && this.lotField.getValue().toString().length() > 0) {
            display.append(this.lotField.getValue().toString() + "-");
        }
        if (this.lotSelection != null && this.lotSelection.getDisplay().length() > 0) {
            display.append(this.lotSelection.getDisplay() + "-");
        }
        if (this.guaranteeDateField != null && this.guaranteeDateField.getValue() != null) {
            display.append(this.guaranteeDateSelection.getDisplay() + this.guaranteeDateField.getValue().toString() + "-");
        }
        for (i = 0; i < this.m_productEditors.size(); ++i) {
            c = this.m_productEditors.get(i);
            cTo = this.m_productEditorsTo.get(i);
            if (c instanceof VComboBox) {
                field = (VComboBox)c;
                display.append(((VComboBox)field).getDisplay() + "-");
                continue;
            }
            if (c instanceof VNumber) {
                field = (VNumber)c;
                display.append(((VNumber)field).getDisplay() + "-");
                fieldTo = (VNumber)cTo;
                display.append(fieldTo.getDisplay() + "-");
                continue;
            }
            field = (VString)c;
            display.append(((VString)field).getDisplay() + "-");
        }
        for (i = 0; i < this.m_instanceEditors.size(); ++i) {
            c = this.m_instanceEditors.get(i);
            cTo = this.m_instanceEditorsTo.get(i);
            if (c instanceof VComboBox) {
                field = (VComboBox)c;
                display.append(((VComboBox)field).getDisplay() + "-");
                continue;
            }
            if (c instanceof VNumber) {
                field = (VNumber)c;
                display.append(((VNumber)field).getDisplay() + "-");
                fieldTo = (VNumber)cTo;
                display.append(fieldTo.getDisplay() + "-");
                continue;
            }
            field = (VString)c;
            display.append(((VString)field).getDisplay() + "-");
        }
        while (display.toString().contains("--") && display.length() > 1) {
            display.delete(display.indexOf("--"), display.indexOf("--") + 1);
        }
        while (display.toString().startsWith("-") && display.length() >= 1) {
            display.delete(0, 1);
        }
        while (display.toString().endsWith("-") && display.length() >= 1) {
            display.delete(display.length() - 1, display.length());
        }
        this.m_display = display.toString();
    }

    public String getWhereClause() {
        return this.m_query;
    }
}

