/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.swing.CLabel;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class InfoAssignment
extends Info {
    private static final long serialVersionUID = 5017170699571459745L;
    private int fieldID = 0;
    private CLabel labelResourceType = new CLabel(Msg.translate(Env.getCtx(), "S_ResourceType_ID"));
    private VLookup fieldResourceType;
    private CLabel labelResource = new CLabel(Msg.translate(Env.getCtx(), "S_Resource_ID"));
    private VLookup fieldResource;
    private CLabel labelFrom = new CLabel(Msg.translate(Env.getCtx(), "DateFrom"));
    private VDate fieldFrom = new VDate(15);
    private CLabel labelTo = new CLabel(Msg.translate(Env.getCtx(), "DateTo"));
    private VDate fieldTo = new VDate(15);
    private static String s_From = "S_ResourceAssignment ra, S_ResourceType rt, S_Resource r, C_UOM uom";
    private static String s_Where = "ra.IsActive='Y' AND ra.S_Resource_ID=r.S_Resource_ID AND r.S_ResourceType_ID=rt.S_ResourceType_ID AND rt.C_UOM_ID=uom.C_UOM_ID";
    private static String s_Order = "rt.Name, r.Name";
    private static Info_Column[] s_Layout = new Info_Column[]{new Info_Column(" ", "ra.S_ResourceAssignment_ID", IDColumn.class), new Info_Column(Msg.translate(Env.getCtx(), "S_ResourceType_ID"), "rt.Name", String.class), new Info_Column(Msg.translate(Env.getCtx(), "S_Resource_ID"), "r.Name", String.class), new Info_Column(Msg.translate(Env.getCtx(), "AssignDateFrom"), "ra.AssignDateFrom", Timestamp.class), new Info_Column(Msg.translate(Env.getCtx(), "Qty"), "ra.Qty", Double.class), new Info_Column(Msg.translate(Env.getCtx(), "C_UOM_ID"), "uom.UOMSymbol", String.class), new Info_Column(Msg.translate(Env.getCtx(), "AssignDateTo"), "ra.AssignDateTo", Timestamp.class), new Info_Column(Msg.translate(Env.getCtx(), "IsConfirmed"), "ra.IsConfirmed", Boolean.class)};

    @Deprecated
    public InfoAssignment(Frame frame, boolean modal, int WindowNo, String value, boolean multiSelection, String whereClause) {
        this(frame, modal, WindowNo, 0, value, multiSelection, true, whereClause);
    }

    public InfoAssignment(Frame frame, boolean modal, int WindowNo, int record_id, String value, boolean multiSelection, boolean saveResults, String whereClause) {
        super(frame, modal, WindowNo, "ra", "S_ResourceAssigment_ID", multiSelection, saveResults, whereClause);
        this.log.info(value);
        this.setTitle(Msg.getMsg(Env.getCtx(), "InfoAssignment"));
        StringBuffer where = new StringBuffer(s_Where);
        if (whereClause != null && whereClause.length() > 0) {
            where.append(" AND ").append(whereClause);
        }
        this.setWhereClause(where.toString());
        this.setTableLayout(s_Layout);
        this.setFromClause(s_From);
        this.setOrderClause(s_Order);
        this.statInit();
        this.initInfo(record_id, value);
        this.m_heldLastFocus = this.fieldResourceType;
        if (this.autoQuery() || record_id != 0 || value != null && value.length() > 0 && value != "%") {
            this.executeQuery();
        }
        this.p_loadedOK = true;
        AEnv.positionCenterWindow(frame, this);
    }

    private void statInit() {
        this.fieldResourceType = new VLookup("S_ResourceType_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("S_ResourceType", "S_ResourceType_ID"), 19));
        this.fieldResourceType.addActionListener(this);
        this.fieldResource = new VLookup("S_Resource_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("S_Resource", "S_Resource_ID"), 19));
        this.fieldResource.addActionListener(this);
        this.fieldFrom.addActionListener(this);
        this.fieldTo.addActionListener(this);
        this.p_criteriaGrid.setLayout(new ALayout());
        this.p_criteriaGrid.add((Component)this.labelResourceType, new ALayoutConstraint(0, 0));
        this.p_criteriaGrid.add((Component)this.fieldResourceType, null);
        this.p_criteriaGrid.add((Component)this.labelResource, null);
        this.p_criteriaGrid.add((Component)this.fieldResource, null);
        this.p_criteriaGrid.add((Component)this.labelFrom, new ALayoutConstraint(1, 0));
        this.p_criteriaGrid.add((Component)this.fieldFrom, null);
        this.p_criteriaGrid.add((Component)this.labelTo, null);
        this.p_criteriaGrid.add((Component)this.fieldTo, null);
    }

    @Override
    protected void initInfo(int record_id, String value) {
        this.prepareTable(this.getTableLayout(), this.getFromClause(), this.getWhereClause(), this.getOrderClause());
        if (record_id != 0 && value != null && value.length() > 0) {
            this.log.severe("Received both a record_id and a value: " + record_id + " - " + value);
        }
        if (record_id != 0) {
            this.fieldID = record_id;
        } else if (value == null || value.length() <= 0) {
            String sr;
            String srt;
            String sra = Env.getContext(Env.getCtx(), this.p_WindowNo, "S_ResourceAssignment_ID");
            if (sra != null && sra.length() != 0) {
                this.fieldID = Integer.valueOf(sra);
            }
            if ((srt = Env.getContext(Env.getCtx(), this.p_WindowNo, "S_ResourceType_ID")) != null && srt.length() > 0) {
                this.fieldResourceType.setValue(Integer.valueOf(srt));
            }
            if ((sr = Env.getContext(Env.getCtx(), this.p_WindowNo, "S_Resource_ID")) != null && sr.length() > 0) {
                this.fieldResource.setValue(Integer.valueOf(sr));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
    }

    @Override
    protected String getSQLWhere() {
        Timestamp ts;
        Integer S_Resource_ID;
        Integer S_ResourceType_ID;
        StringBuffer sql = new StringBuffer();
        if (this.isResetRecordID()) {
            this.fieldID = 0;
        }
        if (this.fieldID != 0) {
            sql.append(" AND ra.S_ResourceAssignment_ID=").append(this.fieldID);
        }
        if ((S_ResourceType_ID = (Integer)this.fieldResourceType.getValue()) != null) {
            sql.append(" AND rt.S_ResourceType_ID=").append(S_ResourceType_ID);
        }
        if ((S_Resource_ID = (Integer)this.fieldResource.getValue()) != null) {
            sql.append(" AND r.S_Resource_ID=").append(S_Resource_ID);
        }
        if ((ts = this.fieldFrom.getTimestamp()) != null) {
            sql.append(" AND TRUNC(ra.AssignDateFrom, 'DD')>=").append(DB.TO_DATE(ts, false));
        }
        if ((ts = this.fieldTo.getTimestamp()) != null) {
            sql.append(" AND TRUNC(ra.AssignDateTo, 'DD')<=").append(DB.TO_DATE(ts, false));
        }
        return sql.toString();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
    }

    @Override
    protected boolean hasOutstandingChanges() {
        return this.fieldFrom.hasChanged() || this.fieldResource.hasChanged() || this.fieldResourceType.hasChanged() || this.fieldTo.hasChanged();
    }

    @Override
    protected void setFieldOldValues() {
        this.fieldFrom.set_oldValue();
        this.fieldResource.set_oldValue();
        this.fieldResourceType.set_oldValue();
        this.fieldTo.set_oldValue();
    }

    @Override
    protected void clearParameters() {
        Object nullObject = null;
        this.fieldFrom.setValue(nullObject);
        this.fieldResource.setValue(nullObject);
        this.fieldResourceType.setValue(nullObject);
        this.fieldTo.setValue(nullObject);
    }
}

