/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.awt.Frame;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.swing.CLabel;
import org.compiere.swing.CTextField;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class InfoAsset
extends Info {
    private static final long serialVersionUID = 6014685562933753813L;
    private static String s_From = "A_ASSET a LEFT OUTER JOIN M_Product p ON (a.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN C_BPartner bp ON (a.C_BPartner_ID=bp.C_BPartner_ID) LEFT OUTER JOIN AD_User u ON (a.AD_User_ID=u.AD_User_ID)";
    private static final Info_Column[] s_Layout = new Info_Column[]{new Info_Column(" ", "a.A_Asset_ID", IDColumn.class), new Info_Column(Msg.translate(Env.getCtx(), "Value"), "a.Value", String.class), new Info_Column(Msg.translate(Env.getCtx(), "Name"), "a.Name", String.class), new Info_Column(Msg.translate(Env.getCtx(), "M_Product_ID"), "p.Name", String.class), new Info_Column(Msg.translate(Env.getCtx(), "C_BPartner_ID"), "bp.Name", String.class), new Info_Column(Msg.translate(Env.getCtx(), "AD_User_ID"), "u.Name", String.class), new Info_Column(Msg.translate(Env.getCtx(), "AssetServiceDate"), "a.AssetServiceDate", Timestamp.class), new Info_Column(Msg.translate(Env.getCtx(), "GuaranteeDate"), "a.GuaranteeDate", Timestamp.class), new Info_Column(Msg.translate(Env.getCtx(), "VersionNo"), "a.VersionNo", String.class)};
    private int fieldID = 0;
    private CLabel labelValue = new CLabel();
    private CTextField fieldValue = new CTextField(10);
    private CLabel labelName = new CLabel();
    private CTextField fieldName = new CTextField(10);
    private CLabel lBPartner_ID = new CLabel(Msg.translate(Env.getCtx(), "BPartner"));
    private VLookup fBPartner_ID;
    private CLabel lProduct_ID = new CLabel(Msg.translate(Env.getCtx(), "Product"));
    private VLookup fProduct_ID;

    @Deprecated
    public InfoAsset(Frame frame, boolean modal, int WindowNo, int A_Asset_ID, String value, boolean multiSelection, String whereClause) {
        this(frame, modal, WindowNo, 0, value, multiSelection, true, whereClause);
    }

    public InfoAsset(Frame frame, boolean modal, int WindowNo, int record_id, String value, boolean multiSelection, boolean saveResults, String whereClause) {
        super(frame, modal, WindowNo, "a", "A_Asset_ID", multiSelection, saveResults, whereClause);
        this.log.info(value + ", ID=" + record_id + ", WHERE=" + whereClause);
        this.setTitle(Msg.getMsg(Env.getCtx(), "InfoAsset"));
        StringBuffer where = new StringBuffer();
        where.append("a.IsActive='Y'");
        if (whereClause != null && whereClause.length() > 0) {
            where.append(" AND ").append(whereClause);
        }
        this.setWhereClause(where.toString());
        this.setTableLayout(s_Layout);
        this.setFromClause(s_From);
        this.setOrderClause("a.Value");
        this.statInit();
        this.initInfo(record_id, value);
        this.m_heldLastFocus = this.fieldValue;
        if (this.autoQuery() || record_id != 0 || value != null && value.length() > 0 && value != "%") {
            this.executeQuery();
        }
        this.p_loadedOK = true;
        AEnv.positionCenterWindow(frame, this);
    }

    private void statInit() {
        this.labelValue.setText(Msg.getMsg(Env.getCtx(), "Value"));
        this.fieldValue.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldValue.addActionListener(this);
        this.labelName.setText(Msg.getMsg(Env.getCtx(), "Name"));
        this.fieldName.setBackground(AdempierePLAF.getInfoBackground());
        this.fieldName.addActionListener(this);
        this.fBPartner_ID = new VLookup("C_BPartner_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("A_Asset", "C_BPartner_ID"), 30));
        this.lBPartner_ID.setLabelFor(this.fBPartner_ID);
        this.fBPartner_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fBPartner_ID.addActionListener(this);
        this.fProduct_ID = new VLookup("M_Product_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("A_Asset", "M_Product_ID"), 30));
        this.lProduct_ID.setLabelFor(this.fProduct_ID);
        this.fProduct_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fProduct_ID.addActionListener(this);
        this.p_criteriaGrid.add((Component)this.labelValue, new ALayoutConstraint(0, 0));
        this.p_criteriaGrid.add((Component)this.fieldValue, null);
        this.p_criteriaGrid.add((Component)this.lBPartner_ID, null);
        this.p_criteriaGrid.add((Component)this.fBPartner_ID, null);
        this.p_criteriaGrid.add((Component)this.labelName, new ALayoutConstraint(1, 0));
        this.p_criteriaGrid.add((Component)this.fieldName, null);
        this.p_criteriaGrid.add((Component)this.lProduct_ID, null);
        this.p_criteriaGrid.add((Component)this.fProduct_ID, null);
    }

    @Override
    protected void initInfo(int record_id, String value) {
        if (record_id != 0 && value != null && value.length() > 0) {
            this.log.severe("Received both a record_id and a value: " + record_id + " - " + value);
        }
        if (record_id != 0) {
            this.fieldID = record_id;
        } else if (value != null && value.length() > 0) {
            this.fieldValue.setText(value);
        } else {
            String pid;
            String bp;
            String aid = Env.getContext(Env.getCtx(), this.p_WindowNo, "A_Asset_ID");
            if (aid != null && aid.length() != 0) {
                this.fieldID = Integer.valueOf(aid);
            }
            if ((bp = Env.getContext(Env.getCtx(), this.p_WindowNo, "C_BPartner_ID")) != null && bp.length() != 0) {
                this.fBPartner_ID.setValue((int)Integer.valueOf(bp));
            }
            if ((pid = Env.getContext(Env.getCtx(), this.p_WindowNo, "M_Product_ID")) != null && pid.length() != 0) {
                this.fProduct_ID.setValue((int)Integer.valueOf(pid));
            }
        }
    }

    @Override
    protected String getSQLWhere() {
        Integer M_Product_ID;
        Integer C_BPartner_ID;
        StringBuffer sql = new StringBuffer();
        if (this.isResetRecordID()) {
            this.fieldID = 0;
        }
        if (this.fieldID != 0) {
            sql.append(" AND a.A_Asset_ID = ?");
        }
        if (InfoAsset.isValidSQLText(this.fieldValue)) {
            sql.append(" AND UPPER(a.Value) LIKE ?");
        }
        if (InfoAsset.isValidSQLText(this.fieldName)) {
            sql.append(" AND UPPER(a.Name) LIKE ?");
        }
        if ((C_BPartner_ID = (Integer)this.fBPartner_ID.getValue()) != null) {
            sql.append(" AND a.C_BPartner_ID=").append(C_BPartner_ID);
        }
        if ((M_Product_ID = (Integer)this.fProduct_ID.getValue()) != null) {
            sql.append(" AND a.M_Product_ID=").append(M_Product_ID);
        }
        return sql.toString();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        int index = 1;
        if (this.fieldID != 0) {
            pstmt.setInt(index++, this.fieldID);
            this.log.fine("Record_ID: " + this.fieldID);
        }
        if (InfoAsset.isValidSQLText(this.fieldValue)) {
            pstmt.setString(index++, InfoAsset.getSQLText(this.fieldValue));
            this.log.fine("Value: " + this.fieldValue.getText());
        }
        if (InfoAsset.isValidSQLText(this.fieldName)) {
            pstmt.setString(index++, InfoAsset.getSQLText(this.fieldName));
            this.log.fine("Name: " + this.fieldName.getText());
        }
    }

    @Override
    public void saveSelectionDetail() {
        int row = this.p_table.getSelectedRow();
        if (row == -1) {
            return;
        }
        Integer ID2 = this.getSelectedRowKey();
        Env.setContext(Env.getCtx(), this.p_WindowNo, 1113, "A_Asset_ID", ID2 == null ? "0" : ID2.toString());
    }

    protected void showHistory() {
        this.log.info("InfoAsset.showHistory");
    }

    @Override
    protected boolean hasHistory() {
        return false;
    }

    @Override
    protected void zoom(int record_ID) {
        this.log.info("InfoAsset.zoom");
        Integer A_Asset_ID = record_ID;
        MQuery query = new MQuery("A_Asset");
        query.addRestriction("A_Asset_ID", "=", A_Asset_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("A_Asset", true);
        this.zoom(AD_WindowNo, query);
    }

    @Override
    protected boolean hasZoom() {
        return true;
    }

    @Override
    protected void customize() {
        this.log.info("InfoAsset.customize");
    }

    @Override
    protected boolean hasCustomize() {
        return false;
    }

    @Override
    protected boolean hasOutstandingChanges() {
        return this.fieldValue.hasChanged() || this.fieldName.hasChanged() || this.fProduct_ID.hasChanged() || this.fBPartner_ID.hasChanged();
    }

    @Override
    protected void setFieldOldValues() {
        this.fieldValue.set_oldValue();
        this.fieldName.set_oldValue();
        this.fProduct_ID.set_oldValue();
        this.fBPartner_ID.set_oldValue();
    }

    @Override
    protected void clearParameters() {
        this.fieldValue.setText("");
        this.fieldName.setText("");
        this.fProduct_ID.setValue(null);
        this.fBPartner_ID.setValue(null);
    }
}

