/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JLabel;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.form.Stocktake;
import org.compiere.grid.GridController;
import org.compiere.grid.ed.VLocator;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CPanel;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VStocktake
extends Stocktake
implements FormPanel,
ActionListener,
VetoableChangeListener {
    private CPanel panel = new CPanel();
    private FormFrame m_frame;
    private GridController m_gridController;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private JLabel inventoryLabel = new JLabel();
    private VLookup inventoryField;
    private JLabel locatorLabel = new JLabel();
    private VLocator locatorField;
    private JLabel productLabel = new JLabel();
    private VLookup productField;
    private JLabel lineFLabel = new JLabel();
    private VNumber lineFField;
    private JLabel lineTLabel = new JLabel();
    private VNumber lineTField;
    private JLabel aislexLabel = new JLabel();
    private VLookup aislexField;
    private CCheckBox secondCount = new CCheckBox();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true, true, false, true, false, false, true);
    private StatusBar statusBar = new StatusBar();

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.dynParameter();
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.mainPanel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
    }

    void jbInit() throws Exception {
        CompiereColor.setBackground(this.panel);
        this.mainPanel.setLayout(this.mainLayout);
        this.mainLayout.setVgap(10);
        this.parameterPanel.setLayout(this.parameterLayout);
        this.inventoryLabel.setText(Msg.translate(Env.getCtx(), "M_Inventory_ID"));
        this.locatorLabel.setText(Msg.translate(Env.getCtx(), "M_Locator_ID"));
        this.productLabel.setText(Msg.translate(Env.getCtx(), "M_Product_ID"));
        this.lineFLabel.setText(Msg.translate(Env.getCtx(), "Line") + " " + Msg.translate(Env.getCtx(), "From"));
        this.lineTLabel.setText(Msg.translate(Env.getCtx(), "Line") + " " + Msg.translate(Env.getCtx(), "To"));
        this.aislexLabel.setText(Msg.translate(Env.getCtx(), "X"));
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.parameterPanel.add((Component)this.inventoryLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.inventoryField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.lineFLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.lineFField, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.lineTLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.lineTField, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.secondCount, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.aislexLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.aislexField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.productLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.productField, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.locatorLabel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.parameterPanel.add((Component)this.locatorField, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.secondCount.setText(Msg.getMsg(Env.getCtx(), "Second Count"));
        this.secondCount.addActionListener(this);
        this.confirmPanel.getCustomizeButton().setText(Msg.translate(Env.getCtx(), "CountEntered"));
        this.southPanel.setLayout(this.southLayout);
        this.southPanel.add((Component)this.confirmPanel, "North");
        this.southPanel.add((Component)this.statusBar, "South");
        this.mainPanel.add((Component)this.southPanel, "South");
    }

    private void dynParameter() throws Exception {
        Properties ctx = Env.getCtx();
        String vcode = "M_Inventory.IsStocktake='Y' ";
        MLookup inventoryLookup = MLookupFactory.get(ctx, this.m_WindowNo, 3563, 19, Env.getLanguage(Env.getCtx()), "M_Inventory_ID", 53249, true, vcode);
        this.inventoryField = new VLookup("M_Inventory_ID", true, false, true, inventoryLookup);
        MLocatorLookup locatorLookup = new MLocatorLookup(ctx, this.m_WindowNo);
        this.locatorField = new VLocator("M_Locator_ID", false, false, true, locatorLookup, this.m_WindowNo);
        MLookup productLookup = MLookupFactory.get(ctx, this.m_WindowNo, 0, 3668, 30);
        this.productField = new VLookup("M_Product_ID", false, false, true, productLookup);
        MLookup aislexLookup = MLookupFactory.get(ctx, this.m_WindowNo, 1399, 18, Env.getLanguage(Env.getCtx()), "X", 53562, false, null);
        this.aislexField = new VLookup("X", false, false, true, aislexLookup);
        this.lineFField = new VNumber();
        this.lineTField = new VNumber();
        this.confirmPanel.addActionListener(this);
        this.statusBar.setStatusLine("");
    }

    private void dynInit() {
        super.dynInit(this.statusBar);
        this.m_gridController = new GridController();
        this.m_gridController.initGrid(this.m_mTab, true, this.m_WindowNo, null, null);
        this.mainPanel.add((Component)this.m_gridController, "Center");
    }

    @Override
    public void dispose() {
        if (this.m_gridController != null) {
            this.m_gridController.dispose();
        }
        this.m_gridController = null;
        this.m_mTab = null;
        if (this.m_mWindow != null) {
            this.m_mWindow.dispose();
        }
        this.m_mWindow = null;
        this.inventoryField = null;
        this.locatorField = null;
        this.productField = null;
        this.aislexField = null;
        this.lineFField = null;
        this.lineTField = null;
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getActionCommand().equals("Refresh") || e.getActionCommand().equals("Ok")) {
            this.refresh();
        } else if (e.getActionCommand().equals("Customize")) {
            this.set_counted();
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("M_Product_ID")) {
            this.productField.setValue(e.getNewValue());
        }
    }

    private void refresh() {
        Object inventory = this.inventoryField.getValue();
        Object locator = this.locatorField.getValue();
        Object product = this.productField.getValue();
        Object movementType = this.aislexField.getValue();
        Object lineFrom = this.lineFField.getValue();
        Object lineTo = this.lineTField.getValue();
        Boolean isSecondCount = this.secondCount.isSelected();
        this.panel.setCursor(Cursor.getPredefinedCursor(3));
        this.refresh(inventory, locator, product, movementType, lineFrom, lineTo, this.statusBar, isSecondCount);
        AEnv.sleep(1);
        this.m_gridController.getTable().autoSize(true);
        this.panel.setCursor(Cursor.getDefaultCursor());
    }
}

