/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.form.Match;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VNumber;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MMatchPO;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VMatch
extends Match
implements FormPanel,
ActionListener,
TableModelListener,
ListSelectionListener {
    private CPanel panel = new CPanel();
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(VMatch.class);
    private int m_AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
    private int m_AD_Org_ID = Env.getAD_Org_ID(Env.getCtx());
    private int m_by = Env.getAD_User_ID(Env.getCtx());
    private String[] m_matchOptions = new String[]{Msg.getElement(Env.getCtx(), "C_Invoice_ID", false), Msg.getElement(Env.getCtx(), "M_InOut_ID", false), Msg.getElement(Env.getCtx(), "C_Order_ID", false)};
    private String[] m_matchMode = new String[]{Msg.translate(Env.getCtx(), "NotMatched"), Msg.translate(Env.getCtx(), "Matched")};
    private static final int MODE_NOTMATCHED = 0;
    private static final int MODE_MATCHED = 1;
    private static final int I_QTY = 6;
    private static final int I_MATCHED = 7;
    private BigDecimal m_xMatched = Env.ZERO;
    private BigDecimal m_xMatchedTo = Env.ZERO;
    private StatusBar statusBar = new StatusBar();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel northPanel = new CPanel();
    private GridBagLayout northLayout = new GridBagLayout();
    private CLabel matchFromLabel = new CLabel();
    private CComboBox matchFrom = new CComboBox(this.m_matchOptions);
    private CLabel matchToLabel = new CLabel();
    private CComboBox matchTo = new CComboBox();
    private CLabel matchModeLabel = new CLabel();
    private CComboBox matchMode = new CComboBox(this.m_matchMode);
    private VLookup onlyVendor = null;
    private VLookup onlyProduct = null;
    private CLabel onlyVendorLabel = new CLabel();
    private CLabel onlyProductLabel = new CLabel();
    private CLabel dateFromLabel = new CLabel();
    private CLabel dateToLabel = new CLabel();
    private VDate dateFrom = new VDate("DateFrom", false, false, true, 15, "DateFrom");
    private VDate dateTo = new VDate("DateTo", false, false, true, 15, "DateTo");
    private CButton bSearch = new CButton();
    private CPanel southPanel = new CPanel();
    private GridBagLayout southLayout = new GridBagLayout();
    private CLabel xMatchedLabel = new CLabel();
    private CLabel xMatchedToLabel = new CLabel();
    private CLabel differenceLabel = new CLabel();
    private VNumber xMatched = new VNumber("xMatched", false, true, false, 29, "xMatched");
    private VNumber xMatchedTo = new VNumber("xMatchedTo", false, true, false, 29, "xMatchedTo");
    private VNumber difference = new VNumber("Difference", false, true, false, 29, "Difference");
    private CButton bProcess = new CButton();
    private CPanel centerPanel = new CPanel();
    private BorderLayout centerLayout = new BorderLayout(5, 5);
    private JScrollPane xMatchedScrollPane = new JScrollPane();
    private TitledBorder xMatchedBorder = new TitledBorder("xMatched");
    private MiniTable xMatchedTable = new MiniTable();
    private JScrollPane xMatchedToScrollPane = new JScrollPane();
    private TitledBorder xMatchedToBorder = new TitledBorder("xMatchedTo");
    private MiniTable xMatchedToTable = new MiniTable();
    private CPanel xPanel = new CPanel();
    private JCheckBox sameProduct = new JCheckBox();
    private JCheckBox sameBPartner = new JCheckBox();
    private JCheckBox sameQty = new JCheckBox();
    private JCheckBox IsSOTrx = new JCheckBox();
    private FlowLayout xLayout = new FlowLayout(1, 10, 0);

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        log.info("WinNo=" + this.m_WindowNo + " - AD_Client_ID=" + this.m_AD_Client_ID + ", AD_Org_ID=" + this.m_AD_Org_ID + ", By=" + this.m_by);
        Env.setContext(Env.getCtx(), this.m_WindowNo, "IsSOTrx", "N");
        try {
            this.onlyVendor = VLookup.createBPartner(this.m_WindowNo);
            this.onlyProduct = VLookup.createProduct(this.m_WindowNo);
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.panel, "Center");
            frame.getContentPane().add((Component)this.statusBar, "South");
            new Thread(){

                @Override
                public void run() {
                    log.info("Starting ...");
                    MMatchPO.consolidate(Env.getCtx());
                    log.info("... Done");
                }
            }.start();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        this.panel.setLayout(this.mainLayout);
        this.northPanel.setLayout(this.northLayout);
        this.matchFromLabel.setText(Msg.translate(Env.getCtx(), "MatchFrom"));
        this.matchToLabel.setText(Msg.translate(Env.getCtx(), "MatchTo"));
        this.matchModeLabel.setText(Msg.translate(Env.getCtx(), "MatchMode"));
        this.onlyVendorLabel.setText(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        this.onlyProductLabel.setText(Msg.translate(Env.getCtx(), "M_Product_ID"));
        this.dateFromLabel.setText(Msg.translate(Env.getCtx(), "DateFrom"));
        this.dateToLabel.setText(Msg.translate(Env.getCtx(), "DateTo"));
        this.bSearch.setText(Msg.translate(Env.getCtx(), "Search"));
        this.southPanel.setLayout(this.southLayout);
        this.xMatchedLabel.setText(Msg.translate(Env.getCtx(), "ToBeMatched"));
        this.xMatchedToLabel.setText(Msg.translate(Env.getCtx(), "Matching"));
        this.differenceLabel.setText(Msg.translate(Env.getCtx(), "Difference"));
        this.bProcess.setText(Msg.translate(Env.getCtx(), "Process"));
        this.centerPanel.setLayout(this.centerLayout);
        this.xMatchedScrollPane.setBorder(this.xMatchedBorder);
        this.xMatchedScrollPane.setPreferredSize(new Dimension(450, 200));
        this.xMatchedToScrollPane.setBorder(this.xMatchedToBorder);
        this.xMatchedToScrollPane.setPreferredSize(new Dimension(450, 200));
        this.sameProduct.setSelected(true);
        this.sameProduct.setText(Msg.translate(Env.getCtx(), "SameProduct"));
        this.sameBPartner.setSelected(true);
        this.sameBPartner.setText(Msg.translate(Env.getCtx(), "SameBPartner"));
        this.sameQty.setSelected(false);
        this.sameQty.setText(Msg.translate(Env.getCtx(), "SameQty"));
        this.IsSOTrx.setText(Msg.translate(Env.getCtx(), "IsSOTrx"));
        this.xPanel.setLayout(this.xLayout);
        this.panel.add((Component)this.northPanel, "North");
        this.northPanel.add((Component)this.matchFromLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 5, 5), 0, 0));
        this.northPanel.add((Component)this.matchFrom, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(12, 0, 5, 0), 0, 0));
        this.northPanel.add((Component)this.matchToLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.matchTo, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(12, 0, 5, 0), 0, 0));
        this.northPanel.add((Component)this.matchModeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.northPanel.add((Component)this.matchMode, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.northPanel.add((Component)this.IsSOTrx, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 12), 0, 0));
        this.northPanel.add((Component)this.onlyVendor, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.northPanel.add((Component)this.onlyProduct, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.northPanel.add((Component)this.onlyVendorLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.northPanel.add((Component)this.onlyProductLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.northPanel.add((Component)this.dateFromLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 5), 0, 0));
        this.northPanel.add((Component)this.dateToLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.northPanel.add((Component)this.dateFrom, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.northPanel.add((Component)this.dateTo, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.northPanel.add((Component)this.bSearch, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 12, 5, 12), 0, 0));
        this.panel.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.xMatchedLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 12, 5, 5), 0, 0));
        this.southPanel.add((Component)this.xMatched, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.southPanel.add((Component)this.xMatchedToLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.southPanel.add((Component)this.bProcess, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 12, 5, 12), 0, 0));
        this.southPanel.add((Component)this.differenceLabel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.panel.add((Component)this.centerPanel, "Center");
        this.centerPanel.add((Component)this.xMatchedScrollPane, "North");
        this.xMatchedScrollPane.getViewport().add((Component)this.xMatchedTable, null);
        this.centerPanel.add((Component)this.xMatchedToScrollPane, "South");
        this.centerPanel.add((Component)this.xPanel, "Center");
        this.xPanel.add((Component)this.sameBPartner, null);
        this.xPanel.add((Component)this.sameProduct, null);
        this.xPanel.add((Component)this.sameQty, null);
        this.xMatchedToScrollPane.getViewport().add((Component)this.xMatchedToTable, null);
        this.southPanel.add((Component)this.difference, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.southPanel.add((Component)this.xMatchedTo, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
    }

    private void dynInit() {
        ColumnInfo[] layout = new ColumnInfo[]{new ColumnInfo(" ", ".", IDColumn.class, false, false, ""), new ColumnInfo(Msg.translate(Env.getCtx(), "DocumentNo"), ".", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Date"), ".", Timestamp.class), new ColumnInfo(Msg.translate(Env.getCtx(), "C_BPartner_ID"), ".", KeyNamePair.class, "."), new ColumnInfo(Msg.translate(Env.getCtx(), "Line"), ".", KeyNamePair.class, "."), new ColumnInfo(Msg.translate(Env.getCtx(), "M_Product_ID"), ".", KeyNamePair.class, "."), new ColumnInfo(Msg.translate(Env.getCtx(), "Qty"), ".", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Matched"), ".", Double.class), new ColumnInfo(Msg.translate(Env.getCtx(), "AD_Org_ID"), ".", KeyNamePair.class, ".")};
        this.xMatchedTable.prepareTable(layout, "", "", false, "");
        this.xMatchedToTable.prepareTable(layout, "", "", true, "");
        CompiereColor.setBackground(this.panel);
        this.matchFrom.addActionListener(this);
        this.matchTo.addActionListener(this);
        this.bSearch.addActionListener(this);
        this.IsSOTrx.addActionListener(this);
        this.xMatchedTable.getSelectionModel().addListSelectionListener(this);
        this.xMatchedToTable.getModel().addTableModelListener(this);
        this.bProcess.addActionListener(this);
        this.sameBPartner.addActionListener(this);
        this.sameProduct.addActionListener(this);
        this.sameQty.addActionListener(this);
        this.matchTo.setModel((ComboBoxModel)new DefaultComboBoxModel<String>(this.cmd_matchFrom((String)this.matchFrom.getSelectedItem())));
        this.xMatchedBorder.setTitle((String)this.matchFrom.getSelectedItem());
        this.xMatchedScrollPane.repaint();
        this.xMatchedTable.setRowCount(0);
        this.cmd_matchTo();
        this.statusBar.setStatusLine("");
        this.statusBar.setStatusDB(0);
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Timestamp to;
        this.panel.setCursor(Cursor.getPredefinedCursor(3));
        Integer product = this.onlyProduct.getValue() != null ? (Integer)this.onlyProduct.getValue() : null;
        Integer vendor = this.onlyVendor.getValue() != null ? (Integer)this.onlyVendor.getValue() : null;
        Timestamp from = this.dateFrom.getValue() != null ? (Timestamp)this.dateFrom.getValue() : null;
        Timestamp timestamp = to = this.dateTo.getValue() != null ? (Timestamp)this.dateTo.getValue() : null;
        if (e.getSource() == this.matchFrom) {
            String selection = (String)this.matchFrom.getSelectedItem();
            this.matchTo.setModel((ComboBoxModel)new DefaultComboBoxModel<String>(this.cmd_matchFrom(selection)));
            this.xMatchedBorder.setTitle(selection);
            this.xMatchedScrollPane.repaint();
            this.xMatchedTable.setRowCount(0);
            this.cmd_matchTo();
        } else if (e.getSource() == this.matchTo) {
            this.cmd_matchTo();
        } else if (e.getSource() == this.bSearch) {
            this.xMatchedTable = (MiniTable)this.cmd_search(this.xMatchedTable, this.matchFrom.getSelectedIndex(), (String)this.matchTo.getSelectedItem(), product, vendor, from, to, this.IsSOTrx.isSelected(), this.matchMode.getSelectedIndex() == 1);
            this.xMatched.setValue(Env.ZERO);
            this.statusBar.setStatusLine(this.matchFrom.getSelectedItem().toString() + "# = " + this.xMatchedTable.getRowCount(), this.xMatchedTable.getRowCount() == 0);
            this.statusBar.setStatusDB(0);
        } else if (e.getSource() == this.bProcess) {
            this.cmd_process(this.xMatchedTable, this.xMatchedToTable, this.matchMode.getSelectedIndex(), this.matchFrom.getSelectedIndex(), this.matchTo.getSelectedItem(), this.m_xMatched);
            this.xMatchedTable = (MiniTable)this.cmd_search(this.xMatchedTable, this.matchFrom.getSelectedIndex(), (String)this.matchTo.getSelectedItem(), product, vendor, from, to, this.IsSOTrx.isSelected(), this.matchMode.getSelectedIndex() == 1);
            this.xMatched.setValue(Env.ZERO);
            this.statusBar.setStatusLine(this.matchFrom.getSelectedItem().toString() + "# = " + this.xMatchedTable.getRowCount(), this.xMatchedTable.getRowCount() == 0);
            this.statusBar.setStatusDB(0);
        } else if (e.getSource() == this.sameBPartner || e.getSource() == this.sameProduct || e.getSource() == this.sameQty || e.getSource() == this.IsSOTrx) {
            this.xMatchedTable = (MiniTable)this.cmd_search(this.xMatchedTable, this.matchFrom.getSelectedIndex(), (String)this.matchTo.getSelectedItem(), product, vendor, from, to, this.IsSOTrx.isSelected(), this.matchMode.getSelectedIndex() == 1);
        }
        this.panel.setCursor(Cursor.getDefaultCursor());
    }

    private void cmd_matchTo() {
        String selection = (String)this.matchTo.getSelectedItem();
        this.xMatchedToBorder.setTitle(selection);
        this.xMatchedToScrollPane.repaint();
        this.xMatchedToTable.setRowCount(0);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.panel.setCursor(Cursor.getPredefinedCursor(3));
        this.cmd_searchTo();
        this.panel.setCursor(Cursor.getDefaultCursor());
    }

    private void cmd_searchTo() {
        int row = this.xMatchedTable.getSelectedRow();
        log.config("Row=" + row);
        double qty = 0.0;
        if (row < 0) {
            this.xMatchedToTable.setRowCount(0);
        } else {
            String displayString = (String)this.matchTo.getSelectedItem();
            int matchToType = this.matchFrom.getSelectedIndex();
            double docQty = (Double)this.xMatchedTable.getValueAt(row, 6);
            double matchedQty = (Double)this.xMatchedTable.getValueAt(row, 7);
            qty = docQty - matchedQty;
            this.xMatchedToTable = (MiniTable)this.cmd_searchTo(this.xMatchedTable, this.xMatchedToTable, displayString, matchToType, this.sameBPartner.isSelected(), this.sameProduct.isSelected(), this.sameQty.isSelected(), this.matchMode.getSelectedIndex() == 1, this.IsSOTrx.isSelected());
        }
        this.m_xMatched = new BigDecimal(qty);
        this.xMatched.setValue(this.m_xMatched);
        this.xMatchedTo.setValue(Env.ZERO);
        this.difference.setValue(this.m_xMatched);
        this.statusBar.setStatusLine(this.matchFrom.getSelectedItem().toString() + "# = " + this.xMatchedTable.getRowCount() + " - " + this.matchTo.getSelectedItem().toString() + "# = " + this.xMatchedToTable.getRowCount(), this.xMatchedToTable.getRowCount() == 0);
        this.statusBar.setStatusDB(0);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getColumn() != 0) {
            return;
        }
        log.config("Row=" + e.getFirstRow() + "-" + e.getLastRow() + ", Col=" + e.getColumn() + ", Type=" + e.getType());
        this.panel.setCursor(Cursor.getPredefinedCursor(3));
        int matchedRow = this.xMatchedTable.getSelectedRow();
        KeyNamePair Product2 = (KeyNamePair)this.xMatchedTable.getValueAt(matchedRow, 5);
        double qty = 0.0;
        int noRows = 0;
        for (int row = 0; row < this.xMatchedToTable.getRowCount(); ++row) {
            IDColumn id = (IDColumn)this.xMatchedToTable.getValueAt(row, 0);
            if (id == null || !id.isSelected()) continue;
            KeyNamePair ProductCompare = (KeyNamePair)this.xMatchedToTable.getValueAt(row, 5);
            if (Product2.getKey() != ProductCompare.getKey()) {
                id.setSelected(false);
                continue;
            }
            if (this.matchMode.getSelectedIndex() == 0) {
                qty += ((Double)this.xMatchedToTable.getValueAt(row, 6)).doubleValue();
            }
            qty -= ((Double)this.xMatchedToTable.getValueAt(row, 7)).doubleValue();
            ++noRows;
        }
        this.m_xMatchedTo = new BigDecimal(qty);
        this.xMatchedTo.setValue(this.m_xMatchedTo);
        this.difference.setValue(this.m_xMatched.subtract(this.m_xMatchedTo));
        this.bProcess.setEnabled(noRows != 0);
        this.panel.setCursor(Cursor.getDefaultCursor());
        this.statusBar.setStatusDB(noRows);
    }
}

