/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MFactReconciliation;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.Query;
import org.compiere.plaf.CompiereColor;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VFactReconcile
extends CPanel
implements FormPanel,
ActionListener,
TableModelListener,
ASyncProcess {
    private static final long serialVersionUID = 6908391117180005512L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private DecimalFormat m_format = DisplayType.getNumberFormat(12);
    private String m_sql;
    private int m_noSelected = 0;
    private int m_AD_Client_ID = 0;
    private boolean m_isLocked = false;
    private static CLogger log = CLogger.getCLogger(VFactReconcile.class);
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private CLabel labelAcctSchema = new CLabel();
    private VLookup fieldAcctSchema = null;
    private MigLayout parameterLayout = null;
    private CLabel labelOrg = new CLabel();
    private VLookup fieldOrg = null;
    private VCheckBox isReconciled = new VCheckBox();
    private CLabel labelAccount = new CLabel();
    private VLookup fieldAccount = null;
    private CLabel labelBPartner = new CLabel();
    private VLookup fieldBPartner = null;
    private JLabel dataStatus = new JLabel();
    private JScrollPane dataPane = new JScrollPane();
    private MiniTable miniTable = new MiniTable();
    private CPanel commandPanel = new CPanel();
    private JButton bCancel = ConfirmPanel.createCancelButton(true);
    private JButton bGenerate = ConfirmPanel.createProcessButton(true);
    private JButton bReset = ConfirmPanel.createResetButton(true);
    private JButton bZoom = ConfirmPanel.createZoomButton(true);
    private FlowLayout commandLayout = new FlowLayout();
    private JButton bRefresh = ConfirmPanel.createRefreshButton(true);
    private JButton bSelectAll = ConfirmPanel.createCustomizeButton(true);
    private CLabel labelDateAcct = new CLabel();
    private VDate fieldDateAcct = new VDate();
    private CLabel labelDateAcct2 = new CLabel();
    private VDate fieldDateAcct2 = new VDate();
    private CLabel labelProduct = new CLabel();
    private VLookup fieldProduct = null;
    private boolean loading = false;
    private int idColIndex = 3;
    private int amtColIndex = 1;
    private CLabel differenceLabel = new CLabel();
    private CTextField differenceField = new CTextField();

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.dynInit();
            this.jbInit();
            frame.getContentPane().add((Component)this.commandPanel, "South");
            frame.getContentPane().add((Component)this.mainPanel, "Center");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this);
        this.mainPanel.setLayout(this.mainLayout);
        this.parameterLayout = new MigLayout("fillx, wrap 4, hidemode 0", " [150:150][250:250][100:100][200:200]");
        this.parameterPanel.setLayout((LayoutManager)this.parameterLayout);
        this.bRefresh.addActionListener(this);
        this.bReset.addActionListener(this);
        this.bZoom.addActionListener(this);
        this.bGenerate.setEnabled(false);
        this.bReset.setEnabled(false);
        this.bGenerate.setText(Msg.getMsg(Env.getCtx(), "Process"));
        this.bReset.setText(Msg.getMsg(Env.getCtx(), "Reset"));
        this.bZoom.setText(Msg.translate(Env.getCtx(), "Fact_Acct_ID"));
        this.bSelectAll.addActionListener(this);
        this.bSelectAll.setText(Msg.getMsg(Env.getCtx(), "SelectAll"));
        this.labelAcctSchema.setText(Msg.translate(Env.getCtx(), "C_AcctSchema_ID"));
        this.labelAccount.setText(Msg.translate(Env.getCtx(), "Account_ID"));
        this.labelBPartner.setText(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        this.labelDateAcct.setText(Msg.translate(Env.getCtx(), "DateAcct"));
        this.labelDateAcct2.setText("-");
        this.labelProduct.setText(Msg.translate(Env.getCtx(), "M_Product_ID"));
        this.labelOrg.setText(Msg.translate(Env.getCtx(), "AD_Org_ID"));
        this.isReconciled.setText(Msg.translate(Env.getCtx(), "IsReconciled"));
        this.dataStatus.setText(" ");
        this.differenceLabel.setText(Msg.getMsg(Env.getCtx(), "Difference"));
        this.differenceField.setBackground(AdempierePLAF.getFieldBackground_Inactive());
        this.differenceField.setEditable(false);
        this.differenceField.setText("0");
        this.differenceField.setColumns(8);
        this.differenceField.setHorizontalAlignment(4);
        this.bGenerate.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.parameterPanel.add((Component)this.labelAcctSchema, "");
        this.parameterPanel.add((Component)this.fieldAcctSchema, "growx");
        this.parameterPanel.add((Component)this.labelOrg, "");
        this.parameterPanel.add((Component)this.fieldOrg, "growx");
        this.parameterPanel.add((Component)this.labelAccount, "");
        this.parameterPanel.add((Component)this.fieldAccount, "wmax 250");
        this.parameterPanel.add((Component)this.isReconciled, "skip 1");
        this.parameterPanel.add((Component)this.labelBPartner, "");
        this.parameterPanel.add((Component)this.fieldBPartner, "growx");
        this.parameterPanel.add((Component)this.labelProduct, "");
        this.parameterPanel.add((Component)this.fieldProduct, "growx");
        this.parameterPanel.add((Component)this.labelDateAcct, "");
        this.parameterPanel.add((Component)this.fieldDateAcct, "growx");
        this.parameterPanel.add((Component)this.labelDateAcct2, "");
        this.parameterPanel.add((Component)this.fieldDateAcct2, "growx");
        this.parameterPanel.add((Component)this.bRefresh, "growx");
        this.mainPanel.add((Component)this.dataStatus, "South");
        this.mainPanel.add((Component)this.dataPane, "Center");
        this.dataPane.getViewport().add((Component)this.miniTable, null);
        this.commandPanel.setLayout(this.commandLayout);
        this.commandLayout.setAlignment(2);
        this.commandLayout.setHgap(10);
        this.commandPanel.add(this.bSelectAll);
        this.commandPanel.add((Component)this.bZoom, null);
        this.commandPanel.add((Component)this.differenceLabel, null);
        this.commandPanel.add((Component)this.differenceField, null);
        this.commandPanel.add((Component)this.bGenerate, null);
        this.commandPanel.add((Component)this.bReset, null);
        this.commandPanel.add((Component)this.bCancel, null);
    }

    private void dynInit() {
        MLookup lookup;
        Properties ctx = Env.getCtx();
        this.m_AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        this.fieldAcctSchema = new VLookup("C_AcctSchema_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, MColumn.getColumn_ID("Fact_Acct", "C_AcctSchema_ID"), 19));
        this.fieldAcctSchema.addActionListener(this);
        this.fieldAcctSchema.setValue(MClient.get(Env.getCtx()).getAcctSchema().getC_AcctSchema_ID());
        Dimension dim = this.fieldAcctSchema.getPreferredSize();
        dim.width = 300;
        this.fieldAcctSchema.setPreferredSize(dim);
        this.fieldOrg = new VLookup("AD_Org_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, MColumn.getColumn_ID("Fact_Acct", "AD_Org_ID"), 19));
        if (this.fieldOrg.getValue() == null || (Integer)this.fieldOrg.getValue() != 0) {
            this.fieldOrg.setValue(Env.getAD_Org_ID(Env.getCtx()));
        }
        dim = this.fieldOrg.getPreferredSize();
        dim.width = 300;
        this.fieldOrg.setPreferredSize(dim);
        this.fieldBPartner = new VLookup("C_BPartner_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, MColumn.getColumn_ID("Fact_Acct", "C_BPartner_ID"), 30));
        this.fieldProduct = new VLookup("M_Product_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, MColumn.getColumn_ID("Fact_Acct", "M_Product_ID"), 30));
        try {
            lookup = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, MColumn.getColumn_ID("Fact_Acct", "Account_ID"), 19, Env.getLanguage(Env.getCtx()), "Account_ID", 0, false, "C_ElementValue.IsSummary = 'N'");
        }
        catch (Exception e) {
            lookup = MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, MColumn.getColumn_ID("Fact_Acct", "Account_ID"), 19);
        }
        this.fieldAccount = new VLookup("Account_ID", true, false, true, lookup);
        dim = this.fieldAccount.getPreferredSize();
        dim.width = 300;
        this.fieldAccount.setPreferredSize(dim);
        this.m_sql = this.miniTable.prepareTable(new ColumnInfo[]{new ColumnInfo(Msg.translate(ctx, "Amt"), "abs(fa.amtacctdr-fa.amtacctcr)", BigDecimal.class), new ColumnInfo(Msg.translate(ctx, "AmtAcct"), "(fa.amtacctdr-fa.amtacctcr)", BigDecimal.class, true, true, null), new ColumnInfo("DR/CR", "(CASE WHEN (fa.amtacctdr-fa.amtacctcr) < 0 THEN 'CR' ELSE 'DR' END)", String.class), new ColumnInfo(" ", "fa.Fact_Acct_ID", IDColumn.class, false, false, null), new ColumnInfo(Msg.translate(ctx, "C_BPartner_ID"), "bp.Name", String.class), new ColumnInfo(Msg.translate(ctx, "DateAcct"), "fa.DateAcct", Timestamp.class), new ColumnInfo(Msg.translate(ctx, "GL_Category_ID"), "glc.Name", String.class), new ColumnInfo(Msg.translate(ctx, "M_Product_ID"), "p.Value", String.class), new ColumnInfo(Msg.translate(ctx, "Qty"), "Qty", BigDecimal.class), new ColumnInfo(Msg.translate(ctx, "Description"), "fa.Description", String.class), new ColumnInfo(Msg.translate(ctx, "MatchCode"), "r.MatchCode", String.class), new ColumnInfo(Msg.translate(ctx, "DateTrx"), "fa.DateTrx", Timestamp.class), new ColumnInfo(Msg.translate(ctx, "AD_Org_ID"), "o.Value", String.class)}, "Fact_Acct fa LEFT OUTER JOIN Fact_Reconciliation r ON (fa.Fact_Acct_ID=r.Fact_Acct_ID) LEFT OUTER JOIN C_BPartner bp ON (fa.C_BPartner_ID=bp.C_BPartner_ID) LEFT OUTER JOIN AD_Org o ON (o.AD_Org_ID=fa.AD_Org_ID) LEFT OUTER JOIN M_Product p ON (p.M_Product_ID=fa.M_Product_ID) LEFT OUTER JOIN GL_Category glc ON (fa.GL_Category_ID=glc.GL_Category_ID)", " fa.AD_Client_ID=?", true, "fa");
        this.miniTable.getModel().addTableModelListener(this);
        this.miniTable.setColumnVisibility(this.miniTable.getColumnModel().getColumn(1), false);
    }

    private void loadTableInfo() {
        log.config("");
        if (this.m_sql == null) {
            return;
        }
        this.loading = true;
        Object sql = this.m_sql;
        int Account_ID = (Integer)this.fieldAccount.getValue();
        if (Account_ID != 0) {
            sql = (String)sql + " AND fa.Account_ID=?";
        }
        if ((Integer)this.fieldAcctSchema.getValue() > 0) {
            sql = (String)sql + " AND fa.C_AcctSchema_ID = ?";
        }
        sql = (String)sql + " AND ((SELECT SUM(f.amtacctdr-f.amtacctcr) FROM Fact_Reconciliation rec  INNER JOIN Fact_Acct f ON (f.Fact_Acct_ID = rec.Fact_Acct_ID)  WHERE r.MatchCode=rec.MatchCode) ";
        sql = this.isReconciled.isSelected() ? (String)sql + "= 0) " : (String)sql + "<> 0 OR r.MatchCode IS NULL) ";
        if (this.fieldBPartner.getValue() != null) {
            sql = (String)sql + " AND fa.C_BPartner_ID = ?";
        }
        if (this.fieldProduct.getValue() != null) {
            sql = (String)sql + " AND fa.M_Product_ID = ?";
        }
        if (this.fieldDateAcct.getValue() != null) {
            sql = (String)sql + " AND fa.DateAcct >= ?";
        }
        if (this.fieldDateAcct2.getValue() != null) {
            sql = (String)sql + " AND fa.DateAcct <= ?";
        }
        sql = (String)sql + " ORDER BY 1,5,3,6";
        log.finest((String)sql + "Account_ID =" + Account_ID);
        try {
            int index = 1;
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(index++, this.m_AD_Client_ID);
            pstmt.setInt(index++, (Integer)this.fieldAccount.getValue());
            if ((Integer)this.fieldAcctSchema.getValue() > 0) {
                pstmt.setInt(index++, (Integer)this.fieldAcctSchema.getValue());
            }
            if (this.fieldBPartner.getValue() != null) {
                pstmt.setInt(index++, (Integer)this.fieldBPartner.getValue());
            }
            if (this.fieldProduct.getValue() != null) {
                pstmt.setInt(index++, (Integer)this.fieldProduct.getValue());
            }
            if (this.fieldDateAcct.getValue() != null) {
                pstmt.setTimestamp(index++, (Timestamp)this.fieldDateAcct.getValue());
            }
            if (this.fieldDateAcct2.getValue() != null) {
                pstmt.setTimestamp(index++, (Timestamp)this.fieldDateAcct2.getValue());
            }
            ResultSet rs = pstmt.executeQuery();
            this.miniTable.loadTable(rs);
            rs.close();
            pstmt.close();
            log.log(Level.FINE, (String)sql);
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, (String)sql, e);
        }
        this.loading = false;
        this.calculateSelection();
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bGenerate) {
            this.generateReconciliation();
        } else if (e.getSource() == this.bReset) {
            this.resetReconciliation();
        } else if (e.getSource() == this.bZoom) {
            this.zoom();
        } else if (e.getSource() == this.bCancel) {
            this.dispose();
        } else if (e.getSource() == this.bRefresh) {
            this.loadTableInfo();
        } else if (e.getSource() == this.bSelectAll) {
            int rows = this.miniTable.getModel().getRowCount();
            for (int i = 0; i < rows; ++i) {
                IDColumn id = (IDColumn)this.miniTable.getModel().getValueAt(i, this.idColIndex);
                id.setSelected(true);
            }
            this.miniTable.repaint();
            this.calculateSelection();
        }
    }

    protected void zoom() {
        log.info("");
        int selected = this.miniTable.getSelectedRow();
        if (selected == -1) {
            return;
        }
        int factId = ((IDColumn)this.miniTable.getModel().getValueAt(selected, this.idColIndex)).getRecord_ID();
        AEnv.zoom(270, factId);
    }

    private void resetReconciliation() {
        log.info("");
        this.miniTable.stopEditor(true);
        if (this.miniTable.getRowCount() == 0) {
            return;
        }
        this.miniTable.setRowSelectionInterval(0, 0);
        this.calculateSelection();
        if (this.m_noSelected == 0) {
            return;
        }
        for (int r = 0; r < this.miniTable.getModel().getRowCount(); ++r) {
            if (!((IDColumn)this.miniTable.getModel().getValueAt(r, this.idColIndex)).isSelected()) continue;
            int factId = ((IDColumn)this.miniTable.getModel().getValueAt(r, this.idColIndex)).getRecord_ID();
            MFactReconciliation rec = (MFactReconciliation)new Query(Env.getCtx(), "Fact_Reconciliation", "Fact_Acct_ID = ?", null).setParameters(factId).first();
            if (rec == null) continue;
            rec.setMatchCode(null);
            rec.saveEx();
            ((DefaultTableModel)this.miniTable.getModel()).removeRow(r--);
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.loading) {
            this.calculateSelection();
        }
    }

    public void calculateSelection() {
        this.m_noSelected = 0;
        BigDecimal selectedAmt = new BigDecimal(0.0);
        int rows = this.miniTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            IDColumn id = (IDColumn)this.miniTable.getModel().getValueAt(i, this.idColIndex);
            if (!id.isSelected()) continue;
            BigDecimal amt = (BigDecimal)this.miniTable.getModel().getValueAt(i, this.amtColIndex);
            if (amt != null) {
                selectedAmt = selectedAmt.add(amt);
            }
            ++this.m_noSelected;
        }
        StringBuffer info = new StringBuffer();
        info.append(this.m_noSelected).append(" ").append(Msg.getMsg(Env.getCtx(), "Selected")).append(" / ").append(this.miniTable.getRowCount());
        this.differenceField.setText(this.m_format.format(selectedAmt));
        this.dataStatus.setText(info.toString());
        this.bGenerate.setEnabled(this.m_noSelected != 0 && Env.ZERO.compareTo(selectedAmt) == 0 && !this.isReconciled.isSelected());
        this.bReset.setEnabled(this.m_noSelected > 0 && this.isReconciled.isSelected());
    }

    private void generateReconciliation() {
        log.info("");
        this.miniTable.stopEditor(true);
        if (this.miniTable.getRowCount() == 0) {
            return;
        }
        this.miniTable.setRowSelectionInterval(0, 0);
        this.calculateSelection();
        if (this.m_noSelected == 0) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = DisplayType.getDateFormat();
        String time = sdf.format(cal.getTime());
        String matchcode = Msg.parseTranslation(Env.getCtx(), "@IsManual@: " + Env.getContext(Env.getCtx(), "#AD_User_Name") + " " + time);
        for (int r = 0; r < this.miniTable.getModel().getRowCount(); ++r) {
            if (!((IDColumn)this.miniTable.getModel().getValueAt(r, this.idColIndex)).isSelected()) continue;
            int factId = ((IDColumn)this.miniTable.getModel().getValueAt(r, this.idColIndex)).getRecord_ID();
            MFactReconciliation rec = (MFactReconciliation)new Query(Env.getCtx(), "Fact_Reconciliation", "Fact_Acct_ID = ?", null).setParameters(factId).first();
            if (rec == null) {
                rec = new MFactReconciliation(Env.getCtx(), 0, null);
                rec.setFact_Acct_ID(factId);
            }
            rec.setMatchCode(matchcode);
            rec.saveEx();
            ((DefaultTableModel)this.miniTable.getModel()).removeRow(r--);
        }
    }

    @Override
    public void lockUI(ProcessInfo pi) {
        this.setEnabled(false);
        this.m_isLocked = true;
    }

    @Override
    public void unlockUI(ProcessInfo pi) {
        this.setEnabled(true);
        this.m_isLocked = false;
    }

    @Override
    public boolean isUILocked() {
        return this.m_isLocked;
    }

    @Override
    public void executeASync(ProcessInfo pi) {
        log.config("-");
    }
}

