/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.apps.AEnv;
import org.compiere.apps.IStatusBar;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MQuery;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class TrxMaterial {
    public int m_WindowNo = 0;
    public GridWindow m_mWindow = null;
    public GridTab m_mTab = null;
    public MQuery m_staticQuery = null;
    public static CLogger log = CLogger.getCLogger(TrxMaterial.class);
    public int AD_Window_ID;
    public MQuery query;

    public void dynInit(IStatusBar statusBar) {
        this.m_staticQuery = new MQuery();
        this.m_staticQuery.addRestriction("AD_Client_ID", "=", Env.getAD_Client_ID(Env.getCtx()));
        int AD_Window_ID = 223;
        GridWindowVO wVO = AEnv.getMWindowVO(this.m_WindowNo, AD_Window_ID, 0);
        if (wVO == null) {
            return;
        }
        this.m_mWindow = new GridWindow(wVO);
        this.m_mTab = this.m_mWindow.getTab(0);
        this.m_mWindow.initTab(0);
        this.m_mTab.setQuery(MQuery.getEqualQuery("1", "2"));
        this.m_mTab.query(false);
        statusBar.setStatusLine(" ", false);
        statusBar.setStatusDB(" ");
    }

    public void refresh(Object organization, Object locator, Object product, Object movementType, Timestamp movementDateFrom, Timestamp movementDateTo, IStatusBar statusBar) {
        MQuery query = this.m_staticQuery.deepCopy();
        if (organization != null && organization.toString().length() > 0) {
            query.addRestriction("AD_Org_ID", "=", organization);
        }
        if (locator != null && locator.toString().length() > 0) {
            query.addRestriction("M_Locator_ID", "=", locator);
        }
        if (product != null && product.toString().length() > 0) {
            query.addRestriction("M_Product_ID", "=", product);
        }
        if (movementType != null && movementType.toString().length() > 0) {
            query.addRestriction("MovementType", "=", movementType);
        }
        if (movementDateFrom != null) {
            query.addRestriction("TRUNC(MovementDate, 'DD')", ">=", movementDateFrom);
        }
        if (movementDateTo != null) {
            query.addRestriction("TRUNC(MovementDate, 'DD')", "<=", movementDateTo);
        }
        log.info("VTrxMaterial.refresh query=" + query.toString());
        statusBar.setStatusLine(Msg.getMsg(Env.getCtx(), "StartSearch"), false);
        this.m_mTab.setQuery(query);
        this.m_mTab.query(false);
        int no = this.m_mTab.getRowCount();
        statusBar.setStatusLine(" ", false);
        statusBar.setStatusDB(Integer.toString(no));
    }

    public void zoom() {
        log.info("");
        this.AD_Window_ID = 0;
        String ColumnName = null;
        String SQL = null;
        int lineID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "M_InOutLine_ID");
        if (lineID != 0) {
            log.fine("M_InOutLine_ID=" + lineID);
            this.AD_Window_ID = Env.getContext(Env.getCtx(), this.m_WindowNo, "MovementType").startsWith("C") ? 169 : 184;
            ColumnName = "M_InOut_ID";
            SQL = "SELECT M_InOut_ID FROM M_InOutLine WHERE M_InOutLine_ID=?";
        } else {
            lineID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "M_InventoryLine_ID");
            if (lineID != 0) {
                log.fine("M_InventoryLine_ID=" + lineID);
                this.AD_Window_ID = 168;
                ColumnName = "M_Inventory_ID";
                SQL = "SELECT M_Inventory_ID FROM M_InventoryLine WHERE M_InventoryLine_ID=?";
            } else {
                lineID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "M_MovementLine_ID");
                if (lineID != 0) {
                    log.fine("M_MovementLine_ID=" + lineID);
                    this.AD_Window_ID = 170;
                    ColumnName = "M_Movement_ID";
                    SQL = "SELECT M_Movement_ID FROM M_MovementLine WHERE M_MovementLine_ID=?";
                } else {
                    lineID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "M_ProductionLine_ID");
                    if (lineID != 0) {
                        log.fine("M_ProductionLine_ID=" + lineID);
                        this.AD_Window_ID = 191;
                        ColumnName = "M_Production_ID";
                        SQL = "SELECT M_Production_ID FROM M_ProductionLine WHERE M_ProductionLine_ID=?";
                    } else {
                        lineID = Env.getContextAsInt(Env.getCtx(), this.m_WindowNo, "C_ProjectIssue_ID");
                        if (lineID != 0) {
                            log.fine("C_ProjectIssue_ID=" + lineID);
                            this.AD_Window_ID = 286;
                            ColumnName = "C_Project_ID";
                            SQL = "SELECT C_Project_ID FROM C_ProjectIssue WHERE C_ProjectIssue_ID=?";
                        } else {
                            log.fine("Not found WindowNo=" + this.m_WindowNo);
                        }
                    }
                }
            }
        }
        if (this.AD_Window_ID == 0) {
            return;
        }
        int parentID = 0;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, lineID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                parentID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, SQL, e);
        }
        this.query = MQuery.getEqualQuery(ColumnName, parentID);
        log.config("AD_Window_ID=" + this.AD_Window_ID + " - " + this.query);
        if (parentID == 0) {
            log.log(Level.SEVERE, "No ParentValue - " + SQL + " - " + lineID);
        }
    }
}

