/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class Merge {
    private static final long serialVersionUID = 149783846292562740L;
    public int m_WindowNo = 0;
    public int m_totalCount = 0;
    public StringBuffer m_errorLog = new StringBuffer();
    private Trx m_trx = null;
    public static CLogger log = CLogger.getCLogger(Merge.class);
    public static String AD_ORG_ID = "AD_Org_ID";
    public static String C_BPARTNER_ID = "C_BPartner_ID";
    public static String AD_USER_ID = "AD_User_ID";
    public static String M_PRODUCT_ID = "M_Product_ID";
    public static String[] s_delete_Org = new String[]{"AD_OrgInfo", "AD_Role_OrgAccess"};
    public static String[] s_delete_User = new String[]{"AD_User_Roles"};
    public static String[] s_delete_BPartner = new String[]{"C_BP_Employee_Acct", "C_BP_Vendor_Acct", "C_BP_Customer_Acct", "T_Aging"};
    public static String[] s_delete_Product = new String[]{"M_Product_PO", "M_Replenish", "T_Replenish", "M_ProductPrice", "M_Product_Costing", "M_Cost", "M_Product_Trl", "M_Product_Acct", "M_Storage"};
    public String[] m_columnName = null;
    public String[] m_deleteTables = null;

    public void updateDeleteTable(String columnName) {
        if (columnName.equals(AD_ORG_ID)) {
            this.m_deleteTables = s_delete_Org;
        } else if (columnName.equals(AD_USER_ID)) {
            this.m_deleteTables = s_delete_User;
        } else if (columnName.equals(C_BPARTNER_ID)) {
            this.m_deleteTables = s_delete_BPartner;
        } else if (columnName.equals(M_PRODUCT_ID)) {
            this.m_deleteTables = s_delete_Product;
        }
    }

    public boolean merge(String ColumnName, int from_ID, int to_ID) {
        String TableName = ColumnName.substring(0, ColumnName.length() - 3);
        log.config(ColumnName + " - From=" + from_ID + ",To=" + to_ID);
        boolean success = true;
        this.m_totalCount = 0;
        this.m_errorLog = new StringBuffer();
        Object sql = "SELECT t.TableName, c.ColumnName FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) WHERE t.IsView='N' AND t.TableName NOT IN ('C_TaxDeclarationAcct') AND ((c.ColumnName=? AND c.IsKey='N') OR c.AD_Reference_Value_ID IN (SELECT rt.AD_Reference_ID FROM AD_Ref_Table rt INNER JOIN AD_Column cc ON (rt.AD_Table_ID=cc.AD_Table_ID AND rt.AD_Key=cc.AD_Column_ID) WHERE cc.IsKey='Y' AND cc.ColumnName=?)) AND c.ColumnSQL IS NULL ORDER BY t.LoadSeq DESC";
        CPreparedStatement pstmt = null;
        try {
            this.m_trx = Trx.get(Trx.createTrxName("merge"), true);
            pstmt = DB.prepareStatement((String)sql, Trx.createTrxName());
            pstmt.setString(1, ColumnName);
            pstmt.setString(2, ColumnName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String tName = rs.getString(1);
                String cName = rs.getString(2);
                if (TableName.equals(tName)) continue;
                int count = this.mergeTable(tName, cName, from_ID, to_ID);
                if (count < 0) {
                    success = false;
                    continue;
                }
                this.m_totalCount += count;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            log.config("Success=" + success + " - " + ColumnName + " - From=" + from_ID + ",To=" + to_ID);
            if (success && DB.executeUpdate((String)(sql = "DELETE " + TableName + " WHERE " + ColumnName + "=" + from_ID), this.m_trx.getTrxName()) < 0) {
                this.m_errorLog.append(Env.NL).append("DELETE ").append(TableName).append(" - ");
                success = false;
                log.config(this.m_errorLog.toString());
                this.m_trx.rollback();
                return false;
            }
            if (success) {
                success = this.m_trx.commit();
            } else {
                this.m_trx.rollback();
            }
            this.m_trx.close();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, ColumnName, ex);
            success = false;
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        pstmt = null;
        return success;
    }

    public int mergeTable(String TableName, String ColumnName, int from_ID, int to_ID) {
        int count;
        log.fine(TableName + "." + ColumnName + " - From=" + from_ID + ",To=" + to_ID);
        String sql = "UPDATE " + TableName + " SET " + ColumnName + "=" + to_ID + " WHERE " + ColumnName + "=" + from_ID;
        boolean delete = false;
        for (int i = 0; i < this.m_deleteTables.length; ++i) {
            if (!this.m_deleteTables[i].equals(TableName)) continue;
            delete = true;
            sql = "DELETE " + TableName + " WHERE " + ColumnName + "=" + from_ID;
        }
        if (delete && "M_Storage".equals(TableName) && M_PRODUCT_ID.equals(ColumnName)) {
            sql = sql + " AND M_AttributeSetInstance_ID = 0  AND QtyOnHand = 0  AND QtyOrdered = 0  AND QtyReserved = 0 ";
        }
        if ((count = DB.executeUpdate(sql, this.m_trx.getTrxName())) < 0) {
            count = -1;
            this.m_errorLog.append(Env.NL).append(delete ? "DELETE " : "UPDATE ").append(TableName).append(" - ").append(" - ").append(sql);
            log.config(this.m_errorLog.toString());
            this.m_trx.rollback();
        }
        log.fine(count + (delete ? " -Delete- " : " -Update- ") + TableName);
        return count;
    }

    public void postMerge(String ColumnName, int to_ID) {
        if (!ColumnName.equals(AD_ORG_ID) && !ColumnName.equals(AD_USER_ID)) {
            if (ColumnName.equals(C_BPARTNER_ID)) {
                MBPartner bp = new MBPartner(Env.getCtx(), to_ID, null);
                if (bp.get_ID() != 0) {
                    MPayment[] payments = MPayment.getOfBPartner(Env.getCtx(), bp.getC_BPartner_ID(), null);
                    for (int i = 0; i < payments.length; ++i) {
                        MPayment payment = payments[i];
                        if (!payment.testAllocation()) continue;
                        payment.saveEx();
                    }
                    MInvoice[] invoices = MInvoice.getOfBPartner(Env.getCtx(), bp.getC_BPartner_ID(), null);
                    for (int i = 0; i < invoices.length; ++i) {
                        MInvoice invoice = invoices[i];
                        if (!invoice.testAllocation()) continue;
                        invoice.saveEx();
                    }
                    bp.setTotalOpenBalance();
                    bp.setActualLifeTimeValue();
                    bp.saveEx();
                }
            } else if (ColumnName.equals(M_PRODUCT_ID)) {
                // empty if block
            }
        }
    }
}

