/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCharge;
import org.compiere.model.MElementValue;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class Charge {
    private static final long serialVersionUID = 2478440763968206819L;
    public int m_WindowNo = 0;
    public int m_C_Element_ID = 0;
    private int m_C_AcctSchema_ID = 0;
    private int m_C_TaxCategory_ID = 0;
    private int m_AD_Client_ID = 0;
    private int m_AD_Org_ID = 0;
    private int m_CreatedBy = 0;
    private MAcctSchema m_acctSchema = null;
    public static CLogger log = CLogger.getCLogger(Charge.class);
    public StringBuffer listCreated;
    public StringBuffer listRejected;

    public Vector<Vector<Object>> getData() {
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        String sql = "SELECT C_ElementValue_ID,Value, Name, AccountType FROM C_ElementValue WHERE AccountType IN ('R','E') AND IsSummary='N' AND C_Element_ID=? ORDER BY 2";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_C_Element_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>(4);
                line.add(new IDColumn(rs.getInt(1)));
                line.add(rs.getString(2));
                line.add(rs.getString(3));
                boolean isExpenseType = rs.getString(4).equals("E");
                line.add(isExpenseType);
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        return data;
    }

    public void findChargeElementID() {
        this.m_C_AcctSchema_ID = Env.getContextAsInt(Env.getCtx(), "$C_AcctSchema_ID");
        String sql = "SELECT C_Element_ID FROM C_AcctSchema_Element WHERE ElementType='AC' AND C_AcctSchema_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_C_AcctSchema_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_C_Element_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException exception) {
            log.log(Level.SEVERE, sql, exception);
        }
    }

    public Vector<String> getColumnNames() {
        Vector<String> columnNames = new Vector<String>(4);
        columnNames.add(Msg.getMsg(Env.getCtx(), " "));
        columnNames.add(Msg.translate(Env.getCtx(), "Value"));
        columnNames.add(Msg.translate(Env.getCtx(), "Name"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Expense"));
        return columnNames;
    }

    public void setColumnClass(IMiniTable dataTable) {
        dataTable.setKeyColumnIndex(0);
        dataTable.setColumnClass(0, IDColumn.class, true);
        dataTable.setColumnClass(1, String.class, true);
        dataTable.setColumnClass(2, String.class, true);
        dataTable.setColumnClass(3, Boolean.class, true);
        dataTable.autoSize();
    }

    public void findTaxCategoryID() {
        this.m_AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
        this.m_AD_Org_ID = Env.getAD_Org_ID(Env.getCtx());
        this.m_CreatedBy = Env.getAD_User_ID(Env.getCtx());
        String sql = "SELECT C_TaxCategory_ID FROM C_TaxCategory WHERE IsDefault='Y' AND AD_Client_ID=?";
        this.m_C_TaxCategory_ID = 0;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.m_C_TaxCategory_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
    }

    protected int createElementValue(String value, String name, boolean isExpenseType) {
        log.config(name);
        MElementValue ev = new MElementValue(Env.getCtx(), value, name, null, isExpenseType ? "E" : "R", "N", false, false, null);
        ev.setAD_Org_ID(this.m_AD_Org_ID);
        ev.setC_Element_ID(this.m_C_Element_ID);
        if (!ev.save()) {
            log.log(Level.WARNING, "C_ElementValue_ID not created");
        }
        return ev.getC_ElementValue_ID();
    }

    protected int createCharge(String name, int elementValueId) {
        log.config(name + " - ");
        MCharge charge = new MCharge(Env.getCtx(), 0, null);
        charge.setName(name);
        charge.setC_TaxCategory_ID(this.m_C_TaxCategory_ID);
        if (!charge.save()) {
            log.log(Level.SEVERE, name + " not created");
            return 0;
        }
        this.refreshAccountSchema();
        if (!this.isAccountSchemaValid()) {
            return 0;
        }
        MAccount account = this.getAccount(elementValueId, charge);
        if (account == null) {
            return 0;
        }
        this.updateAccount(charge, account);
        return charge.getC_Charge_ID();
    }

    private void updateAccount(MCharge charge, MAccount account) {
        StringBuffer sql = this.createUpdateAccountSql(charge, account);
        int noAffectedRows = DB.executeUpdate(sql.toString(), null);
        if (noAffectedRows != 1) {
            log.log(Level.SEVERE, "Update #" + noAffectedRows + "\n" + sql.toString());
        }
    }

    private boolean isAccountSchemaValid() {
        if (this.m_acctSchema == null) {
            return false;
        }
        return this.m_acctSchema.getC_AcctSchema_ID() != 0;
    }

    private StringBuffer createUpdateAccountSql(MCharge charge, MAccount account) {
        StringBuffer sql = new StringBuffer("UPDATE C_Charge_Acct ");
        sql.append("SET CH_Expense_Acct=").append(account.getC_ValidCombination_ID());
        sql.append(", CH_Revenue_Acct=").append(account.getC_ValidCombination_ID());
        sql.append(" WHERE C_Charge_ID=").append(charge.getC_Charge_ID());
        sql.append(" AND C_AcctSchema_ID=").append(this.m_C_AcctSchema_ID);
        return sql;
    }

    private void refreshAccountSchema() {
        if (this.m_acctSchema == null) {
            this.m_acctSchema = new MAcctSchema(Env.getCtx(), this.m_C_AcctSchema_ID, null);
        }
    }

    private MAccount getAccount(int elementValueId, MCharge charge) {
        MAccount defaultAccount = MAccount.getDefault(this.m_acctSchema, true);
        MAccount account = MAccount.get(Env.getCtx(), charge.getAD_Client_ID(), charge.getAD_Org_ID(), this.m_acctSchema.getC_AcctSchema_ID(), elementValueId, defaultAccount.getC_SubAcct_ID(), defaultAccount.getM_Product_ID(), defaultAccount.getC_BPartner_ID(), defaultAccount.getAD_OrgTrx_ID(), defaultAccount.getC_LocFrom_ID(), defaultAccount.getC_LocTo_ID(), defaultAccount.getC_SalesRegion_ID(), defaultAccount.getC_Project_ID(), defaultAccount.getC_Campaign_ID(), defaultAccount.getC_Activity_ID(), defaultAccount.getUser1_ID(), defaultAccount.getUser2_ID(), defaultAccount.getUser3_ID(), defaultAccount.getUser4_ID(), defaultAccount.getUserElement1_ID(), defaultAccount.getUserElement2_ID(), null);
        return account;
    }

    public void createAccount(IMiniTable dataTable) {
        log.config("");
        this.listCreated = new StringBuffer();
        this.listRejected = new StringBuffer();
        int rows = dataTable.getRowCount();
        for (int i = 0; i < rows; ++i) {
            if (!dataTable.isRowChecked(i)) continue;
            int C_ElementValue_ID = dataTable.getRowKey(i);
            String name = (String)dataTable.getValueAt(i, dataTable.convertColumnIndexToModel(2));
            int C_Charge_ID = this.createCharge(name, C_ElementValue_ID);
            if (C_Charge_ID == 0) {
                if (this.listRejected.length() > 0) {
                    this.listRejected.append(", ");
                }
                this.listRejected.append(name);
            } else {
                if (this.listCreated.length() > 0) {
                    this.listCreated.append(", ");
                }
                this.listCreated.append(name);
            }
            dataTable.setRowChecked(i, false);
        }
    }
}

