/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_C_Invoice;
import org.adempiere.core.domains.models.I_C_Payment;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrg;
import org.compiere.model.MPayment;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;
import org.openup.core.model.MUYPayReceipt;
import org.openup.core.model.MUYPayReceiptDoc;
import org.openup.core.model.MUYPayReceiptLine;

public class AllocationReceipt {
    public DecimalFormat format = DisplayType.getNumberFormat(12);
    public static CLogger log = CLogger.getCLogger(AllocationReceipt.class);
    private boolean calculating = false;
    public int currencyId = 0;
    public int bPartnerId = 0;
    public int chargeId = 0;
    public int orgWriteId = 0;
    public String description = null;
    private boolean isSOTrx = false;
    private int noInvoices = 0;
    private int noPayments = 0;
    public BigDecimal totalInv = new BigDecimal(0.0);
    public BigDecimal totalPay = new BigDecimal(0.0);
    public BigDecimal totalDiff = new BigDecimal(0.0);
    public Timestamp allocDate = null;
    private int paymentPaidIndex = 8;
    private int paymentOpenIndex = 7;
    private int invoiceOpenIndex = 6;
    private int invoiceDiscountIndex = 7;
    private int invoiceWriteOffIndex = 8;
    private int invoiceAppliedIndex = 9;
    private int invoiceOverUnderIndex = 10;
    public int orgId = 0;
    public String apar = null;
    private int windowNo = 0;
    private PO poFrom = null;
    public static final String APAR_A = "A";
    public static final String APAR_P = "P";
    public static final String APAR_R = "R";
    private ArrayList<Integer> bpartnerCheck = new ArrayList();

    public void dynInit() throws Exception {
        this.setFromPO(null);
        log.info("Currency=" + this.currencyId);
    }

    public void setFromPO(ProcessInfo processInfo) {
        if (processInfo != null && processInfo.getTable_ID() > 0 && processInfo.getRecord_ID() > 0) {
            this.poFrom = MTable.get(Env.getCtx(), processInfo.getTable_ID()).getPO(processInfo.getRecord_ID(), null);
            this.bPartnerId = this.getDefaultBPartnerId();
            this.orgId = this.getDefaultOrgId();
            this.currencyId = this.getDefaultCurrencyId();
            this.isSOTrx = this.isDefaultSOTrx();
        } else {
            this.bPartnerId = -1;
            this.orgId = Env.getAD_Org_ID(Env.getCtx());
            this.currencyId = Env.getContextAsInt(Env.getCtx(), "$C_Currency_ID");
        }
        Env.setContext(Env.getCtx(), this.getWindowNo(), "IsSOTrx", this.isSOTrx ? "Y" : "N");
    }

    private int getDefaultBPartnerId() {
        if (this.poFrom == null) {
            return -1;
        }
        return this.poFrom.get_ValueAsInt("C_BPartner_ID");
    }

    private int getDefaultOrgId() {
        if (this.poFrom == null) {
            return -1;
        }
        return this.poFrom.get_ValueAsInt("AD_Org_ID");
    }

    private int getDefaultCurrencyId() {
        if (this.poFrom == null) {
            return -1;
        }
        return this.poFrom.get_ValueAsInt("C_Currency_ID");
    }

    private boolean isDefaultSOTrx() {
        if (this.poFrom == null) {
            return false;
        }
        int index = this.poFrom.get_ColumnIndex("IsReceipt");
        if (index > 0) {
            return this.poFrom.get_ValueAsBoolean("IsReceipt");
        }
        index = this.poFrom.get_ColumnIndex("IsSOTrx");
        if (index > 0) {
            return this.poFrom.get_ValueAsBoolean("IsSOTrx");
        }
        return false;
    }

    public boolean isDefaultMultiCurrency() {
        int defaultCurrencyId = this.getDefaultCurrencyId();
        if (defaultCurrencyId > 0) {
            int currencyId = Env.getContextAsInt(Env.getCtx(), "$C_Currency_ID");
            return currencyId != defaultCurrencyId;
        }
        return false;
    }

    public boolean isFromParent() {
        return this.poFrom != null;
    }

    public void setWindowNo(int windowNo) {
        this.windowNo = windowNo;
    }

    public int getWindowNo() {
        return this.windowNo;
    }

    public void setAD_Org_ID() {
        if (this.orgId > 0) {
            Env.setContext(Env.getCtx(), this.getWindowNo(), "AD_Org_ID", this.orgId);
        } else {
            Env.setContext(Env.getCtx(), this.getWindowNo(), "AD_Org_ID", "");
        }
    }

    public int getAD_Org_ID() {
        return this.orgId;
    }

    public void setAD_Org_ID(int orgId) {
        this.orgId = orgId;
    }

    public void setDefaultRecord(IMiniTable payment, IMiniTable invoice) {
        block4: {
            block3: {
                if (!this.isFromParent()) {
                    return;
                }
                if (this.poFrom.get_Table_ID() != I_C_Payment.Table_ID) break block3;
                for (int row = 0; row < payment.getRowCount(); ++row) {
                    int paymentId = payment.getRowKey(row);
                    if (paymentId != this.poFrom.get_ID()) continue;
                    payment.setRowChecked(row, true);
                }
                break block4;
            }
            if (this.poFrom.get_Table_ID() != I_C_Invoice.Table_ID) break block4;
            for (int row = 0; row < invoice.getRowCount(); ++row) {
                int invoiceId = invoice.getRowKey(row);
                if (invoiceId != this.poFrom.get_ID()) continue;
                invoice.setRowChecked(row, true);
            }
        }
    }

    public void checkBPartner() {
        log.config("BPartner=" + this.bPartnerId + ", Cur=" + this.currencyId);
        if (this.bPartnerId == 0 || this.currencyId == 0) {
            return;
        }
        Integer key = new Integer(this.bPartnerId);
        if (!this.bpartnerCheck.contains(key)) {
            new Thread(){

                @Override
                public void run() {
                    MPayment.setIsAllocated(Env.getCtx(), AllocationReceipt.this.bPartnerId, null);
                    MInvoice.setIsPaid(Env.getCtx(), AllocationReceipt.this.bPartnerId, null);
                }
            }.start();
            this.bpartnerCheck.add(key);
        }
    }

    public Vector<Vector<Object>> getPaymentData(boolean isMultiCurrency, Object date, IMiniTable paymentTable) {
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        StringBuffer sql = new StringBuffer("SELECT p.DateDoc,p.DocumentNo,p.UY_PayREceipt_ID,c.ISO_Code,p.PayAmt, currencyConvert(p.PayAmt,p.C_Currency_ID," + this.currencyId + ",'" + (Timestamp)date + "',114,p.AD_Client_ID,p.AD_Org_ID) AS ConvertedAmt, currencyConvert(payreceiptavailable (p.uy_payreceipt_id, p.issotrx),p.C_Currency_ID," + this.currencyId + ",'" + (Timestamp)date + "',114, p.AD_Client_ID,p.AD_Org_ID) AS AvailableAmt,p.IsSOTrx,p.AD_Org_ID,p.Description FROM UY_PayReceipt p INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID) WHERE (payreceiptavailable (p.uy_payreceipt_id, p.issotrx) <> 0) AND p.Processed='Y' AND p.C_Charge_ID IS NULL AND p.docstatus = 'CO' AND p.C_BPartner_ID = " + this.bPartnerId);
        if (!isMultiCurrency) {
            sql.append(" AND p.C_Currency_ID=?");
        }
        if (this.orgId != 0) {
            sql.append(" AND p.AD_Org_ID=" + this.orgId);
        }
        if (this.apar != null && !this.apar.equals(APAR_A)) {
            sql.append(" AND p.IsSOTrx= '" + (this.apar.equals(APAR_R) ? "Y" : "N") + "'");
        }
        sql.append(" ORDER BY p.DateDoc,p.DocumentNo");
        sql = new StringBuffer(MRole.getDefault(Env.getCtx(), false).addAccessSQL(sql.toString(), "p", true, false));
        log.fine("PaySQL=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            if (!isMultiCurrency) {
                pstmt.setInt(1, this.currencyId);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                BigDecimal available;
                Vector<Object> line = new Vector<Object>();
                line.add(new IDColumn(rs.getInt("UY_PayReceipt_ID")));
                line.add(rs.getTimestamp("DateDoc"));
                if (rs.getString("IsSOTrx").equals("Y")) {
                    line.add("AR");
                } else {
                    line.add("AP");
                }
                int orgID = rs.getInt("AD_Org_ID");
                if (orgID == 0) {
                    line.add("*");
                } else {
                    line.add(MOrg.get(Env.getCtx(), orgID).getName());
                }
                KeyNamePair pp = new KeyNamePair(rs.getInt("Uy_PayReceipt_ID"), rs.getString("DocumentNo"));
                line.add(pp);
                line.add(rs.getString("Description"));
                if (isMultiCurrency) {
                    line.add(rs.getString("ISO_Code"));
                    line.add(rs.getBigDecimal("PayAmt"));
                }
                if (rs.getString("IsSOTrx").equals("N")) {
                    BigDecimal amt = rs.getBigDecimal("ConvertedAmt");
                    line.add(amt.negate());
                } else {
                    line.add(rs.getBigDecimal("ConvertedAmt"));
                }
                if ((available = rs.getBigDecimal("AvailableAmt")) == null || available.signum() == 0) continue;
                line.add(available);
                line.add(Env.ZERO);
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        return data;
    }

    public Vector<String> getPaymentColumnNames(boolean isMultiCurrency) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "Date"));
        columnNames.add(Msg.getElement(Env.getCtx(), "APAR"));
        columnNames.add(Msg.getElement(Env.getCtx(), "AD_Org_ID"));
        columnNames.add(Util.cleanAmp(Msg.translate(Env.getCtx(), "DocumentNo")));
        columnNames.add(Msg.getElement(Env.getCtx(), "Description"));
        if (isMultiCurrency) {
            columnNames.add(Msg.getMsg(Env.getCtx(), "TrxCurrency"));
            columnNames.add(Msg.translate(Env.getCtx(), "Amount"));
        }
        columnNames.add(Msg.getMsg(Env.getCtx(), "ConvertedAmount"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "OpenAmt"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "AppliedAmt"));
        return columnNames;
    }

    public void setPaymentColumnClass(IMiniTable paymentTable, boolean isMultiCurrency) {
        Vector<String> names = this.getPaymentColumnNames(isMultiCurrency);
        int i = 0;
        paymentTable.setKeyColumnIndex(i);
        paymentTable.setColumnClass(i, IDColumn.class, true, names.get(i++));
        paymentTable.setColumnClass(i, Timestamp.class, true, names.get(i++));
        paymentTable.setColumnClass(i, String.class, true, names.get(i++));
        paymentTable.setColumnClass(i, String.class, true, names.get(i++));
        paymentTable.setColumnClass(i, String.class, true, names.get(i++));
        paymentTable.setColumnClass(i, String.class, true, names.get(i++));
        if (isMultiCurrency) {
            paymentTable.setColumnClass(i, String.class, true, names.get(i++));
            paymentTable.setColumnClass(i, BigDecimal.class, true, names.get(i++));
        }
        paymentTable.setColumnClass(i, BigDecimal.class, true, names.get(i++));
        paymentTable.setColumnClass(i, BigDecimal.class, true, names.get(i++));
        paymentTable.setColumnClass(i, BigDecimal.class, true, names.get(i++));
        this.paymentPaidIndex = isMultiCurrency ? 10 : 8;
        paymentTable.autoSize();
    }

    public Vector<Vector<Object>> getInvoiceData(boolean isMultiCurrency, Object date, IMiniTable invoiceTable) {
        Vector<Vector<Object>> data = new Vector<Vector<Object>>();
        StringBuffer sql = new StringBuffer("SELECT i.DateInvoiced,i.DocumentNo, i.Description, i.C_Invoice_ID,c.ISO_Code, (i.GrandTotal*i.MultiplierAP) AS OriginalAmt, currencyConvert(i.GrandTotal*i.MultiplierAP,i.C_Currency_ID," + this.currencyId + ",'" + (Timestamp)date + "', i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID) AS ConvertedAmt, (currencyConvert(invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID),i.C_Currency_ID," + this.currencyId + ",'" + (Timestamp)date + "',i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.MultiplierAP) AS OpenAmt, (currencyConvert(invoiceDiscount(i.C_Invoice_ID,'" + (Timestamp)date + "',C_InvoicePaySchedule_ID),i.C_Currency_ID," + this.currencyId + ",i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.Multiplier*i.MultiplierAP) AS DiscountAmt,i.MultiplierAP, i.IsSoTrx, i.AD_Org_ID FROM C_Invoice_v i INNER JOIN C_Currency c ON (i.C_Currency_ID=c.C_Currency_ID)  INNER JOIN C_DocType d ON (i.C_DocTypeTarget_ID=d.C_DocType_ID)  WHERE i.IsPaid='N' AND i.Processed='Y' AND d.DocBaseType NOT IN ('DRC','DPC','DRI','DPI') AND i.C_BPartner_ID=" + this.bPartnerId);
        if (!isMultiCurrency) {
            sql.append(" AND i.C_Currency_ID=?");
        }
        if (this.orgId != 0) {
            sql.append(" AND i.AD_Org_ID=" + this.orgId);
        }
        if (this.apar != null && !this.apar.equals(APAR_A)) {
            sql.append(" AND i.IsSoTrx='" + (this.apar.equals(APAR_R) ? "Y" : "N") + "'");
        }
        sql.append(" ORDER BY i.DateInvoiced, i.DocumentNo");
        log.fine("InvSQL=" + sql.toString());
        sql = new StringBuffer(MRole.getDefault(Env.getCtx(), false).addAccessSQL(sql.toString(), "i", true, false));
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            if (!isMultiCurrency) {
                pstmt.setInt(1, this.currencyId);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Vector<Object> line = new Vector<Object>();
                line.add(new IDColumn(rs.getInt("C_Invoice_ID")));
                line.add(rs.getTimestamp("DateInvoiced"));
                if (rs.getString("IsSoTrx").equals("Y")) {
                    line.add("AR");
                } else {
                    line.add("AP");
                }
                int orgID = rs.getInt("AD_Org_ID");
                if (orgID == 0) {
                    line.add("*");
                } else {
                    line.add(MOrg.get(Env.getCtx(), orgID).getName());
                }
                KeyNamePair pp = new KeyNamePair(rs.getInt("C_Invoice_ID"), rs.getString("DocumentNo"));
                line.add(pp);
                line.add(rs.getString("Description"));
                if (isMultiCurrency) {
                    line.add(rs.getString("ISO_Code"));
                    line.add(rs.getBigDecimal("OriginalAmt"));
                }
                line.add(rs.getBigDecimal("ConvertedAmt"));
                BigDecimal open = rs.getBigDecimal("OpenAmt");
                if (open == null) {
                    open = Env.ZERO;
                }
                line.add(open);
                BigDecimal discount = rs.getBigDecimal("DiscountAmt");
                if (discount == null) {
                    discount = Env.ZERO;
                }
                line.add(discount);
                line.add(Env.ZERO);
                line.add(Env.ZERO);
                line.add(open);
                if (Env.ZERO.compareTo(open) == 0) continue;
                data.add(line);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), e);
        }
        return data;
    }

    public Vector<String> getInvoiceColumnNames(boolean isMultiCurrency) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg(Env.getCtx(), "Select"));
        columnNames.add(Msg.translate(Env.getCtx(), "Date"));
        columnNames.add(Msg.getElement(Env.getCtx(), "APAR"));
        columnNames.add(Msg.getElement(Env.getCtx(), "AD_Org_ID"));
        columnNames.add(Util.cleanAmp(Msg.translate(Env.getCtx(), "DocumentNo")));
        columnNames.add(Msg.getElement(Env.getCtx(), "Description"));
        if (isMultiCurrency) {
            columnNames.add(Msg.getMsg(Env.getCtx(), "TrxCurrency"));
            columnNames.add(Msg.translate(Env.getCtx(), "Amount"));
        }
        columnNames.add(Msg.getMsg(Env.getCtx(), "ConvertedAmount"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "OpenAmt"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "Discount"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "WriteOff"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "AppliedAmt"));
        columnNames.add(Msg.getMsg(Env.getCtx(), "OverUnderAmt"));
        return columnNames;
    }

    public void setInvoiceColumnClass(IMiniTable invoiceTable, boolean isMultiCurrency) {
        Vector<String> names = this.getInvoiceColumnNames(isMultiCurrency);
        int i = 0;
        invoiceTable.setKeyColumnIndex(i);
        invoiceTable.setColumnClass(i, IDColumn.class, true, names.get(i++));
        invoiceTable.setColumnClass(i, Timestamp.class, true, names.get(i++));
        invoiceTable.setColumnClass(i, String.class, true, names.get(i++));
        invoiceTable.setColumnClass(i, String.class, true, names.get(i++));
        invoiceTable.setColumnClass(i, String.class, true, names.get(i++));
        invoiceTable.setColumnClass(i, String.class, true, names.get(i++));
        if (isMultiCurrency) {
            invoiceTable.setColumnClass(i, String.class, true, names.get(i++));
            invoiceTable.setColumnClass(i, BigDecimal.class, true, names.get(i++));
        }
        invoiceTable.setColumnClass(i, BigDecimal.class, true, names.get(i++));
        invoiceTable.setColumnClass(i, BigDecimal.class, true, names.get(i++));
        invoiceTable.setColumnClass(i, BigDecimal.class, false, names.get(i++));
        invoiceTable.setColumnClass(i, BigDecimal.class, false, names.get(i++));
        invoiceTable.setColumnClass(i, BigDecimal.class, false, names.get(i++));
        invoiceTable.setColumnClass(i, BigDecimal.class, true, names.get(i++));
        invoiceTable.autoSize();
    }

    public void changeIndexForTables(boolean isMultiCurrency) {
        this.paymentOpenIndex = isMultiCurrency ? 9 : 7;
        this.invoiceOpenIndex = isMultiCurrency ? 9 : 7;
        this.invoiceDiscountIndex = isMultiCurrency ? 10 : 8;
        this.invoiceWriteOffIndex = isMultiCurrency ? 11 : 9;
        this.invoiceAppliedIndex = isMultiCurrency ? 12 : 10;
        this.invoiceOverUnderIndex = isMultiCurrency ? 13 : 11;
    }

    public String writeOff(int row, int col, boolean isInvoice, IMiniTable payment, IMiniTable invoice, boolean isAutoWriteOff) {
        String msg = "";
        if (this.calculating) {
            return msg;
        }
        this.calculating = true;
        log.config("Row=" + row + ", Col=" + col + ", InvoiceTable=" + isInvoice);
        if (!isInvoice) {
            BigDecimal open = (BigDecimal)payment.getValueAt(row, payment.convertColumnIndexToView(this.paymentOpenIndex));
            BigDecimal applied = (BigDecimal)payment.getValueAt(row, payment.convertColumnIndexToView(this.paymentPaidIndex));
            if (col == 0) {
                if (payment.isRowChecked(row)) {
                    applied = open;
                    if (this.totalDiff.abs().compareTo(applied.abs()) < 0 && this.totalDiff.signum() == -applied.signum()) {
                        applied = this.totalDiff.negate();
                    }
                } else {
                    applied = Env.ZERO;
                }
            }
            if (col == payment.convertColumnIndexToView(this.paymentPaidIndex)) {
                if (applied.signum() == -open.signum()) {
                    applied = applied.negate();
                }
                if (open.abs().compareTo(applied.abs()) < 0) {
                    applied = open;
                }
            }
            payment.setValueAt(applied, row, payment.convertColumnIndexToView(this.paymentPaidIndex));
        } else {
            boolean selected = invoice.isRowChecked(row);
            BigDecimal open = (BigDecimal)invoice.getValueAt(row, invoice.convertColumnIndexToView(this.invoiceOpenIndex));
            BigDecimal discount = (BigDecimal)invoice.getValueAt(row, invoice.convertColumnIndexToView(this.invoiceDiscountIndex));
            BigDecimal applied = (BigDecimal)invoice.getValueAt(row, invoice.convertColumnIndexToView(this.invoiceAppliedIndex));
            BigDecimal writeOff = (BigDecimal)invoice.getValueAt(row, invoice.convertColumnIndexToView(this.invoiceWriteOffIndex));
            BigDecimal overUnder = (BigDecimal)invoice.getValueAt(row, invoice.convertColumnIndexToView(this.invoiceOverUnderIndex));
            int openSign = open.signum();
            if (col == 0) {
                if (selected) {
                    applied = open;
                    applied = applied.subtract(discount);
                    writeOff = Env.ZERO;
                    overUnder = Env.ZERO;
                    if (this.totalDiff.abs().compareTo(applied.abs()) < 0 && this.totalDiff.signum() == applied.signum()) {
                        applied = this.totalDiff;
                    }
                    if (isAutoWriteOff) {
                        writeOff = open.subtract(applied.add(discount));
                    } else {
                        overUnder = open.subtract(applied.add(discount));
                    }
                } else {
                    writeOff = Env.ZERO;
                    applied = Env.ZERO;
                    overUnder = Env.ZERO;
                }
            }
            if (selected && col != 0) {
                if (discount.signum() == -openSign) {
                    discount = discount.negate();
                }
                if (writeOff.signum() == -openSign) {
                    writeOff = writeOff.negate();
                }
                if (applied.signum() == -openSign) {
                    applied = applied.negate();
                }
                if (discount.abs().compareTo(open.abs()) > 0) {
                    discount = open;
                }
                if (writeOff.abs().compareTo(open.abs()) > 0) {
                    writeOff = open;
                }
                BigDecimal newTotal = discount.add(writeOff).add(applied).add(overUnder);
                BigDecimal difference = newTotal.subtract(open);
                BigDecimal diffWOD = writeOff.add(discount).subtract(open);
                if (diffWOD.signum() == open.signum()) {
                    if (col == invoice.convertColumnIndexToView(this.invoiceDiscountIndex)) {
                        writeOff = writeOff.subtract(diffWOD);
                    } else {
                        discount = discount.subtract(diffWOD);
                    }
                    difference = difference.subtract(diffWOD);
                }
                if (col == invoice.convertColumnIndexToView(this.invoiceAppliedIndex)) {
                    overUnder = overUnder.subtract(difference);
                } else {
                    applied = applied.subtract(difference);
                }
            }
            if (isAutoWriteOff && writeOff.doubleValue() / open.doubleValue() > 0.3) {
                msg = "AllocationWriteOffWarn";
            }
            invoice.setValueAt(discount, row, invoice.convertColumnIndexToView(this.invoiceDiscountIndex));
            invoice.setValueAt(applied, row, invoice.convertColumnIndexToView(this.invoiceAppliedIndex));
            invoice.setValueAt(writeOff, row, invoice.convertColumnIndexToView(this.invoiceWriteOffIndex));
            invoice.setValueAt(overUnder, row, invoice.convertColumnIndexToView(this.invoiceOverUnderIndex));
        }
        this.calculating = false;
        return msg;
    }

    public String calculatePayment(IMiniTable payment, boolean isMultiCurrency) {
        log.config("");
        this.totalPay = new BigDecimal(0.0);
        int rows = payment.getRowCount();
        this.noPayments = 0;
        for (int i = 0; i < rows; ++i) {
            if (!payment.isRowChecked(i)) continue;
            Timestamp ts = (Timestamp)payment.getValueAt(i, payment.convertColumnIndexToView(1));
            if (!isMultiCurrency) {
                this.allocDate = TimeUtil.max(this.allocDate, ts);
            }
            BigDecimal bd = (BigDecimal)payment.getValueAt(i, payment.convertColumnIndexToView(this.paymentPaidIndex));
            this.totalPay = this.totalPay.add(bd);
            ++this.noPayments;
            log.fine("Payment_" + i + " = " + bd + " - Total=" + this.totalPay);
        }
        return String.valueOf(this.noPayments) + " - " + Msg.getMsg(Env.getCtx(), "Sum") + "  " + this.format.format(this.totalPay) + " ";
    }

    public String calculateInvoice(IMiniTable invoice, boolean isMultiCurrency) {
        this.totalInv = new BigDecimal(0.0);
        int rows = invoice.getRowCount();
        this.noInvoices = 0;
        for (int i = 0; i < rows; ++i) {
            if (!invoice.isRowChecked(i)) continue;
            Timestamp ts = (Timestamp)invoice.getValueAt(i, invoice.convertColumnIndexToView(1));
            if (!isMultiCurrency) {
                this.allocDate = TimeUtil.max(this.allocDate, ts);
            }
            BigDecimal bd = (BigDecimal)invoice.getValueAt(i, invoice.convertColumnIndexToView(this.invoiceAppliedIndex));
            this.totalInv = this.totalInv.add(bd);
            ++this.noInvoices;
            log.fine("Invoice_" + i + " = " + bd + " - Total=" + this.totalPay);
        }
        return String.valueOf(this.noInvoices) + " - " + Msg.getMsg(Env.getCtx(), "Sum") + "  " + this.format.format(this.totalInv) + " ";
    }

    public String saveData(int m_WindowNo, Object date, IMiniTable payment, IMiniTable invoice, String trxName) {
        if (this.noInvoices + this.noPayments == 0) {
            return "";
        }
        int AD_Client_ID = Env.getContextAsInt(Env.getCtx(), m_WindowNo, "AD_Client_ID");
        int orgId = this.orgWriteId;
        if (orgId == 0) {
            orgId = Env.getContextAsInt(Env.getCtx(), m_WindowNo, "AD_Org_ID");
        }
        boolean orderId = false;
        boolean cashLineId = false;
        Timestamp DateTrx = (Timestamp)date;
        if (orgId == 0) {
            throw new AdempiereException("@Org0NotAllowed@");
        }
        log.config("Client=" + AD_Client_ID + ", Org=" + orgId + ", BPartner=" + this.bPartnerId + ", Date=" + DateTrx);
        int pRows = payment.getRowCount();
        int iRows = invoice.getRowCount();
        ArrayList<Object> paymentList = new ArrayList(pRows);
        ArrayList amountList = new ArrayList(pRows);
        BigDecimal paymentAppliedAmt = Env.ZERO;
        paymentList = payment.getSelectedKeys();
        if (paymentList.size() > 1) {
            throw new AdempiereException("Se debe seleccionar un solo recibo a la vez");
        }
        MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, DateTrx, this.currencyId, Env.getContext(Env.getCtx(), "#AD_User_Name"), trxName);
        alloc.setAD_Org_ID(orgId);
        if (!Util.isEmpty(this.description)) {
            alloc.setDescription(this.description);
        }
        alloc.saveEx();
        if (paymentList.size() > 0) {
            int payReceiptId = (Integer)paymentList.get(0);
            MUYPayReceipt receipt = new MUYPayReceipt(Env.getCtx(), payReceiptId, trxName);
            this.generateAllocation(alloc, receipt, payment, invoice, DateTrx);
        }
        paymentList.clear();
        amountList.clear();
        return Msg.parseTranslation(Env.getCtx(), "@C_AllocationHdr_ID@ @Created@: " + alloc.getDocumentNo());
    }

    private void generateAllocation(MAllocationHdr alloc, MUYPayReceipt pr, IMiniTable payment, IMiniTable invoice, Timestamp date) {
        MAllocationLine aLine;
        BigDecimal amount;
        BigDecimal multiplier;
        int i;
        Object sql = "";
        BigDecimal amtReceipt = Env.ZERO;
        List<MUYPayReceiptDoc> docs = null;
        int pRows = payment.getRowCount();
        int iRows = invoice.getRowCount();
        BigDecimal pendiente = Env.ZERO;
        List<MUYPayReceiptLine> payLines = pr.getLinesGen(" order by payamt asc");
        docs = pr.isSOTrx() ? pr.getLinesDoc("DRC", "d.payamt asc") : pr.getLinesDoc("DPC", "d.payamt asc");
        for (i = 0; i < pRows; ++i) {
            if (!payment.isRowChecked(i) || (pendiente = (amtReceipt = (BigDecimal)payment.getValueAt(i, this.paymentPaidIndex))).compareTo(Env.ZERO) >= 0) continue;
            pendiente = pendiente.negate();
        }
        for (i = 0; i < iRows; ++i) {
            if (!invoice.isRowChecked(i)) continue;
            int C_Invoice_ID = ((IDColumn)invoice.getValueAt(i, invoice.getKeyColumnIndex())).getRecord_ID();
            BigDecimal AppliedAmt = (BigDecimal)invoice.getValueAt(i, this.invoiceAppliedIndex);
            BigDecimal DiscountAmt = (BigDecimal)invoice.getValueAt(i, this.invoiceDiscountIndex);
            BigDecimal WriteOffAmt = (BigDecimal)invoice.getValueAt(i, this.invoiceWriteOffIndex);
            BigDecimal OverUnderAmt = ((BigDecimal)invoice.getValueAt(i, this.invoiceOpenIndex)).subtract(AppliedAmt).subtract(DiscountAmt).subtract(WriteOffAmt);
            MAllocationLine aLine2 = new MAllocationLine(alloc, AppliedAmt, DiscountAmt, WriteOffAmt, OverUnderAmt);
            aLine2.setDocInfo(this.bPartnerId, 0, C_Invoice_ID);
            aLine2.saveEx();
        }
        for (MUYPayReceiptLine payLine : payLines) {
            MPayment cPayment;
            if (pendiente.compareTo(Env.ZERO) <= 0 || payLine.getC_Payment_ID() <= 0 || (cPayment = (MPayment)payLine.getC_Payment()).isAllocated()) continue;
            multiplier = Env.ONE;
            sql = "select currencyConvert(paymentavailable(" + cPayment.get_ID() + ")," + cPayment.getC_Currency_ID() + "," + this.currencyId + ",'" + date + "',114, " + cPayment.getAD_Client_ID() + ", " + cPayment.getAD_Org_ID() + ")";
            amount = DB.getSQLValueBDEx(alloc.get_TrxName(), (String)sql, new Object[0]);
            if (amount.compareTo(Env.ZERO) < 0) {
                amount = amount.negate();
                multiplier = multiplier.negate();
            }
            if (amount.compareTo(pendiente) > 0) {
                amount = pendiente;
            }
            aLine = new MAllocationLine(alloc, amount.multiply(multiplier), payLine.getDiscountAmt(), Env.ZERO, Env.ZERO);
            aLine.setC_Payment_ID(cPayment.get_ID());
            aLine.setC_BPartner_ID(cPayment.getC_BPartner_ID());
            aLine.saveEx();
            pendiente = pendiente.subtract(amount);
        }
        for (MUYPayReceiptDoc docLine : docs) {
            MInvoice inv;
            if (pendiente.compareTo(Env.ZERO) <= 0 || (inv = (MInvoice)docLine.getC_Invoice()).isPaid()) continue;
            multiplier = Env.ONE;
            sql = "select currencyConvert(invoiceopen(" + inv.get_ID() + ", 0)," + inv.getC_Currency_ID() + "," + this.currencyId + ",'" + date + "',114, " + inv.getAD_Client_ID() + ", " + inv.getAD_Org_ID() + ")";
            amount = DB.getSQLValueBDEx(alloc.get_TrxName(), (String)sql, new Object[0]);
            if (amount.compareTo(Env.ZERO) < 0) {
                amount = amount.negate();
                if (pr.isSOTrx()) {
                    multiplier = multiplier.negate();
                }
            }
            if (amount.compareTo(pendiente) > 0) {
                amount = pendiente;
            }
            aLine = new MAllocationLine(alloc, amount.multiply(multiplier), docLine.getDiscountAmt(), Env.ZERO, Env.ZERO);
            aLine.setDocInfo(inv.getC_BPartner_ID(), inv.getC_Order_ID(), inv.get_ID());
            aLine.setC_BPartner_ID(inv.getC_BPartner_ID());
            aLine.saveEx();
            pendiente = pendiente.subtract(amount);
        }
        if (this.chargeId > 0) {
            BigDecimal chargeAmt = this.totalDiff;
            MAllocationLine aLine3 = new MAllocationLine(alloc, chargeAmt.negate(), Env.ZERO, Env.ZERO, Env.ZERO);
            aLine3.set_CustomColumn("C_Charge_ID", this.chargeId);
            aLine3.setC_BPartner_ID(this.bPartnerId);
            aLine3.saveEx(alloc.get_TrxName());
        }
        if (alloc.get_ID() != 0) {
            if (!alloc.processIt("CO")) {
                throw new AdempiereException("@ProcessFailed@: " + alloc.getProcessMsg());
            }
            alloc.saveEx();
        }
        for (int i2 = 0; i2 < iRows; ++i2) {
            if (!invoice.isRowChecked(i2)) continue;
            int C_Invoice_ID = ((IDColumn)invoice.getValueAt(i2, invoice.getKeyColumnIndex())).getRecord_ID();
            Object sql2 = "SELECT invoiceOpen(C_Invoice_ID, 0) FROM C_Invoice WHERE C_Invoice_ID=?";
            BigDecimal open = DB.getSQLValueBD(alloc.get_TrxName(), (String)sql2, C_Invoice_ID);
            if (open != null && open.signum() == 0) {
                sql2 = "UPDATE C_Invoice SET IsPaid='Y' WHERE C_Invoice_ID=" + C_Invoice_ID;
                int no = DB.executeUpdate((String)sql2, alloc.get_TrxName());
                log.config("Invoice #" + i2 + " is paid - updated=" + no);
                continue;
            }
            log.config("Invoice #" + i2 + " is not paid - " + open);
        }
        for (MUYPayReceiptDoc docLine : docs) {
            int C_Invoice_ID = docLine.getC_Invoice_ID();
            Object sql2 = "SELECT invoiceOpen(C_Invoice_ID, 0) FROM C_Invoice WHERE C_Invoice_ID=?";
            BigDecimal open = DB.getSQLValueBD(alloc.get_TrxName(), (String)sql2, C_Invoice_ID);
            if (open == null || open.signum() != 0) continue;
            sql2 = "UPDATE C_Invoice SET IsPaid='Y' WHERE C_Invoice_ID=" + C_Invoice_ID;
            int n = DB.executeUpdate((String)sql2, alloc.get_TrxName());
        }
        for (MUYPayReceiptLine payLine : payLines) {
            if (payLine.getC_Payment_ID() <= 0) continue;
            int paymentId = payLine.getC_Payment_ID();
            MPayment pay = new MPayment(Env.getCtx(), paymentId, alloc.get_TrxName());
            if (!pay.testAllocation()) continue;
            pay.saveEx();
        }
    }
}

