/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.BufferedImage;
import javax.swing.Box;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.compiere.apps.AEnv;
import org.compiere.apps.AMenu;
import org.compiere.apps.WindowManager;
import org.compiere.swing.CFrame;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.jdesktop.swingx.JXButton;
import org.jdesktop.swingx.JXImageView;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.painter.Painter;

public class WindowMenu
extends JMenu {
    private static final long serialVersionUID = 381665816099431316L;
    private WindowManager windowManager;
    private JFrame frame;
    private JMenuItem closeAll = new JMenuItem("Close All Windows");
    private JMenuItem closeOthers = new JMenuItem("Close Other Windows");
    private JMenuItem expose = new JMenuItem("Show All");
    private JXTitledPanel firstBox;

    private void setEnvText(JMenu menu, String msg) {
        char ch;
        Object text = Msg.getMsg(Env.getCtx(), msg);
        int pos = ((String)text).indexOf(38);
        if (pos != -1 && ((String)text).length() > pos && (ch = ((String)text).toUpperCase().charAt(pos + 1)) != ' ') {
            text = ((String)text).substring(0, pos) + ((String)text).substring(pos + 1);
            menu.setMnemonic(ch);
        }
        menu.setText((String)text);
    }

    private void setEnvText(JMenuItem menu, String msg) {
        char ch;
        Object text = Msg.getMsg(Env.getCtx(), msg);
        int pos = ((String)text).indexOf(38);
        if (pos != -1 && ((String)text).length() > pos && (ch = ((String)text).toUpperCase().charAt(pos + 1)) != ' ') {
            text = ((String)text).substring(0, pos) + ((String)text).substring(pos + 1);
            menu.setMnemonic(ch);
        }
        menu.setText((String)text);
    }

    public WindowMenu(WindowManager windowManager, JFrame frame) {
        this.windowManager = windowManager;
        this.frame = frame;
        this.setEnvText(this, "Window");
        this.closeAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.windowManager.close();
            }
        });
        this.setEnvText(this.closeAll, "CloseAllWindows");
        this.closeOthers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                WindowMenu.this.windowManager.closeOthers((CFrame)WindowMenu.this.frame);
            }
        });
        this.expose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WindowMenu.this.expose();
                    }
                });
            }
        });
        this.setEnvText(this.expose, "ShowAllWindow");
        this.expose.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.setEnvText(this.closeOthers, "CloseOtherWindows");
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent e) {
            }

            @Override
            public void menuDeselected(MenuEvent e) {
                WindowMenu.this.removeAll();
            }

            @Override
            public void menuSelected(MenuEvent e) {
                WindowMenu.this.buildChildMenus();
            }
        });
    }

    private JXPanel createSelectionPanel() {
        GridLayout l = new GridLayout(3, 3);
        l.setHgap(5);
        l.setVgap(5);
        JXPanel p2 = new JXPanel();
        p2.setLayout((LayoutManager)l);
        return p2;
    }

    public void expose() {
        final JDialog dialog = new JDialog();
        dialog.setSize(Toolkit.getDefaultToolkit().getScreenSize());
        dialog.setUndecorated(true);
        dialog.setModal(true);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                dialog.setVisible(false);
            }
        };
        JRootPane jr = dialog.getRootPane();
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        jr.registerKeyboardAction(actionListener, stroke, 2);
        SwingUtilities.invokeLater(new Loader(dialog));
        dialog.setCursor(Cursor.getPredefinedCursor(3));
        dialog.setVisible(true);
    }

    private JXTitledPanel createImageBox(JPanel p2, JDialog dialog, int width, int height, CFrame window) {
        BufferedImage bi = new BufferedImage(window.getWidth(), window.getHeight(), 1);
        window.paintAll(bi.createGraphics());
        Image image = bi.getScaledInstance(width, height, 4);
        final JXTitledPanel box = new JXTitledPanel();
        final Painter painter = box.getTitlePainter();
        box.setTitlePainter(null);
        box.setFocusable(true);
        box.setTitle(window.getTitle());
        JXImageView imageView = new JXImageView();
        imageView.setImage(image);
        imageView.setEditable(false);
        box.setContentContainer((Container)imageView);
        box.setPreferredSize(new Dimension(width, height));
        box.setCursor(Cursor.getPredefinedCursor(12));
        box.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                box.requestFocus();
            }
        });
        imageView.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                box.requestFocus();
            }
        });
        PreviewMouseAdapter adapter = new PreviewMouseAdapter(dialog, window);
        box.addMouseListener((MouseListener)adapter);
        imageView.addMouseListener((MouseListener)adapter);
        imageView.setCursor(Cursor.getPredefinedCursor(12));
        box.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                box.setTitlePainter(painter);
            }

            @Override
            public void focusLost(FocusEvent e) {
                box.setTitlePainter(null);
            }
        });
        return box;
    }

    private void buildChildMenus() {
        ChildMenuItem menu;
        JFrame frame;
        this.removeAll();
        CFrame[] array = this.windowManager.getWindows();
        this.add(this.expose);
        if (!(this.frame instanceof AMenu)) {
            this.add(this.closeOthers);
        }
        this.add(this.closeAll);
        if (array.length > 0) {
            this.expose.setEnabled(true);
            this.closeAll.setEnabled(true);
            if (array.length > 1) {
                this.closeOthers.setEnabled(true);
            } else {
                this.closeOthers.setEnabled(false);
            }
            this.addSeparator();
        } else {
            this.closeAll.setEnabled(false);
            this.closeOthers.setEnabled(false);
            this.expose.setEnabled(false);
        }
        if (!(this.frame instanceof AMenu) && (frame = Env.getWindow(0)) != null && frame instanceof AMenu) {
            menu = new ChildMenuItem((AMenu)frame);
            menu.setState(false);
            menu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CFrame frame = ((ChildMenuItem)ae.getSource()).getWindow();
                    AEnv.showWindow(frame);
                }
            });
            this.add(menu);
            this.addSeparator();
        }
        for (int i = 0; i < array.length; ++i) {
            menu = new ChildMenuItem(array[i]);
            menu.setState(array[i].equals(this.frame));
            menu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    CFrame frame = ((ChildMenuItem)ae.getSource()).getWindow();
                    AEnv.showWindow(frame);
                }
            });
            this.add(menu);
        }
    }

    class PreviewMouseAdapter
    extends MouseAdapter {
        private JDialog dialog;
        private Window window;

        PreviewMouseAdapter(JDialog d, Window w) {
            this.dialog = d;
            this.window = w;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.dialog.dispose();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AEnv.showWindow(PreviewMouseAdapter.this.window);
                }
            });
        }
    }

    class Loader
    implements Runnable {
        private JDialog dialog;

        Loader(JDialog d) {
            this.dialog = d;
        }

        @Override
        public void run() {
            int i;
            CFrame[] w = WindowMenu.this.windowManager.getWindows();
            Container dialogContent = this.dialog.getContentPane();
            dialogContent.setLayout(new BorderLayout());
            final CardLayout card = new CardLayout();
            final JXPanel cardContainer = new JXPanel((LayoutManager)card);
            dialogContent.add((Component)cardContainer, "Center");
            JXPanel p2 = WindowMenu.this.createSelectionPanel();
            cardContainer.add((Component)p2, (Object)"page1");
            Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
            int width = (s.width - 30) / 3;
            int height = (s.height - 30) / 3;
            int count = 0;
            JFrame frame = Env.getWindow(0);
            if (frame != null && frame instanceof AMenu) {
                JXTitledPanel box = WindowMenu.this.createImageBox((JPanel)p2, this.dialog, width, height, (CFrame)frame);
                p2.add((Component)box);
                ++count;
                WindowMenu.this.firstBox = box;
            }
            int page = 1;
            for (i = 0; i < w.length; ++i) {
                ++count;
                CFrame window = w[i];
                JXTitledPanel box = WindowMenu.this.createImageBox((JPanel)p2, this.dialog, width, height, window);
                p2.add((Component)box);
                if (i == 0 && WindowMenu.this.firstBox == null) {
                    WindowMenu.this.firstBox = box;
                }
                if (count != 9) continue;
                count = 0;
                p2 = WindowMenu.this.createSelectionPanel();
                cardContainer.add((Component)p2, (Object)("page" + ++page));
            }
            for (i = count; i < 9; ++i) {
                p2.add(Box.createGlue());
            }
            this.dialog.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    if (WindowMenu.this.firstBox != null) {
                        WindowMenu.this.firstBox.requestFocus();
                    }
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                }
            });
            card.first((Container)cardContainer);
            if (page > 1) {
                JXPanel ctrl = new JXPanel();
                JXButton previous = new JXButton("<");
                JXButton next = new JXButton(">");
                previous.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        card.previous((Container)cardContainer);
                    }
                });
                next.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        card.next((Container)cardContainer);
                    }
                });
                ctrl.add((Component)previous);
                ctrl.add((Component)next);
                dialogContent.add((Component)ctrl, "North");
            }
            this.dialog.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    class ChildMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 2258141282389818588L;
        private CFrame window;

        public ChildMenuItem(CFrame window) {
            super(window.getTitle());
            this.window = window;
        }

        public CFrame getWindow() {
            return this.window;
        }
    }
}

