/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Frame;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.apps.AEnv;
import org.compiere.apps.IProcessDialog;
import org.compiere.apps.PrintScreenPainter;
import org.compiere.apps.ProcessDialog;
import org.compiere.apps.ProcessPanel;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CDialog;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ProcessModalDialog
extends CDialog
implements IProcessDialog,
ASyncProcess {
    private static final long serialVersionUID = 6613814452809135635L;
    private ASyncProcess aSyncProcess;
    private int windowNo;
    private boolean isValid = true;
    private boolean isOnlyPanel;
    private boolean autoStart;
    private static CLogger log = CLogger.getCLogger(ProcessDialog.class);
    private ProcessPanel processPanel = null;
    private ProcessInfo processInfo;

    public ProcessModalDialog(Properties ctx, Frame parent, String title, ASyncProcess aProcess, int WindowNo, int AD_Process_ID, int tableId, int recordId, boolean autoStart) {
        this(ctx, parent, title, aProcess, WindowNo, AD_Process_ID, tableId, recordId, autoStart, null, false);
    }

    private ProcessModalDialog(Properties ctx, Frame parent, String title, ASyncProcess aProcess, int WindowNo, int processId, int tableId, int recordId, boolean autoStart, ProcessInfo pi, boolean isOnlyPanel) {
        super(parent, title, true);
        log.info("Process=" + processId);
        this.isOnlyPanel = isOnlyPanel;
        this.autoStart = autoStart;
        if (pi == null) {
            this.aSyncProcess = aProcess;
            this.processInfo = new ProcessInfo(title, processId, tableId, recordId);
        } else {
            this.processInfo = pi;
        }
        this.windowNo = WindowNo;
        try {
            this.jbInit();
            this.init();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
    }

    public ProcessModalDialog(Frame frame, int WindowNo, ProcessInfo pi) {
        this(Env.getCtx(), frame, pi.getTitle(), null, WindowNo, pi.getAD_Process_ID(), pi.getTable_ID(), pi.getRecord_ID(), false, pi, true);
    }

    private void jbInit() throws Exception {
        this.setIconImage(Env.getImage("mProcess.gif"));
    }

    @Override
    public void dispose() {
        this.isValid = false;
        this.processPanel.restoreContext();
        super.dispose();
    }

    public boolean isValidDialog() {
        return this.isValid;
    }

    private boolean init() {
        log.config("");
        this.processInfo.setAD_User_ID(Env.getAD_User_ID(Env.getCtx()));
        this.processInfo.setAD_Client_ID(Env.getAD_Client_ID(Env.getCtx()));
        this.processInfo.setInterfaceType(ProcessInfo.INTERFACE_TYPE_SWING);
        this.processPanel = new ProcessPanel(this, this.windowNo, this.processInfo, 1);
        this.processPanel.setAutoStart(this.autoStart);
        this.processPanel.setIsOnlyPanel(this.isOnlyPanel);
        this.processPanel.createFieldsAndEditors();
        this.getContentPane().add(this.processPanel.getPanel());
        this.setTitle(this.processPanel.getName());
        this.validateScreen();
        return true;
    }

    public boolean isOK() {
        return this.processPanel.isOkPressed();
    }

    @Override
    public void printScreen() {
        PrintScreenPainter.printScreen(this);
    }

    @Override
    public void validateScreen() {
        this.validate();
        this.getRootPane().setDefaultButton(this.processPanel.getDefaultButton());
    }

    @Override
    public void showCenterScreen() {
        AEnv.showCenterScreen(this);
    }

    @Override
    public ASyncProcess getParentProcess() {
        return this;
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public Object getParentContainer() {
        return this;
    }

    public boolean isAutoStart() {
        return this.processPanel.isAutoStart();
    }

    @Override
    public void lockUI(ProcessInfo pi) {
        if (this.aSyncProcess != null) {
            this.aSyncProcess.lockUI(pi);
        }
    }

    @Override
    public void unlockUI(ProcessInfo pi) {
        if (this.aSyncProcess != null) {
            this.aSyncProcess.unlockUI(pi);
        }
        this.processPanel.openResult();
    }

    @Override
    public boolean isUILocked() {
        if (this.aSyncProcess != null) {
            return this.aSyncProcess.isUILocked();
        }
        return false;
    }

    @Override
    public void executeASync(ProcessInfo pi) {
        if (this.aSyncProcess != null) {
            this.aSyncProcess.executeASync(pi);
        }
    }
}

