/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.GraphicsConfiguration;
import java.util.logging.Level;
import org.compiere.apps.AEnv;
import org.compiere.apps.IProcessDialog;
import org.compiere.apps.PrintScreenPainter;
import org.compiere.apps.ProcessPanel;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CFrame;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ProcessDialog
extends CFrame
implements IProcessDialog,
ASyncProcess {
    private static final long serialVersionUID = 790447068287846414L;
    private int processId;
    private int windowNo;
    private static CLogger log = CLogger.getCLogger(ProcessDialog.class);
    private ProcessPanel parameterPanel = null;

    public ProcessDialog(GraphicsConfiguration gc, int AD_Process_ID, boolean isSOTrx) {
        super(gc);
        log.info("Process=" + AD_Process_ID + "; SOTrx=" + isSOTrx);
        this.enableEvents(64L);
        this.processId = AD_Process_ID;
        this.windowNo = Env.createWindowNo(this);
        Env.setContext(Env.getCtx(), this.windowNo, "IsSOTrx", isSOTrx ? "Y" : "N");
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", ex);
        }
    }

    private void jbInit() throws Exception {
        this.setIconImage(Env.getImage("mProcess.gif"));
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.parameterPanel.getPanel().requestFocus();
        }
    }

    @Override
    public void dispose() {
        Env.clearWinContext(this.windowNo);
        super.dispose();
    }

    public boolean init() {
        log.config("");
        ProcessInfo pi = new ProcessInfo(null, this.processId);
        pi.setAD_User_ID(Env.getAD_User_ID(Env.getCtx()));
        pi.setAD_Client_ID(Env.getAD_Client_ID(Env.getCtx()));
        pi.setInterfaceType(ProcessInfo.INTERFACE_TYPE_SWING);
        this.parameterPanel = new ProcessPanel(this, this.windowNo, pi, 1);
        this.parameterPanel.createFieldsAndEditors();
        this.getContentPane().add(this.parameterPanel.getPanel());
        this.setTitle(this.parameterPanel.getName());
        this.validateScreen();
        return true;
    }

    @Override
    public void printScreen() {
        PrintScreenPainter.printScreen(this);
    }

    @Override
    public void validateScreen() {
        this.validate();
        this.getRootPane().setDefaultButton(this.parameterPanel.getDefaultButton());
    }

    @Override
    public void showCenterScreen() {
        AEnv.showCenterScreen(this);
    }

    @Override
    public void lockUI(ProcessInfo pi) {
        this.parameterPanel.lockUI(pi);
    }

    @Override
    public void unlockUI(ProcessInfo pi) {
        this.parameterPanel.unlockUI(pi);
    }

    @Override
    public boolean isUILocked() {
        return this.parameterPanel.isUILocked();
    }

    @Override
    public void executeASync(ProcessInfo pi) {
        this.parameterPanel.executeASync(pi);
    }

    @Override
    public Object getParentContainer() {
        return this;
    }

    @Override
    public boolean isEmbedded() {
        return false;
    }

    @Override
    public ASyncProcess getParentProcess() {
        return this;
    }
}

