/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBankAccount;
import org.compiere.model.MCharge;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MPayment;
import org.compiere.model.MSysConfig;
import org.compiere.util.Env;

public class Doc_Payment
extends Doc {
    private String tenderType = null;
    private boolean prepayment = false;
    private boolean unidentified = false;
    private int bankAccountId = 0;

    public Doc_Payment(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MPayment.class, rs, null, trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        MPayment pay = (MPayment)this.getPO();
        this.setDateDoc(pay.getDateTrx());
        this.tenderType = pay.getTenderType();
        this.prepayment = pay.isPrepayment();
        this.unidentified = pay.isUnidentifiedPayment();
        this.bankAccountId = pay.getC_BankAccount_ID();
        this.setAmount(0, pay.getPayAmt());
        return null;
    }

    @Override
    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact(this, as, "A");
        if ("X".equals(this.tenderType) && !MSysConfig.getBooleanValue("CASH_AS_PAYMENT", true, this.getAD_Client_ID())) {
            ArrayList<Fact> facts = new ArrayList<Fact>();
            facts.add(fact);
            return facts;
        }
        MClient client = new MClient(this.getCtx(), this.getAD_Client_ID(), null);
        MAcctSchema schema = client.getAcctSchema();
        BigDecimal rate = Env.ZERO;
        MPayment hdr = (MPayment)this.getPO();
        int AD_Org_ID = this.getBank_Org_ID();
        if (this.getDocumentType().equals("ARR") || this.getDocumentType().equals("DRR")) {
            if (hdr.getC_ConversionType_ID() > 0 && hdr.getC_ConversionType_ID() == 201 && hdr.getC_Currency_ID() != schema.getC_Currency_ID() && ((rate = MConversionRate.getRate(hdr.getC_Currency_ID(), schema.getC_Currency_ID(), this.getDateDoc(), 201, Env.getAD_Client_ID(this.getCtx()), Env.getAD_Org_ID(this.getCtx()))) == null || rate.compareTo(Env.ZERO) == 0)) {
                throw new AdempiereException("No se encuentra tasa de cambio Company para la fecha y moneda del documento");
            }
            FactLine fl = fact.createLine(null, this.getAccount(11, as), this.getC_Currency_ID(), this.getAmount(), null);
            if (fl != null && AD_Org_ID != 0) {
                fl.setAD_Org_ID(AD_Org_ID);
            }
            MAccount acct = null;
            acct = this.getC_Charge_ID() != 0 ? MCharge.getAccount(this.getC_Charge_ID(), as, this.getAmount()) : (this.prepayment ? this.getAccount(13, as) : (this.unidentified ? this.getAccount(15, as) : this.getAccount(10, as)));
            fl = fact.createLine(null, acct, this.getC_Currency_ID(), null, this.getAmount());
            if (fl != null && AD_Org_ID != 0 && this.getC_Charge_ID() == 0) {
                fl.setAD_Org_ID(AD_Org_ID);
            }
        } else if (this.getDocumentType().equals("APP") || this.getDocumentType().equals("DRP")) {
            MAccount acct = null;
            acct = this.getC_Charge_ID() != 0 ? MCharge.getAccount(this.getC_Charge_ID(), as, this.getAmount()) : (this.prepayment ? this.getAccount(14, as) : (this.unidentified ? this.getAccount(15, as) : this.getAccount(12, as)));
            FactLine fl = fact.createLine(null, acct, this.getC_Currency_ID(), this.getAmount(), null);
            if (fl != null && AD_Org_ID != 0 && this.getC_Charge_ID() == 0) {
                fl.setAD_Org_ID(AD_Org_ID);
            }
            if ((fl = fact.createLine(null, this.getAccount(11, as), this.getC_Currency_ID(), null, this.getAmount())) != null && AD_Org_ID != 0) {
                fl.setAD_Org_ID(AD_Org_ID);
            }
        } else {
            this.p_Error = "DocumentType unknown: " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            fact = null;
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    private int getBank_Org_ID() {
        if (this.bankAccountId == 0) {
            return 0;
        }
        MBankAccount ba = MBankAccount.get(this.getCtx(), this.bankAccountId);
        return ba.getAD_Org_ID();
    }
}

