/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.compiere.acct.Doc;
import org.compiere.acct.Doc_Order;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MCostType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.ProductCost;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_MatchInv
extends Doc {
    private MInvoiceLine m_invoiceLine = null;
    private MInOutLine m_receiptLine = null;
    private MOrderLine m_orderLine = null;
    private ProductCost m_pc = null;

    public Doc_MatchInv(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MMatchInv.class, rs, "MXI", trxName);
    }

    @Override
    protected String loadDocumentDetails() {
        this.setC_Currency_ID(-2);
        MMatchInv matchInv = (MMatchInv)this.getPO();
        this.setDateDoc(matchInv.getDateTrx());
        this.setQty(matchInv.getQty());
        int C_InvoiceLine_ID = matchInv.getC_InvoiceLine_ID();
        this.m_invoiceLine = new MInvoiceLine(this.getCtx(), C_InvoiceLine_ID, this.getTrxName());
        int C_BPartner_ID = this.m_invoiceLine.getParent().getC_BPartner_ID();
        this.setC_BPartner_ID(C_BPartner_ID);
        int M_InOutLine_ID = matchInv.getM_InOutLine_ID();
        this.m_receiptLine = new MInOutLine(this.getCtx(), M_InOutLine_ID, this.getTrxName());
        if (this.m_receiptLine != null) {
            this.m_orderLine = (MOrderLine)this.m_receiptLine.getC_OrderLine();
        }
        this.m_pc = new ProductCost(Env.getCtx(), this.getM_Product_ID(), matchInv.getM_AttributeSetInstance_ID(), this.getTrxName());
        this.m_pc.setQty(this.getQty());
        return null;
    }

    @Override
    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        BigDecimal credit;
        BigDecimal debit;
        ArrayList<Fact> facts = new ArrayList<Fact>();
        if (this.getM_Product_ID() == 0 || this.getQty().signum() == 0 || this.m_receiptLine.getMovementQty().signum() == 0) {
            this.log.fine("No Product/Qty - M_Product_ID=" + this.getM_Product_ID() + ",Qty=" + this.getQty() + ",InOutQty=" + this.m_receiptLine.getMovementQty());
            return facts;
        }
        MCostType ct = MCostType.get(as, this.getM_Product_ID(), this.getAD_Org_ID());
        Fact fact = new Fact(this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        boolean isInterOrg = this.isInterOrg(as);
        MInvoice invoice = this.m_invoiceLine.getParent();
        boolean isSOTrx = invoice.isSOTrx();
        MProduct prodMatch = new MProduct(this.getCtx(), this.getM_Product_ID(), this.getTrxName());
        BigDecimal multiplier = this.getQty().divide(this.m_receiptLine.getMovementQty(), 12, 4).abs();
        int accountID = 0;
        MAccount account = null;
        if (isSOTrx) {
            MInOut inout = (MInOut)this.m_receiptLine.getM_InOut();
            MBPartner partner = (MBPartner)inout.getC_BPartner();
            accountID = DB.getSQLValueEx(this.getTrxName(), "select NotInvoicedReceivables_Acct from c_bp_group_acct where c_bp_group_id = " + partner.getC_BP_Group_ID() + " and ad_client_id = " + this.getAD_Client_ID(), new Object[0]);
            account = MAccount.get(this.getCtx(), accountID);
        } else {
            account = this.getAccount(51, as);
        }
        FactLine dr = fact.createLine(null, account, as.getC_Currency_ID(), Env.ONE, null);
        if (dr == null) {
            this.p_Error = "No Product Costs";
            return null;
        }
        dr.setM_Product_ID(this.m_receiptLine.getM_Product_ID());
        String documentBaseTypeReceipt = DB.getSQLValueString(this.m_receiptLine.get_TrxName(), "SELECT DocBaseType FROM C_DocType WHERE C_DocType_ID=?", this.m_receiptLine.getParent().getC_DocType_ID());
        BigDecimal quantityReceipt = "MMR".equals(documentBaseTypeReceipt) ? this.getQty() : this.getQty().negate();
        dr.setQty(quantityReceipt);
        BigDecimal temp = dr.getAcctBalance();
        if (!dr.updateReverseLine(MInOut.Table_ID, this.m_receiptLine.getM_InOut_ID(), this.m_receiptLine.getM_InOutLine_ID(), quantityReceipt, multiplier)) {
            if (this.m_receiptLine.getM_InOut().isPosted()) {
                dr.setAmtAcctCr(Env.ZERO);
                dr.setAmtAcctDr(Env.ZERO);
                dr.setAmtSourceCr(Env.ZERO);
                dr.setAmtSourceDr(Env.ZERO);
                dr.setQty(quantityReceipt);
            } else {
                this.p_Error = "Mat.Receipt not posted yet";
                return null;
            }
        }
        this.log.fine("CR - Amt(" + temp + "->" + dr.getAcctBalance() + ") - " + dr.toString());
        MAccount expense = this.m_pc.getAccount(10, as);
        BigDecimal LineNetAmt = this.m_invoiceLine.getLineNetAmt();
        MUOM uom = (MUOM)prodMatch.getC_UOM();
        if (!uom.getUOMSymbol().equalsIgnoreCase("AMT")) {
            multiplier = this.getQty().divide(this.m_invoiceLine.getQtyInvoiced(), 12, 4).abs();
            if (multiplier.compareTo(Env.ONE) != 0) {
                LineNetAmt = LineNetAmt.multiply(multiplier);
            }
        } else {
            LineNetAmt = this.getQty().multiply(this.m_orderLine.getPriceEntered());
        }
        FactLine cr = null;
        if (as.isAccrual()) {
            cr = fact.createLine(null, expense, as.getC_Currency_ID(), null, LineNetAmt);
            if (cr == null) {
                this.log.fine("Line Net Amt=0 - M_Product_ID=" + this.getM_Product_ID() + ",Qty=" + this.getQty() + ",InOutQty=" + this.m_receiptLine.getMovementQty());
                BigDecimal ipv = dr.getSourceBalance().negate();
                if (ipv.signum() != 0) {
                    BigDecimal costs = MCostDetail.getByDocLineMatchInv(this.m_invoiceLine, this.m_receiptLine, as.getC_AcctSchema_ID(), as.getM_CostType_ID());
                    int ACCTTYPE_P = 0;
                    ACCTTYPE_P = "S".equals(ct.getCostingMethod()) || "I".equals(ct.getCostingMethod()) ? 6 : 3;
                    BigDecimal diff = ipv.subtract(costs);
                    MInvoice m_invoice = this.m_invoiceLine.getParent();
                    int C_Currency_ID = m_invoice.getC_Currency_ID();
                    FactLine pv = fact.createLine(null, this.m_pc.getAccount(ACCTTYPE_P, as), C_Currency_ID, ipv);
                    pv.setC_Activity_ID(this.m_invoiceLine.getC_Activity_ID());
                    pv.setC_Campaign_ID(this.m_invoiceLine.getC_Campaign_ID());
                    pv.setC_Project_ID(this.m_invoiceLine.getC_Project_ID());
                    pv.setC_ProjectPhase_ID(this.m_invoiceLine.getC_ProjectPhase_ID());
                    pv.setC_ProjectTask_ID(this.m_invoiceLine.getC_ProjectTask_ID());
                    pv.setC_UOM_ID(this.m_invoiceLine.getC_UOM_ID());
                    pv.setUser1_ID(this.m_invoiceLine.getUser1_ID());
                    pv.setUser2_ID(this.m_invoiceLine.getUser2_ID());
                    pv.setUser3_ID(this.m_invoiceLine.getUser3_ID());
                    pv.setUser4_ID(this.m_invoiceLine.getUser4_ID());
                    if (diff.compareTo(Env.ZERO) != 0 && "I".equals(ct.getCostingMethod())) {
                        FactLine diffline = fact.createLine(null, this.m_pc.getAccount(9, as), C_Currency_ID, diff.negate());
                        diffline.setC_Activity_ID(this.m_invoiceLine.getC_Activity_ID());
                        diffline.setC_Project_ID(this.m_invoiceLine.getC_Project_ID());
                        diffline.setC_ProjectPhase_ID(this.m_invoiceLine.getC_ProjectPhase_ID());
                        diffline.setC_ProjectTask_ID(this.m_invoiceLine.getC_ProjectTask_ID());
                        diffline.setC_UOM_ID(this.m_invoiceLine.getC_UOM_ID());
                        diffline.setUser1_ID(this.m_invoiceLine.getUser1_ID());
                        diffline.setUser2_ID(this.m_invoiceLine.getUser2_ID());
                        diffline.setUser3_ID(this.m_invoiceLine.getUser3_ID());
                        diffline.setUser4_ID(this.m_invoiceLine.getUser4_ID());
                        diffline.setQty(Env.ZERO);
                    }
                }
                this.log.fine("IPV=" + ipv + "; Balance=" + fact.getSourceBalance());
                facts.add(fact);
                return facts;
            }
            cr.setM_Product_ID(this.m_invoiceLine.getM_Product_ID());
            temp = cr.getAcctBalance();
            String documentBaseTypeInvoice = DB.getSQLValueString(this.m_invoiceLine.get_TrxName(), "SELECT DocBaseType FROM C_DocType WHERE C_DocType_ID=?", this.m_invoiceLine.getParent().getC_DocType_ID());
            BigDecimal quantityInvoice = "API".equals(documentBaseTypeInvoice) ? this.getQty().negate() : this.getQty();
            cr.setQty(quantityInvoice);
            if (this.m_pc.isService()) {
                if (isSOTrx) {
                    accountID = DB.getSQLValueEx(this.getTrxName(), "select ConciliationServDelivered_Acct from m_product_acct where m_product_id = " + this.m_invoiceLine.getM_Product_ID() + " and ad_client_id = " + this.getAD_Client_ID(), new Object[0]);
                    account = MAccount.get(this.getCtx(), accountID);
                    cr.setAccount(as, account);
                } else {
                    accountID = DB.getSQLValueEx(this.getTrxName(), "select ConciliationServReceived_Acct from m_product_acct where m_product_id = " + this.m_invoiceLine.getM_Product_ID() + " and ad_client_id = " + this.getAD_Client_ID(), new Object[0]);
                    account = MAccount.get(this.getCtx(), accountID);
                    cr.setAccount(as, account);
                }
            }
            if (as.isAccrual() && !cr.updateReverseLineMatchInv(MInvoice.Table_ID, this.m_invoiceLine.getC_Invoice_ID(), this.m_invoiceLine.getC_InvoiceLine_ID(), quantityInvoice, multiplier, prodMatch, LineNetAmt)) {
                this.p_Error = "Invoice not posted yet";
                return null;
            }
            this.log.fine("DR - Amt(" + temp + "->" + cr.getAcctBalance() + ") - " + cr.toString());
        } else {
            if (as.getC_Currency_ID() != invoice.getC_Currency_ID()) {
                LineNetAmt = MConversionRate.convert(this.getCtx(), LineNetAmt, invoice.getC_Currency_ID(), as.getC_Currency_ID(), invoice.getDateAcct(), invoice.getC_ConversionType_ID(), invoice.getAD_Client_ID(), invoice.getAD_Org_ID());
            }
            cr = fact.createLine(null, expense, as.getC_Currency_ID(), null, LineNetAmt);
            cr.setQty(this.getQty().multiply(multiplier).negate());
        }
        cr.setC_Activity_ID(this.m_invoiceLine.getC_Activity_ID());
        cr.setC_Campaign_ID(this.m_invoiceLine.getC_Campaign_ID());
        cr.setC_Project_ID(this.m_invoiceLine.getC_Project_ID());
        cr.setC_ProjectPhase_ID(this.m_invoiceLine.getC_ProjectPhase_ID());
        cr.setC_ProjectTask_ID(this.m_invoiceLine.getC_ProjectTask_ID());
        cr.setC_UOM_ID(this.m_invoiceLine.getC_UOM_ID());
        cr.setUser1_ID(this.m_invoiceLine.getUser1_ID());
        cr.setUser2_ID(this.m_invoiceLine.getUser2_ID());
        cr.setUser3_ID(this.m_invoiceLine.getUser3_ID());
        cr.setUser4_ID(this.m_invoiceLine.getUser4_ID());
        if (dr.getC_Currency_ID() != cr.getC_Currency_ID()) {
            this.setIsMultiCurrency(true);
        }
        MAccount acct_db = dr.getAccount();
        MAccount acct_cr = cr.getAccount();
        if (!as.isPostIfClearingEqual() && acct_db.equals(acct_cr) && !isInterOrg && (debit = dr.getAmtSourceDr()).compareTo(credit = cr.getAmtSourceCr()) == 0) {
            fact.remove(dr);
            fact.remove(cr);
        }
        BigDecimal ipv = cr.getAcctBalance().add(dr.getAcctBalance()).negate();
        BigDecimal ipvSource = cr.getSourceBalance().add(dr.getSourceBalance()).negate();
        if (ipv.compareTo(Env.ZERO) == 0) {
            facts.add(fact);
            return facts;
        }
        if (!"I".equals(ct.getCostingMethod())) {
            int ACCTTYPE_P = 0;
            ACCTTYPE_P = "S".equals(ct.getCostingMethod()) || "I".equals(ct.getCostingMethod()) ? 6 : 3;
            FactLine pv = fact.createLine(null, this.m_pc.getAccount(ACCTTYPE_P, as), as.getC_Currency_ID(), ipv);
            pv.setC_Activity_ID(this.m_invoiceLine.getC_Activity_ID());
            pv.setC_Campaign_ID(this.m_invoiceLine.getC_Campaign_ID());
            pv.setC_Project_ID(this.m_invoiceLine.getC_Project_ID());
            pv.setC_ProjectPhase_ID(this.m_invoiceLine.getC_ProjectPhase_ID());
            pv.setC_ProjectTask_ID(this.m_invoiceLine.getC_ProjectTask_ID());
            pv.setC_UOM_ID(this.m_invoiceLine.getC_UOM_ID());
            pv.setUser1_ID(this.m_invoiceLine.getUser1_ID());
            pv.setUser2_ID(this.m_invoiceLine.getUser2_ID());
            pv.setUser3_ID(this.m_invoiceLine.getUser3_ID());
            pv.setUser4_ID(this.m_invoiceLine.getUser4_ID());
        } else {
            MProduct prod = (MProduct)this.m_receiptLine.getM_Product();
            if (!prod.isService()) {
                FactLine diffline;
                BigDecimal costs = MCostDetail.getByDocLineMatchInv(this.m_invoiceLine, this.m_receiptLine, as.getC_AcctSchema_ID(), as.getM_CostType_ID());
                FactLine pv = fact.createLine(null, this.m_pc.getAccount(3, as), as.getC_Currency_ID(), costs);
                if (pv != null) {
                    pv.setC_Activity_ID(this.m_invoiceLine.getC_Activity_ID());
                    pv.setC_Campaign_ID(this.m_invoiceLine.getC_Campaign_ID());
                    pv.setC_Project_ID(this.m_invoiceLine.getC_Project_ID());
                    pv.setC_ProjectPhase_ID(this.m_invoiceLine.getC_ProjectPhase_ID());
                    pv.setC_ProjectTask_ID(this.m_invoiceLine.getC_ProjectTask_ID());
                    pv.setC_UOM_ID(this.m_invoiceLine.getC_UOM_ID());
                    pv.setUser1_ID(this.m_invoiceLine.getUser1_ID());
                    pv.setUser2_ID(this.m_invoiceLine.getUser2_ID());
                    pv.setUser3_ID(this.m_invoiceLine.getUser3_ID());
                    pv.setUser4_ID(this.m_invoiceLine.getUser4_ID());
                    pv.setQty(Env.ZERO);
                }
                BigDecimal diff = ipv.subtract(costs);
                MInvoice m_invoice = this.m_invoiceLine.getParent();
                if (diff.compareTo(Env.ZERO) != 0 && (diffline = fact.createLine(null, this.m_pc.getAccount(9, as), as.getC_Currency_ID(), diff)) != null) {
                    diffline.setC_Activity_ID(this.m_invoiceLine.getC_Activity_ID());
                    diffline.setC_Project_ID(this.m_invoiceLine.getC_Project_ID());
                    diffline.setC_ProjectPhase_ID(this.m_invoiceLine.getC_ProjectPhase_ID());
                    diffline.setC_ProjectTask_ID(this.m_invoiceLine.getC_ProjectTask_ID());
                    diffline.setC_UOM_ID(this.m_invoiceLine.getC_UOM_ID());
                    diffline.setUser1_ID(this.m_invoiceLine.getUser1_ID());
                    diffline.setUser2_ID(this.m_invoiceLine.getUser2_ID());
                    diffline.setUser3_ID(this.m_invoiceLine.getUser3_ID());
                    diffline.setUser4_ID(this.m_invoiceLine.getUser4_ID());
                    diffline.setQty(Env.ZERO);
                }
            } else {
                expense = isSOTrx ? this.m_pc.getAccount(1, as) : this.m_pc.getAccount(2, as);
                FactLine pv = fact.createLine(null, expense, as.getC_Currency_ID(), ipv);
                if (pv != null) {
                    MBPartner partner;
                    MBPartnerLocation location;
                    pv.setC_Activity_ID(this.m_invoiceLine.getC_Activity_ID());
                    pv.setC_Campaign_ID(this.m_invoiceLine.getC_Campaign_ID());
                    pv.setC_Project_ID(this.m_invoiceLine.getC_Project_ID());
                    pv.setC_ProjectPhase_ID(this.m_invoiceLine.getC_ProjectPhase_ID());
                    pv.setC_ProjectTask_ID(this.m_invoiceLine.getC_ProjectTask_ID());
                    pv.setC_UOM_ID(this.m_invoiceLine.getC_UOM_ID());
                    pv.setUser1_ID(this.m_invoiceLine.getUser1_ID());
                    pv.setUser2_ID(this.m_invoiceLine.getUser2_ID());
                    pv.setUser3_ID(this.m_invoiceLine.getUser3_ID());
                    pv.setUser4_ID(this.m_invoiceLine.getUser4_ID());
                    pv.setQty(Env.ZERO);
                    if (pv.getC_SalesRegion_ID() == 0 && (location = (partner = (MBPartner)invoice.getC_BPartner()).getPrimaryC_BPartner_Location()) != null && location.get_ID() > 0 && location.getC_SalesRegion_ID() > 0) {
                        pv.setC_SalesRegion_ID(location.getC_SalesRegion_ID());
                    }
                    pv.setC_Currency_ID(invoice.getC_Currency_ID());
                    if (ipvSource.signum() < 0) {
                        pv.setAmtSourceCr(ipvSource.abs());
                        pv.setAmtSourceDr(BigDecimal.ZERO);
                    } else {
                        pv.setAmtSourceDr(ipvSource);
                        pv.setAmtSourceCr(BigDecimal.ZERO);
                    }
                }
            }
        }
        this.log.fine("IPV=" + ipv + "; Balance=" + fact.getSourceBalance());
        facts.add(fact);
        if (as.isAccrual() && as.isCreatePOCommitment() && !isSOTrx) {
            fact = Doc_Order.getCommitmentRelease(as, this, this.getQty(), this.m_invoiceLine.getC_InvoiceLine_ID(), Env.ONE);
            if (fact == null) {
                return null;
            }
            facts.add(fact);
        }
        return facts;
    }

    private boolean isInterOrg(MAcctSchema as) {
        MAcctSchemaElement elementorg = as.getAcctSchemaElement("OO");
        if (elementorg == null || !elementorg.isBalanced()) {
            return false;
        }
        return this.m_receiptLine != null && this.m_invoiceLine != null && this.m_receiptLine.getAD_Org_ID() != this.m_invoiceLine.getAD_Org_ID();
    }
}

