/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public final class DocTax {
    private int m_C_Tax_ID = 0;
    private BigDecimal m_amount = null;
    private BigDecimal m_rate = null;
    private String m_name = null;
    private BigDecimal m_taxBaseAmt = null;
    private BigDecimal m_includedTax = Env.ZERO;
    private boolean m_salesTax = false;
    private static CLogger log = CLogger.getCLogger(DocTax.class);
    public static final int ACCTTYPE_TaxDue = 0;
    public static final int ACCTTYPE_TaxLiability = 1;
    public static final int ACCTTYPE_TaxCredit = 2;
    public static final int ACCTTYPE_TaxReceivables = 3;
    public static final int ACCTTYPE_TaxExpense = 4;

    public DocTax(int C_Tax_ID, String name, BigDecimal rate, BigDecimal taxBaseAmt, BigDecimal amount, boolean salesTax) {
        this.m_C_Tax_ID = C_Tax_ID;
        this.m_name = name;
        this.m_rate = rate;
        this.m_amount = amount;
        this.m_salesTax = salesTax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MAccount getAccount(int acctType, MAcctSchema acctSchema) {
        if (acctType < 0 || acctType > 4) {
            return null;
        }
        String sql = "SELECT T_Due_Acct, T_Liability_Acct, T_Credit_Acct, T_Receivables_Acct, T_Expense_Acct FROM C_Tax_Acct WHERE C_Tax_ID=? AND C_AcctSchema_ID=?";
        int validCombinationId = 0;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, acctSchema.get_TrxName());
            pstmt.setInt(1, this.m_C_Tax_ID);
            pstmt.setInt(2, acctSchema.getC_AcctSchema_ID());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                validCombinationId = rs.getInt(acctType + 1);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (validCombinationId == 0) {
            return null;
        }
        return MAccount.getValidCombination(acctSchema.getCtx(), validCombinationId, acctSchema.get_TrxName());
    }

    public BigDecimal getAmount() {
        return this.m_amount;
    }

    public BigDecimal getTaxBaseAmt() {
        return this.m_taxBaseAmt;
    }

    public BigDecimal getRate() {
        return this.m_rate;
    }

    public String getName() {
        return this.m_name;
    }

    public int getC_Tax_ID() {
        return this.m_C_Tax_ID;
    }

    public String getDescription() {
        return this.m_name + " " + this.m_taxBaseAmt.toString();
    }

    public void addIncludedTax(BigDecimal amt) {
        this.m_includedTax = this.m_includedTax.add(amt);
    }

    public BigDecimal getIncludedTax() {
        return this.m_includedTax;
    }

    public BigDecimal getIncludedTaxDifference() {
        return this.m_amount.subtract(this.m_includedTax);
    }

    public boolean isIncludedTaxDifference() {
        return Env.ZERO.compareTo(this.getIncludedTaxDifference()) != 0;
    }

    public int getAPTaxType() {
        if (this.isSalesTax()) {
            return 4;
        }
        return 2;
    }

    public boolean isSalesTax() {
        return this.m_salesTax;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Tax=(");
        sb.append(this.m_name);
        sb.append(" Amt=").append(this.m_amount);
        sb.append(")");
        return sb.toString();
    }
}

