/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.acct.Doc;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MColumn;
import org.compiere.model.MDocBaseType;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class DocFactory {
    private static CLogger s_log = CLogger.getCLogger(DocFactory.class);
    private MAcctSchema[] accountingSchemes = null;
    private int tableID = 0;
    private int recordID = 0;
    private String trxName = null;
    private ResultSet resultSet = null;

    public DocFactory withAccountingSchemes(MAcctSchema[] accountingSchemes) {
        this.accountingSchemes = accountingSchemes;
        return this;
    }

    public DocFactory withTableID(int tableID) {
        this.tableID = tableID;
        return this;
    }

    public DocFactory withRecordID(int recordID) {
        this.recordID = recordID;
        return this;
    }

    public DocFactory withTrxName(String trxName) {
        this.trxName = trxName;
        return this;
    }

    public DocFactory withResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
        return this;
    }

    public Doc get() {
        Doc doc = null;
        if (this.accountingSchemes != null && this.tableID > 0) {
            if (this.resultSet != null) {
                doc = this.getByResultSet();
            }
            if (doc == null && this.recordID > 0) {
                doc = this.getByID();
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Doc getByID() {
        ResultSet rs;
        CPreparedStatement pstmt;
        Doc doc;
        block7: {
            String TableName = null;
            for (int i = 0; i < Doc.getDocumentsTableID().length; ++i) {
                if (Doc.getDocumentsTableID()[i] != this.tableID) continue;
                TableName = Doc.getDocumentsTableName()[i];
                break;
            }
            if (TableName == null) {
                s_log.severe("Not found AD_Table_ID=" + this.tableID);
                return null;
            }
            doc = null;
            StringBuffer sql = new StringBuffer("SELECT * FROM ").append(TableName).append(" WHERE ").append(TableName).append("_ID=? AND Processed='Y'");
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql.toString(), this.trxName);
                pstmt.setInt(1, this.recordID);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    this.resultSet = rs;
                    doc = this.getByResultSet();
                    break block7;
                }
                s_log.severe("Not Found: " + TableName + "_ID=" + this.recordID);
            }
            catch (Exception e) {
                try {
                    s_log.log(Level.SEVERE, sql.toString(), e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return doc;
    }

    private Doc getByResultSet() {
        Doc doc = null;
        AtomicReference<Object> className = new AtomicReference<Object>(null);
        Optional<MTable> maybeTable = Optional.ofNullable(MTable.get(Env.getCtx(), "C_DocBaseType"));
        maybeTable.ifPresent(table -> {
            Optional<MColumn> maybeColumn = Optional.ofNullable(table.getColumn("C_DocBaseType_ID"));
            maybeColumn.ifPresent(columnDocBaseType -> {
                if (columnDocBaseType.getAD_Column_ID() > 0) {
                    int C_DocType_ID = 0;
                    try {
                        C_DocType_ID = this.resultSet.getInt("C_DocType_ID");
                    }
                    catch (Exception e) {
                        s_log.warning(e.getMessage());
                        C_DocType_ID = 0;
                    }
                    finally {
                        Optional<MDocBaseType> maybeDocBaseType = Optional.ofNullable(MDocBaseType.get(C_DocType_ID, this.tableID));
                        maybeDocBaseType.ifPresent(docBaseType -> className.set(docBaseType.getAccountingClassname()));
                    }
                }
            });
        });
        if (className.get() == null || className.get() != null && ((String)className.get()).isEmpty()) {
            String tableName = MTable.getTableName(Env.getCtx(), this.tableID);
            String packageName = "org.compiere.acct";
            int firstUnderscore = tableName.indexOf("_");
            if (firstUnderscore == 1) {
                className.set((packageName + ".Doc_" + tableName.substring(2).replaceAll("_", "")));
            } else {
                className.set((packageName + ".Doc_" + tableName.replaceAll("_", "")));
            }
        }
        try {
            Class<?> cClass = Class.forName(className.get());
            Constructor<?> cnstr = cClass.getConstructor(MAcctSchema[].class, ResultSet.class, String.class);
            doc = (Doc)cnstr.newInstance(this.accountingSchemes, this.resultSet, this.trxName);
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, "Doc Class invalid: " + className + " (" + e.toString() + ")");
            throw new AdempiereException("Doc Class invalid: " + className + " (" + e.toString() + ")");
        }
        if (doc == null) {
            s_log.log(Level.SEVERE, "Unknown AD_Table_ID=" + this.tableID);
        }
        return doc;
    }
}

