/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.adempiere.util.Check;
import org.adempiere.util.IMultitonService;
import org.adempiere.util.IService;
import org.adempiere.util.IServiceNameAutoDetectPolicy;
import org.adempiere.util.ISingletonService;
import org.adempiere.util.UnitTestServiceNamePolicy;
import org.adempiere.util.exceptions.ServicesException;

public class Services {
    private static final Logger logger = Logger.getLogger(Services.class.getName());
    private static Map<Class<? extends IService>, Object> services = new HashMap<Class<? extends IService>, Object>();
    private static boolean isAutodetectServices = true;
    private static IServiceNameAutoDetectPolicy serviceNameAutoDetectPolicy = new UnitTestServiceNamePolicy();

    public static void setAutodetectServices(boolean enable) {
        isAutodetectServices = enable;
    }

    public static boolean isAutodetectServices() {
        return isAutodetectServices;
    }

    public static <T extends IService> T get(Class<T> clazz) {
        Check.assumeNotNull(clazz, "Param 'clazz' not null", new Object[0]);
        T service = Services.getSingleton(clazz);
        if (service == null) {
            logger.severe("No service is registered for " + clazz);
            return null;
        }
        if (service instanceof IMultitonService) {
            return (T)Services.newMultitonInstance((IMultitonService)service);
        }
        return service;
    }

    private static <T extends IService> T getSingleton(Class<T> clazz) {
        IService service = (IService)services.get(clazz);
        if (service != null) {
            return (T)service;
        }
        if (isAutodetectServices) {
            String serviceClassname = serviceNameAutoDetectPolicy.getServiceImplementationClassName(clazz);
            try {
                Class<?> serviceClass = Thread.currentThread().getContextClassLoader().loadClass(serviceClassname);
                service = (IService)Services.newClassInstance(serviceClass);
                Constructor<?> serviceClassCtor = null;
                for (Constructor<?> ctor : serviceClass.getDeclaredConstructors()) {
                    if (ctor.getParameterTypes().length != 0) continue;
                    serviceClassCtor = ctor;
                    break;
                }
                if (serviceClassCtor != null) {
                    if (!serviceClassCtor.isAccessible()) {
                        serviceClassCtor.setAccessible(true);
                    }
                    service = (IService)serviceClassCtor.newInstance(new Object[0]);
                } else {
                    service = (IService)serviceClass.newInstance();
                }
                services.put(clazz, service);
                logger.info("Autodetected service for " + clazz + ": " + service.getClass());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Cannot load autodetected class " + serviceClassname, e);
            }
        }
        if (service == null) {
            logger.log(Level.SEVERE, "No service is registered for {0}", clazz);
        }
        return (T)service;
    }

    private static final <T> T newClassInstance(Class<?> serviceClass) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object service;
        Constructor<?> serviceClassCtor = null;
        for (Constructor<?> ctor : serviceClass.getDeclaredConstructors()) {
            if (ctor.getParameterTypes().length != 0) continue;
            serviceClassCtor = ctor;
            break;
        }
        if (serviceClassCtor != null) {
            if (!serviceClassCtor.isAccessible()) {
                serviceClassCtor.setAccessible(true);
            }
            service = serviceClassCtor.newInstance(new Object[0]);
        } else {
            service = serviceClass.newInstance();
        }
        return (T)service;
    }

    private static <T extends IMultitonService> T newMultitonInstance(T inst) {
        try {
            Class<?> serviceClass = inst.getClass();
            IMultitonService service = (IMultitonService)Services.newClassInstance(serviceClass);
            return (T)service;
        }
        catch (InstantiationException e) {
            throw new ServicesException(e);
        }
        catch (IllegalAccessException e) {
            throw new ServicesException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ServicesException(e);
        }
        catch (InvocationTargetException e) {
            throw new ServicesException(e.getTargetException());
        }
    }

    public static boolean isRegistered(Class<?> clazz) {
        return services.get(clazz) != null;
    }

    public static <T extends IService> void registerService(Class<T> clazz, T implementation) {
        Check.assumeNotNull(clazz, "Param 'clazz' not null", new Object[0]);
        Check.assumeNotNull(implementation, "Param 'implementation' not null", new Object[0]);
        Services.checkAndRegister(clazz, implementation);
    }

    private static <T extends IService> void checkAndRegister(Class<T> clazz, T implementation) {
        logger.info("Registering implementation (class " + implementation.getClass().getName() + ") for API-class " + clazz);
        Services.checkParams(clazz, implementation);
        services.put(clazz, implementation);
    }

    private static <T extends IService> void checkParams(Class<T> apiClazz, T impl) {
        if (!apiClazz.isInterface()) {
            throw new IllegalArgumentException("Parameter 'clazz' must be an interface class. clazz is" + apiClazz.getName());
        }
        Class<?> implClazz = impl.getClass();
        if (!apiClazz.isAssignableFrom(implClazz)) {
            throw new IllegalArgumentException("Service " + implClazz + " must implement interface " + apiClazz);
        }
        if (!(impl instanceof IMultitonService) && !(impl instanceof ISingletonService)) {
            throw new IllegalArgumentException("Parameter 'clazz' must extend " + IMultitonService.class + " or " + ISingletonService.class);
        }
    }

    public static void clear() {
        services.clear();
    }

    public static void setServiceNameAutoDetectPolicy(IServiceNameAutoDetectPolicy serviceNameAutoDetectPolicy) {
        Check.assumeNotNull(serviceNameAutoDetectPolicy, "Param 'serviceNameAutoDetectPolicy' not null", new Object[0]);
        Services.serviceNameAutoDetectPolicy = serviceNameAutoDetectPolicy;
    }
}

