/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.production.process;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.adempiere.production.process.GenerateReplenishPlanReportAbstract;
import org.compiere.model.MTable;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.production.model.MReplenishPlan;
import org.compiere.util.DB;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class GenerateReplenishPlanReport
extends GenerateReplenishPlanReportAbstract {
    private int redPrintColorId;
    private Timestamp dateFrom;
    private Timestamp dateTo;
    private Calendar calendar = Calendar.getInstance();
    private Map<Integer, String> weekDateInfo = new HashMap<Integer, String>();

    @Override
    protected void prepare() {
        super.prepare();
        this.redPrintColorId = DB.getSQLValue(this.get_TrxName(), "SELECT AD_PrintColor_ID FROM AD_PrintColor WHERE Name ='Red'");
    }

    @Override
    protected String doIt() {
        MReplenishPlan run = new MReplenishPlan(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        this.dateFrom = run.getDateStart();
        this.dateTo = run.getDateFinish();
        if (this.dateFrom == null) {
            throw new IllegalArgumentException(Msg.parseTranslation(this.getCtx(), "@FillMandatory@ @DateStart@"));
        }
        if (this.dateTo == null) {
            throw new IllegalArgumentException(Msg.parseTranslation(this.getCtx(), "@FillMandatory@ @DateFinish@"));
        }
        this.addWeekDateInfo();
        if (Ini.isClient()) {
            this.getProcessInfo().setTransientObject(this.getPrintFormat());
        } else {
            this.getProcessInfo().setSerializableObject(this.getPrintFormat());
        }
        return null;
    }

    private MPrintFormat getPrintFormat() {
        MPrintFormat pf = null;
        pf = Ini.isClient() ? (MPrintFormat)this.getProcessInfo().getTransientObject() : (MPrintFormat)this.getProcessInfo().getSerializableObject();
        if (pf == null) {
            pf = MPrintFormat.get(this.getCtx(), 0, MTable.getTable_ID("M_ReplenishPlanLine"));
        }
        int count = pf.getItemCount();
        int weeksToDisplay = TimeUtil.getWeeksBetween(this.dateFrom, this.dateTo);
        int startIndx = 1;
        int endIndx = weeksToDisplay;
        for (int i = 0; i < count; ++i) {
            MPrintFormatItem pfi = pf.getItem(i);
            String columnName = pfi.getColumnName().toLowerCase();
            if (columnName != null && columnName.startsWith("week")) {
                int index = Integer.parseInt(columnName.substring(4));
                if (index > weeksToDisplay) {
                    if (pfi.isPrinted()) {
                        pfi.setIsPrinted(false);
                    }
                } else {
                    int displayWeek = startIndx + (index - 1);
                    String printName = this.weekDateInfo.get(displayWeek);
                    pfi.setPrintName(printName);
                    pfi.setIsPrinted(true);
                    pfi.setIsSuppressNull(false);
                    pfi.setIsSuppressRepeats(false);
                    pfi.setMaxWidth(35);
                    pfi.setIsFixedWidth(true);
                    pfi.setIsHeightOneLine(false);
                    pfi.setLineAlignmentType("T");
                    pfi.setFieldAlignmentType("T");
                    pfi.setSeqNo(50 + index * 10);
                    if (displayWeek > startIndx + 1 && displayWeek < endIndx - 1) {
                        pfi.setAD_PrintColor_ID(this.redPrintColorId);
                    } else {
                        pfi.setAD_PrintColor_ID(-1);
                    }
                }
            }
            pfi.saveEx();
            this.log.fine(pfi.toString());
        }
        pf.setTranslation();
        pf = MPrintFormat.get(this.getCtx(), pf.getAD_PrintFormat_ID(), true);
        return pf;
    }

    private void addWeekDateInfo() {
        int start = 1;
        int end = TimeUtil.getWeeksBetween(this.dateFrom, this.dateTo);
        Date dt = this.dateFrom;
        for (int count = start; count <= end; ++count) {
            this.calendar.setTimeInMillis(dt.getTime());
            StringBuilder weekStartDate = new StringBuilder(new SimpleDateFormat("dd-").format(dt));
            this.calendar.add(7, 6);
            dt = this.calendar.getTime();
            weekStartDate.append(new SimpleDateFormat("dd (MMM yyyy)").format(dt));
            this.calendar.add(7, 1);
            dt.setTime(this.calendar.getTimeInMillis());
            this.weekDateInfo.put(count, weekStartDate.toString());
        }
    }
}

