/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.production.process;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_M_ReplenishPlanLine;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.production.process.CalculateReplenishPlanAbstract;
import org.compiere.model.MOrder;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MProductPricing;
import org.compiere.model.MProduction;
import org.compiere.model.MReplenish;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MStorage;
import org.compiere.model.Query;
import org.compiere.production.model.MReplenishPlan;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.eevolution.manufacturing.model.MPPProductBOM;
import org.eevolution.manufacturing.model.MPPProductBOMLine;

public class CalculateReplenishPlan
extends CalculateReplenishPlanAbstract {
    private static final String TYPE_RQ = "RQ";
    private static final String TYPE_PO = "PO";
    private static final String TYPE_MO = "MO";
    private int lineNo = 10;
    private int countProd = 0;
    private int countReq = 0;
    private int docTypePlannedOrder;
    private int docTypeConfirmedOrder;
    private int docTypePurchaseOrder;
    private int docTypeMRPRequisition;
    private int priceListId;
    private Calendar calendar = Calendar.getInstance();
    private Map<Integer, BigDecimal> availableInventory = new TreeMap<Integer, BigDecimal>();
    Map<java.util.Date, Map<Integer, BigDecimal>> mapDemand = new TreeMap<java.util.Date, Map<Integer, BigDecimal>>();
    Map<Integer, Map<java.util.Date, BigDecimal>> mapRequirePlanningQty = new TreeMap<Integer, Map<java.util.Date, BigDecimal>>();
    Map<java.util.Date, MRequisition> mapRequisition = new TreeMap<java.util.Date, MRequisition>();
    StringBuilder infoMsg = new StringBuilder();
    StringBuilder productionDocs = new StringBuilder();
    StringBuilder requisitionDocs = new StringBuilder();
    private MReplenishPlan replenishPlan = null;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.replenishPlan = new MReplenishPlan(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        if (this.getDateStart() == null) {
            this.setDateStart(this.replenishPlan.getDateStart());
        } else {
            this.replenishPlan.setDateStart(this.getDateStart());
        }
        if (this.getDateFinish() == null) {
            this.setDateFinish(this.replenishPlan.getDateFinish());
        } else {
            this.replenishPlan.setDateFinish(this.getDateFinish());
        }
        this.priceListId = this.replenishPlan.getM_PriceList_ID();
        this.docTypePlannedOrder = this.replenishPlan.getC_DocType_PlannedOrder();
        this.docTypeConfirmedOrder = this.replenishPlan.getC_DocType_ConfirmedOrder();
        this.docTypePurchaseOrder = this.replenishPlan.getC_DocType_PO();
        this.docTypeMRPRequisition = this.replenishPlan.getC_DocType_Requisition();
        StringBuilder error = new StringBuilder();
        if (this.docTypePlannedOrder <= 0) {
            error.append("@C_DocType_PlannedOrder@ @NotFound@\n");
        }
        if (this.docTypeConfirmedOrder <= 0) {
            error.append("@C_DocType_ConfirmedOrder@ @NotFound@\n");
        }
        if (this.docTypePurchaseOrder <= 0) {
            error.append("@C_DocType_PO@ @NotFound@\n");
        }
        if (this.docTypeMRPRequisition <= 0) {
            error.append("@C_DocType_Requisition@ @NotFound@\n");
        }
        if (error.length() > 0) {
            throw new Exception(Msg.parseTranslation(this.getCtx(), error.toString()));
        }
        if (this.getDateStart() == null) {
            throw new IllegalArgumentException(Msg.parseTranslation(this.getCtx(), "@FillMandatory@ @DateStart@"));
        }
        if (this.getDateFinish() == null) {
            throw new IllegalArgumentException(Msg.parseTranslation(this.getCtx(), "@FillMandatory@ @DateFinish@"));
        }
        if (this.priceListId == 0) {
            throw new IllegalArgumentException(Msg.parseTranslation(this.getCtx(), "@FillMandatory@ @M_PriceList_ID@"));
        }
        this.replenishPlan.saveEx();
        String sql = "DELETE FROM M_ReplenishPlanLine WHERE M_ReplenishPlan_ID=?";
        int noOfLinesDeleted = DB.executeUpdateEx(sql, new Object[]{this.getRecord_ID()}, this.get_TrxName());
        this.log.fine("No. of MRP lines deleted : " + noOfLinesDeleted);
        if (this.replenishPlan.isDeleteUnconfirmedProduction()) {
            this.deleteUnconfirmedProduction();
        }
        if (this.replenishPlan.isDeletePlannedPO()) {
            this.deletePlannedPO();
        }
        TreeMap<Integer, MiniMRPProduct> miniMrpProducts = new TreeMap<Integer, MiniMRPProduct>();
        TreeSet<Integer> productIds = new TreeSet<Integer>();
        this.generateProductInfo(miniMrpProducts, productIds);
        this.doRunProductsSO(miniMrpProducts, productIds);
        this.doRunCreatePOandProductionOrder(miniMrpProducts);
        this.doRunOpenOrders(miniMrpProducts, productIds, TYPE_PO);
        this.doRunOpenOrders(miniMrpProducts, productIds, TYPE_MO);
        this.doRunOpenOrders(miniMrpProducts, productIds, TYPE_RQ);
        this.renderPeggingReport(miniMrpProducts);
        this.updateHasSupplyDemand();
        return this.infoMsg.toString();
    }

    private void deleteUnconfirmedProduction() {
        String sql = "DELETE FROM M_ProductionLine WHERE EXISTS(SELECT 1 FROM M_Production \t\t\t\t\tWHERE M_Production_ID = M_ProductionLine.M_Production_ID \t\t\t\t\tAND Processed='N' \t\t\t\t\tAND C_DocType_ID = ?)";
        int noOfLinesDeleted = DB.executeUpdate(sql, this.docTypePlannedOrder, this.get_TrxName());
        this.log.fine("No. of planned production line deleted : " + noOfLinesDeleted);
        sql = "DELETE FROM M_Production\tWHERE Processed='N' AND C_DocType_ID = ?";
        noOfLinesDeleted = DB.executeUpdate(sql, this.docTypePlannedOrder, this.get_TrxName());
        this.log.fine("No. of planned production deleted : " + noOfLinesDeleted);
        sql = "DELETE FROM M_ProductionBatch b  WHERE b.C_DocType_ID = ? AND NOT EXISTS(SELECT 1                   FROM M_Production                   WHERE M_ProductionBatch_ID = b.M_ProductionBatch_ID)";
        noOfLinesDeleted = DB.executeUpdate(sql, this.docTypePlannedOrder, this.get_TrxName());
        this.log.fine("No. of Production Batch deleted " + noOfLinesDeleted);
        sql = "DELETE FROM M_MovementLine ml WHERE EXISTS(SELECT 1 FROM M_Movement m \t\t\t\tWHERE m.M_Movement_ID = ml.M_Movement_ID \t\t\t\tAND m.M_ProductionBatch_ID IS NOT NULL \t\t\t\tAND m.Processed = 'N' \t\t\t\t\tAND NOT EXISTS(SELECT 1 \t\t\t\t\t\t\tFROM M_ProductionBatch b \t\t\t\t\t\t\tWHERE b.M_ProductionBatch_ID = m.M_ProductionBatch_ID))";
        noOfLinesDeleted = DB.executeUpdate(sql, this.get_TrxName());
        this.log.fine("No. of Movement Lines cleaned : " + noOfLinesDeleted);
        sql = "DELETE FROM M_Movement m WHERE m.M_ProductionBatch_ID IS NOT NULL AND m.Processed = 'N'AND NOT EXISTS(SELECT 1 FROM M_ProductionBatch b \t\t\t\tWHERE b.M_ProductionBatch_ID = m.M_ProductionBatch_ID)";
        noOfLinesDeleted = DB.executeUpdate(sql, this.get_TrxName());
        this.log.fine("No. of Inventory Movements cleaned : " + noOfLinesDeleted);
    }

    private void deletePlannedPO() {
        String sql = "DELETE FROM PP_MRP WHERE EXISTS(SELECT 1 FROM M_Requisition \t\t\t\t\tWHERE M_Requisition_ID = PP_MRP.M_Requisition_ID\t\t\t\t\tAND DocStatus = 'DR' \t\t\t\t\tAND Processed='N' \t\t\t\t\tAND AD_Client_ID = ? \t\t\t\t\tAND C_DocType_ID = ?)";
        int noOfLinesDeleted = DB.executeUpdateEx(sql, new Object[]{this.getAD_Client_ID(), this.docTypeMRPRequisition}, this.get_TrxName());
        this.log.fine("No. of Material Requirement Planning (PP_MRP) Line deleted : " + noOfLinesDeleted);
        sql = "DELETE FROM M_RequisitionLine WHERE EXISTS(SELECT 1 FROM M_Requisition \t\t\t\t\tWHERE M_Requisition_ID = M_RequisitionLine.M_Requisition_ID\t\t\t\t\tAND DocStatus = 'DR' \t\t\t\t\tAND Processed='N' \t\t\t\t\tAND AD_Client_ID = ? \t\t\t\t\tAND C_DocType_ID = ?)";
        noOfLinesDeleted = DB.executeUpdateEx(sql, new Object[]{this.getAD_Client_ID(), this.docTypeMRPRequisition}, this.get_TrxName());
        this.log.fine("No. of MRP Requisition Line deleted : " + noOfLinesDeleted);
        sql = "DELETE FROM M_Requisition WHERE DocStatus = 'DR' AND Processed='N' AND AD_Client_ID = ? AND C_DocType_ID = ?";
        noOfLinesDeleted = DB.executeUpdateEx(sql, new Object[]{this.getAD_Client_ID(), this.docTypeMRPRequisition}, this.get_TrxName());
        this.log.fine("No. of MRP Requisition deleted : " + noOfLinesDeleted);
    }

    private void updateHasSupplyDemand() {
        String sql = new String("UPDATE M_ReplenishPlanLine SET HasSupplyDemand = 'Y' WHERE M_ReplenishPlan_ID = ? \tAND EXISTS(SELECT 1 FROM M_ReplenishPlanLine rpl \t\t\t\tWHERE rpl.M_ReplenishPlan_ID = M_ReplenishPlanLine.M_ReplenishPlan_ID \t\t\t\tGROUP BY rpl.AD_Client_ID, rpl.M_ReplenishPlan_ID, rpl.M_Product_ID \t\t\t\tHAVING COUNT(rpl.M_Product_ID) > 2)");
        int updated = DB.executeUpdateEx(sql, new Object[]{this.getRecord_ID()}, this.get_TrxName());
        this.log.fine("Lines with supply/demand updated: " + updated);
    }

    private void doRunCreatePOandProductionOrder(Map<Integer, MiniMRPProduct> miniMrpProducts) {
        MRequisition requisition = null;
        this.runProcessCalculatePlannedQty(miniMrpProducts);
        for (Integer productID : this.mapRequirePlanningQty.keySet()) {
            MiniMRPProduct mrp = miniMrpProducts.get(productID);
            TreeMap<java.util.Date, BigDecimal> weeklyProductionQty = new TreeMap<java.util.Date, BigDecimal>(this.mapRequirePlanningQty.get(productID));
            for (java.util.Date date : weeklyProductionQty.keySet()) {
                if (((BigDecimal)weeklyProductionQty.get(date)).compareTo(Env.ZERO) == 0) continue;
                if (!mrp.isBOM() && mrp.isPurchased() && !mrp.isPhantom()) {
                    requisition = this.createRequisitionHeader(date);
                    this.createRequisitionLine(requisition, mrp, (BigDecimal)weeklyProductionQty.get(date));
                    continue;
                }
                if (!mrp.isBOM() || mrp.isPhantom()) continue;
                this.createProductionOrder(mrp, (BigDecimal)weeklyProductionQty.get(date), new Timestamp(date.getTime()));
            }
        }
        this.infoMsg.append(" @M_Requisition_ID@ @Created@:" + this.countReq);
        this.infoMsg.append(" @M_Production_ID@:" + this.countProd);
        this.log.log(Level.INFO, this.infoMsg.toString());
    }

    private void runProcessCalculatePlannedQty(Map<Integer, MiniMRPProduct> miniMrpProducts) {
        for (java.util.Date date : this.mapDemand.keySet()) {
            Map<Integer, BigDecimal> mapOrderQty = this.mapDemand.get(date);
            for (Integer productID : mapOrderQty.keySet()) {
                MProduct product = new MProduct(this.getCtx(), productID, this.get_TrxName());
                if (!product.isStocked()) {
                    return;
                }
                BigDecimal demandQty = mapOrderQty.get(productID);
                if (demandQty.compareTo(Env.ZERO) == 0) continue;
                MiniMRPProduct mrp = miniMrpProducts.get(productID);
                if (mrp == null) {
                    MProduct p = MProduct.get(this.getCtx(), productID);
                    String error = "Please check Product=" + p.getValue() + " replenishment parameters may not be setup properly.";
                    this.log.severe(error);
                    throw new AdempiereException(error);
                }
                Integer nonPhantomProduct = mrp.isPhantom() && mrp.isBOM() ? 0 : productID;
                this.createPlannedQtyMap(miniMrpProducts, date, productID, demandQty, 0, nonPhantomProduct);
            }
        }
    }

    private void createPlannedQtyMap(Map<Integer, MiniMRPProduct> miniMrpProducts, java.util.Date date, Integer productID, BigDecimal demandQty, int level, Integer nonPhantomProduct) {
        if (miniMrpProducts.containsKey(productID)) {
            MiniMRPProduct mrp = miniMrpProducts.get(productID);
            if (mrp.getQtyOnHand().compareTo(demandQty) >= 0) {
                mrp.setQtyOnHand(mrp.getQtyOnHand().subtract(demandQty));
                demandQty = Env.ZERO;
                return;
            }
            if (mrp.getQtyOnHand().compareTo(Env.ZERO) != 0 && mrp.getQtyOnHand().compareTo(demandQty) < 0) {
                demandQty = demandQty.subtract(mrp.getQtyOnHand());
                mrp.setQtyOnHand(Env.ZERO);
            }
            Map<java.util.Date, BigDecimal> confirmProductQty = mrp.getMapConfirmProductQty();
            if (demandQty.compareTo(Env.ZERO) > 0 && confirmProductQty != null && !confirmProductQty.isEmpty()) {
                for (java.util.Date dateProduction : confirmProductQty.keySet()) {
                    BigDecimal confirmQty = confirmProductQty.get(dateProduction);
                    if (confirmQty.compareTo(Env.ZERO) <= 0 || date.compareTo(dateProduction) < 0) continue;
                    if (confirmQty.compareTo(demandQty) >= 0) {
                        confirmQty = confirmQty.subtract(demandQty);
                        confirmProductQty.put(dateProduction, confirmQty);
                        demandQty = Env.ZERO;
                        break;
                    }
                    demandQty = demandQty.subtract(confirmQty);
                    confirmProductQty.put(dateProduction, Env.ZERO);
                }
            }
            if (mrp.isReplenishTypeMRPCalculated() && mrp.getExtraQtyPlanned().compareTo(Env.ZERO) != 0) {
                if (mrp.getExtraQtyPlanned().compareTo(demandQty) < 0) {
                    demandQty = demandQty.subtract(mrp.getExtraQtyPlanned());
                    mrp.setExtraQtyPlanned(Env.ZERO);
                } else {
                    mrp.setExtraQtyPlanned(mrp.getExtraQtyPlanned().subtract(demandQty));
                    demandQty = Env.ZERO;
                    return;
                }
            }
            if (demandQty.compareTo(Env.ZERO) > 0) {
                if (!mrp.isPhantom() && mrp.isBOM()) {
                    ++level;
                    nonPhantomProduct = mrp.getM_Product_ID();
                } else if (!mrp.isPhantom() && !mrp.isBOM() && nonPhantomProduct != 0) {
                    ++level;
                }
                this.calendar.setTimeInMillis(date.getTime());
                this.calendar.add(5, level * -7);
                this.calendar.set(7, 2);
                Timestamp plannedDate = new Timestamp(this.calendar.getTimeInMillis());
                if (plannedDate.compareTo(this.getDateStart()) < 0) {
                    plannedDate = this.getDateStart();
                }
                if (!mrp.isPhantom() && nonPhantomProduct != 0 && mrp.isBOM()) {
                    if (mrp.isReplenishTypeMRPCalculated()) {
                        demandQty = this.calculateBatchSizeWiseOrderCreation(mrp, demandQty, plannedDate);
                    } else {
                        this.setRequirePlanningQty(mrp, plannedDate, demandQty);
                    }
                }
                if (mrp.isBOM()) {
                    this.planBOMTree(miniMrpProducts, productID, date, demandQty, level, nonPhantomProduct);
                } else if (!mrp.isPhantom()) {
                    if (mrp.isReplenishTypeMRPCalculated()) {
                        demandQty = this.calculateBatchSizeWiseOrderCreation(mrp, demandQty, plannedDate);
                    } else {
                        this.setRequirePlanningQty(mrp, plannedDate, demandQty);
                    }
                }
            }
        }
    }

    private void createProductionOrder(MiniMRPProduct mrp, BigDecimal qty, Timestamp date) {
        MProduction mProd = new MProduction(this.getCtx(), 0, this.get_TrxName());
        mProd.setAD_Org_ID(this.replenishPlan.getAD_Org_ID());
        mProd.setM_Product_ID(mrp.getM_Product_ID());
        mProd.setProductionQty(qty);
        mProd.setM_Locator_ID(this.getLocatorId());
        mProd.setC_DocType_ID(this.docTypePlannedOrder);
        mProd.setName("Planned Production Order");
        mProd.setDescription("Creating from MiniMRP");
        mProd.setDatePromised(date);
        mProd.setMovementDate(date);
        mProd.setDocumentNo("<>");
        mProd.saveEx();
        mProd.createLines(false);
        mProd.setIsCreated(true);
        mProd.saveEx();
        ++this.countProd;
        this.productionDocs.append(mProd.getDocumentNo()).append(",");
    }

    private BigDecimal calculateBatchSizeWiseOrderCreation(MiniMRPProduct mrp, BigDecimal qty, Timestamp date) {
        int createNoOfOrder = 1;
        BigDecimal QtyPlan = qty;
        if (mrp.getQtyBatchSize().compareTo(Env.ZERO) == 0) {
            this.setRequirePlanningQty(mrp, date, qty);
            return qty;
        }
        createNoOfOrder = qty.divide(mrp.getQtyBatchSize(), 0, RoundingMode.CEILING).intValue();
        QtyPlan = mrp.getQtyBatchSize();
        BigDecimal qtyPlanned = QtyPlan.multiply(new BigDecimal(createNoOfOrder));
        mrp.setExtraQtyPlanned(mrp.getExtraQtyPlanned().add(qtyPlanned).subtract(qty));
        for (int i = 0; i < createNoOfOrder; ++i) {
            if (mrp.isBOM()) {
                this.createProductionOrder(mrp, QtyPlan, date);
                continue;
            }
            MRequisition requisition = this.createRequisitionHeader(date);
            this.createRequisitionLine(requisition, mrp, QtyPlan);
        }
        return qtyPlanned;
    }

    private void setRequirePlanningQty(MiniMRPProduct mrp, java.util.Date date, BigDecimal demandQty) {
        if (mrp.isPhantom()) {
            return;
        }
        if (this.mapRequirePlanningQty.containsKey(mrp.getM_Product_ID())) {
            Map<java.util.Date, BigDecimal> weekly = this.mapRequirePlanningQty.get(mrp.getM_Product_ID());
            if (weekly.containsKey(date)) {
                weekly.put(date, weekly.get(date).add(demandQty));
            } else {
                weekly.put(date, demandQty);
            }
        } else {
            HashMap<java.util.Date, BigDecimal> weekly = new HashMap<java.util.Date, BigDecimal>();
            weekly.put(date, demandQty);
            this.mapRequirePlanningQty.put(mrp.getM_Product_ID(), weekly);
        }
    }

    private void planBOMTree(Map<Integer, MiniMRPProduct> miniMrpProducts, Integer productID, java.util.Date date, BigDecimal demandQty, int level, Integer nonPhantomProduct) {
        List bomList = new Query(this.getCtx(), "M_Product_BOM", "M_Product_ID= ?", this.get_TrxName()).setParameters(productID).setClient_ID().list();
        bomList.stream().forEach(productBOM -> {
            BigDecimal requiredQty = Env.ZERO;
            if (productBOM.getBOMQty() != null && demandQty != null) {
                demandQty.multiply(productBOM.getBOMQty());
            }
            if (requiredQty.compareTo(Env.ZERO) > 0) {
                this.createPlannedQtyMap(miniMrpProducts, date, productBOM.getM_ProductBOM_ID(), requiredQty, level, nonPhantomProduct);
            }
        });
    }

    private MRequisition createRequisitionHeader(java.util.Date date) {
        MRequisition requisition = null;
        if (!this.mapRequisition.containsKey(date)) {
            requisition = this.createRequisition(date);
            this.mapRequisition.put(date, requisition);
            this.log.severe("New Requisition Header created. " + requisition.toString());
        } else {
            requisition = this.mapRequisition.get(date);
        }
        return requisition;
    }

    private MRequisition createRequisition(java.util.Date date) {
        MRequisition requisition = new MRequisition(this.getCtx(), 0, this.get_TrxName());
        requisition.setM_Warehouse_ID(this.getWarehouseId());
        requisition.setC_DocType_ID(this.docTypeMRPRequisition);
        requisition.setAD_User_ID(this.getAD_User_ID());
        requisition.setDescription(Msg.parseTranslation(this.getCtx(), "@Created@ @from@ @M_ReplenishPlan_ID@"));
        requisition.setDateRequired(new Timestamp(date.getTime()));
        requisition.setDateDoc(new Timestamp(date.getTime()));
        requisition.setM_PriceList_ID(this.priceListId);
        requisition.saveEx();
        ++this.countReq;
        this.requisitionDocs.append(requisition.getDocumentNo()).append(",");
        return requisition;
    }

    private void createRequisitionLine(MRequisition requisition, MiniMRPProduct mrp, BigDecimal qty) {
        MRequisitionLine rLine = new MRequisitionLine(requisition);
        rLine.setM_Product_ID(mrp.getM_Product_ID());
        rLine.setC_BPartner_ID(mrp.getC_BPartner_ID());
        rLine.setPriceActual(mrp.getPriceActual());
        rLine.setQty(qty);
        rLine.saveEx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConfirmProductQty(MiniMRPProduct mrp) {
        int productID = mrp.getM_Product_ID();
        TreeMap<java.util.Date, BigDecimal> mapConfirmQty = new TreeMap<java.util.Date, BigDecimal>();
        String sqlConfirmPORQ = new String(" SELECT DateRequired AS DatePromised, SUM(Qty) AS Qty FROM ((SELECT ol.DatePromised AS DateRequired, ol.QtyOrdered - QtyDelivered AS Qty\t\t\tFROM C_Order o  \tINNER JOIN C_OrderLine ol ON (ol.C_Order_ID = o.C_Order_ID)  \tWHERE o.DocStatus IN ('CO', 'CL') \t\tAND o.IsSoTrx = 'N' \t\tAND ol.M_Product_ID = ? \t\tAND ol.QtyOrdered > ol.QtyDelivered \t\tAND o.DatePromised BETWEEN ? AND ?  ORDER BY o.DatePromised) UNION ALL\t(SELECT r.DateRequired, SUM(rl.Qty) AS QtyOrdered \t\tFROM M_Requisition r  \tINNER JOIN M_RequisitionLine rl ON (r.M_Requisition_ID = rl.M_Requisition_ID)  \tINNER JOIN M_Product mp ON (mp.M_Product_ID = rl.M_Product_ID)  \tWHERE r.DocStatus = 'DR' \t\tAND rl.M_Product_ID = ? \t\tAND r.DateRequired BETWEEN ? AND ? \t\tAND rl.IsActive = 'Y' \t\tAND mp.AD_Client_ID = ? \t\tAND r.C_DocType_ID = ? \t\tAND mp.IsActive = 'Y'  GROUP BY mp.M_Product_ID, r.M_Requisition_ID \tORDER BY mp.M_Product_ID, r.DateRequired)) AS QtyOrdered\tGROUP BY DateRequired");
        String sqlFromProduction = new String("SELECT DatePromised, ProductionQty AS Qty, M_Production_ID  FROM M_Production  WHERE Processed = 'N' \tAND M_Product_ID = ? \tAND DatePromised BETWEEN ? AND ? \tAND (C_DocType_ID IS NULL OR C_DocType_ID != ?) ORDER BY DatePromised");
        String sql = mrp.isBOM() ? sqlFromProduction : sqlConfirmPORQ;
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, productID);
            pstmt.setTimestamp(2, this.getDateStart());
            pstmt.setTimestamp(3, this.getDateFinish());
            if (mrp.isBOM()) {
                pstmt.setInt(4, this.docTypePlannedOrder);
            } else {
                pstmt.setInt(4, productID);
                pstmt.setTimestamp(5, this.getDateStart());
                pstmt.setTimestamp(6, this.getDateFinish());
                pstmt.setInt(7, this.getAD_Client_ID());
                pstmt.setInt(8, this.docTypeMRPRequisition);
            }
            rs = pstmt.executeQuery();
            String productionsql = new String("SELECT p.M_Product_ID, SUM(QtyUsed) AS QtyUsed, mp.DatePromised FROM M_Production mp INNER JOIN M_ProductionLine pl ON (pl.M_Production_ID = mp.M_Production_ID) INNER JOIN M_Product p ON (p.M_Product_ID = pl.M_Product_ID) WHERE pl.IsActive='Y' AND pl.M_Production_ID = ? AND pl.IsEndProduct = 'N' AND p.IsPhantom = 'N' GROUP BY mp.M_Production_ID, p.M_Product_ID ORDER BY p.M_Product_ID");
            while (rs.next()) {
                Date datePromised = rs.getDate("DatePromised");
                BigDecimal qty = rs.getBigDecimal("Qty");
                if (mapConfirmQty.containsKey(datePromised)) {
                    mapConfirmQty.put(datePromised, ((BigDecimal)mapConfirmQty.get(datePromised)).add(qty));
                } else {
                    mapConfirmQty.put(datePromised, qty);
                }
                if (!mrp.isBOM()) continue;
                CPreparedStatement pstatement = null;
                ResultSet rset = null;
                try {
                    pstatement = DB.prepareStatement(productionsql, this.get_TrxName());
                    pstatement.setInt(1, rs.getInt("M_Production_ID"));
                    rset = pstatement.executeQuery();
                    while (rset.next()) {
                        this.setQtyAsDemand(rset.getInt("M_Product_ID"), rset.getBigDecimal("QtyUsed"), rset.getTimestamp("DatePromised"));
                    }
                    DB.close(rset, pstatement);
                    rset = null;
                    pstatement = null;
                }
                catch (SQLException e) {
                    this.log.severe(e.getLocalizedMessage());
                }
                finally {
                    DB.close(rset, pstatement);
                    rset = null;
                    pstatement = null;
                }
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            this.log.severe(e.getLocalizedMessage());
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        mrp.setMapConfirmProductQty(mapConfirmQty);
    }

    public void addAvailableInventory(int mProductId, BigDecimal qty) {
        this.availableInventory.put(mProductId, qty);
    }

    private X_M_ReplenishPlanLine getX_M_ReplenishPlanLine(MiniMRPProduct miniMrpProduct, int line, String type) {
        X_M_ReplenishPlanLine miniMRP = new X_M_ReplenishPlanLine(this.getCtx(), 0, this.get_TrxName());
        miniMRP.setM_Product_ID(miniMrpProduct.getM_Product_ID());
        miniMRP.setM_Product_Category_ID(miniMrpProduct.getM_Product_Category_ID());
        miniMRP.setProductName(miniMrpProduct.getName());
        miniMRP.setLine(line);
        miniMRP.setM_ReplenishPlan_ID(this.getRecord_ID());
        miniMRP.setRecordType(type);
        miniMRP.setDateStart(this.getDateStart());
        miniMRP.setDateFinish(this.getDateFinish());
        return miniMRP;
    }

    public void calculateSuggestedOrders(MiniMRPProduct miniMrpProduct, Map<Integer, BigDecimal> totalDemandLine, Map<Integer, BigDecimal> totalSupplyLine, Map<Integer, BigDecimal> openingBalanceLine, Map<Integer, BigDecimal> closingBalanceLine) {
        int horizon = TimeUtil.getWeeksBetween(this.getDateStart(), this.getDateFinish());
        for (int week = 1; week <= horizon; ++week) {
            BigDecimal sugQty;
            BigDecimal totalDemand = Env.ZERO;
            BigDecimal totalSupply = Env.ZERO;
            BigDecimal openingBalance = Env.ZERO;
            if (totalDemandLine.containsKey(week) && (totalDemand = totalDemandLine.get(week)) == null) {
                totalDemand = Env.ZERO;
            }
            if (totalSupplyLine.containsKey(week) && (totalSupply = totalSupplyLine.get(week)) == null) {
                totalSupply = Env.ZERO;
            }
            if (openingBalanceLine.containsKey(week) && (openingBalance = openingBalanceLine.get(week)) == null) {
                openingBalance = Env.ZERO;
            }
            if ((sugQty = totalDemand.subtract(totalSupply.add(openingBalance))).compareTo(Env.ZERO) > 0) {
                openingBalanceLine.put(week + 1, Env.ZERO);
                closingBalanceLine.put(week, Env.ZERO);
                continue;
            }
            openingBalanceLine.put(week + 1, sugQty.negate());
            closingBalanceLine.put(week, sugQty.negate());
        }
    }

    public Map<Integer, BigDecimal> insertOrderDemands(MiniMRPProduct miniMrpProduct) {
        Map<Integer, Map<Integer, BigDecimal>> orderDemands = miniMrpProduct.getDemand();
        HashMap<Integer, BigDecimal> totalDemandLine = new HashMap<Integer, BigDecimal>();
        SimpleDateFormat format = DisplayType.getDateFormat(15);
        if (!orderDemands.isEmpty()) {
            for (Integer orderId : orderDemands.keySet()) {
                Map<Integer, BigDecimal> weeklyDemand = orderDemands.get(orderId);
                if (weeklyDemand.size() > 0) {
                    X_M_ReplenishPlanLine miniMRP = this.getX_M_ReplenishPlanLine(miniMrpProduct, this.lineNo, "OD");
                    miniMRP.setC_Order_ID(orderId);
                    MOrder order = new MOrder(this.getCtx(), orderId, this.get_TrxName());
                    miniMRP.setOrderInfo(order.getDocumentNo() + " - " + format.format(order.getDatePromised()));
                    for (Integer week : weeklyDemand.keySet()) {
                        BigDecimal qty = weeklyDemand.get(week);
                        this.setWeeklyData(miniMRP, week, qty);
                        if (totalDemandLine.containsKey(week)) {
                            qty = qty.add((BigDecimal)totalDemandLine.get(week));
                        }
                        totalDemandLine.put(week, qty);
                    }
                    miniMRP.saveEx();
                }
                this.lineNo += 10;
            }
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int paramCount = 1;
        try {
            String sql = new String("SELECT p.M_Production_ID, p.DocumentNo, p.DatePromised, SUM(QtyUsed) AS QtyUsed FROM M_Production p INNER JOIN M_ProductionLine pl ON (pl.M_Production_ID = p.M_Production_ID) WHERE p.Processed='N' AND pl.IsEndProduct = 'N' AND pl.M_Product_ID = ?AND p.C_DocType_ID=? AND DatePromised BETWEEN ? AND ? GROUP BY p.M_Production_ID, p.DocumentNo, p.DatePromised ORDER BY p.DatePromised");
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(paramCount++, miniMrpProduct.getM_Product_ID());
            pstmt.setInt(paramCount++, this.docTypePlannedOrder);
            pstmt.setTimestamp(paramCount++, this.getDateStart());
            pstmt.setTimestamp(paramCount++, this.getDateFinish());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                this.insertProductionDemand(miniMrpProduct, totalDemandLine, rs.getInt("M_Production_ID"), rs.getString("DocumentNo"), rs.getTimestamp("DatePromised"), rs.getBigDecimal("QtyUsed"), "Planned");
            }
        }
        catch (Exception e) {
            try {
                this.log.severe(e.getLocalizedMessage());
                throw new AdempiereException(e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        List productionList = new Query(this.getCtx(), "M_Production", "Processed = 'N' AND DatePromised BETWEEN ? AND ? AND (C_DocType_ID IS NULL OR C_DocType_ID != ?) AND EXISTS(SELECT 1 FROM M_ProductionLine pl \t\t\tWHERE pl.M_Production_ID = M_Production.M_Production_ID\t\t\tAND pl.IsEndProduct = 'N' \t\t\tAND pl.M_Product_ID = ?)", this.get_TrxName()).setParameters(this.getDateStart(), this.getDateFinish(), this.docTypePlannedOrder, miniMrpProduct.getM_Product_ID()).setClient_ID().list();
        productionList.stream().forEach(production -> {
            BigDecimal qty = DB.getSQLValueBD(this.get_TrxName(), "SELECT SUM(QtyUsed) FROM M_ProductionLine WHERE M_Production_ID = ? AND M_Product_ID = ?", production.getM_Product_ID(), miniMrpProduct.getM_Product_ID(), this.getAD_Client_ID());
            if (qty == null) {
                qty = Env.ZERO;
            }
            this.insertProductionDemand(miniMrpProduct, totalDemandLine, production.getM_Production_ID(), production.getDocumentNo(), production.getDatePromised(), qty, "Confirm");
        });
        if (!totalDemandLine.isEmpty()) {
            this.insertTotalLine(miniMrpProduct, totalDemandLine, "TD");
        }
        return totalDemandLine;
    }

    private void insertProductionDemand(MiniMRPProduct miniMrpProduct, Map<Integer, BigDecimal> totalDemandLine, int mProduction_ID, String documentNo, Timestamp promisedDate, BigDecimal qtyUsed, String prodType) {
        X_M_ReplenishPlanLine miniMRP = this.getX_M_ReplenishPlanLine(miniMrpProduct, this.lineNo, "OD");
        miniMRP.setM_Production_ID(mProduction_ID);
        String datePromised = null;
        int week = 0;
        datePromised = DisplayType.getDateFormat(15).format(promisedDate);
        week = TimeUtil.getWeeksBetween(this.getDateStart(), promisedDate);
        miniMRP.setProductionInfo(documentNo + " - " + datePromised + " - " + prodType);
        this.setWeeklyData(miniMRP, week, qtyUsed);
        if (totalDemandLine.containsKey(week)) {
            BigDecimal totalDemand = totalDemandLine.get(week);
            if (totalDemand == null) {
                totalDemand = Env.ZERO;
            }
            qtyUsed = qtyUsed.add(totalDemand);
        }
        totalDemandLine.put(week, qtyUsed);
        miniMRP.saveEx();
        this.lineNo += 10;
    }

    public void insertTotalLine(MiniMRPProduct miniMrpProduct, Map<Integer, BigDecimal> totalLine, String lineType) {
        if (!totalLine.isEmpty()) {
            X_M_ReplenishPlanLine miniMRP = this.getX_M_ReplenishPlanLine(miniMrpProduct, this.lineNo, lineType);
            for (Integer week : totalLine.keySet()) {
                BigDecimal qty = totalLine.get(week);
                this.setWeeklyData(miniMRP, week, qty);
            }
            miniMRP.saveEx();
        }
        this.lineNo += 10;
    }

    public Map<Integer, BigDecimal> insertSupplyLines(MiniMRPProduct miniMrpProduct) {
        HashMap<Integer, BigDecimal> totalSupplyLine = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> subTotalSupplyLine = new HashMap<Integer, BigDecimal>();
        this.insertSupplyLineMO(miniMrpProduct, totalSupplyLine, subTotalSupplyLine, false);
        this.insertTotalSupplyProductionLine(miniMrpProduct, subTotalSupplyLine, false);
        subTotalSupplyLine.clear();
        this.insertSupplyLineMO(miniMrpProduct, totalSupplyLine, subTotalSupplyLine, true);
        this.insertTotalSupplyProductionLine(miniMrpProduct, subTotalSupplyLine, true);
        subTotalSupplyLine.clear();
        this.insertSupplyLinePO(miniMrpProduct, totalSupplyLine, subTotalSupplyLine, true);
        this.insertTotalSupplyLine(miniMrpProduct, subTotalSupplyLine, true);
        subTotalSupplyLine.clear();
        this.insertSupplyLinePO(miniMrpProduct, totalSupplyLine, subTotalSupplyLine, false);
        this.insertTotalSupplyLine(miniMrpProduct, subTotalSupplyLine, false);
        if (!totalSupplyLine.isEmpty()) {
            this.insertTotalLine(miniMrpProduct, totalSupplyLine, "TS");
        }
        return totalSupplyLine;
    }

    public void insertSupplyLineMO(MiniMRPProduct miniMrpProduct, Map<Integer, BigDecimal> totalSupplyLine, Map<Integer, BigDecimal> subTotalSupplyLine, boolean isPlannedOrder) {
        TreeMap<Integer, Map<Integer, BigDecimal>> supplyLineMO = new TreeMap<Integer, Map<Integer, BigDecimal>>(miniMrpProduct.getSupplyLineMO());
        SimpleDateFormat format = DisplayType.getDateFormat(15);
        if (!supplyLineMO.isEmpty()) {
            for (Integer M_Production_ID : supplyLineMO.keySet()) {
                Map weeklyDemand = (Map)supplyLineMO.get(M_Production_ID);
                MProduction production = new MProduction(this.getCtx(), M_Production_ID, this.get_TrxName());
                if ((isPlannedOrder || production.getC_DocType_ID() == this.docTypePlannedOrder) && (!isPlannedOrder || production.getC_DocType_ID() != this.docTypePlannedOrder)) continue;
                if (weeklyDemand.size() > 0) {
                    X_M_ReplenishPlanLine miniMRP = this.getX_M_ReplenishPlanLine(miniMrpProduct, this.lineNo, isPlannedOrder ? "PP" : "CP");
                    miniMRP.setM_Production_ID(M_Production_ID);
                    miniMRP.setProductionInfo(production.getDocumentNo() + " - " + format.format(production.getDatePromised()));
                    for (Integer week : weeklyDemand.keySet()) {
                        BigDecimal qty = (BigDecimal)weeklyDemand.get(week);
                        this.setWeeklyData(miniMRP, week, qty);
                        if (totalSupplyLine.containsKey(week)) {
                            qty = qty.add(totalSupplyLine.get(week));
                        }
                        totalSupplyLine.put(week, qty);
                        BigDecimal qtyProd = (BigDecimal)weeklyDemand.get(week);
                        if (subTotalSupplyLine.containsKey(week)) {
                            qtyProd = qtyProd.add(subTotalSupplyLine.get(week));
                        }
                        subTotalSupplyLine.put(week, qtyProd);
                    }
                    miniMRP.saveEx();
                }
                this.lineNo += 10;
            }
        }
    }

    public void insertSupplyLinePO(MiniMRPProduct miniMrpProduct, Map<Integer, BigDecimal> totalSupplyLine, Map<Integer, BigDecimal> subTotalSupplyLine, boolean isPO) {
        String typeSupply;
        Map<Integer, Map<Integer, BigDecimal>> supplyLine;
        if (isPO) {
            supplyLine = miniMrpProduct.getSupplyLinePO();
            typeSupply = "SP";
        } else {
            supplyLine = miniMrpProduct.getSupplyLineRQ();
            typeSupply = "SR";
        }
        SimpleDateFormat format = DisplayType.getDateFormat(15);
        if (!supplyLine.isEmpty()) {
            for (Integer columnID : supplyLine.keySet()) {
                Map<Integer, BigDecimal> weeklyDemand = supplyLine.get(columnID);
                if (weeklyDemand.size() > 0) {
                    Timestamp datePromised;
                    X_M_ReplenishPlanLine miniMRP = this.getX_M_ReplenishPlanLine(miniMrpProduct, this.lineNo, typeSupply);
                    String docNo = null;
                    if (isPO) {
                        miniMRP.setC_Order_ID(columnID);
                        MOrder order = new MOrder(this.getCtx(), columnID, this.get_TrxName());
                        datePromised = order.getDatePromised();
                        docNo = order.getDocumentNo();
                    } else {
                        miniMRP.setM_Requisition_ID(columnID);
                        MRequisition req = new MRequisition(this.getCtx(), columnID, this.get_TrxName());
                        datePromised = req.getDateRequired();
                        docNo = req.getDocumentNo();
                    }
                    miniMRP.setOrderInfo(docNo + " - " + format.format(datePromised));
                    for (Integer week : weeklyDemand.keySet()) {
                        BigDecimal qty = weeklyDemand.get(week);
                        this.setWeeklyData(miniMRP, week, qty);
                        if (totalSupplyLine.containsKey(week)) {
                            qty = qty.add(totalSupplyLine.get(week));
                        }
                        totalSupplyLine.put(week, qty);
                        BigDecimal qtyProd = weeklyDemand.get(week);
                        if (subTotalSupplyLine.containsKey(week)) {
                            qtyProd = qtyProd.add(subTotalSupplyLine.get(week));
                        }
                        subTotalSupplyLine.put(week, qtyProd);
                    }
                    miniMRP.saveEx();
                }
                this.lineNo += 10;
            }
        }
    }

    public void insertTotalSupplyLine(MiniMRPProduct miniMrpProduct, Map<Integer, BigDecimal> subTotalSupplyLine, boolean isPO) {
        if (!subTotalSupplyLine.isEmpty()) {
            X_M_ReplenishPlanLine miniMRP = this.getX_M_ReplenishPlanLine(miniMrpProduct, this.lineNo, isPO ? "TP" : "TR");
            for (Integer week : subTotalSupplyLine.keySet()) {
                BigDecimal qty = subTotalSupplyLine.get(week);
                this.setWeeklyData(miniMRP, week, qty);
            }
            miniMRP.saveEx();
        }
        this.lineNo += 10;
    }

    public void insertTotalSupplyProductionLine(MiniMRPProduct miniMrpProduct, Map<Integer, BigDecimal> subTotalSupplyLine, boolean isPlanned) {
        if (!subTotalSupplyLine.isEmpty()) {
            X_M_ReplenishPlanLine miniMRP = this.getX_M_ReplenishPlanLine(miniMrpProduct, this.lineNo, isPlanned ? "TM" : "TC");
            for (Integer week : subTotalSupplyLine.keySet()) {
                BigDecimal qty = subTotalSupplyLine.get(week);
                this.setWeeklyData(miniMRP, week, qty);
            }
            miniMRP.saveEx();
        }
        this.lineNo += 10;
    }

    public void insertOpeningBalanceLine(MiniMRPProduct miniMrpProduct, Map<Integer, BigDecimal> openingBalanceLine) {
        if (!openingBalanceLine.isEmpty()) {
            X_M_ReplenishPlanLine miniMRP = this.getX_M_ReplenishPlanLine(miniMrpProduct, 10, "OB" + (miniMrpProduct.isPhantom ? " - Phantom Product" : ""));
            for (Integer week : openingBalanceLine.keySet()) {
                this.setWeeklyData(miniMRP, week, openingBalanceLine.get(week));
            }
            miniMRP.saveEx();
        }
    }

    public void insertClosingBalanceLine(MiniMRPProduct miniMrpProduct, Map<Integer, BigDecimal> closingBalanceLine) {
        if (!closingBalanceLine.isEmpty()) {
            X_M_ReplenishPlanLine miniMRP = this.getX_M_ReplenishPlanLine(miniMrpProduct, this.lineNo, "CB");
            for (Integer week : closingBalanceLine.keySet()) {
                this.setWeeklyData(miniMRP, week, closingBalanceLine.get(week));
            }
            miniMRP.saveEx();
        }
    }

    private void renderPeggingReport(Map<Integer, MiniMRPProduct> miniMrpProducts) {
        for (MiniMRPProduct miniMrpProduct : miniMrpProducts.values()) {
            this.lineNo = 20;
            HashMap<Integer, BigDecimal> openingBalanceLine = new HashMap<Integer, BigDecimal>();
            HashMap<Integer, BigDecimal> closingBalanceLine = new HashMap<Integer, BigDecimal>();
            if (this.availableInventory.containsKey(miniMrpProduct.getM_Product_ID())) {
                BigDecimal qty = this.availableInventory.get(miniMrpProduct.getM_Product_ID());
                openingBalanceLine.put(1, qty);
            }
            Map<Integer, BigDecimal> totalDemandLine = this.insertOrderDemands(miniMrpProduct);
            Map<Integer, BigDecimal> totalSupplyLine = this.insertSupplyLines(miniMrpProduct);
            this.calculateSuggestedOrders(miniMrpProduct, totalDemandLine, totalSupplyLine, openingBalanceLine, closingBalanceLine);
            this.insertClosingBalanceLine(miniMrpProduct, closingBalanceLine);
            this.insertOpeningBalanceLine(miniMrpProduct, openingBalanceLine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forOpenMO(Map<Integer, MiniMRPProduct> miniMrpProducts, Set<Integer> productIds) {
        String sql = new String("SELECT mprod.M_Production_ID, mprod.M_Product_ID, SUM(mprod.ProductionQty) AS OrderedQty, mprod.DatePromised FROM M_Production mprod WHERE mprod.IsActive='Y' AND mprod.Processed='N' AND mprod.DatePromised BETWEEN ? AND ? AND mprod.AD_Client_ID = ? AND mprod.M_Product_ID IN" + productIds.toString().replace('[', '(').replace(']', ')') + " GROUP BY mprod.M_Product_ID, mprod.M_Production_ID, mprod.DatePromised ORDER BY mprod.M_Product_ID, mprod.DatePromised");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int paramCount = 1;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setTimestamp(paramCount++, this.getDateStart());
            pstmt.setTimestamp(paramCount++, this.getDateFinish());
            pstmt.setInt(paramCount++, this.getAD_Client_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int productionId = rs.getInt("M_Production_ID");
                int productId = rs.getInt("M_Product_ID");
                BigDecimal orderQty = rs.getBigDecimal("OrderedQty");
                Timestamp datePromised = rs.getTimestamp("DatePromised");
                int weekPromised = TimeUtil.getWeeksBetween(this.getDateStart(), datePromised);
                MiniMRPProduct product = miniMrpProducts.get(productId);
                product.setSupplyLineMO(productionId, weekPromised, orderQty);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forOpenPO(Map<Integer, MiniMRPProduct> miniMrpProducts, Set<Integer> productIds) {
        String sql = new String("SELECT co.C_Order_ID, col.M_Product_ID, SUM(col.QtyOrdered - col.QtyDelivered) AS OrderedQty, co.DatePromised FROM C_Order co INNER JOIN C_OrderLine col ON(co.C_Order_ID = col.C_Order_ID) WHERE co.IsSOTrx='N' AND co.DocStatus = 'CO' AND col.QtyOrdered > col.QtyDelivered AND col.DatePromised BETWEEN ? AND ? AND co.AD_Client_ID = ? AND col.M_Product_ID IN" + productIds.toString().replace('[', '(').replace(']', ')') + " GROUP BY col.M_Product_ID, co.C_Order_ID, co.DatePromised ORDER BY col.M_Product_ID, co.DatePromised");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int paramCount = 1;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setTimestamp(paramCount++, this.getDateStart());
            pstmt.setTimestamp(paramCount++, this.getDateFinish());
            pstmt.setInt(paramCount++, this.getAD_Client_ID());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int productId = rs.getInt("M_Product_ID");
                BigDecimal orderQty = rs.getBigDecimal("OrderedQty");
                Timestamp datePromised = rs.getTimestamp("DatePromised");
                int weekPromised = TimeUtil.getWeeksBetween(this.getDateStart(), datePromised);
                MiniMRPProduct product = miniMrpProducts.get(productId);
                int orderId = rs.getInt("C_Order_ID");
                product.setSupplyLinePO(orderId, weekPromised, orderQty);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forOpenRQ(Map<Integer, MiniMRPProduct> miniMrpProducts, Set<Integer> productIds) {
        String sql = new String("SELECT r.M_Requisition_ID, rl.M_Product_ID, SUM(rl.Qty) AS OrderedQty, r.DateRequired FROM M_Requisition r INNER JOIN M_RequisitionLine rl ON (r.M_Requisition_ID = rl.M_Requisition_ID) WHERE r.DocStatus = 'DR' AND r.DateRequired BETWEEN ? AND ? AND rl.IsActive = 'Y' AND r.AD_Client_ID = ? AND rl.M_Product_ID IN" + productIds.toString().replace('[', '(').replace(']', ')') + " AND r.C_DocType_ID = ? GROUP BY rl.M_Product_ID, r.M_Requisition_ID, r.DateRequired ORDER BY rl.M_Product_ID, r.DateRequired");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        int paramCount = 1;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setTimestamp(paramCount++, this.getDateStart());
            pstmt.setTimestamp(paramCount++, this.getDateFinish());
            pstmt.setInt(paramCount++, this.getAD_Client_ID());
            pstmt.setInt(paramCount++, this.docTypeMRPRequisition);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                int productId = rs.getInt("M_Product_ID");
                BigDecimal orderQty = rs.getBigDecimal("OrderedQty");
                Timestamp dateRequired = rs.getTimestamp("DateRequired");
                int weekPromised = TimeUtil.getWeeksBetween(this.getDateStart(), dateRequired);
                MiniMRPProduct product = miniMrpProducts.get(productId);
                int requisitionId = rs.getInt("M_Requisition_ID");
                product.setSupplyLineRQ(requisitionId, weekPromised, orderQty);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private void doRunOpenOrders(Map<Integer, MiniMRPProduct> miniMrpProducts, Set<Integer> productIds, String type) {
        if (type.equals(TYPE_MO)) {
            this.forOpenMO(miniMrpProducts, productIds);
        } else if (type.equals(TYPE_PO)) {
            this.forOpenPO(miniMrpProducts, productIds);
        } else if (type.equals(TYPE_RQ)) {
            this.forOpenRQ(miniMrpProducts, productIds);
        }
    }

    private void doRunProductsSO(Map<Integer, MiniMRPProduct> miniMrpProducts, Set<Integer> productIds) {
        List lines = new Query(this.getCtx(), "C_OrderLine", "DatePromised BETWEEN ? AND ? AND (COALESCE(QtyOrdered, 0) - COALESCE(QtyDelivered, 0)) > 0  AND M_Product_ID IN" + productIds.toString().replace('[', '(').replace(']', ')') + " AND EXISTS(SELECT 1 FROM C_Order o \t\t\t\tWHERE o.C_Order_ID = C_OrderLine.C_Order_ID\t\t\t\tAND o.DocStatus = 'CO'\t\t\t\tAND o.IsSOTrx = 'Y')", this.get_TrxName()).setParameters(this.getDateStart(), this.getDateFinish()).setClient_ID().setOrderBy("DatePromised").list();
        lines.stream().filter(orderLinePhantom -> !orderLinePhantom.getM_Product().isPhantom()).forEach(orderLine -> {
            if (miniMrpProducts.containsKey(orderLine.getM_Product_ID())) {
                MiniMRPProduct mrpProduct = (MiniMRPProduct)miniMrpProducts.get(orderLine.getM_Product_ID());
                this.setQtyAsDemand(orderLine.getM_Product_ID(), orderLine.getQtyReserved(), orderLine.getDatePromised());
                int weekPromised = TimeUtil.getWeeksBetween(this.getDateStart(), orderLine.getDatePromised());
                mrpProduct.explodeDemand(orderLine.getC_Order_ID(), orderLine.getQtyReserved(), weekPromised, miniMrpProducts);
            } else {
                this.log.log(Level.SEVERE, "Error in miniMrpProducts setup.");
            }
        });
    }

    private void setQtyAsDemand(int mProductID, BigDecimal qty, java.util.Date date) {
        if (this.mapDemand.containsKey(date)) {
            Map<Integer, BigDecimal> mapOrderQty = this.mapDemand.get(date);
            if (mapOrderQty.containsKey(mProductID)) {
                mapOrderQty.put(mProductID, mapOrderQty.get(mProductID).add(qty));
            } else {
                mapOrderQty.put(mProductID, qty);
            }
        } else {
            HashMap<Integer, BigDecimal> mapOrderQty = new HashMap<Integer, BigDecimal>();
            mapOrderQty.put(mProductID, qty);
            this.mapDemand.put(date, mapOrderQty);
        }
    }

    private List<MReplenish> getReplenishList(int warehouseId, int productId) {
        StringBuffer whereClause = new StringBuffer("AD_Client_ID = ?");
        ArrayList<Object> param = new ArrayList<Object>();
        param.add(this.getAD_Client_ID());
        whereClause.append(" AND M_Warehouse_ID = ?");
        param.add(warehouseId);
        if (productId != 0) {
            whereClause.append(" AND M_Product_ID = ?");
            param.add(productId);
        }
        whereClause.append(" AND EXISTS(SELECT 1 FROM M_Product p WHERE p.M_Product_ID = M_Replenish.M_Product_ID AND p.IsActive = ? AND p.IsStocked = ?)");
        param.add("Y");
        param.add("Y");
        List<MReplenish> productReplenish = new Query(this.getCtx(), "M_Replenish", whereClause.toString(), this.get_TrxName()).setParameters(param).setOnlyActiveRecords(true).list();
        return productReplenish;
    }

    private void generateProductInfo(Map<Integer, MiniMRPProduct> miniMrpProducts, Set<Integer> productIds) {
        List<MReplenish> productReplenish = this.getReplenishList(this.getWarehouseId(), this.getProductId());
        if (productReplenish.size() == 0) {
            throw new AdempiereException("@M_Replenish_ID@ @NotFound@");
        }
        productReplenish.stream().forEach(replenish -> {
            MiniMRPProduct miniMrpProduct;
            if (!miniMrpProducts.containsKey(replenish.getM_Product_ID()) && (miniMrpProduct = this.addProductToProcess((MReplenish)replenish, miniMrpProducts, productIds)).isBOM() && miniMrpProduct.isVerified()) {
                this.processBOMLines(miniMrpProducts, productIds, miniMrpProduct.getM_Product_ID());
            }
        });
    }

    private MiniMRPProduct addProductToProcess(MReplenish replenish, Map<Integer, MiniMRPProduct> miniMrpProducts, Set<Integer> productIds) {
        MProduct product = MProduct.get(this.getCtx(), replenish.getM_Product_ID());
        MProductPO[] productPO = MProductPO.getOfProduct(this.getCtx(), product.getM_Product_ID(), this.get_TrxName());
        int bPartnerId = 0;
        if (productPO.length > 0) {
            bPartnerId = productPO[0].getC_BPartner_ID();
        }
        BigDecimal levelMin = replenish.getLevel_Min();
        BigDecimal availableInventory = MStorage.getQtyAvailable(this.getWarehouseId(), 0, product.getM_Product_ID(), 0, this.get_TrxName());
        if (availableInventory == null) {
            availableInventory = Env.ZERO;
        }
        if (product.isPhantom()) {
            levelMin = Env.ZERO;
            availableInventory = Env.ZERO;
        }
        MProductPricing price = new MProductPricing(product.getM_Product_ID(), bPartnerId, levelMin, false, this.get_TrxName());
        price.setM_PriceList_ID(this.priceListId);
        price.calculatePrice();
        MiniMRPProduct miniMrpProduct = new MiniMRPProduct(product.getM_Product_ID());
        miniMrpProduct.setAvailableQty(availableInventory);
        miniMrpProduct.setName(product.getName());
        miniMrpProduct.setM_Product_Category_ID(product.getM_Product_Category_ID());
        miniMrpProduct.setProjectedLeadTime(0);
        miniMrpProduct.setBOM(product.isBOM());
        miniMrpProduct.setVerified(product.isVerified());
        miniMrpProduct.setPurchased(product.isPurchased());
        miniMrpProduct.setPhantom(product.isPhantom());
        miniMrpProduct.setC_BPartner_ID(bPartnerId);
        miniMrpProduct.setPriceActual(price.getPriceList());
        miniMrpProduct.setQtyBatchSize(replenish.getQtyBatchSize());
        miniMrpProduct.setLevel_Min(levelMin);
        miniMrpProduct.setReplenishTypeMRPCalculated(replenish.getReplenishType().equals("4"));
        if (miniMrpProduct.isReplenishTypeMRPCalculated()) {
            miniMrpProduct.setQtyOnHand(availableInventory.subtract(levelMin));
        } else {
            miniMrpProduct.setQtyOnHand(availableInventory);
        }
        if (miniMrpProduct.getQtyOnHand().compareTo(Env.ZERO) < 0 && !product.isPhantom()) {
            this.setQtyAsDemand(product.getM_Product_ID(), miniMrpProduct.getQtyOnHand().negate(), this.getDateStart());
            miniMrpProduct.setQtyOnHand(Env.ZERO);
        }
        productIds.add(product.getM_Product_ID());
        miniMrpProducts.put(product.getM_Product_ID(), miniMrpProduct);
        this.addAvailableInventory(product.getM_Product_ID(), availableInventory);
        this.setConfirmProductQty(miniMrpProduct);
        return miniMrpProduct;
    }

    private void explodeRequiredMaterials(MiniMRPProduct miniMrpProduct, MiniMRPProduct parentProduct, BigDecimal qtyBom) {
        Map<Integer, BigDecimal> requiredProdMaterials = miniMrpProduct.getRequiredProdMaterials();
        for (Integer mProdId : requiredProdMaterials.keySet()) {
            BigDecimal qty = requiredProdMaterials.get(mProdId);
            parentProduct.addMaterials(mProdId, qtyBom.multiply(qty));
        }
    }

    public void processBOMLines(Map<Integer, MiniMRPProduct> miniMrpProducts, Set<Integer> productIds, int M_Product_ID) {
        MProduct product = MProduct.get(this.getCtx(), M_Product_ID);
        List<MPPProductBOM> boms = MPPProductBOM.getProductBOMs(product);
        if (boms.size() > 0) {
            for (MPPProductBOMLine line : boms.get(0).getLines()) {
                List<MReplenish> productReplenish = this.getReplenishList(this.getWarehouseId(), this.getProductId());
                productReplenish.stream().forEach(replenish -> {
                    BigDecimal qtyBom = line.getQtyBOM();
                    MiniMRPProduct parentProduct = (MiniMRPProduct)miniMrpProducts.get(M_Product_ID);
                    parentProduct.addMaterials(line.getM_Product_ID(), qtyBom);
                    MiniMRPProduct miniMrpProduct = null;
                    if (miniMrpProducts.containsKey(line.getM_Product_ID())) {
                        miniMrpProduct = (MiniMRPProduct)miniMrpProducts.get(line.getM_Product_ID());
                        this.explodeRequiredMaterials(miniMrpProduct, parentProduct, qtyBom);
                    } else {
                        miniMrpProduct = this.addProductToProcess((MReplenish)replenish, miniMrpProducts, productIds);
                        if (miniMrpProduct.isBOM() && miniMrpProduct.isVerified()) {
                            this.processBOMLines(miniMrpProducts, productIds, line.getM_Product_ID());
                            this.explodeRequiredMaterials(miniMrpProduct, parentProduct, qtyBom);
                        }
                    }
                });
            }
        }
    }

    public void setWeeklyData(X_M_ReplenishPlanLine miniMRP, int week, BigDecimal qty) {
        switch (week) {
            case 0: {
                miniMRP.setWeek1(qty);
                break;
            }
            case 1: {
                miniMRP.setWeek2(qty);
                break;
            }
            case 2: {
                miniMRP.setWeek3(qty);
                break;
            }
            case 3: {
                miniMRP.setWeek4(qty);
                break;
            }
            case 4: {
                miniMRP.setWeek5(qty);
                break;
            }
            case 5: {
                miniMRP.setWeek6(qty);
                break;
            }
            case 6: {
                miniMRP.setWeek7(qty);
                break;
            }
            case 7: {
                miniMRP.setWeek8(qty);
                break;
            }
            case 8: {
                miniMRP.setWeek9(qty);
                break;
            }
            case 9: {
                miniMRP.setWeek10(qty);
                break;
            }
            case 10: {
                miniMRP.setWeek11(qty);
                break;
            }
            case 11: {
                miniMRP.setWeek12(qty);
                break;
            }
            case 12: {
                miniMRP.setWeek13(qty);
                break;
            }
            case 13: {
                miniMRP.setWeek14(qty);
                break;
            }
            case 14: {
                miniMRP.setWeek15(qty);
                break;
            }
            case 15: {
                miniMRP.setWeek16(qty);
                break;
            }
            case 16: {
                miniMRP.setWeek17(qty);
                break;
            }
            case 17: {
                miniMRP.setWeek18(qty);
                break;
            }
            case 18: {
                miniMRP.setWeek19(qty);
                break;
            }
            case 19: {
                miniMRP.setWeek20(qty);
                break;
            }
            case 20: {
                miniMRP.setWeek21(qty);
                break;
            }
            case 21: {
                miniMRP.setWeek22(qty);
                break;
            }
            case 22: {
                miniMRP.setWeek23(qty);
                break;
            }
            case 23: {
                miniMRP.setWeek24(qty);
                break;
            }
        }
    }

    class MiniMRPProduct {
        private MiniMRPProduct parent;
        private int M_Product_ID;
        private int projectedLeadTimeInWeek = 1;
        private int M_Product_Category_ID;
        private int projectedLeadTime;
        private int C_BPartner_ID;
        private String name;
        private boolean isBOM;
        private boolean isVerified;
        private boolean isPurchased;
        private boolean isPhantom;
        private boolean isReplenishTypeMRPCalculated;
        private BigDecimal availableQty;
        private BigDecimal qtyBal;
        private BigDecimal qtyOnHand = Env.ZERO;
        private BigDecimal priceActual = Env.ZERO;
        private BigDecimal qtyBatchSize = Env.ZERO;
        private BigDecimal level_Min = Env.ZERO;
        private BigDecimal extraQtyPlanned = Env.ZERO;
        private Map<Integer, BigDecimal> requiredProdMaterials = new HashMap<Integer, BigDecimal>();
        private Map<Integer, Map<Integer, BigDecimal>> supplyLinePO = new TreeMap<Integer, Map<Integer, BigDecimal>>();
        private Map<Integer, Map<Integer, BigDecimal>> supplyLineMO = new TreeMap<Integer, Map<Integer, BigDecimal>>();
        private Map<Integer, Map<Integer, BigDecimal>> supplyLineRQ = new TreeMap<Integer, Map<Integer, BigDecimal>>();
        private Map<Integer, Map<Integer, BigDecimal>> demand = new LinkedHashMap<Integer, Map<Integer, BigDecimal>>();
        private Map<java.util.Date, BigDecimal> mapConfirmedProductQty = new HashMap<java.util.Date, BigDecimal>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Map<Integer, Map<Integer, BigDecimal>> getSupplyLinePO() {
            return this.supplyLinePO;
        }

        public Map<Integer, Map<Integer, BigDecimal>> getSupplyLineMO() {
            return this.supplyLineMO;
        }

        public Map<Integer, Map<Integer, BigDecimal>> getSupplyLineRQ() {
            return this.supplyLineRQ;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MiniMRPProduct)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            MiniMRPProduct rhs = (MiniMRPProduct)obj;
            return this.M_Product_ID == rhs.M_Product_ID;
        }

        public void addMaterials(int productId, BigDecimal qty) {
            if (this.requiredProdMaterials.containsKey(productId)) {
                qty = qty.add(this.requiredProdMaterials.get(productId));
            }
            this.requiredProdMaterials.put(productId, qty);
        }

        public void addDemand(int mOrderID, BigDecimal netRequiredQty, int projectdOrderWeek) {
            Map<Integer, BigDecimal> weekDemand = this.getOrderDemand(mOrderID);
            weekDemand.put(projectdOrderWeek, netRequiredQty);
        }

        public void explodeDemand(int mOrderID, BigDecimal orderQty, int weekPromised, Map<Integer, MiniMRPProduct> miniMrpProducts) {
            BigDecimal netRequiredQty = orderQty;
            this.addDemand(mOrderID, netRequiredQty, weekPromised);
        }

        public Map<Integer, Map<Integer, BigDecimal>> getDemand() {
            return this.demand;
        }

        public Map<Integer, BigDecimal> getOrderDemand(int mOrderID) {
            HashMap<Integer, BigDecimal> weekDemand = null;
            if (this.demand.containsKey(mOrderID)) {
                weekDemand = this.demand.get(mOrderID);
            } else {
                weekDemand = new HashMap();
                this.demand.put(mOrderID, weekDemand);
            }
            return weekDemand;
        }

        public void setSupplyLinePO(int c_order_id, int week, BigDecimal openPOqty) {
            Map<Object, Object> weekDemand = null;
            if (this.supplyLinePO.containsKey(c_order_id)) {
                weekDemand = this.supplyLinePO.get(c_order_id);
                openPOqty = openPOqty.add((BigDecimal)weekDemand.get(week));
                weekDemand.put(week, openPOqty);
            } else {
                weekDemand = new HashMap<Integer, BigDecimal>();
                weekDemand.put(week, openPOqty);
            }
            this.supplyLinePO.put(c_order_id, weekDemand);
        }

        public void setSupplyLineMO(int m_production_id, int week, BigDecimal openMOqty) {
            Map<Object, Object> weekDemand = null;
            if (this.supplyLineMO.containsKey(m_production_id)) {
                weekDemand = this.supplyLineMO.get(m_production_id);
                openMOqty = openMOqty.add((BigDecimal)weekDemand.get(week));
                weekDemand.put(week, openMOqty);
            } else {
                weekDemand = new HashMap<Integer, BigDecimal>();
                weekDemand.put(week, openMOqty);
            }
            this.supplyLineMO.put(m_production_id, weekDemand);
        }

        public void setSupplyLineRQ(int m_requisition_id, int week, BigDecimal openRQqty) {
            Map<Object, Object> weekDemand = null;
            if (this.supplyLineRQ.containsKey(m_requisition_id)) {
                weekDemand = this.supplyLineRQ.get(m_requisition_id);
                openRQqty = openRQqty.add((BigDecimal)weekDemand.get(week));
                weekDemand.put(week, openRQqty);
            } else {
                weekDemand = new HashMap<Integer, BigDecimal>();
                weekDemand.put(week, openRQqty);
            }
            this.supplyLineRQ.put(m_requisition_id, weekDemand);
        }

        public BigDecimal explod(BigDecimal totalRequiredQty) {
            if (this.getQtyBal().compareTo(Env.ZERO) != 0) {
                BigDecimal avaibleInventory = this.getAvailableQty();
                if (avaibleInventory.compareTo(totalRequiredQty) > 0) {
                    this.setAvailableQty(avaibleInventory.subtract(totalRequiredQty));
                    totalRequiredQty = Env.ZERO;
                } else {
                    totalRequiredQty = totalRequiredQty.subtract(avaibleInventory);
                    this.setAvailableQty(Env.ZERO);
                }
            }
            return totalRequiredQty;
        }

        public boolean hasParent() {
            return this.parent != null;
        }

        public int getM_Product_ID() {
            return this.M_Product_ID;
        }

        public MiniMRPProduct(int M_Product_ID) {
            this.M_Product_ID = M_Product_ID;
        }

        public boolean isVerified() {
            return this.isVerified;
        }

        public void setVerified(boolean isVerified) {
            this.isVerified = isVerified;
        }

        public int getProjectedLeadTime() {
            return this.projectedLeadTime;
        }

        public int getProjectedLeadTimeInWeek() {
            return this.projectedLeadTimeInWeek;
        }

        public void setProjectedLeadTime(int projectedLeadTime) {
            this.projectedLeadTime = projectedLeadTime;
            if (!this.isBOM() && projectedLeadTime > 0) {
                float projectedLTimeInWeek = (float)projectedLeadTime / 7.0f;
                if (projectedLTimeInWeek - (float)((int)projectedLTimeInWeek) > 0.0f) {
                    this.setProjectedLeadTimeInWeek((int)projectedLTimeInWeek + 1);
                } else {
                    this.setProjectedLeadTimeInWeek((int)projectedLTimeInWeek);
                }
            }
        }

        public void setProjectedLeadTimeInWeek(int projectedLeadTimeWeek) {
            this.projectedLeadTimeInWeek = projectedLeadTimeWeek;
        }

        public BigDecimal getAvailableQty() {
            return this.availableQty;
        }

        public void setAvailableQty(BigDecimal availableQty) {
            this.availableQty = availableQty;
            this.setQtyBal(availableQty);
        }

        public int getM_Product_Category_ID() {
            return this.M_Product_Category_ID;
        }

        public void setM_Product_Category_ID(int m_Product_Category_ID) {
            this.M_Product_Category_ID = m_Product_Category_ID;
        }

        public Map<Integer, BigDecimal> getRequiredProdMaterials() {
            return this.requiredProdMaterials;
        }

        public boolean isBOM() {
            return this.isBOM;
        }

        public void setBOM(boolean isBOM) {
            this.isBOM = isBOM;
        }

        public BigDecimal getQtyBal() {
            return this.qtyBal;
        }

        public void setQtyBal(BigDecimal qtyBal) {
            this.qtyBal = qtyBal;
        }

        public BigDecimal getQtyOnHand() {
            return this.qtyOnHand;
        }

        public void setQtyOnHand(BigDecimal qtyOnHand) {
            this.qtyOnHand = qtyOnHand;
        }

        public Map<java.util.Date, BigDecimal> getMapConfirmProductQty() {
            return this.mapConfirmedProductQty;
        }

        public void setMapConfirmProductQty(Map<java.util.Date, BigDecimal> mapConfirmProductionQty) {
            this.mapConfirmedProductQty = mapConfirmProductionQty;
        }

        public void addConfirmProductionQty(java.util.Date date, BigDecimal qty) {
            if (this.mapConfirmedProductQty.containsKey(date)) {
                qty = this.mapConfirmedProductQty.get(date).add(qty);
            }
            this.mapConfirmedProductQty.put(date, qty);
        }

        public boolean isPurchased() {
            return this.isPurchased;
        }

        public void setPurchased(boolean isPurchased) {
            this.isPurchased = isPurchased;
        }

        public int getC_BPartner_ID() {
            return this.C_BPartner_ID;
        }

        public void setC_BPartner_ID(int c_BPartner_ID) {
            this.C_BPartner_ID = c_BPartner_ID;
        }

        public BigDecimal getPriceActual() {
            return this.priceActual;
        }

        public void setPriceActual(BigDecimal priceActual) {
            this.priceActual = priceActual;
        }

        public boolean isPhantom() {
            return this.isPhantom;
        }

        public void setPhantom(boolean isPhantom) {
            this.isPhantom = isPhantom;
        }

        public BigDecimal getQtyBatchSize() {
            return this.qtyBatchSize;
        }

        public void setQtyBatchSize(BigDecimal qtyBatchSize) {
            this.qtyBatchSize = qtyBatchSize;
        }

        public BigDecimal getLevel_Min() {
            return this.level_Min;
        }

        public void setLevel_Min(BigDecimal level_Min) {
            this.level_Min = level_Min;
        }

        public BigDecimal getExtraQtyPlanned() {
            return this.extraQtyPlanned;
        }

        public void setExtraQtyPlanned(BigDecimal extraQtyPlanned) {
            this.extraQtyPlanned = extraQtyPlanned;
        }

        public boolean isReplenishTypeMRPCalculated() {
            return this.isReplenishTypeMRPCalculated;
        }

        public void setReplenishTypeMRPCalculated(boolean isReplenishTypeMRPCalculated) {
            this.isReplenishTypeMRPCalculated = isReplenishTypeMRPCalculated;
        }
    }
}

