/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process.rpl.imp;

import java.util.logging.Level;
import org.adempiere.process.rpl.XMLHelper;
import org.adempiere.process.rpl.imp.ImportHelper;
import org.compiere.Adempiere;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogMgt;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.w3c.dom.Document;

public class ModelImporter
extends SvrProcess {
    protected int p_AD_Client_ID = 0;
    protected int p_C_DocType_ID = 0;
    protected int p_Record_ID = 0;
    protected int p_EXP_Format_ID = 0;
    protected String p_FileName = "";
    int AD_Table_ID = 0;

    @Override
    protected void prepare() {
        this.p_Record_ID = this.getRecord_ID();
        if (this.p_AD_Client_ID == 0) {
            this.p_AD_Client_ID = Env.getAD_Client_ID(this.getCtx());
        }
        this.AD_Table_ID = this.getTable_ID();
        StringBuffer sb = new StringBuffer("AD_Table_ID=").append(this.AD_Table_ID);
        sb.append("; Record_ID=").append(this.getRecord_ID());
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("EXP_Format_ID")) {
                this.p_EXP_Format_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("FileName")) {
                this.p_FileName = (String)para[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_EXP_Format_ID == 0) {
            this.p_EXP_Format_ID = this.p_Record_ID;
        }
        if (this.p_FileName == null) {
            String fileNameOr = Ini.findAdempiereHome() + System.getProperty("file.separator") + "data" + System.getProperty("file.separator") + "ExportFile.xml";
            this.p_FileName = fileNameOr;
        }
        this.log.info(sb.toString());
    }

    @Override
    protected String doIt() throws Exception {
        Document documentToBeImported = XMLHelper.createDocumentFromFile(this.p_FileName);
        ImportHelper impHelper = new ImportHelper(this.getCtx());
        impHelper.importXMLDocument(documentToBeImported, this.get_TrxName());
        String resultMsg = impHelper.getResultLog();
        this.addLog(0, null, null, Msg.getMsg(this.getCtx(), "ImportModelProcessResult") + "\n" + resultMsg);
        return resultMsg;
    }

    public static void main(String[] args) {
        CLogMgt.setLoggerLevel(Level.INFO, null);
        CLogMgt.setLevel(Level.INFO);
        Adempiere.startupEnvironment(false);
        ProcessInfo pi = new ProcessInfo("Test Import Model", 1000000);
        pi.setAD_Client_ID(11);
        pi.setAD_User_ID(100);
        ModelImporter modelImporter = new ModelImporter();
        modelImporter.startProcess(Env.getCtx(), pi, null);
        System.out.println("Process=" + pi.getTitle() + " Error=" + pi.isError() + " Summary=" + pi.getSummary());
    }
}

