/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process.rpl;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.spin.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLHelper {
    private static XPath xPath = XPathFactory.newInstance().newXPath();

    public static Element getElement(String xPathExpression, Node node) throws XPathExpressionException {
        return (Element)xPath.evaluate(xPathExpression, node, XPathConstants.NODE);
    }

    public static Node getNode(String xPathExpression, Node node) throws XPathExpressionException {
        return (Node)xPath.evaluate(xPathExpression, node, XPathConstants.NODE);
    }

    public static NodeList getNodeList(String xPathExpression, Node node) throws XPathExpressionException {
        return (NodeList)xPath.evaluate(xPathExpression, node, XPathConstants.NODESET);
    }

    public static Double getNumber(String xPathExpression, Node node) throws XPathExpressionException {
        return (Double)xPath.evaluate(xPathExpression, node, XPathConstants.NUMBER);
    }

    public static String getString(String xPathExpression, Node node) throws XPathExpressionException {
        return (String)xPath.evaluate(xPathExpression, node, XPathConstants.STRING);
    }

    public static Boolean getBoolean(String xPathExpression, Node node) throws XPathExpressionException {
        return (Boolean)xPath.evaluate(xPathExpression, node, XPathConstants.BOOLEAN);
    }

    public static Document createDocumentFromFile(String pathToXmlFile) throws ParserConfigurationException, SAXException, IOException {
        String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
        String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        XMLUtils.setDefaultFeatures(documentBuilderFactory);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new File(pathToXmlFile));
        return document;
    }

    public static Document createDocumentFromString(String str) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        XMLUtils.setDefaultFeatures(documentBuilderFactory);
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(str)));
        return document;
    }
}

