/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Optional;
import javax.swing.tree.TreeNode;
import org.adempiere.model.MBrowse;
import org.adempiere.process.SynchronizeEntityTypeAbstract;
import org.compiere.model.MEntityType;
import org.compiere.model.MForm;
import org.compiere.model.MMenu;
import org.compiere.model.MProcess;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.model.MWindow;
import org.compiere.wf.MWorkflow;

public class SynchronizeEntityType
extends SynchronizeEntityTypeAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        MTree treeMenu = new MTree(this.getCtx(), 10, false, this.get_TrxName());
        Optional<MTreeNode> maybeTreeRoot = Optional.ofNullable(treeMenu.getRoot());
        maybeTreeRoot.ifPresent(this::synchronize);
        return "@Ok@";
    }

    private void synchronize(MTreeNode treeRoot) {
        Optional<MMenu> maybeMenu = Optional.ofNullable(MMenu.getFromId(this.getCtx(), this.getMenuId()));
        MEntityType entityType = new MEntityType(this.getCtx(), this.getEntityTypeId(), this.get_TrxName());
        maybeMenu.ifPresent(menu -> this.synchronize(treeRoot, (MMenu)menu, entityType));
    }

    private void synchronize(MTreeNode treeRoot, MMenu menu, MEntityType entityType) {
        Optional<MTreeNode> maybeTreeItem = Optional.ofNullable(treeRoot.findNode(menu.getAD_Menu_ID()));
        if (menu.isSummary()) {
            if (!menu.getEntityType().equals(entityType.getEntityType())) {
                menu.setEntityType(entityType.getEntityType());
                menu.saveEx();
            }
            maybeTreeItem.ifPresent(treeItem -> {
                Enumeration<TreeNode> children = treeItem.children();
                while (children.hasMoreElements()) {
                    MTreeNode childNode = (MTreeNode)children.nextElement();
                    Optional<MMenu> maybeChildMenu = Optional.ofNullable(MMenu.getFromId(this.getCtx(), childNode.getNode_ID()));
                    maybeChildMenu.ifPresent(menuChild -> this.synchronize(treeRoot, (MMenu)menuChild, entityType));
                }
            });
        } else {
            MForm form;
            if (menu.getAD_Window_ID() > 0) {
                MWindow window = MWindow.get(this.getCtx(), menu.getAD_Window_ID());
                if (!window.getEntityType().equals(entityType.getEntityType())) {
                    window.setEntityType(entityType.getEntityType());
                    window.saveEx();
                }
                Arrays.asList(window.getTabs(true, this.get_TrxName())).forEach(tab -> {
                    if (!tab.getEntityType().equals(entityType.getEntityType())) {
                        tab.setEntityType(entityType.getEntityType());
                        tab.saveEx();
                    }
                    Arrays.asList(tab.getFields(true, this.get_TrxName())).forEach(field -> {
                        if (!field.getEntityType().equals(entityType.getEntityType())) {
                            field.setEntityType(entityType.getEntityType());
                            field.saveEx();
                        }
                    });
                });
            }
            if (menu.getAD_Form_ID() > 0 && !(form = new MForm(this.getCtx(), menu.getAD_Form_ID(), this.get_TrxName())).getEntityType().equals(entityType.getEntityType())) {
                form.setEntityType(entityType.getEntityType());
                form.saveEx();
            }
            if (menu.getAD_Process_ID() > 0) {
                MProcess process = MProcess.get(this.getCtx(), menu.getAD_Process_ID());
                if (!process.getEntityType().equals(entityType.getEntityType())) {
                    process.setEntityType(entityType.getEntityType());
                    process.saveEx();
                }
                Arrays.asList(process.getParameters()).forEach(processPara -> {
                    if (!processPara.getEntityType().equals(entityType.getEntityType())) {
                        processPara.setEntityType(entityType.getEntityType());
                        processPara.saveEx();
                    }
                });
            }
            if (menu.getAD_Browse_ID() > 0) {
                MBrowse browse = MBrowse.get(this.getCtx(), menu.getAD_Browse_ID());
                if (!browse.getEntityType().equals(entityType.getEntityType())) {
                    browse.setEntityType(entityType.getEntityType());
                    browse.saveEx();
                }
                browse.getFields().forEach(field -> {
                    if (!field.getEntityType().equals(entityType.getEntityType())) {
                        field.setEntityType(entityType.getEntityType());
                        field.saveEx();
                    }
                });
            }
            if (menu.getAD_Workflow_ID() > 0) {
                MWorkflow workflow = MWorkflow.get(this.getCtx(), menu.getAD_Workflow_ID());
                if (!workflow.getEntityType().equals(entityType.getEntityType())) {
                    workflow.setEntityType(entityType.getEntityType());
                    workflow.saveEx();
                }
                Arrays.asList(workflow.getNodes(true, this.getAD_Client_ID())).forEach(node -> {
                    if (!node.getEntityType().equals(entityType.getEntityType())) {
                        node.setEntityType(entityType.getEntityType());
                        node.saveEx();
                    }
                    Arrays.asList(node.getTransitions(this.getAD_Client_ID())).forEach(next -> {
                        if (!next.getEntityType().equals(entityType.getEntityType())) {
                            next.setEntityType(entityType.getEntityType());
                            next.saveEx();
                        }
                    });
                });
            }
        }
    }
}

