/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import com.eevolution.model.MSContract;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_C_Invoice;
import org.adempiere.core.domains.models.X_C_OrderLine;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.SB_InvoiceGenerateFromOrderLineAbstract;
import org.compiere.model.MBPartner;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MPriceList;
import org.compiere.model.MProject;
import org.compiere.model.Query;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.eevolution.model.MTaxGroup;
import org.openup.LUY.model.MLUYCFEType;
import org.openup.core.utils.POGroupingProcessor;
import org.openup.core.utils.Utils;

public class SB_InvoiceGenerateFromOrderLine
extends SB_InvoiceGenerateFromOrderLineAbstract {
    private MInOut m_ship = null;
    private int m_created = 0;
    private int m_line = 0;
    private List<MInvoice> mInvoices;
    protected List<MOrderLine> mOrderLines = null;
    protected LinkedHashMap<Integer, LinkedHashMap<String, Object>> m_values = null;
    StringBuffer resultMsg = new StringBuffer();
    private boolean copyDescription;
    private List<Integer> recordIds;
    HashMap<Integer, HashMap<Integer, HashMap<Integer, HashMap<Integer, MInvoice>>>> groupInvoices;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getDateInvoiced() == null) {
            this.setDateInvoiced(Env.getContextAsDate(this.getCtx(), "#Date"));
            if (this.getDateInvoiced() == null) {
                this.setDateInvoiced(new Timestamp(System.currentTimeMillis()));
            }
        }
        if (this.getDocAction() == null) {
            this.setDocAction("CO");
        } else if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("PR");
        }
        this.copyDescription = this.getParameterAsBoolean("CopyDescription");
    }

    @Override
    protected String doIt() throws Exception {
        this.recordIds = this.getSelectionKeys();
        String whereClause = "EXISTS (SELECT T_Selection_ID FROM T_Selection WHERE  T_Selection.AD_PInstance_ID=?  AND T_Selection.T_Selection_ID=c_orderLine.C_OrderLine_ID)";
        this.mOrderLines = new Query(this.getCtx(), "C_OrderLine", whereClause, this.get_TrxName()).setParameters(this.getAD_PInstance_ID()).setClient_ID().list();
        if (this.mOrderLines != null) {
            POGroupingProcessor<Object> obp = new POGroupingProcessor<Object>();
            obp.addPO(this.mOrderLines);
            obp.addCriteria("Bill_BPartner_ID", mOrderLine -> mOrderLine.getC_Order().getBill_BPartner_ID());
            obp.addCriteria("Bill_Location_ID", mOrderLine -> mOrderLine.getC_Order().getBill_Location_ID());
            obp.addCriteria("C_Currency_ID_To", mOrderLine -> {
                MOrder mOrder = (MOrder)mOrderLine.getC_Order();
                int c_currency_id = mOrder.get_ValueAsInt("C_Currency_ID_To");
                return c_currency_id > 0 ? c_currency_id : mOrder.getC_Currency_ID();
            });
            obp.addCriteria("invDocType", mOrderLine -> this.getDocTypeToInvoice((MOrderLine)mOrderLine).get_ID());
            String orderGrouping = this.getOrderGrouping();
            if ("O".equalsIgnoreCase(orderGrouping)) {
                obp.addCriteria("orderGrouping", poGeneric -> poGeneric.getC_Order_ID());
            } else if ("P".equalsIgnoreCase(orderGrouping)) {
                obp.addCriteria("orderGrouping", poGeneric -> poGeneric.getC_Project_ID() > 0 ? poGeneric.getC_Project_ID() : poGeneric.getC_Order().getC_Project_ID());
            } else if ("C".equalsIgnoreCase(orderGrouping)) {
                obp.addCriteria("orderGrouping", mOrderLine -> ((MOrder)mOrderLine.getC_Order()).get_ValueAsInt("S_Contract_ID"));
            } else if ("TC".equalsIgnoreCase(orderGrouping)) {
                obp.addCriteria("orderGrouping", mOrderLine -> mOrderLine.getC_Tax_ID());
                obp.addCriteria("S_Contract_ID", mOrderLine -> ((MOrder)mOrderLine.getC_Order()).get_ValueAsInt("S_Contract_ID"));
            }
            this.mInvoices = new ArrayList<MInvoice>();
            obp.processGrupedObjects((params, poList) -> {
                poList.forEach(po -> System.out.println("OrderLine: " + po.get_ID()));
                if (poList.size() > 0) {
                    MInvoice mInvoice = this.createInvoice(obp, params, poList);
                    this.mInvoices.add(mInvoice);
                    poList.forEach(o -> this.createInvoiceLine(params, mInvoice, (MOrderLine)o));
                }
            });
            this.mInvoices.forEach(mInvoice -> {
                try {
                    Trx.run(mInvoice.get_TrxName(), trxLocal -> {
                        mInvoice.set_TrxName(trxLocal);
                        if (!mInvoice.processIt(this.getDocAction())) {
                            this.log.warning("completeInvoice - failed: " + mInvoice);
                            this.addLog(Msg.getMsg(this.getCtx(), "GenerateInvoiceFromInOut.completeInvoice.Failed") + mInvoice);
                        }
                        mInvoice.saveEx();
                        this.addLog(mInvoice.getC_Invoice_ID(), mInvoice.getDateInvoiced(), null, mInvoice.getDocumentNo());
                        ++this.m_created;
                    });
                }
                catch (Exception e) {
                    this.log.warning(e.getMessage());
                }
            });
        }
        return "@DocProcessed@: " + this.mInvoices.size() + " | " + this.mInvoices.stream().map(X_C_Invoice::getDocumentNo).collect(Collectors.joining(", "));
    }

    private void createInvoiceLine(HashMap<String, Integer> params, MInvoice mInvoice, MOrderLine mOrderLine) {
        MOrder mOrder = (MOrder)mOrderLine.getC_Order();
        AtomicReference qtyEntered = new AtomicReference();
        this.recordIds.forEach(integer -> {
            if (this.getSelectionAsInt((int)integer, "OLINE_C_OrderLine_ID") == mOrderLine.get_ID()) {
                qtyEntered.set(this.getSelectionAsBigDecimal((int)integer, "OLINE_QtyEntered"));
                if (qtyEntered.get() == null) {
                    qtyEntered.set(Env.ZERO);
                }
                BigDecimal qtyOrdered = Utils.whenNull(this.getSelectionAsBigDecimal((int)integer, "OLINE_QtyOrdered"), Env.ZERO);
                BigDecimal qtyInvoiced = Utils.whenNull(this.getSelectionAsBigDecimal((int)integer, "OLINE_QtyInvoiced"), Env.ZERO);
                BigDecimal qtyAvailable = qtyOrdered.subtract(qtyInvoiced);
                if (((BigDecimal)qtyEntered.get()).compareTo(qtyAvailable) > 0) {
                    throw new AdempiereException("Cantidad ingresada mayor a la cantidad ordenada menos facturada");
                }
            }
        });
        String sqlReturnedMInOut = "SELECT \nshipL.M_InOutLine_ID M_InOutLine_ID,\nCASE WHEN ol.C_UOM_ID=shipL.C_UOM_ID THEN shipL.qtyEntered ELSE shipL.movementQty END - \nCASE WHEN ol.C_UOM_ID=shipL.C_UOM_ID THEN SUM(CASE WHEN shipDev.docStatus='CO' THEN shipLDev.qtyEntered ELSE 0 END) ELSE SUM(CASE WHEN shipDev.docStatus='CO' THEN shipLDev.movementQty ELSE 0 END) END qtyDelivered,\nshipL.movementQty - SUM(CASE WHEN shipDev.docStatus='CO' THEN shipLDev.qtyEntered ELSE 0 END) qtyMovement,\n(SELECT coalesce(SUM(qty),0) FROM m_matchinv WHERE m_inoutline_id = shipL.m_inoutline_id) as qtyUsed FROM C_OrderLine ol\nJOIN M_InOutLine shipL ON ol.C_OrderLine_ID=shipL.C_OrderLine_ID\nJOIN M_InOut ship ON shipL.M_InOut_ID=ship.M_InOut_ID\nJOIN C_DocType docShip ON ship.C_DocType_ID=docShip.C_DocType_ID\nLEFT JOIN M_RMALine rmal ON shipl.M_InOutLine_ID=rmal.M_InOutLine_ID\nLEFT JOIN M_InOutLine shiplDev ON rmal.M_RMALine_ID=shipLDev.M_RMALine_ID\nLEFT JOIN M_InOut shipDev ON shiplDev.M_InOut_ID=shipDev.M_InOut_ID\nWHERE docShip.DocBaseType='MMS'\nAND ship.docStatus='CO'\nAND shipL.isInvoiced='N'\nAND ol.C_OrderLine_ID=?\nGROUP BY ol.C_OrderLine_ID, shipL.M_InOutLine_ID\nHAVING (\n  CASE WHEN ol.C_UOM_ID=shipL.C_UOM_ID THEN shipL.qtyEntered ELSE shipL.movementQty END - \n  CASE WHEN ol.C_UOM_ID=shipL.C_UOM_ID THEN SUM(CASE WHEN shipDev.docStatus='CO' THEN shipLDev.qtyEntered ELSE 0 END) ELSE SUM(CASE WHEN shipDev.docStatus='CO' THEN shipLDev.movementQty ELSE 0 END) END\n) <> 0";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sqlReturnedMInOut, this.get_TrxName());
            pstmt.setInt(1, mOrderLine.get_ID());
            rs = pstmt.executeQuery();
            BigDecimal restShipQtyEntered = (BigDecimal)qtyEntered.get();
            BigDecimal restShipQtyInvoiced = (BigDecimal)qtyEntered.get();
            while (rs.next() && restShipQtyEntered.compareTo(Env.ZERO) >= 0 && restShipQtyInvoiced.compareTo(Env.ZERO) >= 0) {
                BigDecimal qtyAvailable;
                MInOutLine mInOutLine = new MInOutLine(this.getCtx(), rs.getInt("M_InOutLine_ID"), this.get_TrxName());
                BigDecimal qtyEnt = rs.getBigDecimal("qtyDelivered");
                BigDecimal qtyInv = rs.getBigDecimal("qtyMovement");
                BigDecimal qtyUsed = rs.getBigDecimal("qtyUsed");
                if (restShipQtyEntered.compareTo(qtyEnt) < 0) {
                    qtyEnt = restShipQtyEntered;
                }
                if (restShipQtyInvoiced.compareTo(qtyInv) < 0) {
                    qtyInv = restShipQtyInvoiced;
                }
                if ((qtyAvailable = qtyEnt.subtract(qtyUsed)).compareTo(Env.ZERO) <= 0) continue;
                this.createInvoiceLine(params, mInvoice, mOrderLine, mInOutLine, qtyEnt, qtyInv);
                restShipQtyEntered = restShipQtyEntered.subtract(qtyEnt);
                restShipQtyInvoiced = restShipQtyInvoiced.subtract(qtyInv);
            }
            if (!("D".equals(mOrder.getInvoiceRule()) || restShipQtyEntered.compareTo(Env.ZERO) <= 0 && restShipQtyInvoiced.compareTo(Env.ZERO) <= 0)) {
                this.createInvoiceLine(params, mInvoice, mOrderLine, null, restShipQtyEntered, restShipQtyInvoiced);
            }
        }
        catch (Exception e) {
            try {
                throw new AdempiereException(e);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
    }

    private void createInvoiceLine(HashMap<String, Integer> params, MInvoice mInvoice, MOrderLine mOrderLine, MInOutLine mInOutLine, BigDecimal qtyEntered, BigDecimal qtyInvoiced) {
        MInvoiceLine line = new MInvoiceLine(mInvoice);
        line.setOrderLine(mOrderLine);
        line.setQtyInvoiced(qtyInvoiced);
        line.setQtyEntered(qtyEntered);
        line.setLine(this.m_line + mOrderLine.getLine());
        if (mInOutLine != null && mInOutLine.get_ID() > 0) {
            line.setM_InOutLine_ID(mInOutLine.get_ID());
        }
        if (line.get_ValueAsInt("C_Project_ID") <= 0) {
            Utils.setWhenNotNullNoEx(mOrderLine.getC_Order().getC_Project_ID(), line::setC_Project_ID);
        }
        if (line.getC_Campaign_ID() <= 0) {
            Utils.setWhenNotNullNoEx(Utils.when(mOrderLine.getC_Campaign_ID(), Integer.valueOf(mOrderLine.getC_Order().getC_Campaign_ID()), (o1, o2) -> o1 != 0), line::setC_Campaign_ID);
        }
        if (line.get_ValueAsInt("S_ContractLine_ID") <= 0) {
            Utils.setWhenNotNullNoEx(mOrderLine.get_ValueAsInt("S_ContractLine_ID"), integer -> line.set_ValueOfColumn("S_ContractLine_ID", integer));
        }
        if (line.getUser1_ID() <= 0) {
            Utils.setWhenNotNullNoEx(Utils.when(mOrderLine.getUser1_ID(), Integer.valueOf(mOrderLine.getC_Order().getUser1_ID()), (o1, o2) -> o1 != 0), line::setUser1_ID);
        }
        if (line.getUser2_ID() <= 0) {
            Utils.setWhenNotNullNoEx(Utils.when(mOrderLine.getUser2_ID(), Integer.valueOf(mOrderLine.getC_Order().getUser2_ID()), (o1, o2) -> o1 != 0), line::setUser2_ID);
        }
        if (line.getUser3_ID() <= 0) {
            Utils.setWhenNotNullNoEx(Utils.when(mOrderLine.getUser3_ID(), Integer.valueOf(mOrderLine.getC_Order().getUser3_ID()), (o1, o2) -> o1 != 0), line::setUser3_ID);
        }
        if (line.getUser4_ID() <= 0) {
            Utils.setWhenNotNullNoEx(Utils.when(mOrderLine.getUser4_ID(), Integer.valueOf(mOrderLine.getC_Order().getUser4_ID()), (o1, o2) -> o1 != 0), line::setUser4_ID);
        }
        line.saveEx();
        this.log.fine(line.toString());
    }

    private MInvoice createInvoice(POGroupingProcessor<MOrderLine> obp, HashMap<String, Integer> params, List<MOrderLine> poList) {
        MInvoice invoice;
        MBPartner mbPartner = new MBPartner(this.getCtx(), params.get("Bill_BPartner_ID"), this.get_TrxName());
        String orderGrouping = this.getOrderGrouping();
        if ("O".equalsIgnoreCase(orderGrouping)) {
            invoice = new MInvoice((MOrder)poList.get(0).getC_Order(), 0, this.getDateInvoiced());
            if (this.getOrgTrxId() != 0) {
                invoice.setAD_Org_ID(this.getOrgTrxId());
            }
            if (!this.copyDescription) {
                invoice.setDescription("");
            }
            MSContract orderContract = null;
            try {
                orderContract = new MSContract(this.getCtx(), ((MOrder)obp.getListValue(poList, X_C_OrderLine::getC_Order)).get_ValueAsInt("S_Contract_ID"), this.get_TrxName());
                if (orderContract.get_ID() <= 0) {
                    orderContract = null;
                }
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "@S_Contract@ @not.found@");
                e.printStackTrace();
            }
            if (orderContract != null) {
                invoice.set_ValueOfColumn("S_Contract_ID", (Object)orderContract.get_ID());
            }
        } else {
            invoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
            MCurrency mCurrency = new MCurrency(this.getCtx(), params.get("C_Currency_ID_To"), this.get_TrxName());
            MPriceList mPriceList = MPriceList.get(this.getCtx(), true, mCurrency.getISO_Code(), false);
            invoice.setIsSOTrx(true);
            invoice.setC_Currency_ID(mCurrency.get_ID());
            invoice.setM_PriceList_ID(mPriceList.get_ID());
            invoice.setIsTaxIncluded(mPriceList.isTaxIncluded());
            invoice.setC_ConversionType_ID(obp.getListValue(poList, MOrderLine::getC_ConversionType_ID, "Varios tipos de conversi\u00f3n encontrados"));
            invoice.setPaymentRule(obp.getListValue(poList, mOrderLine -> mOrderLine.getC_Order().getPaymentRule(), "Varias reglas de pago encontradas"));
            MSContract orderContract = null;
            try {
                orderContract = new MSContract(this.getCtx(), ((MOrder)obp.getListValue(poList, X_C_OrderLine::getC_Order)).get_ValueAsInt("S_Contract_ID"), this.get_TrxName());
                if (orderContract.get_ID() <= 0) {
                    orderContract = null;
                }
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "@S_Contract@ @not.found@");
                e.printStackTrace();
            }
            if (orderContract != null) {
                invoice.set_ValueOfColumn("S_Contract_ID", (Object)orderContract.get_ID());
            }
            try {
                MSContract msContract;
                if ("P".equalsIgnoreCase(orderGrouping)) {
                    MProject mProject = new MProject(this.getCtx(), obp.getListValue(poList, po -> po.getC_Order().getC_Project_ID(), null), this.get_TrxName());
                    MSContract msContract2 = new MSContract(this.getCtx(), obp.getListValue(poList, po -> {
                        MProject t = (MProject)po.getC_Order().getC_Project();
                        return t != null ? t.get_ValueAsInt("S_Contract_ID") : 0;
                    }), this.get_TrxName());
                    invoice.setPOReference(mProject.getPOReference());
                    if (this.copyDescription) {
                        invoice.setDescription(mProject.getDescription());
                    }
                    invoice.setC_Project_ID(mProject.get_ID());
                    Utils.setWhenNotNullNoEx(msContract2 != null ? Integer.valueOf(msContract2.get_ID()) : null, o -> invoice.set_ValueOfColumn("S_Contract_ID", o));
                    Utils.setWhenNotNullNoEx(mProject.getUser1_ID(), integer -> invoice.set_ValueOfColumn("User1_ID", integer));
                    Utils.setWhenNotNullNoEx(mProject.getUser4_ID(), integer -> invoice.set_ValueOfColumn("User4_ID", integer));
                } else if ("C".equalsIgnoreCase(orderGrouping)) {
                    msContract = new MSContract(this.getCtx(), obp.getListValue(poList, po -> ((MOrder)po.getC_Order()).get_ValueAsInt("S_Contract_ID"), null), this.get_TrxName());
                    invoice.setPOReference(msContract.getPOReference());
                    if (this.copyDescription) {
                        invoice.setDescription(msContract.getDescription());
                    }
                    invoice.set_ValueOfColumn("S_Contract_ID", (Object)msContract.get_ID());
                    Utils.setWhenNotNullNoEx(msContract.getUser1_ID(), integer -> invoice.set_ValueOfColumn("User1_ID", integer));
                    Utils.setWhenNotNullNoEx(msContract.getUser4_ID(), integer -> invoice.set_ValueOfColumn("User4_ID", integer));
                } else if ("TC".equalsIgnoreCase(orderGrouping)) {
                    msContract = new MSContract(this.getCtx(), params.get("S_Contract_ID"), this.get_TrxName());
                    Integer s_contract_id = obp.getListValue(poList, mOrderLine -> mOrderLine.get_ValueAsInt("S_Contract_ID"));
                    Integer user1_id = obp.getListValue(poList, mOrderLine -> mOrderLine.get_ValueAsInt("User1_ID"));
                    invoice.set_ValueOfColumn("S_Contract_ID", (Object)(s_contract_id != null && s_contract_id > 0 ? s_contract_id.intValue() : msContract.get_ID()));
                    invoice.set_ValueOfColumn("User1_ID", (Object)(user1_id != null && user1_id > 0 ? user1_id.intValue() : msContract.getUser1_ID()));
                }
            }
            catch (Exception msContract) {
                // empty catch block
            }
            invoice.setAD_OrgTrx_ID(this.getOrgTrxId());
            invoice.setPOReference(obp.getListValue(poList, mOrderLine -> mOrderLine.getC_Order().getPOReference(), "Campo \"OC Cliente\" debe ser el mismo para todas las ordenes del grupo"));
            Utils.setWhenNotNull(obp.getListValue(poList, mOrderLine -> Utils.when(mOrderLine.getC_Project_ID(), Integer.valueOf(mOrderLine.getC_Order().getC_Project_ID()), (o1, o2) -> o1 != 0)), invoice::setC_Project_ID);
            Utils.setWhenNotNull(obp.getListValue(poList, mOrderLine -> Utils.when(mOrderLine.getC_Campaign_ID(), Integer.valueOf(mOrderLine.getC_Order().getC_Campaign_ID()), (o1, o2) -> o1 != 0)), invoice::setC_Campaign_ID);
            Utils.setWhenNotNull(obp.getListValue(poList, mOrderLine -> Utils.when(mOrderLine.getC_Activity_ID(), Integer.valueOf(mOrderLine.getC_Order().getC_Activity_ID()), (o1, o2) -> o1 != 0)), invoice::setC_Activity_ID);
            Utils.setWhenNotNull(obp.getListValue(poList, mOrderLine -> Utils.when(mOrderLine.getUser1_ID(), Integer.valueOf(mOrderLine.getC_Order().getUser1_ID()), (o1, o2) -> o1 != 0)), invoice::setUser1_ID);
            Utils.setWhenNotNull(obp.getListValue(poList, mOrderLine -> Utils.when(mOrderLine.getUser2_ID(), Integer.valueOf(mOrderLine.getC_Order().getUser2_ID()), (o1, o2) -> o1 != 0)), invoice::setUser2_ID);
            Utils.setWhenNotNull(obp.getListValue(poList, mOrderLine -> Utils.when(mOrderLine.getUser3_ID(), Integer.valueOf(mOrderLine.getC_Order().getUser3_ID()), (o1, o2) -> o1 != 0)), invoice::setUser3_ID);
            Utils.setWhenNotNull(obp.getListValue(poList, mOrderLine -> Utils.when(mOrderLine.getUser4_ID(), Integer.valueOf(mOrderLine.getC_Order().getUser4_ID()), (o1, o2) -> o1 != 0)), invoice::setUser4_ID);
            Integer cPaymentTermId = obp.getListValue(poList, mOrderLine -> {
                try {
                    return mOrderLine.getC_Order().getC_PaymentTerm_ID();
                }
                catch (Exception ignored) {
                    return 0;
                }
            });
            if (cPaymentTermId != null && cPaymentTermId > 0) {
                invoice.setC_PaymentTerm_ID(cPaymentTermId);
            } else {
                cPaymentTermId = obp.getListValue(poList, mOrderLine -> {
                    try {
                        return mOrderLine.getC_Order().getC_BPartner().getC_PaymentTerm_ID();
                    }
                    catch (Exception ignored) {
                        return 0;
                    }
                });
                if (cPaymentTermId != null && cPaymentTermId > 0) {
                    invoice.setC_PaymentTerm_ID(cPaymentTermId);
                } else {
                    throw new AdempiereException("Varios t\u00e9rminos de pagos de diferentes ordenes encontrados, y no definido en el SDN");
                }
            }
            invoice.setDateAcct(this.getDateInvoiced());
            invoice.setDateInvoiced(this.getDateInvoiced());
            Integer salesRep_id = obp.getListValue(poList, po -> po.getC_Order().getSalesRep_ID(), null);
            if (salesRep_id == null || salesRep_id <= 0) {
                salesRep_id = obp.getListValue(poList, po -> {
                    MSContract msContract = new MSContract(this.getCtx(), ((MOrder)po.getC_Order()).get_ValueAsInt("S_Contract_ID"), this.get_TrxName());
                    return msContract.getSalesRep_ID();
                }, null);
            }
            if (salesRep_id <= 0) {
                throw new AdempiereException("Representante de ventas no establecido en las lineas de orden ni en el Contrato a Facturar");
            }
            invoice.setSalesRep_ID(salesRep_id);
            invoice.setC_BPartner_ID(mbPartner.get_ID());
            invoice.setC_BPartner_Location_ID(params.get("Bill_Location_ID"));
        }
        MDocType mDocType = new MDocType(this.getCtx(), params.get("invDocType"), this.get_TrxName());
        invoice.setC_DocType_ID(mDocType.get_ID());
        invoice.setC_DocTypeTarget_ID(mDocType.get_ID());
        MOrder order = (MOrder)poList.get(0).getC_Order();
        if (order != null && order.get_ValueAsInt("UY_ViaLoan_ID") > 0) {
            invoice.set_ValueOfColumn("UY_ViaLoan_ID", (Object)order.get_ValueAsInt("UY_ViaLoan_ID"));
        }
        invoice.saveEx();
        return invoice;
    }

    private MDocType getDocTypeToInvoice(MOrderLine mOrderLine) {
        MOrder mOrder = (MOrder)mOrderLine.getC_Order();
        MBPartner mbPartner = (MBPartner)mOrder.getC_BPartner();
        MDocType orderDocType = (MDocType)mOrder.getC_DocTypeTarget();
        MDocType mDocTypeToInv = (MDocType)orderDocType.getC_DocTypeInvoice();
        MOrg mOrg = new MOrg(this.getCtx(), Env.getAD_Org_ID(this.getCtx()), this.get_TrxName());
        MTaxGroup mTaxGroup = (MTaxGroup)mbPartner.getC_TaxGroup();
        if (mTaxGroup == null || mTaxGroup.get_ID() <= 0) {
            throw new AdempiereException("Tipo de documento no definido para Socio de Negocio: " + mbPartner.getName() + "(c\u00f3digo: " + mbPartner.getValue() + ")");
        }
        if (mDocTypeToInv == null || !mDocTypeToInv.get_ValueAsBoolean("IsSummary")) {
            MLUYCFEType mLuyCfeType = MLUYCFEType.getDefaultEx(this.getCtx(), mOrg.get_ID(), mbPartner.getC_TaxGroup_ID(), "ARI", this.get_TrxName());
            return (MDocType)mLuyCfeType.getC_DocType();
        }
        String query = "EXISTS (\n  SELECT 1\n  FROM C_DocType dt\n  JOIN LUY_CFEType c ON dt.C_DocType_ID=c.C_DocType_ID\n  WHERE dt.Parent_ID= " + mDocTypeToInv.get_ID() + "\n  AND c.C_TaxGroup_ID=" + mTaxGroup.get_ID() + "\n  AND c.AD_Org_ID=" + mOrg.get_ID() + "\n  AND c.C_DocType_ID=C_DocType.C_DocType_ID\n)";
        MDocType mDocType = (MDocType)new Query(this.getCtx(), "C_DocType", query, this.get_TrxName()).first();
        if (mDocType == null || mDocType.get_ID() <= 0) {
            throw new AdempiereException("(Orden: " + mOrder.getDocumentNo() + ") El documento " + orderDocType.getName() + " (ID:" + orderDocType.get_ID() + ")  tiene el documento a facturar " + mDocTypeToInv.getName() + " (ID:" + mDocTypeToInv.get_ID() + ") que es entidad acumulada pero no se encontraron documentos hijos para la siguiente combinaci\u00f3n (" + mOrg.getName() + " - " + mTaxGroup.getName() + ")");
        }
        return mDocType;
    }
}

