/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_Invoice;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPartner;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.PO;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.LUY.model.MLUYCFEType;
import org.openup.core.model.MAllocInvoice;

public class InvoiceGenerateRMA
extends SvrProcess {
    private boolean p_Selection = false;
    private String p_docAction = "CO";
    private int m_created = 0;
    private Timestamp m_dateinvoiced = null;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("Selection")) {
                this.p_Selection = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("DocAction")) {
                this.p_docAction = (String)para[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.m_dateinvoiced = Env.getContextAsDate(this.getCtx(), "#Date");
        if (this.m_dateinvoiced == null) {
            this.m_dateinvoiced = new Timestamp(System.currentTimeMillis());
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (!this.p_Selection) {
            throw new IllegalStateException("Shipments can only be generated from selection");
        }
        String sql = "SELECT rma.M_RMA_ID FROM M_RMA rma, T_Selection WHERE rma.DocStatus='CO' AND rma.IsSOTrx='Y' AND rma.AD_Client_ID=? AND rma.M_RMA_ID = T_Selection.T_Selection_ID AND T_Selection.AD_PInstance_ID=? ";
        CPreparedStatement pstmt = null;
        PO inv = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, Env.getAD_Client_ID(this.getCtx()));
            pstmt.setInt(2, this.getAD_PInstance_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MRMA rma = new MRMA(this.getCtx(), rs.getInt(1), this.get_TrxName());
                if (inv == null) {
                    inv = this.generateInvoice(rma);
                    continue;
                }
                boolean error = false;
                if (inv.getAD_Org_ID() != rma.getAD_Org_ID() || ((X_C_Invoice)inv).getC_BPartner_ID() != rma.getC_BPartner_ID() || ((X_C_Invoice)inv).getC_Currency_ID() != rma.getC_Currency_ID()) {
                    error = true;
                }
                if (rma.getInOut_ID() > 0) {
                    MInOut inout = (MInOut)rma.getInOut();
                    if (inv.get_ValueAsInt("S_Contract_ID") != inout.get_ValueAsInt("S_Contract_ID")) {
                        error = true;
                    }
                }
                if (error) {
                    inv.deleteEx(true);
                    this.m_created = 0;
                    throw new AdempiereException("ERROR: Las solicitudes de devolucion seleccionadas deben tener la misma organizacion, socio de negocio, contrato y moneda");
                }
                this.createInvoiceLines(rma, (MInvoice)inv);
            }
            this.generateCFEREferences(sql, (MInvoice)inv);
            if (inv != null && inv.get_ID() > 0) {
                this.addLog(((X_C_Invoice)inv).getC_Invoice_ID(), ((X_C_Invoice)inv).getDateInvoiced(), null, ((X_C_Invoice)inv).getDocumentNo());
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, sql, ex);
            throw new AdempiereException(ex.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, "Could not close prepared statement");
            }
        }
        return "@Created@ = " + this.m_created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCFEREferences(String sql, MInvoice inv) {
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, Env.getAD_Client_ID(this.getCtx()));
            pstmt.setInt(2, this.getAD_PInstance_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MRMA rma = new MRMA(this.getCtx(), rs.getInt(1), this.get_TrxName());
                this.setOriginalInvoices(rma, inv);
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, sql, ex);
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, "Could not close prepared statement");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOriginalInvoices(MRMA rma, MInvoice inv) {
        String sql = "select distinct(il.c_invoice_id) from c_orderline ol join c_invoiceline il on ol.c_orderline_id = il.c_orderline_id join c_invoice i on il.c_invoice_id = i.c_invoice_id join c_doctype d on i.c_doctypetarget_id = d.c_doctype_id where i.docstatus in ('CO','CL') and ol.c_order_id = " + rma.getShipment().getC_Order_ID() + " and d.docbasetype = 'ARI' and not exists (select c_allocinvoice_id from uy_allocinvoice where c_allocinvoice_id = il.c_invoice_id and c_invoice_id = " + inv.get_ID() + ")";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int allocInvoiceID = rs.getInt("C_Invoice_ID");
                MAllocInvoice alloc = new MAllocInvoice(this.getCtx(), 0, this.get_TrxName());
                alloc.setC_Invoice_ID(inv.get_ID());
                alloc.setC_AllocInvoice_ID(allocInvoiceID);
                BigDecimal amtInvAllocate = DB.getSQLValueBDEx(this.get_TrxName(), "select invoiceopen(" + allocInvoiceID + ", null)", new Object[0]);
                alloc.setOpenAmt(amtInvAllocate);
                alloc.setAmtToAllocate(rma.getAmt());
                alloc.setFromProcess(true);
                alloc.saveEx();
            }
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, sql, ex);
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception ex) {
                this.log.log(Level.SEVERE, "Could not close prepared statement");
            }
        }
    }

    private int getInvoiceDocTypeId(MRMA rma) {
        int docTypeId = -1;
        MBPartner partner = (MBPartner)rma.getC_BPartner();
        if (partner.getC_TaxGroup_ID() <= 0) {
            return docTypeId;
        }
        MLUYCFEType mLuyCfeType = MLUYCFEType.getDefaultEx(this.getCtx(), rma.getAD_Org_ID(), partner.getC_TaxGroup_ID(), "ARC", this.get_TrxName());
        docTypeId = mLuyCfeType.getC_DocType_ID();
        return docTypeId;
    }

    private MInvoice createInvoice(MRMA rma) {
        int docTypeId = this.getInvoiceDocTypeId(rma);
        if (docTypeId == -1) {
            throw new IllegalStateException("Could not get invoice document type for Vendor RMA");
        }
        MInvoice invoice = new MInvoice(this.getCtx(), 0, this.get_TrxName());
        invoice.setRMA(rma);
        invoice.setC_DocTypeTarget_ID(docTypeId);
        if (!invoice.save()) {
            throw new IllegalStateException("Could not create invoice");
        }
        return invoice;
    }

    private MInvoiceLine[] createInvoiceLines(MRMA rma, MInvoice invoice) {
        MRMALine[] rmaLines;
        ArrayList<MInvoiceLine> invLineList = new ArrayList<MInvoiceLine>();
        for (MRMALine rmaLine : rmaLines = rma.getLines(true)) {
            if (rmaLine.getM_InOutLine_ID() == 0) {
                throw new IllegalStateException("No customer return line - RMA = " + rma.getDocumentNo() + ", Line = " + rmaLine.getLine());
            }
            MInvoiceLine invLine = new MInvoiceLine(invoice);
            invLine.setRMALine(rmaLine);
            if (rmaLine.getM_InOutLine_ID() > 0) {
                MInOutLine ioLine = (MInOutLine)rmaLine.getM_InOutLine();
                invLine.setC_OrderLine_ID(ioLine.getC_OrderLine_ID());
                String sql = "select il.m_inoutline_id from m_inout i join m_inoutline il on i.m_inout_id = il.m_inout_id where i.docstatus in ('CO','CL') and il.m_rmaline_id = " + rmaLine.get_ID();
                int ioLineID = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
                if (ioLineID > 0) {
                    invLine.setM_InOutLine_ID(ioLineID);
                }
            }
            if (!invLine.save()) {
                throw new IllegalStateException("Could not create invoice line");
            }
            invLineList.add(invLine);
        }
        MInvoiceLine[] invLines = new MInvoiceLine[invLineList.size()];
        invLineList.toArray(invLines);
        return invLines;
    }

    private void generateInvoice(int M_RMA_ID) {
        MInvoice invoice;
        MRMA rma = new MRMA(this.getCtx(), M_RMA_ID, this.get_TrxName());
        MInvoiceLine[] invoiceLines = this.createInvoiceLines(rma, invoice = this.createInvoice(rma));
        if (invoiceLines.length == 0) {
            this.log.log(Level.WARNING, "No invoice lines created: M_RMA_ID=" + M_RMA_ID + ", M_Invoice_ID=" + invoice.get_ID());
        }
        StringBuffer processMsg = new StringBuffer(invoice.getDocumentNo());
        if (!invoice.processIt(this.p_docAction)) {
            processMsg.append(" (NOT Processed)");
            this.log.warning("Invoice Processing failed: " + invoice + " - " + invoice.getProcessMsg());
        }
        if (!invoice.save()) {
            throw new IllegalStateException("Could not update invoice");
        }
        ++this.m_created;
    }

    private MInvoice generateInvoice(MRMA rma) {
        MInvoiceLine[] invoiceLines;
        MInOut inout;
        MInvoice invoice = this.createInvoice(rma);
        if (rma.getInOut_ID() > 0 && invoice.get_ValueAsInt("S_Contract_ID") == 0 && (inout = (MInOut)rma.getInOut()).get_ValueAsInt("S_Contract_ID") > 0) {
            invoice.set_ValueOfColumn("S_Contract_ID", (Object)inout.get_ValueAsInt("S_Contract_ID"));
        }
        if ((invoiceLines = this.createInvoiceLines(rma, invoice)).length == 0) {
            this.log.log(Level.WARNING, "No invoice lines created: M_RMA_ID=" + rma.get_ID() + ", M_Invoice_ID=" + invoice.get_ID());
        }
        StringBuffer processMsg = new StringBuffer(invoice.getDocumentNo());
        if (!invoice.processIt(this.p_docAction)) {
            processMsg.append(" (NOT Processed)");
            this.log.warning("Invoice Processing failed: " + invoice + " - " + invoice.getProcessMsg());
        }
        if (!invoice.save()) {
            throw new IllegalStateException("Could not update invoice");
        }
        ++this.m_created;
        return invoice;
    }
}

