/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.adempiere.core.domains.models.I_AD_Menu;
import org.adempiere.core.domains.models.I_ASP_Level;
import org.adempiere.core.domains.models.X_ASP_Browse;
import org.adempiere.core.domains.models.X_ASP_Field;
import org.adempiere.core.domains.models.X_ASP_Form;
import org.adempiere.core.domains.models.X_ASP_Process;
import org.adempiere.core.domains.models.X_ASP_Process_Para;
import org.adempiere.core.domains.models.X_ASP_Tab;
import org.adempiere.core.domains.models.X_ASP_Task;
import org.adempiere.core.domains.models.X_ASP_Window;
import org.adempiere.core.domains.models.X_ASP_Workflow;
import org.adempiere.model.MBrowse;
import org.adempiere.process.ASPGenerateLevelAbstract;
import org.compiere.model.MClientInfo;
import org.compiere.model.MColumn;
import org.compiere.model.MField;
import org.compiere.model.MForm;
import org.compiere.model.MMenu;
import org.compiere.model.MProcess;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTab;
import org.compiere.model.MTask;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.model.MWindow;
import org.compiere.util.DB;
import org.compiere.wf.MWorkflow;

public class ASPGenerateLevel
extends ASPGenerateLevelAbstract {
    private int noWindows = 0;
    private int noTabs = 0;
    private int noFields = 0;
    private int noProcesses = 0;
    private int noParameters = 0;
    private int noForms = 0;
    private int noBrowses = 0;
    private int noTasks = 0;
    private int noWorkflows = 0;
    private int menuId = 0;

    @Override
    protected void prepare() {
        super.prepare();
        if (this.getTable_ID() == I_AD_Menu.Table_ID) {
            this.menuId = this.getRecord_ID();
        } else if (this.getTable_ID() == I_ASP_Level.Table_ID) {
            this.menuId = this.getParameterAsInt("AD_Menu_ID");
            this.setLevelId(this.getRecord_ID());
        }
    }

    @Override
    protected String doIt() throws Exception {
        this.log.info("ASP_Status=" + this.getStatus() + ", AD_Menu_ID=" + this.menuId + ", IsGenerateFields=" + this.isGenerateFields());
        MClientInfo clientInfo = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
        int AD_Tree_ID = clientInfo.getAD_Tree_Menu_ID();
        MTree thisTree = new MTree(this.getCtx(), AD_Tree_ID, true, true, null, this.get_TrxName());
        MTreeNode node = this.menuId > 0 ? thisTree.getRoot().findNode(this.menuId) : thisTree.getRoot();
        if (node != null && node.isSummary()) {
            Enumeration<TreeNode> en = node.preorderEnumeration();
            while (en.hasMoreElements()) {
                MTreeNode nn = (MTreeNode)en.nextElement();
                if (nn.isSummary()) continue;
                this.addNodeToLevel(nn);
            }
        }
        if (this.noWindows > 0) {
            this.addLog("@AD_Window_ID@ (" + this.noWindows + ")");
        }
        if (this.noTabs > 0) {
            this.addLog("@AD_Tab_ID@ (" + this.noTabs + ")");
        }
        if (this.noFields > 0) {
            this.addLog("@AD_Field_ID@ (" + this.noFields + ")");
        }
        if (this.noProcesses > 0) {
            this.addLog("@AD_Process_ID@ (" + this.noProcesses + ")");
        }
        if (this.noParameters > 0) {
            this.addLog("@AD_Process_Para_ID@ (" + this.noParameters + ")");
        }
        if (this.noForms > 0) {
            this.addLog("@AD_Form_ID@ (" + this.noForms + ")");
        }
        if (this.noBrowses > 0) {
            this.addLog("@AD_Browse_ID@ (" + this.noBrowses + ")");
        }
        if (this.noTasks > 0) {
            this.addLog("@AD_Task_ID@ (" + this.noTasks + ")");
        }
        if (this.noWorkflows > 0) {
            this.addLog("@AD_Workflow_ID@ (" + this.noWorkflows + ")");
        }
        return "@OK@";
    }

    private void addNodeToLevel(MTreeNode nn) {
        MMenu menu = new MMenu(this.getCtx(), nn.getNode_ID(), this.get_TrxName());
        if (menu.getAction().equals("W")) {
            MWindow window = new MWindow(this.getCtx(), menu.getAD_Window_ID(), this.get_TrxName());
            int asp_window_id = DB.getSQLValueEx(this.get_TrxName(), "SELECT ASP_Window_ID FROM ASP_Window WHERE ASP_Level_ID = ? AND AD_Window_ID = ?", this.getLevelId(), window.getAD_Window_ID());
            X_ASP_Window aspWindow = null;
            if (asp_window_id < 1) {
                aspWindow = new X_ASP_Window(this.getCtx(), 0, this.get_TrxName());
                aspWindow.setASP_Level_ID(this.getLevelId());
                aspWindow.setAD_Window_ID(window.getAD_Window_ID());
                aspWindow.setASP_Status(this.getStatus());
                if (aspWindow.save()) {
                    ++this.noWindows;
                    asp_window_id = aspWindow.getASP_Window_ID();
                }
            } else {
                aspWindow = new X_ASP_Window(this.getCtx(), asp_window_id, this.get_TrxName());
            }
            for (MTab tab : window.getTabs(true, this.get_TrxName())) {
                int asp_tab_id = DB.getSQLValueEx(this.get_TrxName(), "SELECT ASP_Tab_ID FROM ASP_Tab WHERE ASP_Window_ID = ? AND AD_Tab_ID = ?", asp_window_id, tab.getAD_Tab_ID());
                X_ASP_Tab aspTab = null;
                if (asp_tab_id < 1) {
                    aspTab = new X_ASP_Tab(this.getCtx(), 0, this.get_TrxName());
                    aspTab.setASP_Window_ID(asp_window_id);
                    aspTab.setAD_Tab_ID(tab.getAD_Tab_ID());
                    aspTab.setASP_Status(this.getStatus());
                    aspTab.setAllFields(!this.isGenerateFields());
                    if (aspTab.save()) {
                        ++this.noTabs;
                        asp_tab_id = aspTab.getASP_Tab_ID();
                    }
                } else {
                    aspTab = new X_ASP_Tab(this.getCtx(), asp_tab_id, this.get_TrxName());
                }
                for (MField field : tab.getFields(true, this.get_TrxName())) {
                    MColumn column;
                    if (this.isGenerateFields() && DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM ASP_Field WHERE ASP_Tab_ID = ? AND AD_Field_ID = ?", aspTab.getASP_Tab_ID(), field.getAD_Field_ID()) < 1) {
                        X_ASP_Field aspField = new X_ASP_Field(this.getCtx(), 0, this.get_TrxName());
                        aspField.setASP_Tab_ID(aspTab.getASP_Tab_ID());
                        aspField.setAD_Field_ID(field.getAD_Field_ID());
                        aspField.setASP_Status(this.getStatus());
                        aspField.saveEx();
                        ++this.noFields;
                    }
                    if ((column = MColumn.get(this.getCtx(), field.getAD_Column_ID())).getAD_Reference_ID() != 28 || column.getAD_Process_ID() <= 0) continue;
                    this.generateProcess(column.getAD_Process_ID());
                }
            }
        } else if (menu.getAction().equals("P") || menu.getAction().equals("R")) {
            this.generateProcess(menu.getAD_Process_ID());
        } else if (menu.getAction().equals("X")) {
            MForm form = new MForm(this.getCtx(), menu.getAD_Form_ID(), this.get_TrxName());
            if (DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM ASP_Form WHERE ASP_Level_ID = ? AND AD_Form_ID = ?", this.getLevelId(), form.getAD_Form_ID()) < 1) {
                X_ASP_Form aspForm = new X_ASP_Form(this.getCtx(), 0, this.get_TrxName());
                aspForm.setASP_Level_ID(this.getLevelId());
                aspForm.setAD_Form_ID(form.getAD_Form_ID());
                aspForm.setASP_Status(this.getStatus());
                aspForm.saveEx();
                ++this.noForms;
            }
        } else if (menu.getAction().equals("S")) {
            MBrowse browse = new MBrowse(this.getCtx(), menu.getAD_Browse_ID(), this.get_TrxName());
            if (DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM ASP_Browse WHERE ASP_Level_ID = ? AND AD_Browse_ID = ?", this.getLevelId(), browse.getAD_Browse_ID()) < 1) {
                X_ASP_Browse aspBrowse = new X_ASP_Browse(this.getCtx(), 0, this.get_TrxName());
                aspBrowse.setASP_Level_ID(this.getLevelId());
                aspBrowse.setAD_Browse_ID(browse.getAD_Browse_ID());
                aspBrowse.setASP_Status(this.getStatus());
                aspBrowse.saveEx();
                ++this.noBrowses;
            }
        } else if (menu.getAction().equals("T")) {
            MTask task = new MTask(this.getCtx(), menu.getAD_Task_ID(), this.get_TrxName());
            if (DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM ASP_Task WHERE ASP_Level_ID = ? AND AD_Task_ID = ?", this.getLevelId(), task.getAD_Task_ID()) < 1) {
                X_ASP_Task aspTask = new X_ASP_Task(this.getCtx(), 0, this.get_TrxName());
                aspTask.setASP_Level_ID(this.getLevelId());
                aspTask.setAD_Task_ID(task.getAD_Task_ID());
                aspTask.setASP_Status(this.getStatus());
                aspTask.saveEx();
                ++this.noTasks;
            }
        } else if (menu.getAction().equals("F")) {
            this.generateWorkflow(menu.getAD_Workflow_ID());
        }
    }

    private void generateProcess(int p_AD_Process_ID) {
        MProcess process = new MProcess(this.getCtx(), p_AD_Process_ID, this.get_TrxName());
        int asp_process_id = DB.getSQLValueEx(this.get_TrxName(), "SELECT ASP_Process_ID FROM ASP_Process WHERE ASP_Level_ID = ? AND AD_Process_ID = ?", this.getLevelId(), process.getAD_Process_ID());
        X_ASP_Process aspProcess = null;
        if (asp_process_id < 1) {
            aspProcess = new X_ASP_Process(this.getCtx(), 0, this.get_TrxName());
            aspProcess.setASP_Level_ID(this.getLevelId());
            aspProcess.setAD_Process_ID(process.getAD_Process_ID());
            aspProcess.setASP_Status(this.getStatus());
            if (aspProcess.save()) {
                ++this.noProcesses;
                asp_process_id = aspProcess.getASP_Process_ID();
            }
        } else {
            aspProcess = new X_ASP_Process(this.getCtx(), asp_process_id, this.get_TrxName());
        }
        for (MProcessPara processpara : process.getParameters()) {
            if (DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM ASP_Process_Para WHERE ASP_Process_ID = ? AND AD_Process_Para_ID = ?", asp_process_id, processpara.getAD_Process_Para_ID()) >= 1) continue;
            X_ASP_Process_Para aspProcess_Para = new X_ASP_Process_Para(this.getCtx(), 0, this.get_TrxName());
            aspProcess_Para.setASP_Process_ID(asp_process_id);
            aspProcess_Para.setAD_Process_Para_ID(processpara.getAD_Process_Para_ID());
            aspProcess_Para.setASP_Status(this.getStatus());
            if (!aspProcess_Para.save()) continue;
            ++this.noParameters;
        }
        if (process.getAD_Workflow_ID() > 0) {
            this.generateWorkflow(process.getAD_Workflow_ID());
        }
    }

    private void generateWorkflow(int p_AD_Workflow_ID) {
        MWorkflow workflow = new MWorkflow(this.getCtx(), p_AD_Workflow_ID, this.get_TrxName());
        if (DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM ASP_Workflow WHERE ASP_Level_ID = ? AND AD_Workflow_ID = ?", this.getLevelId(), workflow.getAD_Workflow_ID()) < 1) {
            X_ASP_Workflow aspWorkflow = new X_ASP_Workflow(this.getCtx(), 0, this.get_TrxName());
            aspWorkflow.setASP_Level_ID(this.getLevelId());
            aspWorkflow.setAD_Workflow_ID(workflow.getAD_Workflow_ID());
            aspWorkflow.setASP_Status(this.getStatus());
            aspWorkflow.saveEx();
            ++this.noWorkflows;
        }
    }
}

