/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.test;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.adempiere.pos.test.POSClientSide;
import org.compiere.util.Env;

public class POSClientWindow
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = -8800776062735213378L;
    Properties m_ctx = null;
    final SystemTray tray = SystemTray.getSystemTray();
    private Container container;
    private JButton btnConnect;
    private JButton btnDisconnect;
    private JLabel lblTitle;
    private JLabel lblHost;
    private JLabel lblPrint;
    private JTextField fHost;
    private JComboBox cPrint;
    private JTextArea fTerminal = new JTextArea("");
    private POSClientSide p_Client;

    public POSClientWindow(Properties properties) {
        this.m_ctx = properties;
        this.init();
        this.setTitle("Print POS");
        this.setSize(350, 300);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        if (!SystemTray.isSupported()) {
            System.out.println("SystemTray is not supported");
            return;
        }
        this.setDefaultCloseOperation(3);
    }

    private void init() {
        this.container = this.getContentPane();
        this.container.setLayout(null);
        this.btnConnect = new JButton();
        this.btnConnect.setText("Connect");
        this.btnConnect.setBounds(70, 123, 100, 23);
        this.btnConnect.addActionListener(this);
        this.btnDisconnect = new JButton();
        this.btnDisconnect.setText("Disconnect");
        this.btnDisconnect.setBounds(170, 123, 120, 23);
        this.btnDisconnect.addActionListener(this);
        this.btnDisconnect.setEnabled(false);
        this.lblTitle = new JLabel();
        this.lblTitle.setText("Print POS");
        this.lblTitle.setBounds(120, 13, 180, 23);
        this.lblHost = new JLabel();
        this.lblHost.setText("Host Server");
        this.lblHost.setBounds(55, 40, 190, 23);
        this.fHost = new JTextField();
        this.fHost.setText("localhost");
        this.fHost.setBounds(140, 40, 180, 23);
        this.lblPrint = new JLabel();
        this.lblPrint.setText("Printer");
        this.lblPrint.setBounds(85, 67, 190, 23);
        PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(null, null);
        this.cPrint = new JComboBox();
        for (PrintService printService : printServiceArray) {
            this.cPrint.addItem(printService.getName());
        }
        this.cPrint.setBounds(140, 67, 180, 23);
        this.fTerminal.setBounds(0, 190, 300, 300);
        this.fTerminal.setBackground(Color.black);
        this.fTerminal.setForeground(Color.green);
        this.fTerminal.setSelectionColor(Color.red);
        this.fTerminal.setFont(new Font("consolas", 1, 10));
        this.fTerminal.setEnabled(false);
        this.fTerminal.setWrapStyleWord(true);
        this.fTerminal.setLineWrap(true);
        this.container.add(this.lblTitle);
        this.container.add(this.lblHost);
        this.container.add(this.fHost);
        this.container.add(this.lblPrint);
        this.container.add(this.cPrint);
        this.container.add(this.btnConnect);
        this.container.add(this.btnDisconnect);
        JScrollPane jScrollPane = new JScrollPane(this.fTerminal);
        jScrollPane.setBounds(new Rectangle(25, 150, 300, 120));
        this.getContentPane().add(jScrollPane);
    }

    public void setHostName(String string) {
        this.fHost.setText(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnConnect) {
            String string = (String)this.cPrint.getSelectedItem();
            Env.setContext(this.m_ctx, "#Printer", string);
            this.p_Client = new POSClientSide(this.m_ctx, this.fHost.getText(), string, this.fTerminal);
            boolean bl = this.p_Client.isStopped();
            this.btnConnect.setEnabled(bl);
            this.btnDisconnect.setEnabled(!bl);
        } else if (actionEvent.getSource() == this.btnDisconnect) {
            this.p_Client.closeConnect();
            this.btnConnect.setEnabled(true);
            this.btnDisconnect.setEnabled(false);
        }
    }
}

