/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.adempiere.core.domains.models.I_C_Invoice;
import org.adempiere.core.domains.models.I_C_Order;
import org.adempiere.core.domains.models.I_M_InOut;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.process.ReverseTheSalesTransactionAbstract;
import org.compiere.model.MBankStatement;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPayment;
import org.compiere.model.PO;
import org.compiere.process.InOutGenerate;
import org.compiere.process.InvoiceGenerate;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.services.dsl.ProcessBuilder;
import org.spin.process.OrderRMACreateFrom;
import org.spin.process.OrderRMACreateFromInvoice;

public class ReverseTheSalesTransaction
extends ReverseTheSalesTransactionAbstract {
    private Timestamp today;

    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        this.today = new Timestamp(System.currentTimeMillis());
        MOrder sourceOrder = new MOrder(this.getCtx(), this.getOrderId(), this.get_TrxName());
        MOrder returnOrder = null;
        List<MInOut> shipments = Arrays.asList(sourceOrder.getShipments());
        boolean isDelivered = false;
        if (shipments.size() > 0 && shipments.stream().filter(shipment -> shipment.getDocStatus().equals("CO") || shipment.getDocStatus().equals("CL")).findFirst().isPresent()) {
            isDelivered = true;
            if (sourceOrder.getC_BPartner_ID() != this.getBPartnerId() || this.isCancelled()) {
                returnOrder = this.createReturnSource(sourceOrder);
                ArrayList<Integer> selectedRecordsIds = new ArrayList<Integer>();
                ProcessBuilder builder = ProcessBuilder.create(this.getCtx()).process(OrderRMACreateFrom.getProcessId()).withRecordId(I_C_Order.Table_ID, returnOrder.getC_Order_ID());
                LinkedHashMap<Integer, LinkedHashMap<String, Object>> selection = new LinkedHashMap<Integer, LinkedHashMap<String, Object>>();
                shipments.forEach(sourceShipment -> Arrays.asList(sourceShipment.getLines()).forEach(sourceShipmentLine -> {
                    LinkedHashMap<String, Number> selectionValues = new LinkedHashMap<String, Number>();
                    selectionValues.put("CF_M_Product_ID", sourceShipmentLine.getM_Product_ID());
                    selectionValues.put("CF_C_Charge_ID", sourceShipmentLine.getC_Charge_ID());
                    selectionValues.put("CF_C_UOM_ID", sourceShipmentLine.getC_UOM_ID());
                    selectionValues.put("CF_QtyEntered", sourceShipmentLine.getQtyEntered());
                    selectedRecordsIds.add(sourceShipmentLine.getM_InOutLine_ID());
                    selection.put(sourceShipmentLine.getM_InOutLine_ID(), selectionValues);
                }));
                builder.withSelectedRecordsIds(I_M_InOut.Table_ID, selectedRecordsIds, selection).withoutTransactionClose().execute(this.get_TrxName());
            }
        } else {
            List<MInvoice> invoices = Arrays.asList(sourceOrder.getInvoices());
            if (invoices.size() > 0 && (sourceOrder.getC_BPartner_ID() != this.getBPartnerId() || this.isCancelled())) {
                returnOrder = this.createReturnSource(sourceOrder);
                ArrayList<Integer> selectedRecordsIds = new ArrayList<Integer>();
                ProcessBuilder builder = ProcessBuilder.create(this.getCtx()).process(OrderRMACreateFromInvoice.getProcessId()).withRecordId(I_C_Order.Table_ID, returnOrder.getC_Order_ID());
                LinkedHashMap<Integer, LinkedHashMap<String, Object>> selection = new LinkedHashMap<Integer, LinkedHashMap<String, Object>>();
                invoices.forEach(invoice -> Arrays.asList(invoice.getLines()).forEach(sourceInvoiceLine -> {
                    LinkedHashMap<String, Number> selectionValues = new LinkedHashMap<String, Number>();
                    selectionValues.put("CF_M_Product_ID", sourceInvoiceLine.getM_Product_ID());
                    selectionValues.put("CF_C_Charge_ID", sourceInvoiceLine.getC_Charge_ID());
                    selectionValues.put("CF_C_UOM_ID", sourceInvoiceLine.getC_UOM_ID());
                    selectionValues.put("CF_QtyEntered", sourceInvoiceLine.getQtyEntered());
                    selectedRecordsIds.add(sourceInvoiceLine.getC_InvoiceLine_ID());
                    selection.put(sourceInvoiceLine.getC_InvoiceLine_ID(), selectionValues);
                }));
                builder.withSelectedRecordsIds(I_C_Invoice.Table_ID, selectedRecordsIds, selection).withoutTransactionClose().execute(this.get_TrxName());
            }
        }
        if (returnOrder == null) {
            return "@M_RMA_ID@ @NotFound@";
        }
        if (!returnOrder.processIt("CO")) {
            return returnOrder.getProcessMsg();
        }
        returnOrder.saveEx();
        this.getProcessInfo().setRecord_ID(returnOrder.get_ID());
        if (isDelivered && (sourceOrder.getC_BPartner_ID() != this.getBPartnerId() || this.isCancelled())) {
            ProcessBuilder.create(this.getCtx()).process(InOutGenerate.getProcessId()).withTitle(InOutGenerate.getProcessName()).withParameter("M_Warehouse_ID", sourceOrder.getM_Warehouse_ID()).withParameter("DocAction", "CO").withSelectedRecordsIds(I_C_Order.Table_ID, Arrays.asList(returnOrder.getC_Order_ID())).withoutTransactionClose().execute(this.get_TrxName());
        }
        ProcessInfo invoiceInformation = null;
        if (sourceOrder.getC_BPartner_ID() != this.getBPartnerId() || this.isCancelled()) {
            invoiceInformation = ProcessBuilder.create(this.getCtx()).process(InvoiceGenerate.getProcessId()).withTitle(InvoiceGenerate.getProcessName()).withParameter("AD_Org_ID", sourceOrder.getAD_Org_ID()).withParameter("C_Order_ID", returnOrder.getC_Order_ID()).withParameter("DocAction", "CO").withSelectedRecordsIds(I_C_Order.Table_ID, Arrays.asList(returnOrder.getC_Order_ID())).withoutTransactionClose().execute(this.get_TrxName());
        }
        if (invoiceInformation == null || invoiceInformation.getRecord_ID() == 0) {
            throw new AdempiereException("@C_Invoice_ID@ @NotFound@");
        }
        this.cancelPayments(sourceOrder, new MInvoice(this.getCtx(), invoiceInformation.getRecord_ID(), this.get_TrxName())).forEach(payment -> this.addLog(payment.getDocumentInfo()));
        sourceOrder.setDocStatus("CL");
        sourceOrder.setDocAction("--");
        sourceOrder.saveEx();
        if (isDelivered) {
            returnOrder.setDocStatus("CL");
            returnOrder.setDocAction("--");
            returnOrder.saveEx();
        }
        return "@Ok@";
    }

    private List<MPayment> cancelPayments(MOrder sourceOrder, MInvoice creditMemo) {
        ArrayList<MPayment> payments = new ArrayList<MPayment>();
        MPayment.getOfOrder(sourceOrder).forEach(sourcePayment -> {
            MPayment payment = new MPayment(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(sourcePayment, payment);
            payment.setDateTrx(this.today);
            payment.setDateAcct(this.today);
            payment.addDescription(Msg.parseTranslation(this.getCtx(), " @From@ " + sourcePayment.getDocumentNo() + " @of@ @C_Order_ID@ " + sourceOrder.getDocumentNo()));
            payment.setIsReceipt(false);
            payment.setC_DocType_ID(MDocType.getDocType("APP"));
            payment.setDocAction("CO");
            payment.setDocStatus("DR");
            payment.setIsPrepayment(creditMemo.getC_Invoice_ID() <= 0);
            payment.setC_Order_ID(creditMemo.getC_Order_ID());
            payment.setC_Invoice_ID(creditMemo.getC_Invoice_ID());
            payment.saveEx();
            payment.processIt("CO");
            payment.saveEx();
            MBankStatement.addPayment(payment);
            payments.add(payment);
        });
        return payments;
    }

    private MOrder createReturnSource(MOrder source) {
        MOrder target = new MOrder(this.getCtx(), 0, this.get_TrxName());
        target.set_TrxName(this.get_TrxName());
        PO.copyValues(source, target, false);
        target.setDocStatus("DR");
        target.setDocAction("CO");
        target.setIsSelected(false);
        target.setDateOrdered(this.today);
        target.setDateAcct(this.today);
        target.setDatePromised(this.today);
        target.setDatePrinted(null);
        target.setIsPrinted(false);
        target.setIsApproved(false);
        target.setIsCreditApproved(false);
        target.setC_Payment_ID(0);
        target.setC_CashLine_ID(0);
        target.setGrandTotal(Env.ZERO);
        target.setTotalLines(Env.ZERO);
        target.setIsDelivered(false);
        target.setIsInvoiced(false);
        target.setIsSelfService(false);
        target.setIsTransferred(false);
        target.setPosted(false);
        target.setProcessed(false);
        target.save(source.get_TrxName());
        if (this.getDocTypeRMAId() != 0) {
            target.setC_DocTypeTarget_ID(this.getDocTypeRMAId());
        } else {
            target.setC_DocTypeTarget_ID(MDocType.getDocTypeBaseOnSubType(source.getAD_Org_ID(), "SOO", "RM"));
        }
        target.setC_BPartner_ID(this.getBPartnerId());
        target.setRef_Order_ID(source.getC_Order_ID());
        target.setProcessed(false);
        target.saveEx();
        return target;
    }
}

