/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.process;

import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.process.CreateOrderBasedOnAnother;
import org.adempiere.pos.process.GenerateImmediateInvoiceAbstract;
import org.adempiere.pos.process.ReverseTheSalesTransaction;
import org.compiere.model.MOrder;
import org.compiere.process.ProcessInfo;
import org.compiere.util.ASyncProcess;
import org.eevolution.services.dsl.ProcessBuilder;

public class GenerateImmediateInvoice
extends GenerateImmediateInvoiceAbstract
implements ASyncProcess {
    private MOrder order;

    @Override
    protected void prepare() {
        super.prepare();
        this.order = new MOrder(this.getCtx(), this.getOrderId(), this.get_TrxName());
    }

    @Override
    protected String doIt() throws Exception {
        ProcessInfo processInfo = ProcessBuilder.create(this.getCtx()).process(CreateOrderBasedOnAnother.getProcessId()).withTitle(CreateOrderBasedOnAnother.getProcessName()).withParentProcess(this).withParameter("C_OrderSource_ID", this.order.get_ID()).withParameter("Bill_BPartner_ID", this.getInvoicePartnerId()).withParameter("DocSubTypeSO", this.getSOSubType()).withParameter("DocAction", "CO").withParameter("IsIncludePayments", this.isIncludePayments()).withParameter("IsAllocated", this.isAllocated()).withoutTransactionClose().execute(this.get_TrxName());
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getTitle() + " @ProcessRunError@ " + processInfo.getSummary());
        }
        this.addLog(processInfo.getLogInfo());
        int newOrderId = processInfo.getRecord_ID();
        processInfo = ProcessBuilder.create(this.getCtx()).process(ReverseTheSalesTransaction.getProcessId()).withTitle(ReverseTheSalesTransaction.getProcessName()).withParentProcess(this).withParameter("C_Order_ID", this.order.get_ID()).withParameter("Bill_BPartner_ID", this.getInvoicePartnerId()).withParameter("IsShipConfirm", this.isipReceiptConfirmation()).withoutTransactionClose().execute(this.get_TrxName());
        if (processInfo.isError()) {
            throw new AdempiereException(processInfo.getTitle() + " @ProcessRunError@ " + processInfo.getSummary());
        }
        this.addLog(processInfo.getLogInfo());
        this.getProcessInfo().setRecord_ID(newOrderId);
        return "@Ok@";
    }

    @Override
    public void lockUI(ProcessInfo pi) {
    }

    @Override
    public void unlockUI(ProcessInfo pi) {
    }

    @Override
    public boolean isUILocked() {
        return false;
    }

    @Override
    public void executeASync(ProcessInfo pi) {
    }
}

