/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.Box;
import javax.swing.JComponent;
import org.adempiere.plaf.AdempierePLAF;
import org.adempiere.pos.POSTextField;
import org.adempiere.pos.VPOS;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.ed.VLocation;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MLocation;
import org.compiere.model.MLocationLookup;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.swing.CDialog;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public final class VPOSBPartner
extends CDialog
implements ActionListener {
    private static final long serialVersionUID = -4130643780412193122L;
    private VPOS pos;
    private int windowNo;
    private MBPartner partner = null;
    private MBPartnerLocation partnerLocation = null;
    private MUser contact = null;
    private boolean isReadOnly = false;
    private Insets labelInsets = new Insets(2, 15, 2, 0);
    private Insets fieldInsets = new Insets(2, 5, 2, 10);
    private GridBagConstraints m_gbc = new GridBagConstraints();
    private int m_line;
    private static CLogger log = CLogger.getCLogger(VPOSBPartner.class);
    private POSTextField fValue;
    private POSTextField fName;
    private POSTextField fName2;
    private POSTextField fContact;
    private POSTextField fPhone;
    private POSTextField fPhone2;
    private POSTextField fEMail;
    private VLocation fAddress;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel centerPanel = new CPanel();
    private CPanel southPanel = new CPanel();
    private GridBagLayout centerLayout = new GridBagLayout();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private BorderLayout southLayout = new BorderLayout();

    public VPOSBPartner(Frame frame, int n, VPOS vPOS) {
        super(frame, Msg.translate(Env.getCtx(), "C_BPartner_ID"), true);
        this.pos = vPOS;
        this.windowNo = n;
        this.isReadOnly = !MRole.getDefault().canUpdate(Env.getAD_Client_ID(Env.getCtx()), Env.getAD_Org_ID(Env.getCtx()), MBPartner.Table_ID, 0, false);
        log.info("R/O=" + this.isReadOnly);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            log.log(Level.SEVERE, exception.getMessage());
        }
        this.initBPartner();
        AEnv.positionCenterWindow(frame, this);
    }

    void jbInit() throws Exception {
        this.mainPanel.setLayout(this.mainLayout);
        this.southPanel.setLayout(this.southLayout);
        this.centerPanel.setLayout(this.centerLayout);
        this.mainLayout.setVgap(5);
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.centerPanel, "Center");
        this.mainPanel.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.confirmPanel, "Center");
        this.setMinimumSize(new Dimension(400, 300));
        this.confirmPanel.addActionListener(this);
    }

    private void initBPartner() {
        this.m_gbc.anchor = 18;
        this.m_gbc.gridx = 0;
        this.m_gbc.gridy = 0;
        this.m_gbc.gridwidth = 1;
        this.m_gbc.weightx = 0.0;
        this.m_gbc.weighty = 0.0;
        this.m_gbc.fill = 2;
        this.m_gbc.ipadx = 0;
        this.m_gbc.ipady = 0;
        this.m_line = 0;
        this.fValue = new POSTextField("Value", this.pos.getKeyboard());
        this.fValue.addActionListener(this);
        this.fValue.setPreferredSize(new Dimension(300, 25));
        this.createLine(this.fValue, "Value", true);
        this.fName = new POSTextField("Name", this.pos.getKeyboard());
        this.fName.addActionListener(this);
        this.createLine(this.fName, "Name", false).setFontBold(true);
        this.fName2 = new POSTextField("Name2", this.pos.getKeyboard());
        this.createLine(this.fName2, "Name2", false);
        this.fContact = new POSTextField("Contact", this.pos.getKeyboard());
        this.createLine(this.fContact, "Contact", true).setFontBold(true);
        this.fEMail = new POSTextField("EMail", this.pos.getKeyboard());
        this.createLine(this.fEMail, "EMail", false);
        boolean bl = this.isReadOnly;
        if (!bl) {
            boolean bl2 = bl = !MRole.getDefault().canUpdate(Env.getAD_Client_ID(Env.getCtx()), Env.getAD_Org_ID(Env.getCtx()), MBPartnerLocation.Table_ID, 0, false);
        }
        if (!bl) {
            bl = !MRole.getDefault().canUpdate(Env.getAD_Client_ID(Env.getCtx()), Env.getAD_Org_ID(Env.getCtx()), MLocation.Table_ID, 0, false);
        }
        this.fAddress = new VLocation("C_Location_ID", false, bl, true, new MLocationLookup(Env.getCtx(), this.windowNo));
        this.fAddress.setValue(null);
        this.createLine(this.fAddress, "C_Location_ID", true).setFontBold(true);
        this.fPhone = new POSTextField("Phone", this.pos.getKeyboard());
        this.createLine(this.fPhone, "Phone", true);
        this.fPhone2 = new POSTextField("Phone2", this.pos.getKeyboard());
        this.createLine(this.fPhone2, "Phone2", false);
        this.fName.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        this.fValue.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        this.fAddress.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
    }

    private CLabel createLine(JComponent jComponent, String string, boolean bl) {
        if (bl) {
            this.m_gbc.gridy = this.m_line++;
            this.m_gbc.gridx = 1;
            this.m_gbc.insets = this.fieldInsets;
            this.centerPanel.add(Box.createHorizontalStrut(6), this.m_gbc);
        }
        this.m_gbc.gridy = this.m_line++;
        this.m_gbc.gridx = 0;
        this.m_gbc.insets = this.labelInsets;
        this.m_gbc.fill = 2;
        CLabel cLabel = new CLabel(Msg.translate(Env.getCtx(), string));
        this.centerPanel.add((Component)cLabel, this.m_gbc);
        this.m_gbc.gridx = 1;
        this.m_gbc.insets = this.fieldInsets;
        this.m_gbc.fill = 2;
        this.centerPanel.add((Component)jComponent, this.m_gbc);
        if (this.isReadOnly) {
            jComponent.setEnabled(false);
        }
        return cLabel;
    }

    public boolean loadBPartner(int n) {
        log.config("C_BPartner_ID=" + n);
        if (n == 0) {
            this.partner = null;
            this.partnerLocation = null;
            this.contact = null;
            return true;
        }
        this.partner = new MBPartner(Env.getCtx(), n, null);
        if (this.partner.get_ID() == 0) {
            ADialog.error(this.windowNo, this, "BPartnerNotFound");
            return false;
        }
        this.fValue.setText(this.partner.getValue());
        this.fName.setText(this.partner.getName());
        this.fName2.setText(this.partner.getName2());
        this.partnerLocation = this.partner.getLocation(Env.getContextAsInt(Env.getCtx(), this.windowNo, "C_BPartner_Location_ID"));
        if (this.partnerLocation != null) {
            int n2 = this.partnerLocation.getC_Location_ID();
            this.fAddress.setValue(n2);
            this.fPhone.setText(this.partnerLocation.getPhone());
            this.fPhone2.setText(this.partnerLocation.getPhone2());
        }
        this.contact = this.partner.getContact(Env.getContextAsInt(Env.getCtx(), this.windowNo, "AD_User_ID"));
        if (this.contact != null) {
            this.fContact.setText(this.contact.getName());
            this.fEMail.setText(this.contact.getEMail());
            this.fPhone.setText(this.contact.getPhone());
            this.fPhone2.setText(this.contact.getPhone2());
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isReadOnly) {
            this.dispose();
        } else if (actionEvent.getSource() == this.fValue) {
            if (this.fName.getText() == null || this.fName.getText().length() == 0) {
                this.fName.setText(this.fValue.getText());
            }
        } else if (actionEvent.getSource() == this.fName) {
            if (this.fContact.getText() == null || this.fContact.getText().length() == 0) {
                this.fContact.setText(this.fName.getText());
            }
        } else if (actionEvent.getActionCommand().equals("Ok") && this.actionSave()) {
            this.dispose();
        } else if (actionEvent.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
    }

    private boolean actionSave() {
        String string;
        log.config("");
        if (this.fValue.getText().equals("")) {
            this.fValue.setBackground(AdempierePLAF.getFieldBackground_Error());
            return false;
        }
        this.fValue.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        if (this.fName.getText().equals("")) {
            this.fName.setBackground(AdempierePLAF.getFieldBackground_Error());
            return false;
        }
        this.fName.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        if (this.fAddress.getC_Location_ID() == 0) {
            this.fAddress.setBackground(AdempierePLAF.getFieldBackground_Error());
            return false;
        }
        this.fAddress.setBackground(AdempierePLAF.getFieldBackground_Mandatory());
        if (this.partner == null) {
            int n = Env.getAD_Client_ID(Env.getCtx());
            this.partner = MBPartner.getTemplate(Env.getCtx(), n, this.pos.getC_POS_ID());
            this.partner.setAD_Org_ID(Env.getAD_Org_ID(Env.getCtx()));
            boolean bl = !"N".equals(Env.getContext(Env.getCtx(), this.windowNo, "IsSOTrx"));
            this.partner.setIsCustomer(bl);
            this.partner.setIsVendor(!bl);
        }
        if ((string = this.fValue.getText()) == null || string.length() == 0) {
            string = DB.getDocumentNo(Env.getAD_Client_ID(Env.getCtx()), "C_BPartner", null, (PO)this.partner);
            this.fValue.setText(string);
        }
        this.partner.setValue(this.fValue.getText());
        this.partner.setName(this.fName.getText());
        this.partner.setName2(this.fName2.getText());
        if (this.partner.save()) {
            log.fine("C_BPartner_ID=" + this.partner.getC_BPartner_ID());
        } else {
            ADialog.error(this.windowNo, this, "BPartnerNotSaved");
        }
        if (this.partnerLocation == null) {
            this.partnerLocation = new MBPartnerLocation(this.partner);
        }
        this.partnerLocation.setC_Location_ID(this.fAddress.getC_Location_ID());
        this.partnerLocation.setPhone(this.fPhone.getText());
        this.partnerLocation.setPhone2(this.fPhone2.getText());
        if (this.partnerLocation.save()) {
            log.fine("C_BPartner_Location_ID=" + this.partnerLocation.getC_BPartner_Location_ID());
        } else {
            ADialog.error(this.windowNo, this, "BPartnerNotSaved", Msg.translate(Env.getCtx(), "C_BPartner_Location_ID"));
        }
        String string2 = this.fContact.getText();
        String string3 = this.fEMail.getText();
        if (this.contact == null && (string2.length() > 0 || string3.length() > 0)) {
            this.contact = new MUser(this.partner);
        }
        if (this.contact != null) {
            if (string2.length() == 0) {
                string2 = this.fName.getText();
            }
            this.contact.setName(string2);
            this.contact.setEMail(string3);
            this.contact.setPhone(this.fPhone.getText());
            this.contact.setPhone2(this.fPhone2.getText());
            if (this.contact.save()) {
                log.fine("AD_User_ID=" + this.contact.getAD_User_ID());
            } else {
                ADialog.error(this.windowNo, this, "BPartnerNotSaved", Msg.translate(Env.getCtx(), "AD_User_ID"));
            }
        }
        return true;
    }

    public int getC_BPartner_ID() {
        if (this.partner == null) {
            return 0;
        }
        return this.partner.getC_BPartner_ID();
    }
}

