/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.command;

import java.util.Arrays;
import java.util.List;
import org.adempiere.core.domains.models.I_C_Order;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pos.command.Command;
import org.adempiere.pos.command.CommandAbstract;
import org.adempiere.pos.command.CommandReceiver;
import org.compiere.model.MBankStatement;
import org.compiere.model.MDocType;
import org.compiere.model.MInOut;
import org.compiere.model.MInvoice;
import org.compiere.model.MOrder;
import org.compiere.model.MPOS;
import org.compiere.model.MPayment;
import org.compiere.process.InOutGenerate;
import org.compiere.process.InvoiceGenerate;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.util.Util;
import org.eevolution.services.dsl.ProcessBuilder;

public class CommandCompleteDocument
extends CommandAbstract
implements Command {
    public CommandCompleteDocument(String command, String event) {
        this.command = command;
        this.event = event;
    }

    @Override
    public void execute(final CommandReceiver commandReceiver) {
        Trx.run(new TrxRunnable(){

            @Override
            public void run(String trxName) {
                MOrder order = new MOrder(commandReceiver.getCtx(), commandReceiver.getOrderId(), trxName);
                order.setDocAction("CO");
                order.processIt("CO");
                order.saveEx();
                ProcessInfo processInformation = new ProcessInfo("Complete Order", 0, I_C_Order.Table_ID, order.getC_Order_ID());
                processInformation.setSummary("@C_Order_ID@: " + order.getDocumentNo() + " @Completed@");
                MDocType documentType = MDocType.get(commandReceiver.getCtx(), order.getC_DocType_ID());
                if (!Util.isEmpty(documentType.getDocSubTypeSO()) && documentType.getDocSubTypeSO().equals("RM")) {
                    List<MInOut> shipments;
                    MOrder sourceOrder = null;
                    if (order.getRef_Order_ID() != 0) {
                        sourceOrder = (MOrder)order.getRef_Order();
                    }
                    if (sourceOrder != null && (shipments = Arrays.asList(sourceOrder.getShipments())).size() > 0) {
                        ProcessBuilder.create(commandReceiver.getCtx()).process(InOutGenerate.getProcessId()).withTitle(InOutGenerate.getProcessName()).withParameter("M_Warehouse_ID", sourceOrder.getM_Warehouse_ID()).withParameter("DocAction", "CO").withSelectedRecordsIds(I_C_Order.Table_ID, Arrays.asList(order.getC_Order_ID())).withoutTransactionClose().execute(trxName);
                    }
                    ProcessInfo invoiceInformation = null;
                    invoiceInformation = ProcessBuilder.create(commandReceiver.getCtx()).process(InvoiceGenerate.getProcessId()).withTitle(InvoiceGenerate.getProcessName()).withParameter("AD_Org_ID", order.getAD_Org_ID()).withParameter("C_Order_ID", order.getC_Order_ID()).withParameter("DocAction", "CO").withoutTransactionClose().execute(trxName);
                    if (invoiceInformation == null || invoiceInformation.getRecord_ID() == 0) {
                        throw new AdempiereException("@C_Invoice_ID@ @NotFound@");
                    }
                    MInvoice creditMemo = new MInvoice(commandReceiver.getCtx(), invoiceInformation.getRecord_ID(), trxName);
                    CommandCompleteDocument.this.createPayment(commandReceiver, "M", order, creditMemo.getDocumentNo(), trxName);
                    commandReceiver.setProcessInfo(processInformation);
                }
            }
        });
    }

    private MPayment createPayment(CommandReceiver commandReceiver, String tenderType, MOrder order, String referenceNo, String transactionName) {
        MPayment payment = new MPayment(commandReceiver.getCtx(), 0, transactionName);
        MPOS pos = MPOS.get(commandReceiver.getCtx(), commandReceiver.getPOSId());
        payment.setAD_Org_ID(order.getAD_Org_ID());
        payment.setC_POS_ID(commandReceiver.getPOSId());
        payment.setTenderType(tenderType);
        payment.setIsReceipt(false);
        payment.setC_Order_ID(commandReceiver.getOrderId());
        payment.setIsPrepayment(true);
        payment.setC_BPartner_ID(commandReceiver.getPartnerId());
        payment.setDateTrx(order.getDateOrdered());
        payment.setDateAcct(order.getDateOrdered());
        payment.setCreditCardType(null);
        payment.setC_CashBook_ID(pos.getC_CashBook_ID());
        payment.setAmount(order.getC_Currency_ID(), order.getGrandTotal());
        int conversionTypeId = pos.getC_ConversionType_ID();
        if (conversionTypeId > 0) {
            payment.setC_ConversionType_ID(conversionTypeId);
        }
        payment.setC_BankAccount_ID(pos.getC_BankAccount_ID());
        payment.setDocumentNo(referenceNo);
        payment.saveEx();
        payment.setDocAction("CO");
        payment.setDocStatus("DR");
        if (payment.processIt("CO")) {
            payment.saveEx();
            MBankStatement.addPayment(payment);
            return payment;
        }
        return null;
    }
}

