/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.PointerInfo;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.Timer;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.plaf.AdempierePLAF;
import org.adempiere.pos.AdempierePOSException;
import org.adempiere.pos.POSActionPanel;
import org.adempiere.pos.POSDocumentPanel;
import org.adempiere.pos.POSInfoProduct;
import org.adempiere.pos.POSKeyboard;
import org.adempiere.pos.POSKeyboardFocusManager;
import org.adempiere.pos.POSOrderLinePanel;
import org.adempiere.pos.POSQuantityPanel;
import org.adempiere.pos.POSScalesListener;
import org.adempiere.pos.POSUserPinDialog;
import org.adempiere.pos.POSUserPinListener;
import org.adempiere.pos.services.CPOS;
import org.adempiere.pos.services.POSPanelInterface;
import org.adempiere.pos.services.POSScalesPanelInterface;
import org.compiere.apps.ADialog;
import org.compiere.apps.StatusBar;
import org.compiere.apps.Waiting;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.model.MPOS;
import org.compiere.model.MPOSKey;
import org.compiere.swing.CFrame;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VPOS
extends CPOS
implements FormPanel,
POSPanelInterface,
POSScalesPanelInterface {
    private CFrame frame;
    private CPanel mainPanel;
    private JSplitPane dividerPane;
    private CPanel leftPanel;
    private POSActionPanel actionPanel;
    private POSQuantityPanel quantityPanel;
    private POSInfoProduct infoProductPanel;
    private POSOrderLinePanel orderLinePanel;
    private POSDocumentPanel documentPanel;
    private StatusBar statusBar;
    private Timer logoutTimer;
    private Timer userPinTimer;
    private Timer scalesTimer;
    private Boolean isCorrectUserPin;
    private POSUserPinListener userPinListener;
    private POSScalesListener scalesListener;
    private POSKeyboardFocusManager focusManager;
    private KeyboardFocusManager originalKeyboardFocusManager;
    private HashMap<Integer, POSKeyboard> keyboards = new HashMap();
    private CLogger logger = CLogger.getCLogger(this.getClass());
    private Font font;
    private Font plainFont;
    private Font bigFont;
    private Font bigPlainFont;
    public int fieldHeight;
    private int buttonSize;
    private String statusBarInfo;
    private Waiting waiting;

    public VPOS() {
        this.mainPanel = new CPanel(new BorderLayout());
        this.mainPanel.setFocusCycleRoot(true);
        this.dividerPane = new JSplitPane();
        this.dividerPane.setOrientation(1);
        this.dividerPane.setBorder(BorderFactory.createEtchedBorder());
        this.dividerPane.setContinuousLayout(true);
        this.dividerPane.setDividerLocation(this.dividerPane.getSize().width - this.dividerPane.getInsets().right - this.dividerPane.getDividerSize() - 100);
        this.mainPanel.add((Component)this.dividerPane, "Center");
        this.statusBar = new StatusBar();
        this.statusBarInfo = "";
        this.mainPanel.add((Component)this.statusBar, "South");
        this.font = AdempierePLAF.getFont_Field().deriveFont(1, 12.0f);
        this.plainFont = AdempierePLAF.getFont_Field().deriveFont(0, 12.0f);
        this.bigFont = AdempierePLAF.getFont_Field().deriveFont(1, 14.0f);
        this.bigPlainFont = AdempierePLAF.getFont_Field().deriveFont(0, 14.0f);
        this.fieldHeight = 45;
        this.buttonSize = 45;
    }

    private void settingKeyboardFocusManager() {
        if (this.isVirtualKeyboard()) {
            this.originalKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.focusManager = new POSKeyboardFocusManager();
            KeyboardFocusManager.setCurrentKeyboardFocusManager(this.focusManager);
        }
    }

    @Override
    public void init(int WindowNo, final FormFrame frame) {
        this.frame = frame.getCFrame();
        this.frame.setExtendedState(6);
        this.frame.setResizable(true);
        this.logger.info("init - SalesRep_ID=" + Env.getAD_User_ID(this.getCtx()));
        this.setWindowNo(WindowNo);
        frame.setJMenuBar(null);
        if (!this.loadPOS()) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CFrame closeFrame = frame.getCFrame();
                    closeFrame.dispatchEvent(new WindowEvent(closeFrame, 201));
                    VPOS.this.dispose();
                }
            });
            return;
        }
        this.userPinListener = new POSUserPinListener(this);
        this.userPinTimer = new Timer((this.getPINEntryTimeout() + 10) * 1000, this.userPinListener);
        if (this.isPresentElectronicScales()) {
            this.scalesListener = new POSScalesListener(this);
            this.scalesTimer = new Timer(400, this.scalesListener);
        }
        this.isCorrectUserPin = null;
        this.settingKeyboardFocusManager();
        if (this.getM_POS() == null) {
            if (this.frame != null) {
                this.frame.dispose();
            }
            return;
        }
        try {
            if (!this.dynInit()) {
                this.dispose();
                return;
            }
            frame.getContentPane().add((Component)this.mainPanel, "Center");
        }
        catch (AdempierePOSException exception) {
            ADialog.error(this.getWindowNo(), this.frame, exception.getLocalizedMessage());
            this.dispose();
            return;
        }
        this.logger.config("PosPanel.init - " + this.mainPanel.getPreferredSize());
        if (this.getAutoLogoutDelay() > 0 && this.logoutTimer == null) {
            this.logoutTimer = new Timer(1000, new ActionListener(){
                PointerInfo pi = null;
                long lastMouseMove = System.currentTimeMillis();
                long lastKeyboardEvent = System.currentTimeMillis();

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        long now = actionEvent.getWhen();
                        PointerInfo newPi = MouseInfo.getPointerInfo();
                        if (newPi != null && this.pi != null && !this.pi.getLocation().equals(newPi.getLocation())) {
                            this.lastMouseMove = now;
                        }
                        this.pi = newPi;
                        this.lastKeyboardEvent = VPOS.this.isVirtualKeyboard() ? VPOS.this.focusManager.getLastWhen() : 0L;
                        if ((long)(VPOS.this.getAutoLogoutDelay() * 1000) >= now - Math.max(this.lastKeyboardEvent, this.lastMouseMove)) return;
                    }
                    catch (AdempiereException exception) {
                        ADialog.error(VPOS.this.getWindowNo(), VPOS.this.getFrame(), exception.getLocalizedMessage());
                    }
                }
            });
            this.logoutTimer.start();
        }
        if (this.isVirtualKeyboard()) {
            this.focusManager.start();
        }
    }

    public CFrame getFrame() {
        return this.frame;
    }

    public Font getFont() {
        return this.font;
    }

    public Font getPlainFont() {
        return this.plainFont;
    }

    public Font getBigFont() {
        return this.bigFont;
    }

    public Font getBigPlainFont() {
        return this.bigPlainFont;
    }

    public int getFieldHeight() {
        return this.fieldHeight;
    }

    public int getButtonSize() {
        return this.buttonSize;
    }

    public void autoSize() {
        this.dividerPane.setResizeWeight(0.6);
    }

    public Dimension getSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    private boolean loadPOS() {
        String title;
        int salesRep_ID = Env.getAD_User_ID(this.getCtx());
        this.setPOS(salesRep_ID);
        if (this.getM_POS() != null) {
            this.validLocator();
            return true;
        }
        int orgId = Env.getAD_Org_ID(this.getCtx());
        String msg = Msg.getMsg(this.getCtx(), "SelectPOS");
        Object selection = JOptionPane.showInputDialog(this.frame, msg, title = Env.getHeader(this.getCtx(), this.getWindowNo()), 3, null, this.getPOSByOrganization(orgId).toArray(), null);
        if (selection == null) {
            return false;
        }
        this.setM_POS((MPOS)selection);
        this.validLocator();
        return true;
    }

    private boolean dynInit() {
        this.frame.setTitle("Adempiere POS: " + this.getPOSName());
        this.leftPanel = new CPanel(new GridBagLayout());
        this.actionPanel = new POSActionPanel(this);
        this.infoProductPanel = new POSInfoProduct(this);
        this.quantityPanel = new POSQuantityPanel(this);
        this.leftPanel.add((Component)this.actionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.leftPanel.add((Component)this.infoProductPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.leftPanel.add((Component)this.quantityPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.orderLinePanel = new POSOrderLinePanel(this);
        this.leftPanel.add((Component)this.orderLinePanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.documentPanel = new POSDocumentPanel(this);
        this.dividerPane.add((Component)this.leftPanel, "left");
        this.dividerPane.add((Component)this.documentPanel, "right");
        this.statusBar.setInfo("");
        if (this.hasRecord()) {
            this.lastRecord();
        }
        this.refreshPanel();
        return true;
    }

    public void addOrUpdateLine(int productId, BigDecimal qtyOrdered) throws Exception {
        String lineError;
        if (!this.hasOrder()) {
            this.newOrder();
        }
        if ((lineError = this.addOrUpdate(productId, qtyOrdered)) != null) {
            this.logger.warning("POS Error " + lineError);
            ADialog.error(this.getWindowNo(), this.mainPanel, Msg.parseTranslation(this.getCtx(), lineError));
        }
        this.refreshPanel();
    }

    @Override
    public void dispose() {
        this.keyboards.clear();
        this.keyboards = null;
        if (this.logoutTimer != null) {
            this.logoutTimer.stop();
        }
        this.logoutTimer = null;
        if (this.userPinTimer != null) {
            this.userPinTimer.stop();
        }
        this.userPinTimer = null;
        if (this.scalesTimer != null) {
            this.scalesTimer.stop();
        }
        this.scalesTimer = null;
        if (this.isVirtualKeyboard()) {
            if (this.focusManager != null) {
                this.focusManager.stop();
            }
            this.focusManager = null;
            KeyboardFocusManager.setCurrentKeyboardFocusManager(this.originalKeyboardFocusManager);
        }
        if (this.actionPanel != null) {
            this.actionPanel.dispose();
        }
        this.actionPanel = null;
        if (this.orderLinePanel != null) {
            this.orderLinePanel.dispose();
        }
        this.orderLinePanel = null;
        if (this.documentPanel != null) {
            this.documentPanel.dispose();
        }
        this.documentPanel = null;
        if (this.frame != null) {
            this.frame.dispose();
        }
        this.frame = null;
    }

    public POSKeyboard getKeyboard(int keyLayoutId) {
        if (this.keyboards.containsKey(keyLayoutId)) {
            return this.keyboards.get(keyLayoutId);
        }
        if (keyLayoutId > 0) {
            POSKeyboard keyboard = new POSKeyboard(this.mainPanel, keyLayoutId);
            this.keyboards.put(keyLayoutId, keyboard);
            return keyboard;
        }
        return null;
    }

    public POSKeyboard getKeyboard() {
        return this.getKeyboard(this.getOSKeyLayout_ID());
    }

    public void newOrder() throws Exception {
        this.newOrder(0);
        this.infoProductPanel.resetValues();
        this.quantityPanel.resetPanel();
        this.getMainFocus();
    }

    @Override
    public void refreshPanel() {
        this.reloadOrder();
        this.orderLinePanel.refreshPanel();
        this.actionPanel.refreshPanel();
        this.documentPanel.refreshPanel();
        if (!this.hasLines()) {
            this.infoProductPanel.resetValues();
            this.quantityPanel.resetPanel();
        }
        this.quantityPanel.refreshPanel();
    }

    public void refreshProductInfo(MPOSKey key) {
        this.infoProductPanel.refreshProduct(key, this.getQty(), this.getM_PriceList_ID(), this.getC_BPartner_ID());
    }

    public void refreshProductInfo(int productId) {
        this.infoProductPanel.refreshProduct(productId, this.getQty(), this.getM_PriceList_ID(), this.getC_BPartner_ID());
    }

    public void refreshHeader() {
        this.reloadOrder();
        this.actionPanel.refreshPanel();
        this.documentPanel.refreshPanel();
    }

    @Override
    public String validatePayment() {
        return null;
    }

    @Override
    public void changeViewPanel() {
        this.quantityPanel.changeViewPanel();
        this.orderLinePanel.changeViewPanel();
    }

    @Override
    public void updateLineTable() {
        this.orderLinePanel.updateLine();
    }

    @Override
    public void moveUp() {
        this.orderLinePanel.moveUp();
    }

    @Override
    public void moveDown() {
        this.orderLinePanel.moveDown();
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public void addStatusBarInfo(String info) {
        this.statusBarInfo = this.statusBarInfo + " " + info + " ";
        this.getStatusBar().setStatusLine(this.statusBarInfo);
    }

    public ActionListener getUserPinListener() {
        return this.userPinListener;
    }

    public POSScalesListener getScalesListener() {
        return this.scalesListener;
    }

    protected void setIsCorrectUserPin(boolean isCorrectUserPin) {
        this.isCorrectUserPin = isCorrectUserPin;
    }

    protected void validateAndSetUserPin(char[] userPin) {
        if (this.isCorrectUserPin != null && this.isCorrectUserPin.booleanValue()) {
            return;
        }
        boolean isValidUserPin = this.isValidUserPin(userPin);
        if (isValidUserPin) {
            this.userPinTimer.restart();
            this.setIsCorrectUserPin(isValidUserPin);
        }
    }

    protected void invalidateUserPin() {
        this.isCorrectUserPin = null;
    }

    public boolean isUserPinValid() {
        if (!this.isRequiredPIN()) {
            return true;
        }
        if (this.isCorrectUserPin == null) {
            POSUserPinDialog.show(this);
        }
        if (this.isCorrectUserPin == null || !this.isCorrectUserPin.booleanValue()) {
            throw new AdempiereException("@Supervisor_ID@: @UserPin@ @IsInvalid@.");
        }
        return this.isCorrectUserPin;
    }

    public void showCollectPayment() {
        this.documentPanel.getCollectPayment().showPanel();
    }

    public void showScales() {
        this.documentPanel.getScalesPanel().showPanel();
    }

    @Override
    public void hideScales() {
        this.documentPanel.getScalesPanel().hidePanel();
    }

    @Override
    public void setScalesMeasure(String measure) {
        this.documentPanel.getScalesPanel().setMeasure(measure);
    }

    @Override
    public void showKeyboard() {
        this.documentPanel.getKeyboard().showPanel();
    }

    public void hideKeyboard() {
        this.documentPanel.getKeyboard().hidePanel();
    }

    public void disablePOSButtons() {
        this.infoProductPanel.resetValues();
        this.quantityPanel.resetPanel();
        this.actionPanel.resetPanel();
        this.orderLinePanel.disableTable();
    }

    public void restoreTable() {
        this.orderLinePanel.enableTable();
    }

    @Override
    public String getProductUOMSymbol() {
        return this.infoProductPanel.getUOMSymbol();
    }

    public Timer getUserPinTimer() {
        return this.userPinTimer;
    }

    @Override
    public Timer getScalesTimer() {
        return this.scalesTimer;
    }

    public void quantityRequestFocus() {
        this.quantityPanel.requestFocus();
    }

    @Override
    public void getMainFocus() {
        this.actionPanel.getMainFocus();
    }

    @Override
    public void setQty(BigDecimal qty) {
        super.setQty(qty);
        this.quantityPanel.setQuantity(this.getQty());
    }

    public void updateProductPlaceholder(String name) {
        this.actionPanel.updateProductPlaceholder(name);
    }

    public void setBusy(boolean busy) {
        if (busy) {
            this.getFrame().getContentPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.getFrame().getContentPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    public void setBusyMessage(String message) {
    }

    public boolean isBusy() {
        return this.waiting != null;
    }
}

