/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Optional;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.MBrowse;
import org.adempiere.pos.AdempierePOSException;
import org.adempiere.pos.VPOS;
import org.adempiere.pos.command.Command;
import org.adempiere.pos.command.CommandManager;
import org.adempiere.pos.command.CommandReceiver;
import org.adempiere.pos.search.POSQuery;
import org.adempiere.pos.search.QueryBPartner;
import org.adempiere.pos.services.POSQueryInterface;
import org.adempiere.pos.services.POSQueryListener;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.Waiting;
import org.compiere.apps.form.FormFrame;
import org.compiere.model.MBPartner;
import org.compiere.process.ProcessInfo;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.form.VBrowser;
import org.spin.util.ASPUtil;

public class POSActionMenu
implements ActionListener,
POSQueryListener {
    private VPOS pos;
    private POSQuery queryPartner;
    private JPopupMenu popupMenu;
    private CommandManager commandManager;
    private Command currentCommand;

    public POSActionMenu(VPOS pos) {
        this.pos = pos;
        this.popupMenu = new JPopupMenu();
        this.commandManager = new CommandManager();
        for (Map.Entry<String, CommandReceiver> receivers : this.commandManager.getCommandReceivers().entrySet()) {
            CommandReceiver commandReceiver = receivers.getValue();
            this.addMenuItem(commandReceiver.getEvent());
        }
    }

    private void addMenuItem(String optionName) {
        JMenuItem menuItem = new JMenuItem(optionName);
        this.popupMenu.add(menuItem).addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.popupMenu.setVisible(false);
            this.currentCommand = this.commandManager.getCommand(actionEvent.getActionCommand());
            this.beforeExecutionCommand(this.currentCommand);
        }
        catch (AdempiereException exception) {
            ADialog.error(this.pos.getWindowNo(), this.pos.getFrame(), exception.getLocalizedMessage());
        }
    }

    private void beforeExecutionCommand(Command command) {
        if (command.getCommand() == CommandManager.GENERATE_IMMEDIATE_INVOICE) {
            if (this.pos.isCompleted()) {
                this.queryPartner = new QueryBPartner(this.pos);
                this.queryPartner.setModal(true);
                this.queryPartner.addOptionListener(this);
                this.queryPartner.showView();
            }
        } else if (command.getCommand() == CommandManager.GENERATE_REVERSE_SALES) {
            if (this.pos.isCompleted()) {
                this.executeCommand(command);
            }
        } else if (command.getCommand() == CommandManager.GENERATE_RETURN) {
            if (this.pos.getC_Order_ID() > 0 && !this.pos.isReturnMaterial() && this.pos.isCompleted()) {
                this.executeCommand(command);
            }
        } else if (command.getCommand() == CommandManager.COMPLETE_DOCUMENT) {
            if (this.pos.getC_Order_ID() > 0) {
                this.executeCommand(command);
            }
        } else if (command.getCommand() == CommandManager.GENERATE_WITHDRAWAL) {
            this.executeCommand(command);
        } else if (command.getCommand() == CommandManager.CLOSE_STATEMENT) {
            this.executeCommand(command);
        } else {
            ADialog.info(this.pos.getWindowNo(), this.popupMenu, "DocProcessed", this.pos.getDocumentNo());
        }
    }

    private void afterExecutionCommand(Command command) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(Command command) {
        Waiting waiting = new Waiting((Frame)this.pos.getFrame(), Msg.parseTranslation(this.pos.getCtx(), "@Processing@"), false, 120);
        try {
            CommandReceiver receiver = this.commandManager.getCommandReceivers(command.getEvent());
            if (command.getCommand() == CommandManager.GENERATE_IMMEDIATE_INVOICE && this.pos.getC_Order_ID() > 0 && this.pos.isCompleted() && !this.pos.isVoided()) {
                receiver.setCtx(this.pos.getCtx());
                receiver.setPartnerId(this.queryPartner.getRecord_ID());
                receiver.setOrderId(this.pos.getC_Order_ID());
                receiver.setPOSId(this.pos.getC_POS_ID());
                receiver.setBankAccountId(this.pos.getC_BankAccount_ID());
                MBPartner partner = MBPartner.get(this.pos.getCtx(), receiver.getPartnerId());
                Optional<String> taxId = Optional.ofNullable(partner.getTaxID());
                String processMessage = receiver.getName() + " @DisplayDocumentInfo@ : " + this.pos.getDocumentNo() + " @To@ @C_BPartner_ID@ : " + partner.getName() + " @TaxID@ : " + taxId.orElseGet(() -> "");
                if (ADialog.ask(this.pos.getWindowNo(), this.popupMenu, "StartProcess?", Msg.parseTranslation(this.pos.getCtx(), processMessage))) {
                    AEnv.showCenterScreen(waiting);
                    command.execute(receiver);
                    ProcessInfo processInfo = receiver.getProcessInfo();
                    waiting.setVisible(false);
                    if (processInfo != null && processInfo.isError()) {
                        this.showError(processInfo);
                    } else {
                        this.afterExecutionCommand(command);
                        if (processInfo != null) {
                            this.showOkMessage(processInfo);
                            this.pos.setOrder(processInfo.getRecord_ID());
                        }
                        this.pos.refreshHeader();
                        this.pos.printTicket();
                    }
                }
            } else if (!(command.getCommand() != CommandManager.GENERATE_REVERSE_SALES || this.pos.getC_Order_ID() <= 0 || this.pos.isReturnMaterial() || this.pos.isVoided() || this.pos.isClosed())) {
                receiver.setCtx(this.pos.getCtx());
                receiver.setOrderId(this.pos.getC_Order_ID());
                receiver.setPOSId(this.pos.getC_POS_ID());
                receiver.setPartnerId(this.pos.getC_BPartner_ID());
                receiver.setBankAccountId(this.pos.getC_BankAccount_ID());
                String processMessage = receiver.getName() + " @order.no@ : " + this.pos.getDocumentNo() + " @To@ @C_BPartner_ID@ : " + this.pos.getBPName();
                if (ADialog.ask(this.pos.getWindowNo(), this.popupMenu, "StartProcess?", Msg.parseTranslation(this.pos.getCtx(), processMessage))) {
                    AEnv.showCenterScreen(waiting);
                    command.execute(receiver);
                    ProcessInfo processInfo = receiver.getProcessInfo();
                    waiting.setVisible(false);
                    if (processInfo != null && processInfo.isError()) {
                        this.showError(processInfo);
                    } else {
                        this.afterExecutionCommand(command);
                        if (processInfo != null) {
                            this.showOkMessage(processInfo);
                        }
                    }
                    this.pos.printTicket();
                }
            } else if (command.getCommand() == CommandManager.GENERATE_RETURN && this.pos.getC_Order_ID() > 0 && !this.pos.isReturnMaterial() && this.pos.isCompleted()) {
                receiver.setCtx(this.pos.getCtx());
                receiver.setOrderId(this.pos.getC_Order_ID());
                receiver.setPOSId(this.pos.getC_POS_ID());
                receiver.setPartnerId(this.pos.getC_BPartner_ID());
                receiver.setBankAccountId(this.pos.getC_BankAccount_ID());
                String processMessage = receiver.getName() + " @DisplayDocumentInfo@ : " + this.pos.getDocumentNo() + " @To@ @C_BPartner_ID@ : " + this.pos.getBPName();
                if (ADialog.ask(this.pos.getWindowNo(), this.popupMenu, "StartProcess?", Msg.parseTranslation(this.pos.getCtx(), processMessage))) {
                    AEnv.showCenterScreen(waiting);
                    command.execute(receiver);
                    ProcessInfo processInfo = receiver.getProcessInfo();
                    waiting.setVisible(false);
                    if (processInfo != null && processInfo.isError()) {
                        this.showError(processInfo);
                    } else {
                        this.afterExecutionCommand(command);
                        if (processInfo != null && processInfo.getRecord_ID() > 0) {
                            this.showOkMessage(processInfo);
                            this.pos.setOrder(processInfo.getRecord_ID());
                            this.pos.refreshHeader();
                        }
                    }
                }
            } else if (command.getCommand() == CommandManager.GENERATE_WITHDRAWAL) {
                Env.setContext(this.pos.getCtx(), this.pos.getWindowNo(), "C_POS_ID", this.pos.getC_POS_ID());
                Dimension size = new Dimension(1024, 768);
                FormFrame ff = new FormFrame(this.pos.getWindowNo());
                ff.setSize(size);
                new VBrowser(ff, true, this.pos.getWindowNo(), "", ASPUtil.getInstance().getBrowse(50056), "", true, "", true);
                ff.pack();
                AEnv.showCenterScreen(ff);
            } else if (command.getCommand() == CommandManager.CLOSE_STATEMENT) {
                Env.setContext(this.pos.getCtx(), this.pos.getWindowNo(), "C_POS_ID", this.pos.getC_POS_ID());
                Dimension size = new Dimension(1024, 768);
                FormFrame ff = new FormFrame(this.pos.getWindowNo());
                ff.setSize(size);
                MBrowse browse = new MBrowse(Env.getCtx(), 50057, null);
                new VBrowser(ff, true, this.pos.getWindowNo(), "", browse, "", true, "", true);
                ff.pack();
                AEnv.showCenterScreen(ff);
            } else if (command.getCommand() == CommandManager.COMPLETE_DOCUMENT) {
                receiver.setCtx(this.pos.getCtx());
                receiver.setOrderId(this.pos.getC_Order_ID());
                receiver.setPOSId(this.pos.getC_POS_ID());
                receiver.setPartnerId(this.pos.getC_BPartner_ID());
                receiver.setBankAccountId(this.pos.getC_BankAccount_ID());
                command.execute(receiver);
                ProcessInfo processInfo = receiver.getProcessInfo();
                waiting.setVisible(false);
                if (processInfo != null && processInfo.isError()) {
                    this.showError(processInfo);
                } else {
                    this.afterExecutionCommand(command);
                    if (processInfo != null) {
                        this.showOkMessage(processInfo);
                    }
                    this.pos.refreshHeader();
                }
            }
        }
        catch (Exception exception) {
            waiting.setVisible(false);
            ADialog.error(this.pos.getWindowNo(), this.pos.getFrame(), exception.getLocalizedMessage());
        }
        finally {
            waiting.setVisible(false);
            waiting = null;
        }
    }

    public void show(Component component, int x, int y) {
        this.popupMenu.show(component, x, y);
    }

    @Override
    public void okAction(POSQueryInterface query) {
        if (query.getRecord_ID() <= 0) {
            return;
        }
        if (query instanceof QueryBPartner) {
            this.executeCommand(this.currentCommand);
        }
    }

    @Override
    public void cancelAction(POSQueryInterface query) {
    }

    private void showError(ProcessInfo processInfo) throws AdempierePOSException {
        Optional<String> summary = Optional.ofNullable(processInfo.getSummary());
        Optional<String> logs = Optional.ofNullable(processInfo.getLogInfo());
        String errorMessage = Msg.parseTranslation(this.pos.getCtx(), "@AD_Process_ID@ " + processInfo.getTitle() + " @ProcessRunError@ @Summary@ : " + summary.orElseGet(() -> "") + " @ProcessFailed@ : " + logs.orElseGet(() -> ""));
        throw new AdempierePOSException(errorMessage);
    }

    private void showOkMessage(ProcessInfo processInfo) {
        this.pos.refreshHeader();
        Optional<String> summary = Optional.ofNullable(processInfo.getSummary());
        Optional<String> logs = Optional.ofNullable(processInfo.getLogInfo());
        String okMessage = Msg.parseTranslation(this.pos.getCtx(), " @AD_Process_ID@ " + processInfo.getTitle() + " @Summary@ : " + summary.orElseGet(() -> "") + " @ProcessOK@ : " + logs.orElseGet(() -> ""));
        ADialog.info(this.pos.getWindowNo(), this.popupMenu, "ProcessOK", okMessage);
    }
}

