/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.core.domains.models.I_AD_Menu;
import org.adempiere.pipo.PackOut;
import org.adempiere.pipo.handler.GenericPOHandler;
import org.compiere.model.MMenu;
import org.compiere.model.MTree;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.xml.sax.SAXException;

public class MenuElementHandler
extends GenericPOHandler {
    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        int menuId = Env.getContextAsInt(ctx, "AD_Menu_ID");
        this.createParentApplication(ctx, document, menuId);
        this.createApplicationAndChild(ctx, document, menuId);
    }

    private void createParentApplication(Properties ctx, TransformerHandler document, int menuId) throws SAXException {
        PackOut packOut = (PackOut)ctx.get("PackOutProcess");
        MMenu menu = MMenu.getFromId(ctx, menuId);
        this.createReference(menu, packOut, document);
        int defaultTreeId = MTree.getDefaultTreeIdFromTableId(menu.getAD_Client_ID(), I_AD_Menu.Table_ID);
        packOut.createGenericPO(document, menu);
        String childSQL = "SELECT m.AD_Menu_ID FROM AD_Menu m WHERE EXISTS(SELECT 1 FROM AD_TreeNodeMM tnm \t\t\tWHERE tnm.Parent_ID = m.AD_Menu_ID \t\t\tAND tnm.AD_Tree_ID = " + defaultTreeId + " \t\t\tAND tnm.Node_ID = ?)";
        int parentId = DB.getSQLValueEx(null, childSQL, menu.getAD_Menu_ID());
        if (parentId > 0) {
            this.createParentApplication(ctx, document, parentId);
        }
    }

    private void createApplicationAndChild(Properties ctx, TransformerHandler document, int menuId) throws SAXException {
        PackOut packOut = (PackOut)ctx.get("PackOutProcess");
        MMenu menu = MMenu.getFromId(ctx, menuId);
        int defaultTreeId = MTree.getDefaultTreeIdFromTableId(menu.getAD_Client_ID(), I_AD_Menu.Table_ID);
        if (menu.isSummary()) {
            int[] ids;
            packOut.createGenericPO(document, menu);
            String childSQL = "SELECT m.AD_Menu_ID FROM AD_Menu m WHERE EXISTS(SELECT 1 FROM AD_TreeNodeMM tnm \t\t\tWHERE tnm.Node_ID = m.AD_Menu_ID \t\t\tAND tnm.AD_Tree_ID = " + defaultTreeId + " \t\t\tAND tnm.Parent_ID = ?)";
            for (int id : ids = DB.getIDsEx(null, childSQL, menu.getAD_Menu_ID())) {
                this.createApplicationAndChild(ctx, document, id);
            }
        } else {
            this.createReference(menu, packOut, document);
        }
    }

    private void createReference(MMenu menu, PackOut packOut, TransformerHandler document) throws SAXException {
        if (menu.getAD_Window_ID() == 0 && menu.getAD_Workflow_ID() == 0 && menu.getAD_Task_ID() == 0 && menu.getAD_Process_ID() == 0 && menu.getAD_Form_ID() == 0 && menu.getAD_Browse_ID() == 0 && menu.getAD_Workbench_ID() == 0) {
            return;
        }
        if (menu.getAD_Window_ID() > 0) {
            packOut.createWindow(menu.getAD_Window_ID(), document);
        } else if (menu.getAD_Process_ID() > 0) {
            packOut.createProcess(menu.getAD_Process_ID(), document);
        } else if (menu.getAD_Task_ID() > 0) {
            packOut.createTask(menu.getAD_Task_ID(), document);
        } else if (menu.getAD_Form_ID() > 0) {
            packOut.createForm(menu.getAD_Form_ID(), document);
        } else if (menu.getAD_Browse_ID() > 0) {
            packOut.createBrowse(menu.getAD_Browse_ID(), document);
        } else if (menu.getAD_Workflow_ID() > 0) {
            packOut.createWorkflow(menu.getAD_Workflow_ID(), document);
        }
        packOut.createGenericPO(document, menu);
    }
}

