/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.sax.TransformerHandler;
import org.adempiere.core.domains.models.I_AD_EntityType;
import org.adempiere.model.GenericPO;
import org.adempiere.pipo.AbstractElementHandler;
import org.adempiere.pipo.AttributeFiller;
import org.adempiere.pipo.Element;
import org.adempiere.pipo.PoFiller;
import org.adempiere.pipo.exception.POSaveFailedException;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.MTree;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Util;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class GenericPOHandler
extends AbstractElementHandler {
    private final List<String> list = new ArrayList<String>();
    private AttributeFiller customValues = new AttributeFiller(new AttributesImpl());
    public static final String TABLE_NAME_TAG = "TableNameTag";
    public static final String TABLE_ID_TAG = "TableIdTag";
    public static final String RECORD_ID_TAG = "RecordIdTag";
    public static final String TAG_Name = "GenericPO";
    public static final String HANDLE_TRANSLATION_FLAG = "2PACK_HANDLE_TRANSLATIONS";
    public static final String Column_TAG_Name = "GenericPO_AD_Column";
    public static final String IGNORE_WHEN_SAVE_ERROR = "Ignore_When_Save_Error";
    public static final String IGNORE_WHEN_MISSING_MANDATORY_REFERENCE = "Ignore_When_Missing_Mandatory_Reference";
    public static final String IMPORT_HANDLER_CLASS_NAME = "ImportClassNameHandler";

    protected void addStringValue(String key, String value) {
        this.customValues.addString(key, value);
    }

    protected void addBooleanValue(String key, boolean value) {
        this.customValues.addBoolean(key, value);
    }

    protected void addIntValue(String key, int value) {
        this.customValues.addInt(key, value);
    }

    protected void addLongValue(String key, long value) {
        this.customValues.addLong(key, value);
    }

    protected void cleanValues() {
        this.customValues.cleanValues();
    }

    public void setImportHandlerClassName(String className) {
        this.addStringValue(IMPORT_HANDLER_CLASS_NAME, className);
    }

    public void setIgnoreWhenSaveError(boolean ignore) {
        this.addBooleanValue(IGNORE_WHEN_SAVE_ERROR, ignore);
    }

    public void setIgnoreWhenMissingMandatoryReference(boolean ignore) {
        this.addBooleanValue(IGNORE_WHEN_MISSING_MANDATORY_REFERENCE, ignore);
    }

    @Override
    public void startElement(Properties ctx, Element element) throws SAXException {
        String objectStatus;
        int backupId;
        String elementValue = element.getElementValue();
        Attributes atts = element.attributes;
        String tableName = this.getStringValue(atts, TABLE_NAME_TAG);
        this.log.info(elementValue + " " + tableName);
        String uuid = this.getUUIDValue(atts, tableName);
        if (Util.isEmpty(uuid) || Util.isEmpty(tableName)) {
            element.skip = true;
            return;
        }
        POInfo poInfo = POInfo.getPOInfo(ctx, tableName, this.getTrxName(ctx));
        String keyColumnName = poInfo.getKeyColumnName();
        int recordId = 0;
        if (!Util.isEmpty(keyColumnName)) {
            recordId = this.getIdFromUUID(ctx, tableName, uuid);
        }
        PO entity = null;
        entity = poInfo.hasKeyColumn() ? this.getCreatePO(ctx, tableName, recordId, this.getTrxName(ctx)) : this.getCreatePOForMultyKey(ctx, poInfo, atts, this.getTrxName(ctx));
        long importTime = this.getLastUpdatedTime(atts);
        long currentPOTime = 0L;
        if (entity.getUpdated() != null) {
            currentPOTime = entity.getUpdated().getTime();
        }
        if (!Env.getContext(ctx, "UpdateMode").equals("Y") && importTime > 0L && currentPOTime >= importTime && !entity.is_new()) {
            element.skip = true;
            return;
        }
        if (recordId > 0) {
            backupId = this.copyRecord(ctx, poInfo.getTableName(), entity);
            objectStatus = "Update";
        } else {
            objectStatus = "New";
            backupId = 0;
        }
        PoFiller filler = new PoFiller(entity, atts);
        entity.setIsDirectLoad(true);
        for (int index = 0; index < poInfo.getColumnCount(); ++index) {
            String parentTableName;
            String parentNameUuid;
            String parentUuid;
            String columnName;
            if (poInfo.isVirtualColumn(index) || poInfo.isKey(index) && entity.get_ID() > 999999 || poInfo.isEncrypted(index) || (columnName = poInfo.getColumnName(index)).equals("Created") || columnName.equals("CreatedBy") || columnName.equals("Updated") || columnName.equals("UpdatedBy") || columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID")) continue;
            if (this.isLookup(poInfo.getColumnDisplayType(index)) && !Util.isEmpty(parentUuid = atts.getValue(parentNameUuid = AttributeFiller.getUUIDAttribute(columnName))) && !Util.isEmpty(parentTableName = this.getParentTableName(ctx, poInfo.getAD_Column_ID(columnName), poInfo.getColumnDisplayType(index)))) {
                int foreignId = this.getParentId(ctx, parentTableName, parentUuid);
                if (foreignId > 0) {
                    entity.set_ValueOfColumn(columnName, (Object)foreignId);
                    continue;
                }
                if (!poInfo.isColumnMandatory(index) || !this.getBooleanValue(atts, IGNORE_WHEN_MISSING_MANDATORY_REFERENCE)) continue;
                element.skip = true;
                return;
            }
            if (columnName.equals("UUID") && !poInfo.hasKeyColumn() && !Util.isEmpty(entity.get_UUID())) continue;
            filler.setAttribute(columnName);
        }
        String treeUuid = atts.getValue(AttributeFiller.getUUIDAttribute("AD_Tree_ID"));
        String treeType = atts.getValue("TreeType");
        String treeTableUuid = atts.getValue(AttributeFiller.getUUIDAttribute("AD_Table_ID"));
        String sourceUuid = atts.getValue(AttributeFiller.getUUIDAttribute("Node_ID"));
        String parentUuid = atts.getValue(AttributeFiller.getUUIDAttribute("Parent_ID"));
        if (!Util.isEmpty(treeUuid)) {
            int treeId = this.getIdFromUUID(ctx, "AD_Tree", treeUuid);
            int parentId = this.getIdFromNodeUUID(ctx, tableName, parentUuid);
            String parentTableName = null;
            if (treeId > 0) {
                MTree tree = MTree.get(ctx, treeId, this.getTrxName(ctx));
                MTable sourceTable = MTable.get(ctx, tree.getAD_Table_ID());
                parentTableName = sourceTable.getTableName();
            } else {
                int treeTableId = this.getIdFromUUID(ctx, "AD_Table", treeTableUuid);
                parentTableName = MTable.getTableName(ctx, treeTableId);
                treeId = GenericPOHandler.getDefaultTreeIdFromTableId(Env.getAD_Client_ID(ctx), treeTableId, treeType, this.getTrxName(ctx));
            }
            int nodeId = this.getIdFromUUID(ctx, parentTableName, sourceUuid);
            entity.set_ValueOfColumn("AD_Tree_ID", (Object)treeId);
            entity.set_ValueOfColumn("Node_ID", (Object)nodeId);
            entity.set_ValueOfColumn("Parent_ID", (Object)parentId);
        }
        try {
            this.beforeSave(entity);
            try {
                entity.saveEx(this.getTrxName(ctx));
            }
            catch (Exception e) {
                if (this.getBooleanValue(atts, IGNORE_WHEN_SAVE_ERROR)) {
                    element.skip = true;
                    this.log.warning("Ignored Entity: " + tableName + " - " + entity + " - Error: " + e.getMessage());
                    return;
                }
                throw e;
            }
            int originalId = entity.get_ID();
            if (!poInfo.hasKeyColumn()) {
                if (tableName.endsWith("_Trl")) {
                    originalId = entity.get_ValueAsInt(tableName.replaceAll("_Trl", "") + "_ID");
                } else {
                    String keyColumn;
                    MTable table = MTable.get(ctx, tableName);
                    String[] stringArray = table.getKeyColumns();
                    int n = stringArray.length;
                    for (int i = 0; i < n && (originalId = entity.get_ValueAsInt(keyColumn = stringArray[i])) <= 0; ++i) {
                    }
                }
            }
            this.recordLog(ctx, 1, entity.get_ValueAsString("UUID"), this.getTagName(entity), originalId, backupId, objectStatus, "AD_EntityType", I_AD_EntityType.Table_ID);
            this.afterSave(entity);
        }
        catch (Exception e) {
            if (backupId > 0) {
                this.recordLog(ctx, 0, entity.get_ValueAsString("UUID"), this.getTagName(entity), backupId, backupId, objectStatus, "AD_EntityType", I_AD_EntityType.Table_ID);
            }
            throw new POSaveFailedException(e);
        }
    }

    public static int getDefaultTreeIdFromTableId(int clientId, int tableId, String treeType, String trxName) {
        if (tableId <= 0) {
            return -1;
        }
        Object whereClause = new String();
        int treeId = 0;
        if (!Util.isEmpty(treeType)) {
            whereClause = " AND TreeType = '" + treeType + "'";
        }
        String sql = "SELECT tr.AD_Tree_ID FROM AD_Tree tr WHERE tr.AD_Client_ID = ? AND tr.AD_Table_ID = ? AND tr.IsActive='Y' " + (String)whereClause + "ORDER BY tr.IsDefault DESC";
        treeId = DB.getSQLValue(trxName, sql, clientId, tableId);
        return treeId;
    }

    protected void beforeSave(PO entity) {
    }

    protected void afterSave(PO entity) {
    }

    @Override
    public void endElement(Properties ctx, Element element) throws SAXException {
    }

    @Override
    public void create(Properties ctx, TransformerHandler document) throws SAXException {
        this.create(ctx, document, null, true, null);
    }

    public void create(Properties ctx, TransformerHandler document, PO entity) throws SAXException {
        this.create(ctx, document, entity, false, null);
    }

    public void create(Properties ctx, TransformerHandler document, PO entity, boolean includeParents, List<String> excludedParentList) throws SAXException {
        this.create(ctx, document, entity, includeParents, excludedParentList, false);
    }

    private void create(Properties ctx, TransformerHandler document, PO entity, boolean includeParents, List<String> excludedParentList, boolean isFromParent) throws SAXException {
        AttributesImpl defaultAttributes;
        AttributesImpl atts;
        int tableId = 0;
        String tableName = null;
        int recordId = 0;
        if (entity != null) {
            tableId = entity.get_Table_ID();
            tableName = entity.get_TableName();
            recordId = entity.get_ID();
        } else {
            tableId = Env.getContextAsInt(ctx, TABLE_ID_TAG);
            recordId = Env.getContextAsInt(ctx, RECORD_ID_TAG);
        }
        if (tableId <= 0) {
            return;
        }
        if (entity == null) {
            entity = this.getCreatePO(ctx, tableId, recordId, null);
        }
        if (entity == null) {
            entity = this.getCreatePO(ctx, tableName, recordId, null);
        }
        if (entity == null) {
            return;
        }
        String key = entity.get_UUID();
        if (this.list.contains(key)) {
            return;
        }
        this.list.add(key);
        if (includeParents) {
            this.createParent(ctx, document, entity, excludedParentList);
        }
        if ((atts = this.createBinding(ctx, entity, defaultAttributes = this.customValues.getAttributes())) != null) {
            document.startElement("", "", this.getTagName(entity), atts);
            document.endElement("", "", this.getTagName(entity));
        }
        this.createTranslation(ctx, document, entity);
        this.createTreeNode(ctx, document, entity);
        if (!isFromParent) {
            this.customValues.cleanValues();
        }
    }

    private void createParent(Properties ctx, TransformerHandler document, PO entity, List<String> excludedParentList) throws SAXException {
        POInfo poInfo = POInfo.getPOInfo(entity.getCtx(), entity.get_Table_ID());
        for (int index = 0; index < poInfo.getColumnCount(); ++index) {
            PO parentEntity;
            int referenceId;
            String parentTableName;
            String columnName;
            if (poInfo.isVirtualColumn(index) || poInfo.isEncrypted(index) || (columnName = poInfo.getColumnName(index)).equals("Created") || columnName.equals("CreatedBy") || columnName.equals("Updated") || columnName.equals("UpdatedBy") || columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID") || Util.isEmpty(parentTableName = this.getParentTableName(ctx, poInfo.getAD_Column_ID(columnName), poInfo.getColumnDisplayType(index))) || (referenceId = entity.get_ValueAsInt(columnName)) <= 0 || excludedParentList != null && excludedParentList.contains(parentTableName) || (parentEntity = MTable.get(ctx, parentTableName).getPO(referenceId, null)) == null || parentEntity.get_ID() <= 0 || !this.isValidAccess(MTable.get(ctx, entity.get_Table_ID()).getAccessLevel(), MTable.get(ctx, parentEntity.get_Table_ID()).getAccessLevel(), entity.getAD_Client_ID() == parentEntity.getAD_Client_ID())) continue;
            this.create(ctx, document, parentEntity, true, excludedParentList, true);
        }
    }

    private boolean isValidAccess(String accessLevel, String parentAccessLevel, boolean isSameClient) {
        if (isSameClient) {
            return true;
        }
        return !parentAccessLevel.equals("4") || accessLevel.equals("4");
    }

    private String getTagName(PO entity) {
        return "GenericPO_" + entity.get_TableName();
    }

    private PO getCreatePO(Properties ctx, String tableName, int recordId, String trxName) {
        return MTable.get(ctx, tableName).getPO(recordId, trxName);
    }

    private PO getCreatePO(Properties ctx, int tableId, int recordId, String trxName) {
        return MTable.get(ctx, tableId).getPO(recordId, trxName);
    }

    private PO getCreatePOForMultyKey(Properties ctx, POInfo poInfo, Attributes atts, String trxName) {
        MTable table = MTable.get(ctx, poInfo.getTableName());
        String uuid = this.getUUIDValue(atts, poInfo.getTableName());
        Object entity = new Query(ctx, poInfo.getTableName(), "UUID = ?", trxName).setParameters(uuid).first();
        if (entity == null) {
            ArrayList<Object> parameters = new ArrayList<Object>();
            StringBuffer keyColumnNamesForWhereClause = new StringBuffer();
            for (String keyColumn : table.getKeyColumns()) {
                if (keyColumnNamesForWhereClause.length() > 0) {
                    keyColumnNamesForWhereClause.append(" AND ");
                }
                keyColumnNamesForWhereClause.append(keyColumn).append(" = ?");
                String parentUuid = this.getUUIDValue(atts, keyColumn);
                if (!Util.isEmpty(parentUuid)) {
                    String parentTableName = this.getParentTableName(ctx, poInfo.getAD_Column_ID(keyColumn), poInfo.getColumnDisplayType(poInfo.getColumnIndex(keyColumn)));
                    if (Util.isEmpty(parentTableName)) {
                        String treeUuid = atts.getValue(AttributeFiller.getUUIDAttribute("AD_Tree_ID"));
                        String treeType = atts.getValue("TreeType");
                        String treeTableUuid = atts.getValue(AttributeFiller.getUUIDAttribute("AD_Table_ID"));
                        String sourceUuid = atts.getValue(AttributeFiller.getUUIDAttribute("Node_ID"));
                        if (Util.isEmpty(treeUuid) || Util.isEmpty(sourceUuid)) continue;
                        int treeId = this.getIdFromUUID(ctx, "AD_Tree", treeUuid);
                        if (treeId > 0) {
                            MTree tree = MTree.get(ctx, treeId, this.getTrxName(ctx));
                            MTable sourceTable = MTable.get(ctx, tree.getAD_Table_ID());
                            parentTableName = sourceTable.getTableName();
                        } else {
                            int treeTableId = this.getIdFromUUID(ctx, "AD_Table", treeTableUuid);
                            parentTableName = MTable.getTableName(ctx, treeTableId);
                            treeId = GenericPOHandler.getDefaultTreeIdFromTableId(Env.getAD_Client_ID(ctx), treeTableId, treeType, this.getTrxName(ctx));
                        }
                        int nodeId = this.getIdFromUUID(ctx, parentTableName, sourceUuid);
                        if (nodeId <= 0) continue;
                    }
                    int parentId = this.getIdFromUUID(ctx, parentTableName, parentUuid);
                    parameters.add(parentId);
                    continue;
                }
                PoFiller filler = new PoFiller(poInfo, atts);
                parameters.add(filler.getValueFromType(keyColumn));
            }
            entity = new Query(ctx, poInfo.getTableName(), keyColumnNamesForWhereClause.toString(), trxName).setParameters(parameters).first();
        }
        if (entity == null) {
            entity = new GenericPO(poInfo.getTableName(), ctx, -1, trxName);
        }
        return entity;
    }

    private AttributesImpl createBinding(Properties ctx, PO entity, AttributesImpl defaultAttributes) {
        AttributesImpl atts = new AttributesImpl();
        if (defaultAttributes != null) {
            atts.setAttributes(defaultAttributes);
        } else {
            atts.clear();
        }
        POInfo poInfo = POInfo.getPOInfo(entity.getCtx(), entity.get_Table_ID());
        AttributeFiller filler = new AttributeFiller(atts, entity);
        filler.addUUID();
        filler.addString(TABLE_NAME_TAG, entity.get_TableName());
        filler.addInt(TABLE_ID_TAG, entity.get_Table_ID());
        filler.addLastUpdatedTime();
        for (int index = 0; index < poInfo.getColumnCount(); ++index) {
            int treeId;
            String columnName;
            if (poInfo.isVirtualColumn(index) || poInfo.isKey(index) && entity.get_ID() > 999999 || poInfo.isEncrypted(index) || (columnName = poInfo.getColumnName(index)).equals("Created") || columnName.equals("CreatedBy") || columnName.equals("Updated") || columnName.equals("UpdatedBy") || columnName.equals("AD_Client_ID") || columnName.equals("AD_Org_ID")) continue;
            filler.add(columnName);
            String foreignUuid = this.getParentUuid(ctx, poInfo.getAD_Column_ID(columnName), poInfo.getColumnDisplayType(index), columnName, entity);
            if (!Util.isEmpty(foreignUuid)) {
                filler.addString(AttributeFiller.getUUIDAttribute(columnName), foreignUuid);
            }
            if (!columnName.equals("AD_Tree_ID") || (treeId = entity.get_ValueAsInt(columnName)) <= 0) continue;
            int nodeId = entity.get_ValueAsInt("Node_ID");
            int parentId = entity.get_ValueAsInt("Parent_ID");
            MTree tree = MTree.get(ctx, treeId, null);
            MTable sourceTable = MTable.get(ctx, tree.getAD_Table_ID());
            String sourceUuid = this.getUUIDFromId(ctx, sourceTable.getTableName(), nodeId);
            String parentUuid = this.getUUIDFromNodeId(ctx, entity.get_TableName(), treeId, parentId);
            filler.addString(AttributeFiller.getUUIDAttribute("Node_ID"), sourceUuid);
            filler.addString(AttributeFiller.getUUIDAttribute("Parent_ID"), parentUuid);
            filler.addString(AttributeFiller.getUUIDAttribute("AD_Table_ID"), sourceTable.getUUID());
            filler.addString("TreeType", tree.getTreeType());
        }
        return atts;
    }

    private String getParentTableName(Properties ctx, int columnId, int displayType) {
        if (!this.isLookup(displayType)) {
            return null;
        }
        if (17 == displayType) {
            return "AD_Ref_List";
        }
        if (25 == displayType) {
            return "C_ValidCombination";
        }
        if (21 == displayType) {
            return "C_Location";
        }
        if (31 == displayType) {
            return "M_Locator";
        }
        MLookupInfo info = MLookupFactory.getLookupInfo(ctx, 0, columnId, displayType);
        if (info == null) {
            return null;
        }
        return info.TableName;
    }

    private boolean isLookup(int displayType) {
        return DisplayType.isLookup(displayType) || 25 == displayType || 21 == displayType || 31 == displayType || 35 == displayType;
    }

    private String getParentUuid(Properties ctx, int columnId, int displayType, String columnName, PO entity) {
        String parentTableName = this.getParentTableName(ctx, columnId, displayType);
        if (Util.isEmpty(parentTableName)) {
            return null;
        }
        int foreignId = entity.get_ValueAsInt(columnName);
        String referenceUuid = this.getUUIDFromId(ctx, parentTableName, foreignId);
        if (Util.isEmpty(referenceUuid)) {
            return null;
        }
        return referenceUuid;
    }

    private int getParentId(Properties ctx, String parentTableName, String uuid) {
        if (Util.isEmpty(parentTableName)) {
            return -1;
        }
        return this.getIdFromUUID(ctx, parentTableName, uuid);
    }

    public void createTranslation(Properties ctx, TransformerHandler document, PO entity) throws SAXException {
        if (!MSysConfig.getBooleanValue(HANDLE_TRANSLATION_FLAG, false)) {
            return;
        }
        String tableName = entity.get_TableName() + "_Trl";
        MTable table = MTable.get(ctx, tableName);
        if (table == null || Util.isEmpty(table.getTableName())) {
            return;
        }
        String whereClause = entity.get_TableName() + "_ID = ? AND EXISTS(SELECT 1 FROM AD_Language l WHERE l.AD_Language = " + tableName + ".AD_Language AND l.IsSystemLanguage = ? AND l.IsBaseLanguage = ?)";
        List translationList = new Query(ctx, tableName, whereClause, null).setParameters(entity.get_ID(), true, false).setOnlyActiveRecords(true).list();
        for (PO translation : translationList) {
            this.create(ctx, document, translation, false, null, true);
        }
    }

    public void createTreeNode(Properties ctx, TransformerHandler document, PO entity) throws SAXException {
        int tableId = entity.get_Table_ID();
        if (!MTree.hasTree(tableId)) {
            return;
        }
        int treeId = MTree.getDefaultTreeIdFromTableId(entity.getAD_Client_ID(), tableId, entity.get_ValueAsInt("C_Element_ID"));
        if (treeId < 0) {
            return;
        }
        MTree tree = MTree.get(ctx, treeId, null);
        String treeNodeTableName = tree.getNodeTableName();
        if (Util.isEmpty(treeNodeTableName)) {
            return;
        }
        Object nodeEntity = new Query(ctx, treeNodeTableName, "AD_Tree_ID = ? AND Node_ID = ?", null).setParameters(treeId, entity.get_ID()).first();
        if (nodeEntity == null || ((PO)nodeEntity).get_ID() == 0) {
            return;
        }
        this.create(ctx, document, (PO)nodeEntity, false, null);
    }
}

