/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.PO;
import org.compiere.model.POInfo;
import org.compiere.util.Util;
import org.xml.sax.Attributes;

public class PoFiller {
    private PO entity = null;
    private Attributes atts = null;
    private POInfo poInfo = null;

    public PoFiller(PO entity, Attributes atts) {
        this.entity = entity;
        this.atts = atts;
        this.poInfo = POInfo.getPOInfo(entity.getCtx(), entity.get_Table_ID(), entity.get_TrxName());
    }

    public PoFiller(POInfo poInfo, Attributes atts) {
        this.atts = atts;
        this.poInfo = poInfo;
    }

    public void setString(String columnName) {
        String value = this.atts.getValue(columnName);
        value = "".equals(value) ? null : value;
        this.entity.set_ValueOfColumn(columnName, (Object)value);
    }

    public void setBoolean(String columnName) {
        String value = this.atts.getValue(columnName);
        boolean bool = "true".equals(value);
        this.entity.set_ValueOfColumn(columnName, (Object)bool);
    }

    public void setAttribute(String columnName) {
        String value = this.atts.getValue(columnName);
        value = Util.isEmpty(value, true) ? null : value.trim();
        int index = this.poInfo.getColumnIndex(columnName);
        boolean isMandatory = this.poInfo.isColumnMandatory(index);
        boolean isKeyColumn = this.poInfo.isKey(index);
        if (isMandatory && Util.isEmpty(value)) {
            Object valueObject;
            if (!isKeyColumn && (valueObject = this.entity.getDefaultValue(index)) != null) {
                this.entity.set_ValueOfColumn(columnName, valueObject);
            }
            return;
        }
        this.entity.set_ValueOfColumn(columnName, this.getValueFromType(columnName));
    }

    public Object getValueFromType(String columnName) {
        String value;
        String originalValue = value = this.atts.getValue(columnName);
        value = Util.isEmpty(value, true) ? null : value.trim();
        int index = this.poInfo.getColumnIndex(columnName);
        Object valueAsObject = null;
        Class<?> clazz = this.poInfo.getColumnClass(index);
        if (value == null) {
            valueAsObject = null;
        } else if (clazz == BigDecimal.class) {
            valueAsObject = new BigDecimal(value);
        } else if (clazz == Integer.class) {
            valueAsObject = new BigDecimal(value).intValueExact();
        } else if (clazz == String.class) {
            valueAsObject = originalValue;
        } else if (clazz == Boolean.class) {
            valueAsObject = Boolean.valueOf(value);
        } else if (clazz == Timestamp.class) {
            Timestamp dateValue = new Timestamp(Long.parseLong(value));
            valueAsObject = dateValue;
        } else {
            throw new AdempiereException("Class not supported - " + clazz);
        }
        return valueAsObject;
    }

    public String toString() {
        return "PO = " + this.entity + ", Attributes = " + this.atts;
    }
}

