/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import java.util.Properties;
import org.adempiere.core.domains.models.X_AD_ReplicationDocument;
import org.adempiere.core.domains.models.X_AD_ReplicationTable;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.process.rpl.exp.ExportHelper;
import org.compiere.model.MClient;
import org.compiere.model.MReplicationDocument;
import org.compiere.model.MReplicationStrategy;
import org.compiere.model.MReplicationTable;
import org.compiere.model.MTable;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class ExportModelValidator
implements ModelValidator {
    public static final String CTX_IsReplicationEnabled = "#IsReplicationEnabled";
    private static CLogger log = CLogger.getCLogger(ExportModelValidator.class);
    private int clientId = -1;
    private int orgId = -1;
    private int roleId = -1;
    private int userId = -1;
    MClient client = null;
    ModelValidationEngine modelValidationEngine = null;

    @Override
    public void initialize(ModelValidationEngine modelValidationEngine, MClient client) {
        this.modelValidationEngine = modelValidationEngine;
        this.client = client;
        if (client == null) {
            log.warning("Export Model Validator cannot be used as a global validator, it needs to be defined in a per-client (tenant) basis");
            return;
        }
        this.clientId = client.getAD_Client_ID();
        log.info(client.toString());
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        log.info("po.get_TableName() = " + po.get_TableName());
        if (type == 5 || type == 4 || type == 3) {
            MReplicationStrategy.getByOrgAndRole(po.getCtx(), this.orgId, this.roleId, po.get_TrxName()).stream().forEach(replicationStrategy -> {
                MReplicationTable replicationTable = MReplicationStrategy.getReplicationTable(po.getCtx(), replicationStrategy.get_ID(), po.get_Table_ID());
                if (replicationTable != null) {
                    ExportHelper exportHelper = new ExportHelper(this.client, (MReplicationStrategy)replicationStrategy);
                    try {
                        exportHelper.exportRecord(po, replicationTable, (Integer)type);
                    }
                    catch (Exception exeption) {
                        if (replicationStrategy.isValidateError()) {
                            throw new AdempiereException(exeption);
                        }
                        log.warning(exeption.getLocalizedMessage());
                    }
                }
            });
        }
        return null;
    }

    @Override
    public String docValidate(PO po, int type) {
        log.info("Replicate the Document = " + po.get_TableName() + " with Type = " + type);
        String result = null;
        if (type == 9 || type == 11 || type == 13 || type == 10 || type == 12) {
            MReplicationStrategy.getByOrgAndRole(po.getCtx(), this.orgId, this.roleId, po.get_TrxName()).stream().forEach(replicationStrategy -> {
                MReplicationDocument replicationDocument = null;
                int C_DocType_ID = po.get_ValueAsInt("C_DocType_ID");
                replicationDocument = C_DocType_ID > 0 ? MReplicationStrategy.getReplicationDocument(po.getCtx(), replicationStrategy.get_ID(), po.get_Table_ID(), C_DocType_ID) : MReplicationStrategy.getReplicationDocument(po.getCtx(), replicationStrategy.get_ID(), po.get_Table_ID());
                if (replicationDocument != null) {
                    ExportHelper exportHelper = new ExportHelper(this.client, (MReplicationStrategy)replicationStrategy);
                    try {
                        exportHelper.exportRecord(po, replicationDocument, (Integer)type);
                    }
                    catch (Exception exeption) {
                        if (replicationStrategy.isValidateError()) {
                            throw new AdempiereException(exeption);
                        }
                        log.warning(exeption.getLocalizedMessage());
                    }
                }
            });
        }
        return result;
    }

    @Override
    public String login(int orgId, int roleId, int userId) {
        Env.setContext(Env.getCtx(), CTX_IsReplicationEnabled, true);
        this.orgId = orgId;
        this.roleId = roleId;
        this.userId = userId;
        log.info("AD_Org_ID  =" + this.orgId);
        log.info("AD_Role_ID =" + this.roleId);
        log.info("AD_User_ID =" + this.userId);
        this.loadReplicationStrategy(Env.getCtx());
        return null;
    }

    @Override
    public int getAD_Client_ID() {
        return this.clientId;
    }

    public void loadReplicationStrategy(Properties ctx) {
        MReplicationStrategy.getByOrgAndRole(ctx, this.orgId, this.roleId, null).stream().filter(replicationStrategy -> replicationStrategy != null).forEach(replicationStrategy -> {
            String tableName;
            for (X_AD_ReplicationTable rplTable : replicationStrategy.getReplicationTables()) {
                if (!"M".equals(rplTable.getReplicationType()) && !"B".equals(rplTable.getReplicationType()) && !"R".equals(rplTable.getReplicationType())) continue;
                tableName = MTable.getTableName(replicationStrategy.getCtx(), rplTable.getAD_Table_ID());
                this.modelValidationEngine.addModelChange(tableName, this);
            }
            for (X_AD_ReplicationDocument rplDocument : replicationStrategy.getReplicationDocuments()) {
                if (!"M".equals(rplDocument.getReplicationType()) && !"R".equals(rplDocument.getReplicationType())) continue;
                tableName = MTable.getTableName(replicationStrategy.getCtx(), rplDocument.getAD_Table_ID());
                this.modelValidationEngine.addDocValidate(tableName, this);
            }
        });
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(ExportModelValidator.class.getName());
        return stringBuffer.toString();
    }
}

