/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.engine;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import org.adempiere.engine.AbstractCostingMethod;
import org.adempiere.engine.CostComponent;
import org.adempiere.engine.ICostingMethod;
import org.adempiere.engine.IDocumentLine;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostDetail;
import org.compiere.model.MProduct;
import org.compiere.model.MTransaction;
import org.compiere.util.Env;

public class UserDefinedCostingMethodExample
extends AbstractCostingMethod
implements ICostingMethod {
    @Override
    public void setCostingMethod(MAcctSchema accountSchema, MTransaction transaction, IDocumentLine model, MCost dimension, BigDecimal costThisLevel, BigDecimal costLowLevel, Boolean isSalesTransaction) {
        this.accountSchema = accountSchema;
        this.transaction = transaction;
        this.dimension = dimension;
        this.costThisLevel = costThisLevel == null ? Env.ZERO : costThisLevel;
        this.costLowLevel = costLowLevel == null ? Env.ZERO : costLowLevel;
        this.model = model;
        this.costingLevel = MProduct.get(this.transaction.getCtx(), this.transaction.getM_Product_ID()).getCostingLevel(accountSchema, transaction.getAD_Org_ID());
        this.costDetail = MCostDetail.getByTransaction(this.model, this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID());
        this.movementQuantity = transaction.getMovementQty();
    }

    @Override
    public MCostDetail process() {
        this.costDetail = new MCostDetail(this.transaction, this.accountSchema.getC_AcctSchema_ID(), this.dimension.getM_CostType_ID(), this.dimension.getM_CostElement_ID(), Env.ONEHUNDRED.multiply(this.costThisLevel), Env.ONEHUNDRED.multiply(this.costThisLevel), this.movementQuantity, this.transaction.get_TrxName());
        this.costDetail.setDescription("Example User Defined Costing Method");
        this.costDetail.setDateAcct(this.model.getDateAcct());
        this.costDetail.saveEx();
        return this.costDetail;
    }

    @Override
    protected List<CostComponent> getCalculatedCosts() {
        return null;
    }

    @Override
    public void updateAmountCost() {
    }

    @Override
    public BigDecimal getNewCurrentCostPrice(MCostDetail cost, int scale, int roundingMode) {
        return null;
    }

    @Override
    public BigDecimal getNewCurrentCostPrice(MCostDetail cost, int scale, RoundingMode roundingMode) {
        return null;
    }

    @Override
    public BigDecimal getNewAccumulatedAmount(MCostDetail cost) {
        return null;
    }

    @Override
    public BigDecimal getNewCurrentCostPriceLowerLevel(MCostDetail cost, int scale, int roundingMode) {
        return null;
    }

    @Override
    public BigDecimal getNewCurrentCostPriceLowerLevel(MCostDetail cost, int scale, RoundingMode roundingMode) {
        return null;
    }

    @Override
    public BigDecimal getNewAccumulatedAmountLowerLevel(MCostDetail cost) {
        return null;
    }

    @Override
    public BigDecimal getNewAccumulatedQuantity(MCostDetail cost) {
        return null;
    }
}

