/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.ws.wsaddressing;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.spi.Provider;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.w3c.dom.Element;

public final class W3CEndpointReferenceBuilder {
    private String address;
    private List<Element> referenceParameters = new ArrayList<Element>();
    private List<Element> metadata = new ArrayList<Element>();
    private QName serviceName;
    private QName endpointName;
    private String wsdlDocumentLocation;

    public W3CEndpointReferenceBuilder address(String address) {
        this.address = address;
        return this;
    }

    public W3CEndpointReferenceBuilder serviceName(QName serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public W3CEndpointReferenceBuilder endpointName(QName endpointName) {
        if (this.serviceName == null) {
            throw new IllegalStateException("The W3CEndpointReferenceBuilder's serviceName must be set before setting the endpointName: " + endpointName);
        }
        this.endpointName = endpointName;
        return this;
    }

    public W3CEndpointReferenceBuilder wsdlDocumentLocation(String wsdlDocumentLocation) {
        this.wsdlDocumentLocation = wsdlDocumentLocation;
        return this;
    }

    public W3CEndpointReferenceBuilder referenceParameter(Element referenceParameter) {
        if (referenceParameter == null) {
            throw new IllegalArgumentException("The referenceParameter cannot be null.");
        }
        this.referenceParameters.add(referenceParameter);
        return this;
    }

    public W3CEndpointReferenceBuilder metadata(Element metadataElement) {
        if (metadataElement == null) {
            throw new IllegalArgumentException("The metadataElement cannot be null.");
        }
        this.metadata.add(metadataElement);
        return this;
    }

    public W3CEndpointReference build() {
        return Provider.provider().createW3CEndpointReference(this.address, this.serviceName, this.endpointName, this.metadata, this.wsdlDocumentLocation, this.referenceParameters);
    }
}

